/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiil.OiilWinActionsInstall;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiix.OiixRegistryOps;

public class OiilWinActionsDeinstall
extends OiilWinActionsInstall {
    public OiilWinActionsDeinstall() {
        this.m_bInstall = false;
        this.m_bCluster = false;
    }

    @Override
    protected void runRegAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        String sRoot = inputs.getRegRootValue();
        String sKey = inputs.getValueAsString("Key");
        if (sAction.equalsIgnoreCase("createKey")) {
            try {
                OiixRegistryOps.RegDeleteKey(sRoot, sKey);
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
        }
        if (sAction.equalsIgnoreCase("setvalue")) {
            try {
                String sType = inputs.getValueAsString("Type");
                String sName = inputs.getValueAsString("Name");
                String sVal = inputs.getValueAsString("Value");
                switch (OiilWinActionsDeinstall.getValueType(sType)) {
                    case 1: 
                    case 2: 
                    case 4: {
                        OiixRegistryOps.RegDeleteValue(sRoot, sKey, sName);
                        break;
                    }
                    case 3: {
                        OiixRegistryOps.RegUnSetValue(sRoot, sKey, sName, sVal);
                        break;
                    }
                }
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
        }
    }

    @Override
    protected void runShortcutAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equals("") || sAction.equalsIgnoreCase("create")) {
            this.removeItem(inputs);
        }
    }

    @Override
    protected void runServiceAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equalsIgnoreCase("create")) {
            this.deleteService(inputs);
        } else if (!sAction.equalsIgnoreCase("remove")) {
            if (sAction.equalsIgnoreCase("start")) {
                this.stopService(inputs);
            } else if (sAction.equalsIgnoreCase("stop")) {
                this.startService(inputs);
            }
        }
    }
}

