/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiilWinActionInputs {
    private Vector m_vInputs;
    private int m_actionType;
    public static final int REGISTRY = 0;
    public static final int SHORTCUT = 1;
    public static final int SERVICE = 2;
    public static final String REGISTRY_CREATE = "createKey";
    public static final String REGISTRY_SET_VALUE = "setvalue";
    public static final String REGISTRY_TYPE_BIN = "binary";
    public static final String REGISTRY_TYPE_INT = "integer";
    public static final String REGISTRY_TYPE_STRING = "string";
    public static final String REGISTRY_TYPE_MSTR = "multistring";
    public static final String ACTION_TYPE_INSTALL = "install";
    public static final String ACTION_TYPE_DEINSTALL = "deinstall";
    public static final String ACTION_TYPE_BOTH = "both";
    public static final String SHORTCUT_CREATE = "create";
    public static final String SHORTCUT_REMOVE = "remove";
    public static final String SEVICE_ACTION_CREATE = "create";
    public static final String SEVICE_ACTION_REMOVE = "remove";
    public static final String SEVICE_ACTION_START = "start";
    public static final String SEVICE_ACTION_STOP = "stop";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final int REGISTRY_ITYPE_BIN = 1;
    public static final int REGISTRY_ITYPE_INT = 2;
    public static final int REGISTRY_ITYPE_STRING = 3;
    public static final int REGISTRY_ITYPE_MSTR = 4;
    static final String[][] S_REG_ROOTS = new String[][]{{"HKLM", "HKEY_LOCAL_MACHINE"}, {"HKCR", "HKEY_CLASSES_ROOT"}, {"HKCC", "HKEY_CURRENT_CONFIG"}, {"HKCU", "HKEY_CURRENT_USER"}, {"HKU", "HKEY_USERS"}};
    private static Hashtable winActions = new Hashtable();

    public static Vector getCompAction(OiiiCompInstallID cid) {
        return (Vector)winActions.get(cid);
    }

    public static Enumeration getActions() {
        return winActions.elements();
    }

    public static void addCompAction(OiiiCompInstallID cid, Vector vActions) {
        winActions.put(cid, vActions);
    }

    public static void addCompAction(OiiiCompInstallID cid, OiilWinActionInputs inputs) {
        Vector<OiilWinActionInputs> actions = OiilWinActionInputs.getCompAction(cid);
        if (null != actions) {
            actions.add(inputs);
        } else {
            actions = new Vector<OiilWinActionInputs>();
            actions.add(inputs);
            OiilWinActionInputs.addCompAction(cid, actions);
        }
    }

    public OiilWinActionInputs(int type) {
        this.m_actionType = type;
        this.m_vInputs = new Vector();
    }

    public void addInputElement(OiilActionInputElement elem) {
        this.m_vInputs.add(elem);
    }

    public void addInputElement(String paramName, Object value) {
        OiilActionInputElement elem = new OiilActionInputElement(paramName, value);
        this.m_vInputs.add(elem);
    }

    public void addInputElementImplicit(String paramName, Object value) {
        OiilActionInputElement elem = new OiilActionInputElement(paramName, value);
        elem.setImplicit(true);
        this.m_vInputs.add(elem);
    }

    public int getType() {
        return this.m_actionType;
    }

    public int getSize() {
        return this.m_vInputs.size();
    }

    public String getElementName(int nPos) {
        if (nPos < this.m_vInputs.size()) {
            return ((OiilActionInputElement)this.m_vInputs.elementAt(nPos)).getParamName();
        }
        return null;
    }

    public String getElementValue(int nPos) {
        if (nPos < this.m_vInputs.size()) {
            return (String)((OiilActionInputElement)this.m_vInputs.elementAt(nPos)).getObject();
        }
        return null;
    }

    public boolean isImplicitElement(int nPos) {
        if (nPos < this.m_vInputs.size()) {
            return ((OiilActionInputElement)this.m_vInputs.elementAt(nPos)).isImplicit();
        }
        return false;
    }

    public void setElementValue(String val, int nPos) {
        OiilActionInputElement elem = (OiilActionInputElement)this.m_vInputs.get(nPos);
        elem.setObject(val);
    }

    public OiilActionInputElement getParam(String name) {
        int i = OiixVectorOps.vectIndexOf(this.m_vInputs, (Object)name);
        if (i != -1) {
            return (OiilActionInputElement)this.m_vInputs.elementAt(i);
        }
        return null;
    }

    public Object getValue(String name) {
        OiilActionInputElement input = this.getParam(name);
        if (input != null) {
            return input.getObject();
        }
        return null;
    }

    public void setValue(String name, Object val) {
        OiilActionInputElement input = this.getParam(name);
        if (input != null) {
            input.setObject(val);
        }
    }

    public String getValueAsString(String name) {
        OiilActionInputElement input = this.getParam(name);
        if (input != null && input.getObject() != null) {
            return input.getObject().toString();
        }
        return "";
    }

    public String getValueAsNativePath(String name) {
        String path = this.getValueAsString(name);
        path = OiixPathOps.getStandardForm(path);
        return OiixPathOps.getNativeForm(path);
    }

    public int getValueAsInt(String name) {
        OiilActionInputElement input = this.getParam(name);
        if (input != null && input.getObject() != null) {
            Object val = input.getObject();
            if (val instanceof Integer) {
                return (Integer)val;
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        return 0;
    }

    public String getRegRootValue() {
        String val = this.getValueAsString("Root");
        for (int i = 0; i < S_REG_ROOTS.length; ++i) {
            if (!val.equalsIgnoreCase(S_REG_ROOTS[i][0])) continue;
            return S_REG_ROOTS[i][1];
        }
        return val;
    }

    public String getName() {
        String action = "";
        String actionType = "";
        String actionName = "";
        switch (this.getType()) {
            case 0: {
                action = "Registry";
                actionType = this.getValueAsString("Action");
                if (actionType.equals("")) {
                    actionType = REGISTRY_CREATE;
                }
                if (actionType.equalsIgnoreCase(REGISTRY_CREATE)) {
                    actionName = this.getValueAsString("Key");
                    break;
                }
                if (!actionType.equalsIgnoreCase(REGISTRY_SET_VALUE)) break;
                actionName = this.getValueAsString("Name");
                break;
            }
            case 1: {
                action = "Shortcut";
                actionType = this.getValueAsString("Action");
                if (actionType.equals("")) {
                    actionType = "create";
                }
                actionName = this.getValueAsString("ItemName");
                break;
            }
            case 2: {
                action = "Service";
                actionType = this.getValueAsString("Action");
                actionName = this.getValueAsString("ServiceName");
            }
        }
        return action + " " + actionType + " " + actionName;
    }
}

