/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilActionArg;
import oracle.sysman.oii.oiil.OiilActionInfo;
import oracle.sysman.oii.oiil.OiilActionTable;
import oracle.sysman.oii.oiil.OiilDialogInfo;
import oracle.sysman.oii.oiil.OiilDialogTable;
import oracle.sysman.oii.oiil.OiilDlgPropertyInfo;
import oracle.sysman.oii.oiil.OiilExceptionInfo;
import oracle.sysman.oii.oiil.OiilLibElemInfo;
import oracle.sysman.oii.oiil.OiilLibElemTable;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class OiilLibraryXMLHandler
extends OixsDefaultHandler {
    private OiilLibElemTable m_LibTable;
    private int m_nLibType = -1;
    OiilLibElemInfo m_LibInfo = null;
    private int[] m_iaLibPlats;
    private int[] m_iaActionPlats;
    private OixsElementHandler m_LibraryHandler;
    private OixsElementHandler m_ActionHandler;
    private OixsElementHandler m_QueryHandler;
    private OixsElementHandler m_DialogHandler;
    private OixsElementHandler m_ArgListHandler;
    private OixsElementHandler m_ArgHandler;
    private OixsElementHandler m_ExcListHandler;
    private OixsElementHandler m_ExcHandler;
    private OixsElementHandler m_PlatSpHandler;
    private OixsElementHandler m_PlatsHandler;
    private OixsElementHandler m_NatLibHandler;
    private OixsElementHandler m_NatClassHandler;
    private OixsElementHandler m_EntryPointHandler;
    String[] m_saLibClasses;
    String[] m_saNatLibs;
    String m_sEntryPoint;
    boolean m_bCheckingLibXML = false;
    String m_sActionName;
    String m_sActionTypeString = null;
    private static String S_PLAT_ERR1 = "Error(s) in {0} attribute of {1} element:";
    private static String S_PLAT_ERR2 = "Error(s) in {0} attribute of {1} element  {2} in {3} {4}";
    private static String S_PLAT_ERR3 = "Error(s) in {0} attribute of {1} element of {2} {3}";
    private Vector m_vErrs = new Vector();

    OiilLibraryXMLHandler() throws SAXException {
    }

    @Override
    public OixsElementHandler createElementHandlers() {
        this.m_LibraryHandler = new OiilLibraryHandler("LIBRARY");
        this.m_ActionHandler = new OiilActionHandler("ACTION");
        this.m_QueryHandler = new OiilActionHandler("QUERY");
        this.m_DialogHandler = new OiilActionHandler("DIALOG");
        this.m_ArgListHandler = new OixsElementHandler("ARGUMENT_LIST");
        this.m_ArgHandler = new OiilArgumentHandler("ARGUMENT");
        this.m_ExcListHandler = new OixsElementHandler("EXCEPTION_LIST");
        this.m_ExcHandler = new OiilExceptionHandler("EXCEPTION_LIST");
        this.m_PlatSpHandler = new OixsElementHandler("PLAT_SPECIFIC");
        this.m_PlatsHandler = new OiilPlatformsHandler("PLATS");
        this.m_NatLibHandler = new OiilPlatSpecificHandler("NATIVE_LIBRARIES");
        this.m_NatClassHandler = new OiilPlatSpecificHandler("LIBRARY_CLASS");
        this.m_EntryPointHandler = new OiilPlatSpecificHandler("ENTRY_POINT");
        this.m_LibraryHandler.addChildHandler("ACTION", this.m_ActionHandler);
        this.m_LibraryHandler.addChildHandler("QUERY", this.m_QueryHandler);
        this.m_LibraryHandler.addChildHandler("DIALOG", this.m_DialogHandler);
        this.m_ActionHandler.addChildHandler("ARGUMENT_LIST", this.m_ArgListHandler);
        this.m_QueryHandler.addChildHandler("ARGUMENT_LIST", this.m_ArgListHandler);
        this.m_DialogHandler.addChildHandler("ARGUMENT_LIST", this.m_ArgListHandler);
        this.m_ActionHandler.addChildHandler("EXCEPTION_LIST", this.m_ExcListHandler);
        this.m_QueryHandler.addChildHandler("EXCEPTION_LIST", this.m_ExcListHandler);
        this.m_ActionHandler.addChildHandler("PLAT_SPECIFIC", this.m_PlatSpHandler);
        this.m_QueryHandler.addChildHandler("PLAT_SPECIFIC", this.m_PlatSpHandler);
        this.m_ArgListHandler.addChildHandler("ARGUMENT", this.m_ArgHandler);
        this.m_ExcListHandler.addChildHandler("EXCEPTION", this.m_ExcHandler);
        this.m_PlatSpHandler.addChildHandler("PLATS", this.m_PlatsHandler);
        this.m_PlatsHandler.addChildHandler("ENTRY_POINT", this.m_EntryPointHandler);
        this.m_PlatsHandler.addChildHandler("NATIVE_LIBRARIES", this.m_NatLibHandler);
        this.m_PlatsHandler.addChildHandler("LIBRARY_CLASS", this.m_NatClassHandler);
        return this.m_LibraryHandler;
    }

    OiilLibElemTable getLibTable() {
        return this.m_LibTable;
    }

    private void resetNativeVars() {
        this.m_saLibClasses = null;
        this.m_saNatLibs = null;
        this.m_sEntryPoint = "";
    }

    boolean isCheckingLibXML() {
        return this.m_bCheckingLibXML;
    }

    public void setCheckingLibXML(boolean bCheck) {
        this.m_bCheckingLibXML = bCheck;
    }

    public Vector getErrors() {
        return this.m_vErrs;
    }

    void setActionName(String sName) {
        this.m_sActionName = sName;
    }

    String getActionName() {
        return this.m_sActionName;
    }

    String getActionTypeString() {
        if (this.m_sActionTypeString == null) {
            this.m_sActionTypeString = this.m_nLibType == 1 ? "Query" : (this.m_nLibType == 0 ? "Action" : "Dialog");
        }
        return this.m_sActionTypeString;
    }

    static /* synthetic */ int[] access$002(OiilLibraryXMLHandler x0, int[] x1) {
        x0.m_iaLibPlats = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(OiilLibraryXMLHandler x0, int[] x1) {
        x0.m_iaActionPlats = x1;
        return x1;
    }

    class OiilPlatSpecificHandler
    extends OixsElementHandler {
        OiilPlatSpecificHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sFile = atts.getValue("FILE");
            if (name.equals("ENTRY_POINT")) {
                OiilLibraryXMLHandler.this.m_sEntryPoint = sFile;
            } else if (name.equals("NATIVE_LIBRARIES")) {
                OiilLibraryXMLHandler.this.m_saNatLibs = OiilXMLHelper.string2StringArray(sFile);
            } else if (name.equals("LIBRARY_CLASS")) {
                OiilLibraryXMLHandler.this.m_saLibClasses = OiilXMLHelper.string2StringArray(sFile);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    class OiilPlatformsHandler
    extends OixsElementHandler {
        int[] iaPlats;

        OiilPlatformsHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiilLibraryXMLHandler.this.m_nLibType == 2) {
                return;
            }
            String sPlats = atts.getValue("ID");
            Vector vErrs = new Vector();
            this.iaPlats = OiilXMLHelper.platCommonNames2IntArray(sPlats, " ", vErrs);
            if (OiilLibraryXMLHandler.this.isCheckingLibXML() && vErrs.size() != 0) {
                Object[] args = new String[]{"ID", "PLATS", OiilLibraryXMLHandler.this.getActionTypeString(), OiilLibraryXMLHandler.this.getActionName()};
                OiilLibraryXMLHandler.this.m_vErrs.addElement(MessageFormat.format(S_PLAT_ERR3, args));
                for (int i = 0; i < vErrs.size(); ++i) {
                    OiilLibraryXMLHandler.this.m_vErrs.addElement("\t" + (String)vErrs.elementAt(i));
                }
            }
            this.iaPlats = OiilXMLHelper.getPlatsIntersection(OiilLibraryXMLHandler.this.m_iaLibPlats, this.iaPlats);
        }

        @Override
        public void onEnd(String name) {
            OiilActionInfo ai = (OiilActionInfo)OiilLibraryXMLHandler.this.m_LibInfo;
            for (int i = 0; i < this.iaPlats.length; ++i) {
                ai.setActionClassName(OiilLibraryXMLHandler.this.m_sEntryPoint, this.iaPlats[i], OiilLibraryXMLHandler.this.m_saNatLibs, OiilLibraryXMLHandler.this.m_saLibClasses);
            }
            this.iaPlats = null;
            OiilLibraryXMLHandler.this.resetNativeVars();
        }
    }

    class OiilExceptionHandler
    extends OixsElementHandler {
        int m_size;

        OiilExceptionHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiilLibraryXMLHandler.this.m_nLibType == 2) {
                return;
            }
            String sIntName = atts.getValue("NAME");
            String sExtName = atts.getValue("EXT_NAME_ID");
            String sDesc = atts.getValue("DESC_ID");
            String sSev = atts.getValue("SEV");
            int nSev = sSev == null ? 0 : new Integer(sSev);
            OiilExceptionInfo ei = new OiilExceptionInfo(sExtName, sDesc, nSev);
            ei.setExceptionIntName(sIntName);
            OiilActionInfo ai = (OiilActionInfo)OiilLibraryXMLHandler.this.m_LibInfo;
            ai.addException(ei);
        }

        @Override
        public void onEnd(String name) {
        }
    }

    class OiilArgumentHandler
    extends OixsElementHandler {
        OiilArgumentHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sIntName = atts.getValue("NAME");
            String sDesc = atts.getValue("DESC_ID");
            String sExtName = atts.getValue("EXT_NAME_ID");
            String sClassType = atts.getValue("TYPE");
            Class<?> cType = null;
            try {
                cType = Class.forName(sClassType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (OiilLibraryXMLHandler.this.m_nLibType == 2) {
                String sInOut = atts.getValue("IN-OUT");
                boolean bInOut = new Boolean(sInOut);
                OiilDlgPropertyInfo dProp = new OiilDlgPropertyInfo(sIntName, sExtName, cType, bInOut, sDesc);
                OiilDialogInfo di = (OiilDialogInfo)OiilLibraryXMLHandler.this.m_LibInfo;
                di.addProperty(dProp);
            } else {
                int[] iaPlats;
                String sPlats = atts.getValue("PLATS");
                if (sPlats == null || sPlats.trim().length() == 0) {
                    iaPlats = OiilLibraryXMLHandler.this.m_iaActionPlats;
                } else {
                    Vector vErrs = new Vector();
                    iaPlats = OiilXMLHelper.platCommonNames2IntArray(sPlats, " ", vErrs);
                    if (OiilLibraryXMLHandler.this.isCheckingLibXML() && vErrs.size() != 0) {
                        Object[] args = new String[]{"PLATS", "ARGUMENT", sIntName, OiilLibraryXMLHandler.this.getActionTypeString(), OiilLibraryXMLHandler.this.getActionName()};
                        OiilLibraryXMLHandler.this.m_vErrs.addElement(MessageFormat.format(S_PLAT_ERR2, args));
                        for (int i = 0; i < vErrs.size(); ++i) {
                            OiilLibraryXMLHandler.this.m_vErrs.addElement("\t" + (String)vErrs.elementAt(i));
                        }
                    }
                }
                String sImplicit = atts.getValue("IMPLICIT");
                boolean bImplicit = sImplicit == null ? false : new Boolean(sImplicit);
                String sOptional = atts.getValue("OPTIONAL");
                boolean bOptional = sOptional == null ? false : new Boolean(sOptional);
                OiilActionArg aArg = new OiilActionArg(sIntName, cType, sExtName, sDesc, bOptional);
                aArg.setImplicit(bImplicit);
                aArg.setPlatforms(iaPlats);
                OiilActionInfo ai = (OiilActionInfo)OiilLibraryXMLHandler.this.m_LibInfo;
                ai.addArgument(aArg);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    class OiilActionHandler
    extends OixsElementHandler {
        OiilActionHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("EXT_NAME_ID");
            if (OiilLibraryXMLHandler.this.isCheckingLibXML()) {
                OiilLibraryXMLHandler.this.setActionName(sName);
            }
            String sDesc = atts.getValue("DESC_ID");
            String sEntryPoint = atts.getValue("ENTRY_POINT");
            String sPlats = atts.getValue("PLATS");
            String sVisible = atts.getValue("VISIBLE");
            if (sVisible == null) {
                sVisible = "TRUE";
            }
            String sDepr = atts.getValue("DEPR");
            String sDeprId = atts.getValue("DEPR_ID");
            if (OiilLibraryXMLHandler.this.m_nLibType == 2) {
                OiilLibraryXMLHandler.this.m_LibInfo = new OiilDialogInfo(sName, sDesc, sEntryPoint);
            } else {
                OiilActionInfo ai = new OiilActionInfo(sName, new Boolean(sVisible));
                ai.setDescription(sDesc);
                if (sEntryPoint != null && sEntryPoint.length() > 0) {
                    ai.setActionClassName(sEntryPoint);
                }
                if (sPlats == null || sPlats.length() == 0) {
                    OiilLibraryXMLHandler.access$502(OiilLibraryXMLHandler.this, OiilLibraryXMLHandler.this.m_iaLibPlats);
                } else {
                    Vector vErrs = new Vector();
                    OiilLibraryXMLHandler.access$502(OiilLibraryXMLHandler.this, OiilXMLHelper.platCommonNames2IntArray(sPlats, " ", vErrs));
                    if (OiilLibraryXMLHandler.this.isCheckingLibXML() && vErrs.size() != 0) {
                        Object[] args = new String[]{"PLATS", OiilLibraryXMLHandler.this.getActionTypeString().toUpperCase(), OiilLibraryXMLHandler.this.getActionTypeString(), sName};
                        OiilLibraryXMLHandler.this.m_vErrs.addElement(MessageFormat.format(S_PLAT_ERR3, args));
                        for (int i = 0; i < vErrs.size(); ++i) {
                            OiilLibraryXMLHandler.this.m_vErrs.addElement("\t" + (String)vErrs.elementAt(i));
                        }
                    }
                }
                ai.setPlatforms(OiilLibraryXMLHandler.this.m_iaActionPlats);
                if (OiilLibraryXMLHandler.this.m_nLibType == 1) {
                    String sClass = atts.getValue("RETURN_TYPE");
                    Class<?> retClass = null;
                    try {
                        retClass = Class.forName(sClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    ai.setReturnType(retClass);
                }
                OiilLibraryXMLHandler.this.m_LibInfo = ai;
            }
            if (sDepr != null && sDepr.equals("TRUE")) {
                OiilLibraryXMLHandler.this.m_LibInfo.setDeprecated(true);
                if (sDeprId != null) {
                    OiilLibraryXMLHandler.this.m_LibInfo.setDepricatedDescID(sDeprId);
                }
            }
        }

        @Override
        public void onEnd(String name) {
            OiilLibraryXMLHandler.this.m_LibTable.addTableElement(OiilLibraryXMLHandler.this.m_LibInfo);
            OiilLibraryXMLHandler.this.m_LibInfo = null;
        }
    }

    class OiilLibraryHandler
    extends OixsElementHandler {
        OiilLibraryHandler(String sTagName) {
            super(sTagName);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sXMLVersion = atts.getValue("XMLFORMAT_VER");
            String sLibType = atts.getValue("TYPE");
            String sLibVersion = atts.getValue("VER");
            String sReplVersion = atts.getValue("REPL_VER");
            String sMinInstVersion = atts.getValue("MIN_INST_VER");
            String sPlats = atts.getValue("PLAT");
            Vector vErrs = new Vector();
            Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", vErrs);
            vErrs.removeAllElements();
            OiilLibraryXMLHandler.access$002(OiilLibraryXMLHandler.this, OiilXMLHelper.platCommonNames2IntArray(sPlats, " ", vErrs));
            if (OiilLibraryXMLHandler.this.isCheckingLibXML() && vErrs.size() != 0) {
                Object[] args = new String[]{"PLAT", "LIBRARY"};
                OiilLibraryXMLHandler.this.m_vErrs.addElement(MessageFormat.format(S_PLAT_ERR1, args));
                for (int i = 0; i < vErrs.size(); ++i) {
                    OiilLibraryXMLHandler.this.m_vErrs.addElement("\t" + (String)vErrs.elementAt(i));
                }
            }
            OiiiLibraryID lid = new OiiiLibraryID(sName, new OiiiVersion(sLibVersion), vPlats, new OiiiVersion(sReplVersion));
            lid.setInstVer(sMinInstVersion);
            if (sLibType.equals("ACTION")) {
                OiilLibraryXMLHandler.this.m_nLibType = 0;
                OiilLibraryXMLHandler.this.m_LibTable = new OiilActionTable(lid);
            } else if (sLibType.equals("QUERY")) {
                OiilLibraryXMLHandler.this.m_nLibType = 1;
                OiilLibraryXMLHandler.this.m_LibTable = new OiilActionTable(lid);
            } else {
                OiilLibraryXMLHandler.this.m_nLibType = 2;
                OiilLibraryXMLHandler.this.m_LibTable = new OiilDialogTable(lid);
            }
            OiilLibraryXMLHandler.this.m_LibTable.setLibType(OiilLibraryXMLHandler.this.m_nLibType);
        }

        @Override
        public void onEnd(String name) {
        }
    }
}

