/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiil.OiilActionArg;
import oracle.sysman.oii.oiil.OiilActionInfo;
import oracle.sysman.oii.oiil.OiilExceptionInfo;
import oracle.sysman.oii.oiil.OiilLibElemTable;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;

public class OiilActionTable
extends OiilLibElemTable
implements Serializable {
    static final long serialVersionUID = -6445351221352605457L;
    public transient OiixJarResourceBundle resBundle;
    private static final String S_LIBXML_FILENAME = "library.xml";

    public OiilActionTable(OiiiLibraryID id) {
        super(id);
    }

    public OiilActionTable(OiiiLibraryID id, boolean isQueryLibrary) {
        super(id);
        if (isQueryLibrary) {
            this.setLibType(1);
        } else {
            this.setLibType(0);
        }
    }

    public void createTable() {
    }

    public void setBundle(OiixJarResourceBundle rb) {
        this.resBundle = rb;
    }

    public OiilActionInfo createNewActionInfo(String name) {
        return new OiilActionInfo(name);
    }

    public OiilActionInfo createNewActionInfo(String name, int supOnPlats, int[] plats) {
        OiilActionInfo acInfo = new OiilActionInfo(name);
        acInfo.setSupportedOnPlatforms(supOnPlats);
        acInfo.setPlatforms(plats);
        return acInfo;
    }

    public OiilActionInfo createNewActionInfo(String name, String desc) {
        OiilActionInfo acInfo = new OiilActionInfo(name);
        acInfo.setDescription(desc);
        return acInfo;
    }

    public OiilActionInfo createNewActionInfo(String name, String desc, int supOnPlats, int[] plats) {
        OiilActionInfo acInfo = new OiilActionInfo(name);
        acInfo.setSupportedOnPlatforms(supOnPlats);
        acInfo.setPlatforms(plats);
        acInfo.setDescription(desc);
        return acInfo;
    }

    public OiilActionInfo createNewActionInfo(String name, Class type, String desc) {
        OiilActionInfo acInfo = new OiilActionInfo(name);
        acInfo.setReturnType(type);
        acInfo.setDescription(desc);
        return acInfo;
    }

    public OiilActionInfo createNewActionInfo(String name, Class type, String desc, int supOnPlats, int[] plats) {
        OiilActionInfo acInfo = new OiilActionInfo(name);
        acInfo.setSupportedOnPlatforms(supOnPlats);
        acInfo.setPlatforms(plats);
        acInfo.setReturnType(type);
        acInfo.setDescription(desc);
        return acInfo;
    }

    public void addActionInfoToTable(OiilActionInfo actionInfo) {
        this.addTableElement(actionInfo);
    }

    public void setPlatSpecificActionName(OiilActionInfo actionInfo, String name) {
        actionInfo.setActionClassName(name);
    }

    public void setPlatSpecificActionName(OiilActionInfo actionInfo, String name, int platform, String[] nativeLibNames, String[] nativeClassNames) {
        actionInfo.setActionClassName(name, platform, nativeLibNames, nativeClassNames);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description) {
        OiilActionArg oiArgs1 = new OiilActionArg(intlName, name);
        oiArgs1.setType(type);
        oiArgs1.setDescription(description);
        actionInfo.addArgument(oiArgs1);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description, String noOp, boolean optional) {
        OiilActionArg oiArgs1 = new OiilActionArg(intlName, name);
        oiArgs1.setType(type);
        oiArgs1.setDescription(description);
        oiArgs1.setOptional(optional);
        actionInfo.addArgument(oiArgs1);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description, int supOnPlats, int[] plats) {
        OiilActionArg oiArgs1 = new OiilActionArg(intlName, name);
        oiArgs1.setType(type);
        oiArgs1.setDescription(description);
        oiArgs1.setSupportedOnPlatforms(supOnPlats);
        oiArgs1.setPlatforms(plats);
        actionInfo.addArgument(oiArgs1);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description, boolean implicit) {
        OiilActionArg oiArgs1 = new OiilActionArg(intlName, name);
        oiArgs1.setType(type);
        oiArgs1.setDescription(description);
        oiArgs1.setImplicit(implicit);
        actionInfo.addArgument(oiArgs1);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description, int supOnPlats, int[] plats, boolean implicit, boolean optional) {
        OiilActionArg oiArgs1 = new OiilActionArg(intlName, type, name, description, optional);
        oiArgs1.setSupportedOnPlatforms(supOnPlats);
        oiArgs1.setPlatforms(plats);
        oiArgs1.setImplicit(implicit);
        actionInfo.addArgument(oiArgs1);
    }

    public void addArgument(OiilActionInfo actionInfo, String intlName, Class type, String name, String description, int supOnPlats, int[] plats, boolean implicit) {
        this.addArgument(actionInfo, intlName, type, name, description, supOnPlats, plats, implicit, false);
    }

    public void addException(OiilActionInfo actionInfo, String exName, String exString, int severity) {
        OiilExceptionInfo ex = new OiilExceptionInfo(exName, exString, severity);
        actionInfo.addException(ex);
    }

    public void addException(OiilActionInfo actionInfo, String exName, String exString) {
        OiilExceptionInfo ex = new OiilExceptionInfo(exName, exString);
        actionInfo.addException(ex);
    }

    public void addException(OiilActionInfo actionInfo, String exName, String exString, String exIntName) {
        OiilExceptionInfo ex = new OiilExceptionInfo(exName, exString);
        ex.setExceptionIntName(exIntName);
        actionInfo.addException(ex);
    }

    public Enumeration getAllActionElements() {
        return this.getAllElements();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.defaultWriteObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.writeXML();
    }

    public void writeXML() throws IOException {
        FileWriter fWriter = new FileWriter(S_LIBXML_FILENAME);
        BufferedWriter buffWriter = new BufferedWriter(fWriter);
        PrintWriter out = new PrintWriter(buffWriter);
        out.println(OixsXMLOps.getCopyRight());
        String sLibType = "";
        sLibType = this.getLibType() == 1 ? "QUERY" : "ACTION";
        XMLElement xmlLid = this.lid.createXMLElement(sLibType);
        out.println(OixsXMLOps.getStartTag(xmlLid));
        for (int i = 0; i < this.libElemInfoTable.size(); ++i) {
            OiilActionInfo aInfo = (OiilActionInfo)this.libElemInfoTable.elementAt(i);
            aInfo.writeXMLElement(out, sLibType, OiixVectorOps.vect2IntArr(this.lid.getPlatforms()));
        }
        out.println(OixsXMLOps.getEndTag(xmlLid));
        out.flush();
        out.close();
        buffWriter.close();
        fWriter.close();
    }
}

