/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionArg;
import oracle.sysman.oii.oiil.OiilExceptionInfo;
import oracle.sysman.oii.oiil.OiilLibElemInfo;
import oracle.sysman.oii.oiil.OiilPlatInfo;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;

public class OiilActionInfo
extends OiilLibElemInfo
implements Serializable {
    static final long serialVersionUID = -5473066474625915216L;
    Class m_returnType;
    private boolean m_invisible;
    String m_descID;
    Vector m_arguments = new Vector(2, 2);
    Vector m_exceptions = new Vector(2, 2);
    Vector m_platSpecInfo = new Vector(2, 2);
    boolean m_bGenericName = false;
    String m_genericClassName;
    public static int OiALL_PLATFORMS = 100;
    public static int OiTHESE_PLATFORMS = 101;
    public static int OiNOT_THESE_PLATFORMS = 102;
    int[] m_platforms;
    int m_supportedOnPlatforms = OiALL_PLATFORMS;
    private static int METHOD = 0;
    private static int NAT_LIB = 1;
    private static int NAT_CLASS = 2;
    private static int PLAT = 3;

    public OiilActionInfo(String name, boolean visible) {
        super(name);
        this.m_invisible = !visible;
    }

    public OiilActionInfo(String name) {
        this(name, true);
    }

    public Class getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(Class c) {
        this.m_returnType = c;
    }

    public boolean isVisible() {
        return !this.m_invisible;
    }

    public void setVisible(boolean visible) {
        this.m_invisible = !visible;
    }

    public void setDescription(String desc) {
        this.m_descID = desc;
    }

    public String getDescription() throws MissingResourceException {
        return this.getBundle().getString(this.m_descID);
    }

    public String getInternalActionClassName(int platform) {
        if (this.m_bGenericName) {
            return this.m_genericClassName;
        }
        int size = this.m_platSpecInfo.size();
        for (int i = 0; i < size; ++i) {
            OiilPlatInfo mp = (OiilPlatInfo)this.m_platSpecInfo.elementAt(i);
            if (mp.getPlatform() != platform) continue;
            return mp.getMethodName();
        }
        return null;
    }

    public String getActionClassName(int platform) {
        if (this.m_bGenericName) {
            return this.m_genericClassName;
        }
        int size = this.m_platSpecInfo.size();
        for (int i = 0; i < size; ++i) {
            OiilPlatInfo mp = (OiilPlatInfo)this.m_platSpecInfo.elementAt(i);
            if (mp.getPlatform() != platform) continue;
            return mp.getMethodName();
        }
        return null;
    }

    public String[] getNativeLibraryNames(int platform) {
        int size = this.m_platSpecInfo.size();
        for (int i = 0; i < size; ++i) {
            OiilPlatInfo mp = (OiilPlatInfo)this.m_platSpecInfo.elementAt(i);
            if (mp.getPlatform() != platform) continue;
            return mp.getNativeLibraryNames();
        }
        return null;
    }

    public String[] getNativeClassNames(int platform) {
        int size = this.m_platSpecInfo.size();
        for (int i = 0; i < size; ++i) {
            OiilPlatInfo mp = (OiilPlatInfo)this.m_platSpecInfo.elementAt(i);
            if (mp.getPlatform() != platform) continue;
            return mp.getNativeClassNames();
        }
        return null;
    }

    public void setActionClassName(String name) {
        this.m_bGenericName = true;
        this.m_genericClassName = name;
    }

    public void setActionClassName(String name, int platform, String[] nativeLibraryNames, String[] nativeLoaderClassNames) {
        OiilPlatInfo mp = new OiilPlatInfo(name, platform, nativeLibraryNames, nativeLoaderClassNames);
        this.m_platSpecInfo.addElement(mp);
        this.m_supportedOnPlatforms = OiTHESE_PLATFORMS;
    }

    public OiilActionArg getArgument(int i) {
        return (OiilActionArg)this.m_arguments.elementAt(i);
    }

    public void addArgument(OiilActionArg actionArg) {
        this.m_arguments.addElement(actionArg);
    }

    public void addException(OiilExceptionInfo exception) {
        this.m_exceptions.addElement(exception);
    }

    public Enumeration getAllArguments() {
        return this.m_arguments.elements();
    }

    public Enumeration getAllExceptions() {
        return this.m_exceptions.elements();
    }

    public int getNumberOfArguments() {
        return this.m_arguments.size();
    }

    public int getNumberOfExceptions() {
        return this.m_exceptions.size();
    }

    public OiilExceptionInfo getException(int i) {
        return (OiilExceptionInfo)this.m_exceptions.elementAt(i);
    }

    private int getSupportedOnPlatforms() {
        return this.m_supportedOnPlatforms;
    }

    public boolean isActionSupportedOnAllPlatforms() {
        return this.m_supportedOnPlatforms == OiALL_PLATFORMS;
    }

    public boolean isActionSupportedOnPlatform(int platform) {
        if (this.getSupportedOnPlatforms() == OiTHESE_PLATFORMS) {
            int i = this.m_platforms.length;
            for (int j = 0; j < i; ++j) {
                if (this.m_platforms[j] != platform) continue;
                return true;
            }
        } else if (this.getSupportedOnPlatforms() == OiALL_PLATFORMS) {
            return true;
        }
        return false;
    }

    public int[] getPlatforms() {
        if (this.m_supportedOnPlatforms == OiALL_PLATFORMS) {
            return OiixPlatform.getPlatforms();
        }
        if (this.m_supportedOnPlatforms == OiTHESE_PLATFORMS) {
            return this.m_platforms;
        }
        return new int[0];
    }

    public void setSupportedOnPlatforms(int pt) {
        this.m_supportedOnPlatforms = pt;
    }

    public void setPlatforms(int[] pts) {
        this.m_platforms = pts;
        this.m_supportedOnPlatforms = OiTHESE_PLATFORMS;
    }

    @Override
    public void setBundle(OiixJarResourceBundle rb) {
        super.setBundle(rb);
        Enumeration enum1 = this.getAllArguments();
        while (enum1.hasMoreElements()) {
            OiilActionArg arg = (OiilActionArg)enum1.nextElement();
            arg.setBundle(rb);
        }
        Enumeration enum2 = this.getAllExceptions();
        while (enum2.hasMoreElements()) {
            OiilExceptionInfo ex = (OiilExceptionInfo)enum2.nextElement();
            ex.setBundle(rb);
        }
    }

    void writeXMLElement(PrintWriter out, String sLibType, int[] libPlats) throws IOException {
        String[] pInfo;
        XMLElement xmlActionInfo = new XMLElement(sLibType);
        xmlActionInfo.setAttribute("EXT_NAME_ID", this.m_name);
        xmlActionInfo.setAttribute("DESC_ID", this.m_descID);
        if (this.m_bGenericName) {
            xmlActionInfo.setAttribute("ENTRY_POINT", this.m_genericClassName);
        } else if (!this.isActionSupportedOnAllPlatforms() && !OiilXMLHelper.arePlatsSame(libPlats, this.m_platforms)) {
            xmlActionInfo.setAttribute("PLATS", OiilXMLHelper.platArrToString(this.m_platforms));
        }
        xmlActionInfo.setAttribute("VISIBLE", this.isVisible() ? "TRUE" : "FALSE");
        if (this.getReturnType() != null) {
            xmlActionInfo.setAttribute("RETURN_TYPE", this.getReturnType().getName());
        }
        if (this.isDeprecated()) {
            xmlActionInfo.setAttribute("DEPR", "TRUE");
            if (this.getDeprecatedDescription() != null) {
                xmlActionInfo.setAttribute("DEPR_ID", this.getDeprecatedDescription());
            }
        }
        Vector uniquePlatInfo = null;
        boolean bPlatInfoGenerated = false;
        if (!this.m_bGenericName && this.m_platSpecInfo.size() > 0 && (uniquePlatInfo = this.getUniquePlatInfo()).size() == 1 && (pInfo = (String[])uniquePlatInfo.elementAt(0))[NAT_LIB].trim().length() == 0 && pInfo[NAT_LIB].trim().length() == 0) {
            xmlActionInfo.setAttribute("ENTRY_POINT", pInfo[METHOD]);
            bPlatInfoGenerated = true;
        }
        out.println(OixsXMLOps.getStartTag(xmlActionInfo));
        XMLElement xmlArgList = new XMLElement("ARGUMENT_LIST");
        out.println(OixsXMLOps.getStartTag(xmlArgList));
        Enumeration enum_1 = this.getAllArguments();
        while (enum_1 != null && enum_1.hasMoreElements()) {
            OiilActionArg arg = (OiilActionArg)enum_1.nextElement();
            arg.writeXMLElement(out, this.m_bGenericName, this.m_platforms);
        }
        out.println(OixsXMLOps.getEndTag(xmlArgList));
        XMLElement xmlExcList = new XMLElement("EXCEPTION_LIST");
        out.println(OixsXMLOps.getStartTag(xmlExcList));
        enum_1 = this.getAllExceptions();
        while (enum_1 != null && enum_1.hasMoreElements()) {
            OiilExceptionInfo exc = (OiilExceptionInfo)enum_1.nextElement();
            exc.writeXMLElement(out);
        }
        out.println(OixsXMLOps.getEndTag(xmlExcList));
        if (uniquePlatInfo != null) {
            XMLElement xmlPlatSp = new XMLElement("PLAT_SPECIFIC");
            out.println(OixsXMLOps.getStartTag(xmlPlatSp));
            for (int i = 0; !bPlatInfoGenerated && i < uniquePlatInfo.size(); ++i) {
                String[] pInfo2 = (String[])uniquePlatInfo.elementAt(i);
                XMLElement xmlPlats = new XMLElement("PLATS");
                xmlPlats.setAttribute("ID", pInfo2[PLAT]);
                out.println(OixsXMLOps.getStartTag(xmlPlats));
                XMLElement xmlEP = new XMLElement("ENTRY_POINT");
                xmlEP.setAttribute("FILE", pInfo2[METHOD]);
                xmlEP.print(out);
                XMLElement xmlNatLib = new XMLElement("NATIVE_LIBRARIES");
                xmlNatLib.setAttribute("FILE", pInfo2[NAT_LIB]);
                xmlNatLib.print(out);
                XMLElement xmlLC = new XMLElement("LIBRARY_CLASS");
                xmlLC.setAttribute("FILE", pInfo2[NAT_CLASS]);
                xmlLC.print(out);
                out.println(OixsXMLOps.getEndTag(xmlPlats));
            }
            out.println(OixsXMLOps.getEndTag(xmlPlatSp));
        }
        out.println(OixsXMLOps.getEndTag(xmlActionInfo));
    }

    private Vector getUniquePlatInfo() {
        Vector<String[]> uniquePlatInfo = new Vector<String[]>();
        for (int i = 0; i < this.m_platSpecInfo.size(); ++i) {
            OiilPlatInfo pInfo = (OiilPlatInfo)this.m_platSpecInfo.elementAt(i);
            String[] platSpInfo = new String[4];
            platSpInfo[OiilActionInfo.METHOD] = pInfo.getMethodName();
            platSpInfo[OiilActionInfo.NAT_LIB] = OiilXMLHelper.strArrToStr(pInfo.getNativeLibraryNames());
            platSpInfo[OiilActionInfo.NAT_CLASS] = OiilXMLHelper.strArrToStr(pInfo.getNativeClassNames());
            platSpInfo[OiilActionInfo.PLAT] = OiixPlatform.getPlatformCommonName(pInfo.getPlatform());
            boolean bFound = false;
            for (int j = 0; j < uniquePlatInfo.size(); ++j) {
                String[] savedPlatInfo = (String[])uniquePlatInfo.elementAt(j);
                if (!platSpInfo[METHOD].equals(savedPlatInfo[METHOD]) || !platSpInfo[NAT_LIB].equals(savedPlatInfo[NAT_LIB]) || !platSpInfo[NAT_CLASS].equals(savedPlatInfo[NAT_CLASS])) continue;
                int n = PLAT;
                savedPlatInfo[n] = savedPlatInfo[n] + " " + platSpInfo[PLAT];
                bFound = true;
                break;
            }
            if (bFound) continue;
            uniquePlatInfo.addElement(platSpInfo);
        }
        return uniquePlatInfo;
    }
}

