/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiijRACFileInstantiator {
    private String m_sTLDepMode;
    private String m_sSourceLocation;
    private String m_sOracleHome;
    public static final String RACLIST_JARNAME = "racfiles.jar";
    public static final String RACLIST_FILENAME = "racfiles.lst";
    public static final String RACLIST_INSTALL_FILENAME = "installCopyFile.lst";
    private static final String DELIM = "%";

    public OiijRACFileInstantiator(String sSourceLocation, String sTLDepMode, String sOracleHome) {
        this.m_sTLDepMode = sTLDepMode;
        this.m_sSourceLocation = sSourceLocation;
        this.m_sOracleHome = sOracleHome;
    }

    public void instantiateList() {
        String sScratchPath = System.getProperties().getProperty("oracle.installer.scratchPath");
        String sRACJarFile = OiixPathOps.concatPath(this.m_sSourceLocation, RACLIST_JARNAME);
        File fRACJar = new File(sRACJarFile = OiixPathOps.getNativeForm(sRACJarFile));
        if (!fRACJar.exists()) {
            return;
        }
        String sSource = this.m_sTLDepMode + "_" + RACLIST_FILENAME;
        String sCopiedSource = OiixPathOps.concatPath(sScratchPath, sSource);
        String sTargetFile = OiixPathOps.concatPath(sScratchPath, RACLIST_INSTALL_FILENAME);
        sTargetFile = OiixPathOps.getNativeForm(sTargetFile);
        if (!this.copyRACFile(sRACJarFile, sSource, sCopiedSource)) {
            return;
        }
        int nFiles = 0;
        try {
            String sInput;
            BufferedReader bis = new BufferedReader(new FileReader(sCopiedSource));
            PrintWriter pos = new PrintWriter(new BufferedWriter(new FileWriter(sTargetFile, true)));
            while ((sInput = bis.readLine()) != null) {
                int lastIndex = sInput.lastIndexOf(DELIM);
                String sReplace = OiixPathOps.concatPath(this.m_sOracleHome, sInput.substring(lastIndex + 1));
                pos.write(sReplace);
                pos.println();
                ++nFiles;
            }
            bis.close();
            pos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        OiiolTextLogger.appendText("FASTCOPYRAC : The instantantiated RACfiles list file is :" + sTargetFile + ". The file has got " + nFiles + " entries");
    }

    private boolean copyRACFile(String sRACJarFile, String sSource, String sDest) {
        boolean bCopied = false;
        try {
            FileInputStream fis = new FileInputStream(sRACJarFile);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String sEntry = ze.getName();
                if (!sEntry.equals(sSource)) {
                    zis.closeEntry();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(sDest);
                OiixFileOps.copyStream(zis, fos, sDest, false);
                zis.closeEntry();
                bCopied = true;
                break;
            }
            fis.close();
            zis.close();
        }
        catch (Exception ex) {
            bCopied = false;
        }
        return bCopied;
    }
}

