/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.IOException;
import java.util.LinkedList;
import oracle.sysman.oii.oiij.OiijFastJarExtracter;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;

public class OiijJarExtractQueue {
    private final int m_nThreads;
    private final OiijJarExtractWorker[] m_threads;
    private final LinkedList m_requests;
    private String m_sSourceRoot;
    private boolean m_bForceShutdown;
    private static int UNINITIALIZED = 0;
    private static int WAITING = 1;
    private static int DONE_WAITING = 2;
    private static int EXECUTE = 3;
    private static int DONE_EXECUTE = 4;
    private static int DONE_WORK = 5;

    public OiijJarExtractQueue(int nThreads, String sSourceRoot) throws IOException {
        this.m_nThreads = nThreads;
        this.m_requests = new LinkedList();
        this.m_sSourceRoot = sSourceRoot;
        this.m_threads = new OiijJarExtractWorker[nThreads];
        for (int i = 0; i < nThreads; ++i) {
            this.m_threads[i] = new OiijJarExtractWorker();
            this.m_threads[i].start();
        }
        this.confirmThreadsStart();
    }

    private void confirmThreadsStart() {
        for (int i = 0; i < this.m_nThreads; ++i) {
            OiijJarExtractWorker ojw = this.m_threads[i];
            while (!ojw.isAlive()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(OiijFastJarExtracter ofje) {
        LinkedList linkedList = this.m_requests;
        synchronized (linkedList) {
            this.m_requests.addLast(ofje);
            this.m_requests.notify();
        }
    }

    public void waitForCompletion(boolean bInterrupt) {
        for (int i = 0; i < this.m_nThreads; ++i) {
            OiijJarExtractWorker ojw = this.m_threads[i];
            while (!this.m_requests.isEmpty() || ojw.getStatus() != WAITING) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
            if (!bInterrupt) continue;
            this.m_threads[i].interrupt();
        }
    }

    boolean areThreadsWaiting() {
        boolean bRet = false;
        for (int i = 0; i < this.m_nThreads; ++i) {
            OiijJarExtractWorker ojw = this.m_threads[i];
            if (!this.m_requests.isEmpty() || ojw.getStatus() != WAITING) {
                bRet = false;
                break;
            }
            bRet = true;
        }
        return bRet;
    }

    void shutdownThreads(boolean bForce) {
        this.m_bForceShutdown = bForce;
        for (int i = 0; i < this.m_nThreads; ++i) {
            this.m_threads[i].interrupt();
        }
    }

    public void setSourceStage(String sSourceRoot) throws IOException {
        this.m_sSourceRoot = sSourceRoot;
        for (int i = 0; i < this.m_nThreads; ++i) {
            OiijJarExtractWorker ojw = this.m_threads[i];
            ojw.setSourceStage(this.m_sSourceRoot);
        }
    }

    static /* synthetic */ int access$000() {
        return UNINITIALIZED;
    }

    private class OiijJarExtractWorker
    extends Thread {
        int m_nStatus = OiijJarExtractQueue.access$000();
        private int BUFF_SIZE = 512;
        private byte[] _buffer = new byte[this.BUFF_SIZE];
        OiiofFileLoader _oFileLoader;

        public OiijJarExtractWorker() throws IOException {
            this.setSourceStage(OiijJarExtractQueue.this.m_sSourceRoot);
        }

        void setSourceStage(String sSourceRoot) throws IOException {
            this._oFileLoader = OiiofFileLoaderFactory.createFileLoader(sSourceRoot, System.getProperties().getProperty("oracle.installer.scratchPath"));
        }

        int getStatus() {
            return this.m_nStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OiijFastJarExtracter ofje = null;
            boolean bInterrupted = false;
            while (!OiijJarExtractQueue.this.m_bForceShutdown) {
                LinkedList linkedList = OiijJarExtractQueue.this.m_requests;
                synchronized (linkedList) {
                    while (OiijJarExtractQueue.this.m_requests.isEmpty()) {
                        try {
                            this.m_nStatus = WAITING;
                            OiijJarExtractQueue.this.m_requests.wait();
                            this.m_nStatus = DONE_WAITING;
                        }
                        catch (InterruptedException ignored) {
                            bInterrupted = true;
                            break;
                        }
                    }
                    if (bInterrupted) {
                        break;
                    }
                    ofje = (OiijFastJarExtracter)OiijJarExtractQueue.this.m_requests.removeFirst();
                }
                try {
                    this.m_nStatus = EXECUTE;
                    ofje.setBufferInfo(this._buffer, this.BUFF_SIZE);
                    this._oFileLoader.setBufferInfo(this._buffer, this.BUFF_SIZE);
                    ofje.setFileLoader(this._oFileLoader);
                    ofje.extract();
                    this.m_nStatus = DONE_EXECUTE;
                }
                catch (Exception e) {
                    if (OiijJarExtractQueue.this.m_bForceShutdown) break;
                    e.printStackTrace();
                    break;
                }
            }
            this.m_nStatus = DONE_WORK;
        }
    }
}

