/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiij.OiijDefaultJarListReader;
import oracle.sysman.oii.oiij.OiijFastCopyCompDetails;
import oracle.sysman.oii.oiij.OiijFastCopyCompInfo;
import oracle.sysman.oii.oiij.OiijFastCopyData;
import oracle.sysman.oii.oiij.OiijFastCopyExpandedFiles;
import oracle.sysman.oii.oiij.OiijFastCopyPhaseDiskDetails;
import oracle.sysman.oii.oiij.OiijFastJarExtracter;
import oracle.sysman.oii.oiij.OiijJarExtractQueue;
import oracle.sysman.oii.oiij.OiijRACFileInstantiator;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiijFastCopyPhase {
    private OiijFastCopyData m_oFastCopyData;
    private int m_nDisk;
    private String m_sTargetOracleHome;
    private String m_sStageSource;
    private String m_sTLDepMode;
    private int m_nThreads;
    private boolean m_bUpdateProgress = true;
    private OiixProgressListener m_progressListener;
    private String m_sRACLstFile;
    private boolean m_bIsDirsCreated;
    private String m_sFastCopyRoot;
    private String m_sScratchPath;
    private boolean m_bDone;
    private boolean m_bRACInstall;
    private OiifwActionsPhaseWCDE m_actionsWCDE;
    public static final int CREATE_DIRS = 1;
    public static final int EXTRACT_DEFAULT_JARS = 2;
    public static final int SETPERMS = 4;
    public static final int EXTRACT_FILEMAP = 8;
    public static final int INSTANTIATE_RAC = 16;
    public static final int APPLY_SHUTDOWN = 32;
    public static final int COPY_TO_SCRATCH = 64;
    public static final int COPY_EXPANDED_FILES = 128;
    private int m_nMode = 199;
    private OiijJarExtractQueue m_jarQueue = null;
    private String m_sExpandedFilesLoc = null;
    private HashMap m_hmSelComps;
    private int m_nExpInterruptCount = 0;
    private int BUFF_SIZE = 512;
    private byte[] _buffer = new byte[this.BUFF_SIZE];
    private String CUSTOM = "Custom";

    public OiijFastCopyPhase(OiijFastCopyData ofcd, int nDisk, String sTargetOracleHome, String sStageSource, String sTLDepMode, boolean bInstantiateRAC) {
        this.m_oFastCopyData = ofcd;
        this.m_nDisk = nDisk;
        this.m_sTargetOracleHome = sTargetOracleHome;
        this.m_sStageSource = sStageSource;
        this.m_sTLDepMode = sTLDepMode;
        this.m_sScratchPath = System.getProperties().getProperty("oracle.installer.scratchPath");
        this.m_sFastCopyRoot = OiixPathOps.concatPath(this.m_sScratchPath, this.m_oFastCopyData.getFastCopyDir());
        if (bInstantiateRAC) {
            this.m_nMode |= 0x10;
            this.m_bRACInstall = true;
        }
        if (ofcd.getDisks() == 1) {
            this.m_nMode |= 0x20;
        }
        this.m_hmSelComps = new HashMap();
    }

    public void setMode(int nMode) {
        this.m_nMode = nMode;
    }

    public void addMode(int nMode) {
        this.m_nMode |= nMode;
    }

    void setUpdateProgress(boolean bUpdateProgress) {
        this.m_bUpdateProgress = bUpdateProgress;
    }

    public void initialize() throws OiifbEndIterateException {
        String sThreads = System.getProperties().getProperty("oracle.installer.copythreads");
        if (sThreads == null || sThreads.trim().length() == 0) {
            this.m_nThreads = 1;
        } else {
            try {
                this.m_nThreads = Integer.parseInt(sThreads);
                if (this.m_nThreads > 8) {
                    this.m_nThreads = 8;
                }
            }
            catch (NumberFormatException nfe) {
                this.m_nThreads = 1;
            }
        }
        if (this.m_bUpdateProgress) {
            this.m_progressListener = OiicSessionInterfaceManager.getInterfaceManager().getProgressListener();
            if (this.m_progressListener != null) {
                Object[] args = new Object[]{this.m_sTargetOracleHome};
                String sMsg = OiixResourceBundle.getString("S_FASTCOPY_PROGRESS", args);
                this.m_progressListener.setStatus(sMsg);
            }
        }
    }

    private OiijJarExtractQueue getJarExtractQueue(int nThreads, String sStageSource) throws IOException {
        if (this.m_jarQueue != null || this.m_nThreads == 1) {
            return this.m_jarQueue;
        }
        this.m_jarQueue = new OiijJarExtractQueue(nThreads, sStageSource);
        return this.m_jarQueue;
    }

    public void doFastModeOperations(int nDisk) throws OiifbEndIterateException {
        long lTime;
        String sDebugTMDMsg;
        this.m_nDisk = nDisk;
        boolean bShutdown = false;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        long lCurTime = 0L;
        if (isDebugTMD) {
            lCurTime = System.currentTimeMillis();
            sDebugTMDMsg = "Start of FastCopy Phase for Disk :" + this.m_nDisk;
            OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lCurTime, 0L, null);
        }
        try {
            if ((this.m_nMode & 0x40) == 64) {
                this.copyFilesToScratch();
            }
        }
        catch (IOException ioe) {
            throw new OiifbEndIterateException(ioe);
        }
        catch (OiifbCancelException oce) {
            if (System.getProperty("oracle.installer.exitOnStopInstall", "false").equals("true")) {
                OiicExitCode.setExitCode(-4);
            }
            throw new OiifbEndIterateException(oce);
        }
        try {
            if ((this.m_nMode & 1) == 1) {
                this.createDirs();
            }
            this.handleInstallInterruption();
            try {
                this.doFileOperations(true);
                if ((this.m_nMode & 8) == 8) {
                    this.extractFileMap(this.m_jarQueue);
                }
                if (this.m_nThreads != 1) {
                    this.waitForCompletion(false);
                }
                if (isDebugTMD) {
                    lTime = System.currentTimeMillis();
                    sDebugTMDMsg = "End of HAR EXTRACTION Phase for Disk :" + this.m_nDisk;
                    OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, lTime - lCurTime, null);
                }
                if ((this.m_nMode & 0x80) == 128 && this.m_sExpandedFilesLoc != null) {
                    this.copyExpandedFiles(this.m_sExpandedFilesLoc);
                    this.setExpandedFilesLoc(null);
                }
                this.doFileOperations(false);
                boolean bl = bShutdown = (this.m_nMode & 0x20) == 32 || this.m_nDisk == this.m_oFastCopyData.getMaxDiskNumber();
                if (this.m_nThreads != 1) {
                    this.waitForCompletion(bShutdown);
                }
                if ((this.m_nMode & 0x80) == 128 && this.m_sExpandedFilesLoc != null) {
                    this.copyExpandedFiles(this.m_sExpandedFilesLoc);
                    this.setExpandedFilesLoc(null);
                }
            }
            catch (OiifbEndIterateException eix) {
                if (this.m_jarQueue != null) {
                    this.m_jarQueue.shutdownThreads(true);
                }
                throw eix;
            }
        }
        catch (IOException ioe) {
            throw new OiifbEndIterateException(ioe);
        }
        catch (OiifbCancelException oce) {
            if (System.getProperty("oracle.installer.exitOnStopInstall", "false").equals("true")) {
                OiicExitCode.setExitCode(-4);
            }
            throw new OiifbEndIterateException(oce);
        }
        catch (OiifbEndIterateException oeix) {
            throw oeix;
        }
        catch (Exception ex) {
            throw new OiifbEndIterateException(ex);
        }
        if ((this.m_nMode & 0x10) == 16) {
            this.instantiateRACList();
        }
        if ((this.m_nMode & 4) == 4 && OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            this.execPermissions();
        }
        this.m_oFastCopyData.setDoneFastCopy(this.m_nDisk, true);
        if (!this.m_bRACInstall && bShutdown) {
            this.delRACFiles();
        }
        this.handleInstallInterruption();
        if (isDebugTMD) {
            lTime = System.currentTimeMillis();
            sDebugTMDMsg = "End of FastCopy Phase for Disk :" + this.m_nDisk;
            OiixDebug.printDebugTMDMesages(sDebugTMDMsg, lTime, lTime - lCurTime, null);
        }
    }

    private void doFileOperations(boolean bComponentFiles) throws IOException, OiifbCancelException, OiifbEndIterateException {
        String sDefaultFilesLoc = null;
        String sExpandedFilesLoc = null;
        if (!bComponentFiles) {
            OiijFastCopyPhaseDiskDetails ofcd = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk);
            if (ofcd != null) {
                sDefaultFilesLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getPatchDefaultJarList();
                sExpandedFilesLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getPatchExpandedFilesList();
            }
            if (sDefaultFilesLoc == null && sExpandedFilesLoc == null) {
                this.setExpandedFilesLoc(null);
                return;
            }
        } else {
            OiijFastCopyPhaseDiskDetails ofcd = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk);
            if (ofcd != null) {
                sDefaultFilesLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getDefaultJarList();
                sExpandedFilesLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getExpandedFilesList();
            }
        }
        if ((this.m_nMode & 2) == 2) {
            this.readAndExtract(sDefaultFilesLoc);
        }
        if ((this.m_nMode & 0x80) == 128) {
            this.setExpandedFilesLoc(sExpandedFilesLoc);
        }
    }

    private void setExpandedFilesLoc(String sLoc) {
        this.m_sExpandedFilesLoc = sLoc;
    }

    private void waitForCompletion(boolean bShutdown) throws OiifbEndIterateException {
        int curPriority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(1);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_jarQueue != null) {
            while (!this.m_jarQueue.areThreadsWaiting()) {
                try {
                    Thread.sleep(2000L);
                    this.handleInstallInterruption();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (OiifbEndIterateException oe) {
                    Thread.currentThread().setPriority(curPriority);
                    throw oe;
                }
            }
            if (bShutdown) {
                this.m_jarQueue.shutdownThreads(false);
            }
        }
        Thread.currentThread().setPriority(curPriority);
    }

    private void copyExpandedFiles(String sListLocation) throws IOException, OiifbCancelException, OiifbEndIterateException {
        if (sListLocation == null) {
            OiiolTextLogger.appendText("No expanded files copied for disk " + this.m_nDisk);
            return;
        }
        sListLocation = OiixPathOps.concatPath(this.m_sFastCopyRoot, sListLocation);
        OiijFastCopyExpandedFiles ofce = new OiijFastCopyExpandedFiles(sListLocation);
        OiiolTextLogger.appendText("The expanded list location :" + sListLocation);
        OiiofFileLoader oFileLoader = OiiofFileLoaderFactory.createFileLoader(this.m_sStageSource, System.getProperties().getProperty("oracle.installer.scratchPath"));
        this.m_nExpInterruptCount = 0;
        Iterator compIterator = ofce.compIterator();
        while (compIterator.hasNext()) {
            OiijFastCopyCompInfo oInfo = (OiijFastCopyCompInfo)compIterator.next();
            this.processExpandedCompInfo(oInfo, oFileLoader);
        }
        this.m_nExpInterruptCount = 0;
        Iterator patchIterator = ofce.patchIterator();
        while (patchIterator.hasNext()) {
            OiijFastCopyCompInfo oInfo = (OiijFastCopyCompInfo)patchIterator.next();
            this.processExpandedCompInfo(oInfo, oFileLoader);
        }
        this.handleInstallInterruption();
    }

    private void processExpandedCompInfo(OiijFastCopyCompInfo oInfo, OiiofFileLoader oFileLoader) throws IOException, OiifbEndIterateException, OiifbCancelException {
        boolean bLog;
        boolean bl = bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        if (!this.isSelected(oInfo.getCompName(), oInfo.getCompVersion())) {
            OiiolTextLogger.appendText("FastCopy : The component info is ignored :" + oInfo.getCompName() + ":" + oInfo.getCompVersion());
            return;
        }
        HashMap hmFiles = oInfo.getExpandedFiles();
        Set sourceSet = hmFiles.keySet();
        boolean iCount = false;
        for (String sSource : sourceSet) {
            String sDest = (String)hmFiles.get(sSource);
            sDest = OiixPathOps.concatPath(this.m_sTargetOracleHome, sDest);
            oFileLoader.getLocalCopyToDest(sSource, sDest);
            if (this.m_progressListener != null) {
                File fdest = new File(sDest);
                this.m_progressListener.addBytes((int)fdest.length());
            }
            if (bLog) {
                OiiolTextLogger.appendText("Copied Expanded File to :" + sDest, OiiolTextLogger.LOG_GENERAL);
            }
            ++this.m_nExpInterruptCount;
            if (this.m_nExpInterruptCount < 5) continue;
            this.handleInstallInterruption();
            this.m_nExpInterruptCount = 0;
        }
    }

    public boolean isFastCopyDone() {
        return this.m_bDone;
    }

    public void setSourceStage(String sSourceStage) throws IOException {
        this.m_sStageSource = sSourceStage;
        if (this.m_jarQueue != null) {
            this.m_jarQueue.setSourceStage(sSourceStage);
        }
    }

    void readAndExtract(String sListLocation) throws OiifbCancelException, IOException, OiifbEndIterateException {
        int listSize;
        boolean bLog;
        boolean bl = bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        if (sListLocation == null) {
            OiijJarExtractQueue oje = this.getJarExtractQueue(1, this.m_sStageSource);
            return;
        }
        sListLocation = OiixPathOps.concatPath(this.m_sFastCopyRoot, sListLocation);
        OiijDefaultJarListReader reader = new OiijDefaultJarListReader(sListLocation);
        reader.readList();
        if (this.m_jarQueue == null && (listSize = reader.getListSize()) < 10) {
            this.m_nThreads = 1;
        }
        OiiolTextLogger.appendText("Number of threads for fast copy :" + this.m_nThreads);
        Iterator compIterator = reader.compIterator();
        OiijJarExtractQueue oje = this.getJarExtractQueue(this.m_nThreads, this.m_sStageSource);
        while (compIterator.hasNext()) {
            OiijFastCopyCompInfo oInfo = (OiijFastCopyCompInfo)compIterator.next();
            this.processCompInfo(oInfo, oje);
        }
        Iterator patchIterator = reader.patchIterator();
        while (patchIterator.hasNext()) {
            OiijFastCopyCompInfo oInfo = (OiijFastCopyCompInfo)patchIterator.next();
            this.processCompInfo(oInfo, oje);
        }
        if (bLog) {
            OiiolTextLogger.writeLogWithTimeAndTrace("End of extraction", OiiolTextLogger.STR_LOG_GENERAL);
        }
    }

    private void processCompInfo(OiijFastCopyCompInfo oInfo, OiijJarExtractQueue oje) throws OiifbCancelException, IOException, OiifbEndIterateException {
        String sVersion;
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        String sName = oInfo.getCompName();
        if (!this.isSelected(sName, sVersion = oInfo.getCompVersion())) {
            OiiolTextLogger.appendText("FastCopy : The component info is ignored :" + sName + ":" + sVersion);
            return;
        }
        Iterator listIterator = oInfo.getFiles();
        while (listIterator.hasNext()) {
            String sJarLoc = (String)listIterator.next();
            sJarLoc = OiixPathOps.concatPath(this.m_sStageSource, sJarLoc);
            if (bLog) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Default Jar to be extracted :" + sJarLoc, OiiolTextLogger.STR_LOG_GENERAL);
            }
            OiijFastJarExtracter ofje = new OiijFastJarExtracter(sJarLoc, this.m_sTargetOracleHome, !this.m_bIsDirsCreated);
            ofje.setProgressListener(this.m_progressListener);
            if (this.m_nThreads == 1) {
                OiiofFileLoader oFileLoader = OiiofFileLoaderFactory.createFileLoader(this.m_sStageSource, System.getProperties().getProperty("oracle.installer.scratchPath"));
                ofje.setBufferInfo(this._buffer, this.BUFF_SIZE);
                oFileLoader.setBufferInfo(this._buffer, this.BUFF_SIZE);
                ofje.setFileLoader(oFileLoader);
                ofje.extract();
                this.handleInstallInterruption();
                continue;
            }
            oje.addRequest(ofje);
        }
    }

    private void createDirs() {
        File fDirs;
        String sDirsLstLoc;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        long lCurTime = 0L;
        boolean bCustomMode = false;
        if (isDebugTMD) {
            lCurTime = System.currentTimeMillis();
        }
        if ((sDirsLstLoc = this.m_oFastCopyData.getFCCompDetails(this.m_sTLDepMode).getDirsList()) == null) {
            return;
        }
        if (sDirsLstLoc.indexOf(this.CUSTOM) != -1) {
            bCustomMode = true;
        }
        if (!(fDirs = new File(sDirsLstLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.m_sFastCopyRoot, sDirsLstLoc)))).exists()) {
            this.m_bIsDirsCreated = false;
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Directory List not present for fast mode at " + sDirsLstLoc, OiiolTextLogger.STR_LOG_GENERAL);
            }
            return;
        }
        if (bCustomMode) {
            this.m_bIsDirsCreated = false;
            OiiolTextLogger.appendText("Ignoring Directory List for Custom Mode");
            return;
        }
        try {
            String sInput;
            BufferedReader bis = new BufferedReader(new FileReader(sDirsLstLoc));
            while ((sInput = bis.readLine()) != null) {
                String sTargetDir = OiixPathOps.concatPath(this.m_sTargetOracleHome, sInput);
                sTargetDir = OiixPathOps.getNativeForm(sTargetDir);
                OiixFileOps.mkdirs(new File(sTargetDir));
            }
            bis.close();
        }
        catch (IOException ex) {
            this.m_bIsDirsCreated = false;
        }
        this.m_bIsDirsCreated = true;
        if (isDebugTMD) {
            long lTime = System.currentTimeMillis();
            OiixDebug.printDebugTMDMesages("FastCopy : Creating Directories ", lTime, lTime - lCurTime, null);
        }
    }

    private void extractFileMap(OiijJarExtractQueue oje) throws OiifbCancelException, IOException {
        File fFileMapJar;
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        String sFileMapJarLoc = OiixPathOps.concatPath(this.m_sFastCopyRoot, this.m_oFastCopyData.getFilemapJarLocation());
        sFileMapJarLoc = OiixPathOps.getNativeForm(sFileMapJarLoc);
        if (bLog) {
            OiiolTextLogger.writeLogWithTimeAndTrace("Extracting filemap jar from :" + sFileMapJarLoc, OiiolTextLogger.STR_LOG_GENERAL);
        }
        if (!(fFileMapJar = new File(sFileMapJarLoc)).exists()) {
            if (bLog) {
                OiiolTextLogger.appendText("WARNING : Fastcopy Filemap not present at :" + sFileMapJarLoc);
            }
            return;
        }
        String sTargetFileMapDir = OiixPathOps.concatPath(this.m_sTargetOracleHome, "inventory");
        sTargetFileMapDir = OiixPathOps.concatPath(sTargetFileMapDir, "filemap");
        sTargetFileMapDir = OiixPathOps.getNativeForm(sTargetFileMapDir);
        if (bLog) {
            OiiolTextLogger.writeLogWithTimeAndTrace("Target filemap dir for extraction:" + sTargetFileMapDir, OiiolTextLogger.STR_LOG_GENERAL);
        }
        OiijFastJarExtracter ofje = new OiijFastJarExtracter(sFileMapJarLoc, sTargetFileMapDir, true);
        if (this.m_nThreads == 1) {
            OiiofFileLoader oFileLoader = OiiofFileLoaderFactory.createFileLoader(this.m_sStageSource, System.getProperties().getProperty("oracle.installer.scratchPath"));
            ofje.setBufferInfo(this._buffer, this.BUFF_SIZE);
            oFileLoader.setBufferInfo(this._buffer, this.BUFF_SIZE);
            ofje.setFileLoader(oFileLoader);
            ofje.extract();
        } else {
            oje.addRequest(ofje);
        }
    }

    private void instantiateRACList() {
        OiijRACFileInstantiator orfi = new OiijRACFileInstantiator(this.m_sFastCopyRoot, this.m_sTLDepMode, this.m_sTargetOracleHome);
        orfi.instantiateList();
    }

    private void execPermissions() {
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        long lCurTime = 0L;
        if (isDebugTMD) {
            lCurTime = System.currentTimeMillis();
        }
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        String sLoc = null;
        if (this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk) != null) {
            sLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getPermsScript();
        }
        if (sLoc == null) {
            if (bLog) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Warning : Permissions scripts were not generated :", OiiolTextLogger.STR_LOG_GENERAL);
            }
            return;
        }
        String sPermsLoc = OiixPathOps.concatPath(this.m_sFastCopyRoot, sLoc);
        File fPerms = new File(sPermsLoc = OiixPathOps.getNativeForm(sPermsLoc));
        if (!fPerms.exists()) {
            if (bLog) {
                OiiolTextLogger.appendText("WARNING :Permissions script does not exist :" + sPermsLoc);
            }
            return;
        }
        OiiolTextLogger.appendText("Executing permissions file from :" + sPermsLoc);
        String sCWD = OiixEnvironmentOps.getCurrentWorkingDir();
        OiixEnvironmentOps.changeDir(this.m_sTargetOracleHome);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(OiixPathOps.concatPath(this.m_sScratchPath, "setpermslog.err")));
            OiixSpawner oSpawn = new OiixSpawner(System.out, bos);
            oSpawn.setLogOutput(true);
            try {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(sPermsLoc));
                while ((str = in.readLine()) != null) {
                    if (!str.startsWith("chmod")) continue;
                    OiiolTextLogger.appendText(str);
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            oSpawn.execute("sh " + sPermsLoc);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OiixEnvironmentOps.changeDir(sCWD);
        OiiolTextLogger.appendText("DONE Executing permissions file from :" + sPermsLoc);
        if (isDebugTMD) {
            long lTime = System.currentTimeMillis();
            OiixDebug.printDebugTMDMesages("FastCopy : Executing Permissions script ", lTime, lTime - lCurTime, null);
        }
    }

    private void execPermissionsAsync() {
        String sScripts;
        boolean bLog;
        long lCurTime;
        boolean isDebugTMD;
        block11: {
            isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
            lCurTime = 0L;
            if (isDebugTMD) {
                lCurTime = System.currentTimeMillis();
            }
            bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
            String sLoc = null;
            if (this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk) != null) {
                sLoc = this.m_oFastCopyData.getFCDiskDetails(this.m_nDisk).getPermsScript();
            }
            if (sLoc == null) {
                if (bLog) {
                    OiiolTextLogger.writeLogWithTimeAndTrace("Warning : Permissions scripts were not generated :", OiiolTextLogger.STR_LOG_GENERAL);
                }
                return;
            }
            String sPermsLoc = OiixPathOps.concatPath(this.m_sFastCopyRoot, sLoc);
            File fPerms = new File(sPermsLoc = OiixPathOps.getNativeForm(sPermsLoc));
            if (!fPerms.exists()) {
                if (bLog) {
                    OiiolTextLogger.appendText("WARNING :Permissions script does not exist :" + sPermsLoc);
                }
                return;
            }
            sScripts = this.generateExecScript(sLoc, sPermsLoc);
            if (bLog) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Executing permissions file from :" + sScripts, OiiolTextLogger.STR_LOG_GENERAL);
            }
            try {
                Runtime.getRuntime().exec("sh " + sScripts);
            }
            catch (IOException ioe) {
                if (!bLog) break block11;
                OiiolTextLogger.writeLogWithTimeAndTrace("DONE Exception in executing permissions file from :" + sScripts, OiiolTextLogger.STR_LOG_GENERAL);
            }
        }
        if (bLog) {
            OiiolTextLogger.writeLogWithTimeAndTrace("DONE Executing permissions file from :" + sScripts, OiiolTextLogger.STR_LOG_GENERAL);
        }
        if (isDebugTMD) {
            long lTime = System.currentTimeMillis();
            OiixDebug.printDebugTMDMesages("FastCopy : Executing Permissions script ", lTime, lTime - lCurTime, null);
        }
    }

    private String generateExecScript(String sLoc, String sPermsLoc) {
        String sScript = "exec" + sLoc;
        sScript = OiixPathOps.concatPath(this.m_sFastCopyRoot, sScript);
        sScript = OiixPathOps.getStandardForm(sScript);
        String sErr = OiixPathOps.concatPath(this.m_sFastCopyRoot, "exec_err.err");
        sErr = OiixPathOps.getStandardForm(sErr);
        String sOut = OiixPathOps.concatPath(this.m_sFastCopyRoot, "exec_out.out");
        sOut = OiixPathOps.getStandardForm(sOut);
        try {
            BufferedWriter scriptFile = new BufferedWriter(new FileWriter(sScript));
            String sLine = "#!/bin/sh\n";
            scriptFile.write(sLine, 0, sLine.length());
            sLine = "cd " + this.m_sTargetOracleHome + "\n";
            scriptFile.write(sLine, 0, sLine.length());
            sLine = "sh " + sPermsLoc + " 1>" + sOut + " 2>" + sErr + " \n";
            scriptFile.write(sLine, 0, sLine.length());
            scriptFile.flush();
            scriptFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sScript;
    }

    private void copyFilesToScratch() throws IOException, OiifbCancelException {
        String sFile;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
            OiiolTextLogger.writeLogWithTimeAndTrace("Copying FastCopy related files to scratchPath", OiiolTextLogger.STR_LOG_GENERAL);
        }
        this.m_sFastCopyRoot = OiixPathOps.getNativeForm(this.m_sFastCopyRoot);
        File fFastCopyRoot = new File(this.m_sFastCopyRoot);
        fFastCopyRoot.mkdirs();
        OiiofFileLoader ofl = OiiofFileLoaderFactory.createFileLoader(this.m_sStageSource, this.m_sScratchPath);
        boolean bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL;
        int nDisks = this.m_oFastCopyData.getDisks();
        String sLocalFile = null;
        OiijFastCopyCompDetails ofcc = this.m_oFastCopyData.getFCCompDetails(this.m_sTLDepMode);
        Object[] oArgs = new Object[1];
        Iterator itr = ofcc.iteratorNonSetPermsFiles();
        while (itr.hasNext()) {
            sFile = (String)itr.next();
            oArgs[0] = sFile;
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_FASTCOPY_FILE_USED", oArgs));
            sLocalFile = this.copyToScratch(ofl, sFile, sFile);
            if (!bLog) continue;
            OiiolTextLogger.writeLogWithTimeAndTrace("Copying FastCopy file to scratchPath :" + sLocalFile, OiiolTextLogger.STR_LOG_GENERAL);
        }
        itr = ofcc.iteratorSetPermsFiles();
        while (itr.hasNext()) {
            sFile = (String)itr.next();
            oArgs[0] = sFile;
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_FASTCOPY_FILE_USED", oArgs));
            String sSourcePerms = this.copyToScratch(ofl, sFile, sFile + ".org");
            sLocalFile = OiixPathOps.concatPath(this.m_sFastCopyRoot, sFile);
            sLocalFile = OiixPathOps.getNativeForm(sLocalFile);
            OiixFileOps.copyFileAsText(sSourcePerms, sLocalFile);
            if (!bLog) continue;
            OiiolTextLogger.writeLogWithTimeAndTrace("Copying FastCopy SetPerms file to scratchPath :" + sLocalFile, OiiolTextLogger.STR_LOG_GENERAL);
        }
    }

    private String copyToScratch(OiiofFileLoader ofl, String sSource, String sDest) throws IOException, OiifbCancelException {
        String sLocalFile = OiixPathOps.concatPath(this.m_sFastCopyRoot, sDest);
        sLocalFile = OiixPathOps.getNativeForm(sLocalFile);
        String sStageFile = OiixPathOps.concatPath(this.m_oFastCopyData.getFastCopyDir(), sSource);
        return ofl.getLocalCopyToDest(sStageFile, sLocalFile);
    }

    private void delRACFiles() {
        String sDelLstLoc;
        boolean isDebugTMD = OiixDebug.PRINT_TIME || OiixDebug.PRINT_MEMORY || OiixDebug.PRINT_DISKUSAGE;
        long lCurTime = 0L;
        if (isDebugTMD) {
            lCurTime = System.currentTimeMillis();
        }
        if ((sDelLstLoc = this.m_oFastCopyData.getFCCompDetails(this.m_sTLDepMode).getDelFilesList()) == null) {
            return;
        }
        File fLoc = new File(sDelLstLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.m_sFastCopyRoot, sDelLstLoc)));
        if (!fLoc.exists()) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_GENERAL) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Del files list not present for fast mode : " + sDelLstLoc, OiiolTextLogger.STR_LOG_GENERAL);
            }
            return;
        }
        try {
            String sInput;
            BufferedReader bis = new BufferedReader(new FileReader(sDelLstLoc));
            while ((sInput = bis.readLine()) != null) {
                String sTargetFile = OiixPathOps.concatPath(this.m_sTargetOracleHome, sInput);
                File fTarget = new File(sTargetFile = OiixPathOps.getNativeForm(sTargetFile));
                boolean bDel = fTarget.delete();
                if (bDel) continue;
                OiiolTextLogger.appendText("Warning :  Fastcopy mode, unable to delete file :" + sTargetFile);
            }
            bis.close();
        }
        catch (IOException ex) {
            OiiolTextLogger.appendText("Exception in deleting files in FastCopy Mode :" + ex.getMessage());
        }
        if (isDebugTMD) {
            long lTime = System.currentTimeMillis();
            OiixDebug.printDebugTMDMesages("FastCopy : deleting files in NON-RAC mode ", lTime, lTime - lCurTime, null);
        }
    }

    public void dispose() {
    }

    public void setActionsWCDE(OiifwActionsPhaseWCDE actionsWCDE) {
        this.m_actionsWCDE = actionsWCDE;
    }

    void handleInstallInterruption() throws OiifbEndIterateException {
        if (this.m_actionsWCDE.isInstallInterrupted() && this.m_actionsWCDE.isSessionCancelled()) {
            if (System.getProperty("oracle.installer.exitOnStopInstall", "false").equals("true")) {
                OiicExitCode.setExitCode(-4);
            }
            OiifbCancelException installException = new OiifbCancelException(OiixResourceBundle.getString("S_USER_CANCEL_INS"), true);
            throw new OiifbEndIterateException(installException);
        }
    }

    public void setSelectedComps(HashMap hmSelComps) {
        this.m_hmSelComps = hmSelComps;
    }

    private boolean isSelected(String sName, String sVersion) {
        String sKey = sName + ":" + sVersion;
        Object oID = this.m_hmSelComps.get(sKey);
        return oID != null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage : OiijFastCopyPhase <FastCopyXMLLocation> <TargetOH> <StageSource> <TopLevel_DepMode>");
            return;
        }
        OiijFastCopyData ofcd = new OiijFastCopyData(args[0]);
        ofcd.setTLDepMode(args[3]);
        OiijFastCopyPhase copier = new OiijFastCopyPhase(ofcd, 1, args[1], args[2], args[3], false);
        OiiolTextLogger.setEnabled(false);
        copier.setUpdateProgress(false);
        copier.initialize();
        copier.addMode(32);
        copier.doFastModeOperations(1);
    }
}

