/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiij.OiijFastCopyCompDetails;
import oracle.sysman.oii.oiij.OiijFastCopyPhaseDiskDetails;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.xml.jaxp.JXDocumentBuilderFactory;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiijFastCopyData {
    private String m_sMetaDataFile;
    private String m_sTLDepMode;
    private Hashtable m_hFCCompDetails;
    private String m_sRACFilesLocation;
    private String m_sFilemapJarLocation;
    private String m_sFastCopyRoot;
    private int m_nDisks;
    private String m_sFastCopyDir;
    private boolean m_bSuccess;
    private HashSet m_hsFiles;
    private boolean m_bLog;
    private String m_sVersion;
    private static final String s_sCompatibleVersion = "10.2";

    public OiijFastCopyData(String sMetaDataFile) {
        this.m_sMetaDataFile = sMetaDataFile;
        this.m_hFCCompDetails = new Hashtable(3);
        this.m_bLog = OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_GENERAL;
        this.processFMMetaData();
    }

    private void processFMMetaData() {
        Document doc = null;
        Exception exception = null;
        try {
            doc = OiijFastCopyData.getDocument(this.m_sMetaDataFile);
            XMLElement elFastCopy = (XMLElement)doc.getDocumentElement();
            if (elFastCopy == null || !elFastCopy.getTagName().equals("FASTCOPY")) {
                this.m_bSuccess = false;
            } else {
                this.m_bSuccess = this.processFastCopyTag(elFastCopy);
                if (this.m_bLog) {
                    OiiolTextLogger.writeLogWithTimeAndTrace("FastCopyMode,  processing of fastcopy.xml :" + this.m_bSuccess, OiiolTextLogger.STR_LOG_GENERAL);
                }
            }
        }
        catch (IOException ioe) {
            this.m_bSuccess = false;
            exception = ioe;
        }
        catch (SAXException se) {
            this.m_bSuccess = false;
            exception = se;
        }
        catch (ParserConfigurationException pe) {
            this.m_bSuccess = false;
            exception = pe;
        }
        catch (Exception e) {
            this.m_bSuccess = false;
            exception = e;
        }
        if (exception != null && this.m_bLog) {
            OiiolTextLogger.writeLogWithTimeAndTrace("fastcopy.xml parsing failed, error :" + exception.getMessage(), OiiolTextLogger.STR_LOG_GENERAL);
        }
    }

    private boolean processFastCopyTag(XMLElement elFastCopy) {
        String sDisks = elFastCopy.getAttribute("DISKS");
        this.m_sFastCopyDir = elFastCopy.getAttribute("DIR");
        this.m_nDisks = Integer.parseInt(sDisks);
        this.m_sVersion = elFastCopy.getAttribute("VERSION");
        NodeList ntTopLevelComps = elFastCopy.getElementsByTagName("TOPLEVEL_COMPONENT");
        int nLen = ntTopLevelComps.getLength();
        if (nLen == 0) {
            if (this.m_bLog) {
                OiiolTextLogger.writeLogWithTimeAndTrace("FastCopyMode,  There is no TOP_LEVEL_COMPONENT tag in  fastcopy.xml", OiiolTextLogger.STR_LOG_GENERAL);
            }
            return false;
        }
        XMLElement el = null;
        el = (XMLElement)elFastCopy.getElementsByTagName("RACFILES").item(0);
        if (el == null) {
            if (this.m_bLog) {
                OiiolTextLogger.writeLogWithTimeAndTrace("FastCopyMode,  There is no RACFILES tag in  fastcopy.xml", OiiolTextLogger.STR_LOG_GENERAL);
            }
            return false;
        }
        this.m_sRACFilesLocation = this.getElementValue(el);
        this.m_hsFiles = new HashSet();
        this.addToFilesList(this.m_sRACFilesLocation);
        XMLElement elSetPerms = (XMLElement)elFastCopy.getElementsByTagName("SETPERMS").item(0);
        for (int i = 0; i < nLen; ++i) {
            XMLElement elDelFiles;
            XMLElement elFileMap;
            el = (XMLElement)ntTopLevelComps.item(i);
            String sComp = el.getAttribute("NAME");
            String sInstallType = el.getAttribute("INSTALL_TYPE");
            OiijFastCopyCompDetails ofmc = new OiijFastCopyCompDetails(sComp, sInstallType);
            if (sInstallType == null || sInstallType.length() == 0) {
                this.m_hFCCompDetails.put(sComp, ofmc);
            } else {
                this.m_hFCCompDetails.put(sComp + "_" + sInstallType, ofmc);
            }
            XMLElement elDir = (XMLElement)el.getElementsByTagName("DIRS_LIST").item(0);
            if (elDir != null) {
                String sDirsLst = this.getElementValue(elDir);
                ofmc.setDirsList(sDirsLst);
                this.addToFilesList(sDirsLst);
            }
            if ((elFileMap = (XMLElement)el.getElementsByTagName("PREPROC_FILEMAP").item(0)) != null) {
                String sFilemapJarLocation = this.getElementValue(elFileMap);
                this.addToFilesList(sFilemapJarLocation);
                ofmc.setFilemapJarLocation(sFilemapJarLocation);
            }
            if ((elDelFiles = (XMLElement)el.getElementsByTagName("DELETE_FILES_LIST").item(0)) != null) {
                String sDelFilesList = this.getElementValue(elDelFiles);
                ofmc.setDelFilesList(sDelFilesList);
            }
            NodeList nlDefJars = el.getElementsByTagName("DEFAULT_JARS_LIST");
            NodeList nlExpList = el.getElementsByTagName("EXPANDED_FILES_LIST");
            NodeList nlPatchDefJars = el.getElementsByTagName("DEFAULT_PATCH_JARS_LIST");
            NodeList nlPatchExpList = el.getElementsByTagName("EXPANDED_PATCH_FILES_LIST");
            ofmc.setRACFilesJar(this.m_sRACFilesLocation);
            this.computeCompDiskDetails(nlDefJars, nlExpList, nlPatchDefJars, nlPatchExpList, elSetPerms, ofmc);
        }
        return true;
    }

    private void computeCompDiskDetails(NodeList nlDefJars, NodeList nlExpList, NodeList nlPatchDefJars, NodeList nlPatchExpList, XMLElement elSetPerms, OiijFastCopyCompDetails ofmc) {
        String sExpFile;
        int nDisk;
        String sDefJarLoc;
        String sDisk;
        XMLElement el;
        int i;
        int nLength = nlDefJars.getLength();
        for (i = 0; i < nLength; ++i) {
            el = (XMLElement)nlDefJars.item(i);
            sDisk = el.getAttribute("DISK").trim();
            sDefJarLoc = el.getText().trim();
            nDisk = Integer.parseInt(sDisk);
            ofmc.setDefaultJarList(nDisk, sDefJarLoc);
            this.addToFilesList(sDefJarLoc);
        }
        nLength = nlExpList.getLength();
        for (i = 0; i < nLength; ++i) {
            el = (XMLElement)nlExpList.item(i);
            sDisk = el.getAttribute("DISK").trim();
            sExpFile = el.getText().trim();
            nDisk = Integer.parseInt(sDisk);
            ofmc.setExpandedFilesList(nDisk, sExpFile);
            this.addToFilesList(sExpFile);
        }
        nLength = nlPatchDefJars.getLength();
        for (i = 0; i < nLength; ++i) {
            el = (XMLElement)nlPatchDefJars.item(i);
            sDisk = el.getAttribute("DISK").trim();
            sDefJarLoc = el.getText().trim();
            nDisk = Integer.parseInt(sDisk);
            ofmc.setPatchDefaultJarList(nDisk, sDefJarLoc);
            this.addToFilesList(sDefJarLoc);
        }
        nLength = nlPatchExpList.getLength();
        for (i = 0; i < nLength; ++i) {
            el = (XMLElement)nlPatchExpList.item(i);
            sDisk = el.getAttribute("DISK").trim();
            sExpFile = el.getText().trim();
            nDisk = Integer.parseInt(sDisk);
            ofmc.setPatchExpandedFilesList(nDisk, sExpFile);
            this.addToFilesList(sExpFile);
        }
        if (elSetPerms != null) {
            NodeList nlScripts = elSetPerms.getElementsByTagName("SCRIPT");
            nLength = nlScripts.getLength();
            for (int i2 = 0; i2 < nLength; ++i2) {
                XMLElement el2 = (XMLElement)nlScripts.item(i2);
                String sDisk2 = el2.getAttribute("DISK").trim();
                String sScriptLoc = el2.getText().trim();
                int nDisk2 = Integer.parseInt(sDisk2);
                ofmc.setPermsScript(nDisk2, sScriptLoc);
                this.addToFilesList(sScriptLoc);
            }
        }
    }

    private String getElementValue(XMLElement el) {
        return el.getText().trim();
    }

    public static Document getDocument(String sFile) throws IOException, SAXException, ParserConfigurationException {
        JXDocumentBuilderFactory oJXDocumentBuilderFactory = new JXDocumentBuilderFactory();
        DocumentBuilder oDocBuilder = oJXDocumentBuilderFactory.newDocumentBuilder();
        return oDocBuilder.parse(new File(sFile));
    }

    public int getDisks() {
        return this.m_nDisks;
    }

    public String getFastCopyDir() {
        return this.m_sFastCopyDir;
    }

    public String getRACFilesLocation() {
        return this.m_sRACFilesLocation;
    }

    public String getFilemapJarLocation() {
        OiijFastCopyCompDetails ofcd = this.getCurrentFCCompDetails();
        return ofcd.getFilemapJarLocation();
    }

    public OiijFastCopyPhaseDiskDetails getFCDiskDetails(int nDisk) {
        OiijFastCopyCompDetails ofcd = this.getCurrentFCCompDetails();
        return ofcd.getFCDiskDetails(nDisk);
    }

    public int getMaxDiskNumber() {
        OiijFastCopyCompDetails ofcd = this.getCurrentFCCompDetails();
        return ofcd.getMaxDiskNumber();
    }

    public boolean isFastCopyDone(int nDisk) {
        OiijFastCopyCompDetails ofcd = this.getCurrentFCCompDetails();
        OiijFastCopyPhaseDiskDetails ofcp = ofcd.getFCDiskDetails(nDisk);
        if (ofcp == null) {
            return true;
        }
        return ofcp.isFastCopyDone();
    }

    public OiijFastCopyCompDetails getFCCompDetails(String sTLDepMode) {
        return (OiijFastCopyCompDetails)this.m_hFCCompDetails.get(sTLDepMode);
    }

    private OiijFastCopyCompDetails getCurrentFCCompDetails() {
        return (OiijFastCopyCompDetails)this.m_hFCCompDetails.get(this.m_sTLDepMode);
    }

    public void setDoneFastCopy(int nDisk, boolean bDone) {
        OiijFastCopyCompDetails ofcd = this.getCurrentFCCompDetails();
        OiijFastCopyPhaseDiskDetails ofcp = ofcd.getFCDiskDetails(nDisk);
        if (ofcp == null) {
            return;
        }
        ofcp.setDoneFastCopy(bDone);
    }

    public void setTLDepMode(String sTLDepMode) {
        this.m_sTLDepMode = sTLDepMode;
    }

    public boolean isProcessingSuccess() {
        return this.m_bSuccess;
    }

    private void addToFilesList(String sFile) {
        this.m_hsFiles.add(sFile);
    }

    public Iterator getAllFiles() {
        if (this.m_hsFiles == null) {
            return null;
        }
        return this.m_hsFiles.iterator();
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public boolean isFastCopyCompatible() {
        if (this.m_sVersion == null || this.m_sVersion.length() == 0) {
            OiiolTextLogger.appendText("FastCopy : File Version is NOT Compatible");
            return false;
        }
        OiiiVersion fileVer = new OiiiVersion(this.m_sVersion);
        OiiiVersion compatVer = new OiiiVersion(s_sCompatibleVersion);
        if (fileVer.equals(compatVer) || fileVer.laterThan(compatVer)) {
            OiiolTextLogger.appendText("FastCopy : File Version is Compatible");
            return true;
        }
        OiiolTextLogger.appendText("FastCopy : File Version is NOT Compatible");
        return false;
    }

    public static void main(String[] args) {
        OiijFastCopyData ofcd = new OiijFastCopyData(args[0]);
        ofcd.setTLDepMode(args[1] + "_" + args[2]);
        int nDisks = ofcd.getDisks();
        System.out.println(">>> MAIN Disks :" + nDisks);
        System.out.println(">>> MAIN Comp Disks :" + ofcd.getCurrentFCCompDetails().getDisks());
        System.out.println(">>> MAIN Comp MAX Disk :" + ofcd.getMaxDiskNumber());
        for (int i = 1; i <= nDisks; ++i) {
            OiijFastCopyPhaseDiskDetails ofcp = ofcd.getFCDiskDetails(i);
            System.out.println(">>> MAIN DISK Details for :" + i);
            System.out.println(">>> MAIN DEFAULT JAR :" + ofcp.getDefaultJarList());
            System.out.println(">>> MAIN SCRIP :" + ofcp.getPermsScript());
        }
    }
}

