/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiij;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.sysman.oii.oiij.OiijFastCopyPhaseDiskDetails;

public class OiijFastCopyCompDetails {
    private String m_sCompName;
    private String m_sInstallType;
    private String m_sDirsList;
    private int m_nDisks;
    private int m_nMaxDisk;
    private Hashtable m_hFCDiskDetails;
    private String m_sFilemapJarLocation;
    private String m_sDelFilesList;
    private String m_sRACFilesJar;

    protected OiijFastCopyCompDetails(String sCompName, String sInstallType) {
        this.m_sCompName = sCompName;
        this.m_sInstallType = sInstallType;
        this.m_hFCDiskDetails = new Hashtable();
    }

    void setDirsList(String sDirsList) {
        this.m_sDirsList = sDirsList;
    }

    public String getDirsList() {
        return this.m_sDirsList;
    }

    void setDefaultJarList(int nDisk, String sDefJarsList) {
        OiijFastCopyPhaseDiskDetails ofcd = this.getFCDiskDetails(nDisk, true);
        ofcd.setDefaultJarList(sDefJarsList);
    }

    void setExpandedFilesList(int nDisk, String sExpFilesList) {
        OiijFastCopyPhaseDiskDetails ofcd = this.getFCDiskDetails(nDisk, true);
        ofcd.setExpandedFilesList(sExpFilesList);
    }

    void setPatchDefaultJarList(int nDisk, String sDefJarsList) {
        OiijFastCopyPhaseDiskDetails ofcd = this.getFCDiskDetails(nDisk, true);
        ofcd.setPatchDefaultJarList(sDefJarsList);
    }

    void setPatchExpandedFilesList(int nDisk, String sExpFilesList) {
        OiijFastCopyPhaseDiskDetails ofcd = this.getFCDiskDetails(nDisk, true);
        ofcd.setPatchExpandedFilesList(sExpFilesList);
    }

    void setPermsScript(int nDisk, String sPermsScript) {
        OiijFastCopyPhaseDiskDetails ofcd = this.getFCDiskDetails(nDisk, true);
        ofcd.setPermsScript(sPermsScript);
    }

    public void setFilemapJarLocation(String sFilemapJarLocation) {
        this.m_sFilemapJarLocation = sFilemapJarLocation;
    }

    void setDelFilesList(String sLocation) {
        this.m_sDelFilesList = sLocation;
    }

    void setRACFilesJar(String sRACFilesJar) {
        this.m_sRACFilesJar = sRACFilesJar;
    }

    private OiijFastCopyPhaseDiskDetails getFCDiskDetails(int nDisk, boolean bCreate) {
        Integer oDisk = new Integer(nDisk);
        OiijFastCopyPhaseDiskDetails ofcd = (OiijFastCopyPhaseDiskDetails)this.m_hFCDiskDetails.get(oDisk);
        if (ofcd == null && bCreate) {
            ofcd = new OiijFastCopyPhaseDiskDetails(nDisk);
            this.m_hFCDiskDetails.put(oDisk, ofcd);
            ++this.m_nDisks;
            if (nDisk > this.m_nMaxDisk) {
                this.m_nMaxDisk = nDisk;
            }
        }
        return ofcd;
    }

    public int getDisks() {
        return this.m_nDisks;
    }

    public int getMaxDiskNumber() {
        return this.m_nMaxDisk;
    }

    OiijFastCopyPhaseDiskDetails getFCDiskDetails(int nDisk) {
        return this.getFCDiskDetails(nDisk, false);
    }

    public String getFilemapJarLocation() {
        return this.m_sFilemapJarLocation;
    }

    public String getDelFilesList() {
        return this.m_sDelFilesList;
    }

    public Iterator iteratorNonSetPermsFiles() {
        HashSet<String> hs = new HashSet<String>(5);
        if (this.m_sFilemapJarLocation != null) {
            hs.add(this.m_sFilemapJarLocation);
        }
        if (this.m_sDelFilesList != null) {
            hs.add(this.m_sDelFilesList);
        }
        if (this.m_sDirsList != null) {
            hs.add(this.m_sDirsList);
        }
        if (this.m_sRACFilesJar != null) {
            hs.add(this.m_sRACFilesJar);
        }
        for (int i = 1; i <= this.m_nMaxDisk; ++i) {
            OiijFastCopyPhaseDiskDetails ofcp = this.getFCDiskDetails(i);
            if (ofcp == null) continue;
            hs.addAll(ofcp.getNonSetPermsFiles());
        }
        return hs.iterator();
    }

    public Iterator iteratorSetPermsFiles() {
        HashSet<String> hs = new HashSet<String>(3);
        for (int i = 1; i <= this.m_nMaxDisk; ++i) {
            String sPerms;
            OiijFastCopyPhaseDiskDetails ofcp = this.getFCDiskDetails(i);
            if (ofcp == null || (sPerms = ofcp.getPermsScript()) == null) continue;
            hs.add(sPerms);
        }
        return hs.iterator();
    }
}

