/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class OiiiWinActionsXMLHandler
extends OixsDefaultHandler {
    private OiiiAreaInventory m_inventory;
    private OiiiCompInstallID m_cid;
    private int m_homeIndex;
    OixsElementHandler m_handlerWinActions;
    OixsElementHandler m_handlerComp;
    OixsElementHandler m_handlerRegistry;
    OixsElementHandler m_handlerShortcut;
    OixsElementHandler m_handlerService;

    public OiiiWinActionsXMLHandler(OiiiAreaInventory inv, int homeIndex) throws SAXException {
        this.m_inventory = inv;
        this.m_homeIndex = homeIndex;
    }

    @Override
    public OixsElementHandler createElementHandlers() {
        this.m_handlerWinActions = new OixsElementHandler("DESKTOP_ACTIONS");
        this.m_handlerComp = new OiiiCompHandler("Component");
        this.m_handlerWinActions.addChildHandler("Component", this.m_handlerComp);
        this.m_handlerRegistry = new OiiiRegistryHandler();
        this.m_handlerShortcut = new OiiiShortcutHandler();
        this.m_handlerService = new OiiiServiceHandler();
        this.m_handlerComp.addChildHandler("Registry", this.m_handlerRegistry);
        this.m_handlerComp.addChildHandler("Shortcut", this.m_handlerShortcut);
        this.m_handlerComp.addChildHandler("Service", this.m_handlerService);
        return this.m_handlerWinActions;
    }

    private class OiiiServiceHandler
    extends OixsElementHandler {
        OiiiServiceHandler() {
            super("Service");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiiiWinActionsXMLHandler.this.m_cid != null) {
                String sExename = atts.getValue("ExeName");
                String sName = atts.getValue("ServiceName");
                String sDisplay = atts.getValue("DisplayName");
                String sAccess = atts.getValue("Access");
                String sType = atts.getValue("Type");
                String sStartType = atts.getValue("StartType");
                String sErrCtrl = atts.getValue("ErrorControl");
                String sDepNames = atts.getValue("DependencyNames");
                String sAccName = atts.getValue("AccountName");
                String sPasswd = atts.getValue("Password");
                String sAction = atts.getValue("Action");
                String sActionType = atts.getValue("ActionType");
                String sCondition = atts.getValue("Condition");
                OiilWinActionInputs actionInputs = new OiilWinActionInputs(2);
                actionInputs.addInputElement("ExeName", sExename);
                actionInputs.addInputElement("ServiceName", sName);
                actionInputs.addInputElement("DisplayName", sDisplay);
                actionInputs.addInputElement("Access", sAccess);
                actionInputs.addInputElement("Type", sType);
                actionInputs.addInputElement("StartType", sStartType);
                actionInputs.addInputElement("ErrorControl", sErrCtrl);
                actionInputs.addInputElement("DependencyNames", sDepNames);
                actionInputs.addInputElement("AccountName", sAccName);
                actionInputs.addInputElement("Password", sPasswd);
                actionInputs.addInputElement("Action", sAction);
                actionInputs.addInputElement("ActionType", sActionType);
                actionInputs.addInputElement("Condition", sCondition);
                OiilWinActionInputs.addCompAction(OiiiWinActionsXMLHandler.this.m_cid, actionInputs);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiShortcutHandler
    extends OixsElementHandler {
        OiiiShortcutHandler() {
            super("Shortcut");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiiiWinActionsXMLHandler.this.m_cid != null) {
                String sFolder = atts.getValue("FolderName");
                String sItem = atts.getValue("ItemName");
                String sParams = atts.getValue("Parameters");
                String sExename = atts.getValue("ExeName");
                String sWorkDir = atts.getValue("WorkingDirectory");
                String sIcon = atts.getValue("Icon");
                String sIconIdx = atts.getValue("IconIndex");
                String sIconSrc = atts.getValue("IconSrc");
                String sRunType = atts.getValue("RunType");
                String sParamList = atts.getValue("ParametersList");
                String sAction = atts.getValue("Action");
                String sActionType = atts.getValue("ActionType");
                String sCondition = atts.getValue("Condition");
                String sDesktopItem = atts.getValue("DesktopItem");
                String sStartupItem = atts.getValue("StartupItem");
                OiilWinActionInputs actionInputs = new OiilWinActionInputs(1);
                actionInputs.addInputElement("FolderName", sFolder);
                actionInputs.addInputElement("ItemName", sItem);
                actionInputs.addInputElement("Parameters", sParams);
                actionInputs.addInputElement("ExeName", sExename);
                actionInputs.addInputElement("WorkingDirectory", sWorkDir);
                actionInputs.addInputElement("Icon", sIcon);
                actionInputs.addInputElement("IconIndex", sIconIdx);
                actionInputs.addInputElement("IconSrc", sIconSrc);
                actionInputs.addInputElement("RunType", sRunType);
                actionInputs.addInputElement("ParametersList", sParamList);
                actionInputs.addInputElement("Action", sAction);
                actionInputs.addInputElement("ActionType", sActionType);
                actionInputs.addInputElement("Condition", sCondition);
                actionInputs.addInputElement("DesktopItem", sDesktopItem);
                actionInputs.addInputElement("StartupItem", sStartupItem);
                OiilWinActionInputs.addCompAction(OiiiWinActionsXMLHandler.this.m_cid, actionInputs);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiRegistryHandler
    extends OixsElementHandler {
        OiiiRegistryHandler() {
            super("Registry");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiiiWinActionsXMLHandler.this.m_cid != null) {
                String sRoot = atts.getValue("Root");
                String sKey = atts.getValue("Key");
                String sName = atts.getValue("Name");
                String sType = atts.getValue("Type");
                String sValue = atts.getValue("Value");
                String sAction = atts.getValue("Action");
                String sUpdateType = atts.getValue("UpdateType");
                String sActionType = atts.getValue("ActionType");
                String sCondition = atts.getValue("Condition");
                OiilWinActionInputs actionInputs = new OiilWinActionInputs(0);
                actionInputs.addInputElement("Root", sRoot);
                actionInputs.addInputElement("Key", sKey);
                actionInputs.addInputElement("Name", sName);
                actionInputs.addInputElement("Type", sType);
                actionInputs.addInputElement("Value", sValue);
                actionInputs.addInputElement("Action", sAction);
                actionInputs.addInputElement("UpdateType", sUpdateType);
                actionInputs.addInputElement("ActionType", sActionType);
                actionInputs.addInputElement("Condition", sCondition);
                OiilWinActionInputs.addCompAction(OiiiWinActionsXMLHandler.this.m_cid, actionInputs);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiCompHandler
    extends OixsElementHandler {
        private OixsElementHandler m_handlerRegistry;
        private OixsElementHandler m_handlerSuppressConfigTool;

        OiiiCompHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VERSION");
            String sPlats = atts.getValue("PLATFORMS");
            if (sName != null && sVer != null) {
                OiiiVersion oVer = new OiiiVersion(sVer);
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                if (OiiiWinActionsXMLHandler.this.m_homeIndex != 0) {
                    cid.setHomeType(2);
                }
                if (OiiiWinActionsXMLHandler.this.m_inventory != null) {
                    OiiiCompInvEntry curEntry = OiiiWinActionsXMLHandler.this.m_inventory.getCompInvEntry(cid, OiiiWinActionsXMLHandler.this.m_homeIndex);
                    OiiiWinActionsXMLHandler.this.m_cid = curEntry.getCompInstallID();
                } else {
                    OiiiWinActionsXMLHandler.this.m_cid = cid;
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }
}

