/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiVersionFormatException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiiVersion
implements Serializable {
    static final long serialVersionUID = 6071654166129269042L;
    private String m_verString;
    private int m_iBuildNumber;
    private transient String m_verHashCode;
    public static final int MAX_PARTS = 5;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    public static String FILE_VERSION_DELIMITERS = ".,";
    public static String VERSION_DELIMITERS = ".";
    private static String m_currentDelimiters = FILE_VERSION_DELIMITERS;
    public static final boolean IGNORE_BUILD_NUMBER = true;
    public static final boolean CONSIDER_BUILD_NUMBER = false;

    public OiiiVersion(String verString) {
        try {
            if (!OiiiVersion.fileValidate(verString)) {
                throw new OiiiVersionFormatException(verString);
            }
            this.m_verString = OiiiVersion.verNormalize(verString);
        }
        catch (OiiiVersionFormatException nfe) {
            this.m_verString = null;
        }
    }

    public OiiiVersion(String verString, boolean bValidate) throws OiiiVersionFormatException {
        if (bValidate && !OiiiVersion.validate(verString)) {
            throw new OiiiVersionFormatException(verString);
        }
        this.m_verString = OiiiVersion.verNormalize(verString);
    }

    public OiiiVersion(String verString, boolean bValidate, boolean bStandardize) throws OiiiVersionFormatException {
        this(verString, bValidate);
        if (bStandardize) {
            this.m_verString = OiiiVersion.getStandardVerString(verString);
        }
    }

    public String getVerString() {
        return this.getVerString(true);
    }

    public String getVerString(boolean bIgnoreBuild) {
        if (!bIgnoreBuild && this.m_iBuildNumber > 0) {
            Object[] sArgs = new String[]{this.m_verString, String.valueOf(this.m_iBuildNumber)};
            return OiixResourceBundle.getString("S_VERSION_WITH_BUILD", sArgs);
        }
        return this.m_verString;
    }

    public void setBuildNumber(int iBuildNumber) throws OiiiVersionFormatException {
        OiiiVersion.validateBuildNumber(iBuildNumber);
        this.m_iBuildNumber = iBuildNumber;
    }

    public int getBuildNumber() {
        return this.m_iBuildNumber;
    }

    private static String verNormalize(String verString) throws OiiiVersionFormatException {
        if (verString == null) {
            throw new OiiiVersionFormatException(verString);
        }
        String retStr = verString.trim();
        int strLength = retStr.length();
        String minStr = "0";
        try {
            char chari;
            int i;
            for (i = 0; i < strLength && (chari = retStr.charAt(i)) == '0'; ++i) {
            }
            if (i < strLength) {
                chari = retStr.charAt(i);
                if (!Character.isDigit(chari)) {
                    return minStr + retStr.substring(i);
                }
            } else {
                return minStr;
            }
            return retStr.substring(i);
        }
        catch (NumberFormatException nfe) {
            throw new OiiiVersionFormatException(verString);
        }
    }

    public static OiiiVersion getStandardForm(OiiiVersion oVer) {
        int iBuildNumber = oVer.getBuildNumber();
        OiiiVersion oStdVer = new OiiiVersion(OiiiVersion.getStandardVerString(oVer.getVerString()));
        try {
            oStdVer.setBuildNumber(iBuildNumber);
        }
        catch (OiiiVersionFormatException oiiiVersionFormatException) {
            // empty catch block
        }
        return oStdVer;
    }

    public static OiiiVersion getStandardForm(String sVer) {
        return new OiiiVersion(OiiiVersion.getStandardVerString(sVer));
    }

    private static String getStandardVerString(String sVer) {
        if (sVer == null) {
            return sVer;
        }
        String sVerTrim = sVer.trim();
        if (sVerTrim.equals("")) {
            return "0.0.0.0.0";
        }
        Vector vDigits = OiiiVersion.getVerDigits(sVerTrim);
        int iDigits = vDigits.size();
        if (iDigits == 0) {
            return sVerTrim;
        }
        char cLastChar = '\u0000';
        if (iDigits < 5) {
            int len;
            String sLastPart = (String)vDigits.elementAt(iDigits - 1);
            char lastChar = sLastPart.charAt((len = sLastPart.length()) - 1);
            if (Character.isLetter(lastChar)) {
                cLastChar = lastChar;
                sVer = sVer.substring(0, sVer.length() - 1);
            }
            StringBuffer sStdVerString = sVer.endsWith(".") ? new StringBuffer(sVer.substring(0, sVer.length() - 1)) : new StringBuffer(sVer);
            for (int i = iDigits; i < 5; ++i) {
                sStdVerString.append(".0");
            }
            if (cLastChar != '\u0000') {
                sStdVerString.append(cLastChar);
            }
            return sStdVerString.toString();
        }
        return sVer;
    }

    public static String maskLastVersionDigit(String sVer) {
        String maskString = "";
        String sVerStandard = OiiiVersion.getStandardVerString(sVer);
        Vector verDigits = OiiiVersion.getVerDigits(sVerStandard);
        for (int i = 0; i < verDigits.size() - 1; ++i) {
            maskString = maskString + (String)verDigits.get(i) + ".";
        }
        maskString = maskString + "0";
        return maskString;
    }

    public static void validateBuildNumber(int iBuildNumber) throws OiiiVersionFormatException {
        if (iBuildNumber < 0) {
            Object[] sArgs = new String[]{String.valueOf(iBuildNumber)};
            String sMesg = OiixResourceBundle.getString("S_INCORRECT_BUILD_FORMAT", sArgs);
            throw new OiiiVersionFormatException(sMesg);
        }
    }

    public static boolean validate(String verCandidate) {
        m_currentDelimiters = VERSION_DELIMITERS;
        boolean bValid = OiiiVersion.fileValidate(verCandidate);
        m_currentDelimiters = FILE_VERSION_DELIMITERS;
        return bValid;
    }

    public static boolean fileValidate(String verCandidate) {
        int j;
        int partLen;
        String verPart;
        boolean valid;
        Vector digs = OiiiVersion.getVerDigits(verCandidate);
        int numdigs = digs.size();
        if (numdigs == 0 && verCandidate != null && !verCandidate.equals("")) {
            return false;
        }
        boolean bl = valid = numdigs <= 5;
        if (valid) {
            for (int i = 0; i < numdigs - 1; ++i) {
                char charj;
                verPart = (String)digs.elementAt(i);
                partLen = verPart.length();
                if (partLen == 0) {
                    return false;
                }
                if (partLen > 16) {
                    return false;
                }
                for (j = 0; j < partLen && Character.isDigit(charj = verPart.charAt(j)); ++j) {
                }
                if (j >= partLen) continue;
                valid = false;
                break;
            }
        }
        if (valid && numdigs > 0) {
            verPart = (String)digs.elementAt(numdigs - 1);
            partLen = verPart.length();
            int checkLen = partLen;
            if (checkLen > 1) {
                --checkLen;
            }
            if (checkLen > 16) {
                return false;
            }
            for (j = 0; j < checkLen; ++j) {
                char charj = verPart.charAt(j);
                if (Character.isDigit(charj)) continue;
                valid = false;
                break;
            }
            if (valid && checkLen == partLen - 1 && !Character.isLetterOrDigit(verPart.charAt(checkLen))) {
                valid = false;
            }
        }
        return valid;
    }

    public static boolean validate1(String verCandidate) {
        Vector digs = OiiiVersion.getVerDigits(verCandidate);
        int numdigs = digs.size();
        boolean valid = numdigs <= 5;
        for (int i = 0; i < numdigs - 1; ++i) {
            try {
                Integer.parseInt((String)digs.elementAt(i));
                continue;
            }
            catch (NumberFormatException nfe) {
                valid = false;
                break;
            }
        }
        if (valid && numdigs > 0) {
            String verPart = (String)digs.elementAt(numdigs - 1);
            int partLen = verPart.length();
            try {
                char lastChar = verPart.charAt(partLen - 1);
                if (Character.isLetter(lastChar)) {
                    Integer.parseInt(verPart.substring(0, partLen - 1));
                } else {
                    Integer.parseInt(verPart);
                }
            }
            catch (NumberFormatException nfe) {
                valid = false;
            }
        }
        return valid;
    }

    public boolean laterThan(OiiiVersion other) {
        return this.laterThan(other, true);
    }

    public boolean laterThan(OiiiVersion other, boolean bIgnoreBuild) {
        if (this.equals(other, true)) {
            if (bIgnoreBuild) {
                return false;
            }
            return this.m_iBuildNumber > other.getBuildNumber();
        }
        return this.laterThanInt(other, false);
    }

    public boolean laterFileVersionThan(OiiiVersion other) {
        if (this.equalsFileVersion(other)) {
            return false;
        }
        return this.laterThanInt(other, true);
    }

    private boolean laterThanInt(OiiiVersion other, boolean fileVerCompare) {
        int i;
        boolean retVal = false;
        Vector digs1 = OiiiVersion.getVerDigits(this.m_verString);
        Vector digs2 = OiiiVersion.getVerDigits(other.getVerString(true));
        int numdigs1 = digs1.size();
        int numdigs2 = digs2.size();
        int numiter = Math.min(numdigs1, numdigs2);
        for (i = 0; i < numiter; ++i) {
            int comp = this.partCompare((String)digs1.elementAt(i), (String)digs2.elementAt(i), fileVerCompare, i, i == numiter - 1);
            if (comp == 0) continue;
            if (comp <= 0) break;
            retVal = true;
            break;
        }
        if (i == numiter && numdigs1 > numiter) {
            retVal = true;
        }
        return retVal;
    }

    private int partCompare(String ver1pt, String ver2pt, boolean fileVerCompare, int index, boolean bChkEndLetter) {
        int retval;
        boolean bMkFraction = fileVerCompare ? index != 0 : false;
        double dig1 = OiiiVersion.digitValue(ver1pt, bMkFraction, bChkEndLetter);
        double dig2 = OiiiVersion.digitValue(ver2pt, bMkFraction, bChkEndLetter);
        double diff = dig1 - dig2;
        int n = diff < 0.0 ? -1 : (retval = diff == 0.0 ? 0 : 1);
        if (retval == 0 && bChkEndLetter) {
            int pt1len = ver1pt.length();
            char pt1lc = ver1pt.charAt(pt1len - 1);
            boolean pt1let = Character.isLetter(pt1lc);
            int pt2len = ver2pt.length();
            char pt2lc = ver2pt.charAt(pt2len - 1);
            boolean pt2let = Character.isLetter(pt2lc);
            if (pt1let || pt2let) {
                if (pt1let && pt2let) {
                    String pt1ls = "" + Character.toUpperCase(pt1lc);
                    String pt2ls = "" + Character.toUpperCase(pt2lc);
                    retval = pt1ls.compareTo(pt2ls);
                } else {
                    retval = pt1let ? 1 : -1;
                }
            }
        }
        return retval;
    }

    private static double digitValue(String verPart, boolean makeFraction, boolean chkEndLetter) {
        char lastChar;
        int verPartLen = verPart.length();
        if (chkEndLetter && !Character.isDigit(lastChar = verPart.charAt(verPartLen - 1))) {
            verPart = verPart.substring(0, verPartLen - 1);
        }
        if (makeFraction) {
            verPart = "." + verPart;
        }
        return Double.valueOf(verPart);
    }

    private static Vector getVerDigits(String verStr) {
        Vector<Object> retVect = new Vector<Object>();
        if (verStr != null && verStr.length() > 0) {
            StringTokenizer st = new StringTokenizer(verStr, m_currentDelimiters);
            while (st.hasMoreElements()) {
                retVect.addElement(st.nextElement());
            }
        }
        return retVect;
    }

    public String toHashCode() {
        if (this.m_verHashCode == null) {
            this.m_verHashCode = OiiiVersion.getStandardVerString(this.getVerString(true));
            if (this.m_iBuildNumber > 0) {
                this.m_verHashCode = this.m_verHashCode + "(Build " + this.m_iBuildNumber + ")";
            }
        }
        return this.m_verHashCode;
    }

    public String toString() {
        return this.getVerString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OiiiVersion)) {
            return false;
        }
        OiiiVersion ver = (OiiiVersion)obj;
        return this.equals(ver);
    }

    public boolean equals(OiiiVersion ver) {
        return this.equals(ver, true);
    }

    public boolean equals(OiiiVersion ver, boolean bIgnoreBuild) {
        boolean bEqualVer = true;
        if (ver != null) {
            String verStr = ver.getVerString(true);
            bEqualVer = this.m_verString != null && verStr != null && (this.m_verString.equalsIgnoreCase(verStr) || OiiiVersion.trailingZeroDiffOnly(this.m_verString, verStr));
        } else {
            bEqualVer = false;
        }
        if (bEqualVer && !bIgnoreBuild) {
            bEqualVer = this.m_iBuildNumber == ver.getBuildNumber();
        }
        return bEqualVer;
    }

    public boolean equalsFileVersion(OiiiVersion ver) {
        if (ver != null) {
            String verStr = ver.getVerString(true);
            return this.m_verString != null && verStr != null && (this.m_verString.equalsIgnoreCase(verStr) || OiiiVersion.trailZeroDiffAnyPart(this.m_verString, verStr));
        }
        return false;
    }

    private static boolean trailingZeroDiffOnly(String verStr1, String verStr2) {
        int checkPos;
        boolean retVal = false;
        boolean bLastCharEqual = false;
        char lastChar1 = Character.toUpperCase(verStr1.charAt(verStr1.length() - 1));
        char lastChar2 = Character.toUpperCase(verStr2.charAt(verStr2.length() - 1));
        boolean b1 = Character.isLetter(lastChar1);
        boolean b2 = Character.isLetter(lastChar2);
        if (b1 && b2 && lastChar1 == lastChar2) {
            verStr1 = verStr1.substring(0, verStr1.length() - 1);
            verStr2 = verStr2.substring(0, verStr2.length() - 1);
            bLastCharEqual = true;
        } else if (!b1 && !b2) {
            bLastCharEqual = true;
        }
        int len1 = verStr1.length();
        int len2 = verStr2.length();
        String longStr = null;
        String shortStr = null;
        int shortLen = 0;
        int longLen = 0;
        if (len1 > len2) {
            shortLen = len2;
            longLen = len1;
            shortStr = verStr2;
            longStr = verStr1;
        } else if (len2 > len1) {
            shortLen = len1;
            longLen = len2;
            shortStr = verStr1;
            longStr = verStr2;
        }
        if (longStr != null && shortStr != null && bLastCharEqual && longStr.startsWith(shortStr) && longStr.charAt(checkPos = shortLen) == '.') {
            ++checkPos;
            retVal = true;
            while (checkPos < longLen) {
                char checkChar = longStr.charAt(checkPos);
                if (checkChar != '.' && checkChar != '0') {
                    retVal = false;
                    break;
                }
                ++checkPos;
            }
        }
        return retVal;
    }

    private static boolean trailZeroDiffAnyPart(String verStr1, String verStr2) {
        boolean retVal = false;
        boolean bEndingCheck = false;
        char lastChar1 = Character.toUpperCase(verStr1.charAt(verStr1.length() - 1));
        char lastChar2 = Character.toUpperCase(verStr2.charAt(verStr2.length() - 1));
        boolean letEnd1 = Character.isLetter(lastChar1);
        boolean letEnd2 = Character.isLetter(lastChar2);
        if (letEnd1 && letEnd2 && letEnd1 == letEnd2) {
            verStr1 = verStr1.substring(0, verStr1.length() - 1);
            verStr2 = verStr2.substring(0, verStr2.length() - 1);
            bEndingCheck = true;
        } else if (!letEnd1 && !letEnd2) {
            bEndingCheck = true;
        }
        if (bEndingCheck) {
            int shortNumDigs;
            int longNumDigs;
            Vector digs1 = OiiiVersion.getVerDigits(verStr1);
            Vector digs2 = OiiiVersion.getVerDigits(verStr2);
            int numdigs1 = digs1.size();
            int numdigs2 = digs2.size();
            Vector longDigsVect = null;
            Vector shortDigsVect = null;
            if (numdigs1 > numdigs2) {
                longNumDigs = numdigs1;
                shortNumDigs = numdigs2;
                longDigsVect = digs1;
                shortDigsVect = digs2;
            } else {
                longNumDigs = numdigs2;
                shortNumDigs = numdigs1;
                longDigsVect = digs2;
                shortDigsVect = digs1;
            }
            retVal = true;
            int i = 0;
            for (i = 0; i < shortNumDigs; ++i) {
                double dig2;
                String verPart1 = (String)digs1.elementAt(i);
                String verPart2 = (String)digs2.elementAt(i);
                double dig1 = OiiiVersion.digitValue(verPart1, i != 0, false);
                if (dig1 == (dig2 = OiiiVersion.digitValue(verPart2, i != 0, false))) continue;
                retVal = false;
                break;
            }
            if (i == shortNumDigs) {
                while (i < longNumDigs) {
                    String verPart = (String)longDigsVect.elementAt(i);
                    double dig = OiiiVersion.digitValue(verPart, true, false);
                    if (dig != 0.0) {
                        retVal = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return retVal;
    }

    public static boolean isInstVersionPreX(OiiiVersion oVer, OiiiVersion[] instVersionForStaging) {
        boolean bRet = false;
        if (instVersionForStaging == null || oVer == null) {
            return true;
        }
        for (OiiiVersion oOldVer : instVersionForStaging) {
            if (!oVer.laterThan(oOldVer)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static boolean isInstVersionPostX(OiiiVersion oVer, OiiiVersion[] instVersionForStaging) {
        boolean bRet = false;
        if (instVersionForStaging == null || oVer == null) {
            return false;
        }
        for (OiiiVersion oStageVer : instVersionForStaging) {
            if (!oStageVer.laterThan(oVer)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static void main(String[] args) throws Exception {
        String[] vers;
        int i;
        if (args != null && args.length != 0 && args[0].equalsIgnoreCase("validate")) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                System.out.println("Validating + " + args[i2] + " returned " + OiiiVersion.validate(args[i2]));
            }
            return;
        }
        int testnum = 3;
        if (args.length > 0) {
            testnum = Integer.parseInt(args[0]);
        }
        if (testnum == 1) {
            String[] checkVers = new String[]{"5.", "", null, "0.0.5", "0a", "000.0a", "000", "001.0a", "0.00.50a", "100.050.10.3.5a", "100.050.10.3b.5a", "100.050.10.3b.5a", "123456789123456789.a", "100ab"};
            for (i = 0; i < checkVers.length; ++i) {
                boolean validChk1 = false;
                boolean validChk2 = false;
                boolean exceptChk = true;
                validChk1 = OiiiVersion.validate(checkVers[i]);
                validChk2 = OiiiVersion.validate1(checkVers[i]);
                try {
                    System.out.println("Normalized form of " + checkVers[i] + " is " + OiiiVersion.verNormalize(checkVers[i]));
                }
                catch (OiiiVersionFormatException nfe) {
                    exceptChk = false;
                }
                System.out.println("Standard form of " + checkVers[i] + " is " + OiiiVersion.getStandardForm(checkVers[i]));
                System.out.println("In checks of " + checkVers[i] + ",validate = " + validChk1 + ", validate1 = " + validChk2 + ", normalizeException = " + exceptChk);
            }
        }
        if (testnum == 2) {
            OiiiVersion a = new OiiiVersion("1.1.1.1.2a");
            System.out.println("Checking equality of " + a + " against " + a + " returns " + a.equals(a));
        }
        if (testnum == 3) {
            String[] lowVers = new String[]{"5.100.0", "03.02.002.1.1A", "03.1.002.1", "2.2.2.1.1A", "1.2", "1.1.6.2.2o", "5.1.005", "5.100", "5.100.0", "1.7a"};
            String[] hiVers = new String[]{"5.1.05", "03.02.002.1.1A", "03.1.002.1", "2.2.2.1.1A", "1.2", "1.1.6.2.2o", "5.1.05", "5.10", "5.100", "1.7.0.0a"};
            for (int i3 = 0; i3 < lowVers.length; ++i3) {
                for (int j = 0; j < hiVers.length; ++j) {
                    OiiiVersion loVer = new OiiiVersion(lowVers[i3]);
                    OiiiVersion hiVer = new OiiiVersion(hiVers[j]);
                    System.out.println("Comparing " + loVer + "(" + lowVers[i3] + ") .laterThan " + hiVer + "(" + hiVers[j] + ") returned " + loVer.laterThan(hiVer));
                    System.out.println("Comparing " + loVer + "(" + lowVers[i3] + ") .laterFileVersionThan " + hiVer + "(" + hiVers[j] + ") returned " + loVer.laterFileVersionThan(hiVer));
                }
            }
        }
        if (testnum == 4) {
            vers = new String[]{"1.1.6.1", "1.1.6.1a"};
            for (i = 0; i < vers.length; ++i) {
                for (int j = i + 1; j < vers.length; ++j) {
                    System.out.println("Comparing " + vers[i] + " and " + vers[j] + ", equals returns " + new OiiiVersion(vers[i]).equals(new OiiiVersion(vers[j])) + ", trailingZeroDiffOnly returns " + OiiiVersion.trailingZeroDiffOnly(vers[i], vers[j]) + ", trailZeroDiffAnyPart returns " + OiiiVersion.trailZeroDiffAnyPart(vers[i], vers[j]));
                }
            }
        }
        if (testnum == 5) {
            vers = new String[]{"1.6", "1.6.0", "1.60", "1.6.00", "1.60.00A", "1.6a"};
            for (i = 0; i < vers.length; ++i) {
                OiiiVersion v = new OiiiVersion(vers[i]);
                System.out.println("Hash code " + v.toHashCode());
            }
        }
        if (testnum == 6) {
            vers = new String[]{"1.6", "1.6.1", "1.6.5.4", "1.6.1.0.0", "1.6a", "1.6.45a", "0.6", "00.6a", "1.7.0.20.0a"};
            for (i = 0; i < vers.length; ++i) {
                OiiiVersion v = new OiiiVersion(vers[i]);
                v = OiiiVersion.getStandardForm(v.getVerString());
                System.out.println("Version string : " + vers[i] + " converted to " + v.toString());
            }
        }
        if (testnum == 7) {
            vers = new String[]{"1.6", "1.6", "1.6", "1.6", "1.6.1", "1.6.5.4", "1.6.1.0.0", "1.6a", "1.6.45a", "0.6", "00.6a", "1.7.0.20.0a"};
            int[] builds = new int[]{0, 1, 1, 2, 0, -4, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0, 0, 0};
            boolean[] ignoreBuild = new boolean[]{true, false};
            for (int k = 0; k < ignoreBuild.length; ++k) {
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                System.out.println("Ignoring build = " + ignoreBuild[k]);
                for (int i4 = 0; i4 < vers.length; ++i4) {
                    OiiiVersion v1 = new OiiiVersion(vers[i4]);
                    System.out.println("vers[" + i4 + "] =" + vers[i4]);
                    try {
                        v1.setBuildNumber(builds[i4]);
                    }
                    catch (OiiiVersionFormatException e) {
                        System.out.println(e.getMessage());
                    }
                    for (int j = i4 + 1; j < vers.length; ++j) {
                        OiiiVersion v2 = new OiiiVersion(vers[j]);
                        System.out.println("vers[" + j + "] =" + vers[j]);
                        try {
                            v2.setBuildNumber(builds[j]);
                        }
                        catch (OiiiVersionFormatException e) {
                            System.out.println(e.getMessage());
                        }
                        System.out.println("Comparing " + v1.getVerString(ignoreBuild[k]) + " and " + v2.getVerString(ignoreBuild[k]) + ", equals returns " + v1.equals(v2, ignoreBuild[k]) + ", laterThan returns " + v1.laterThan(v2, ignoreBuild[k]));
                    }
                }
            }
        }
    }
}

