/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInvHomeInfo;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class OiiiUpdateCompsVersion {
    private OiiiInstallInventory m_installInv = null;

    public OiiiUpdateCompsVersion(OiiiInstallInventory inv) {
        this.m_installInv = inv;
    }

    public boolean updateCompVersion(String compName, OiiiVersion version, int homeIndex) {
        OiiiCompInvEntry ocie;
        boolean versionChanged = false;
        OiiiInvHomeInfo oihi = this.m_installInv.getCompOHListInfo(homeIndex);
        String homeName = null;
        if (homeIndex == 0) {
            homeName = "Independent Products";
        } else {
            OiiiOracleHomeInfo oInfo = this.m_installInv.getHomeInfo(homeIndex);
            homeName = oInfo.getName();
        }
        Vector comps = this.m_installInv.getCompOHListElement(homeIndex);
        for (int i = 0; i < comps.size(); ++i) {
            ocie = (OiiiCompInvEntry)comps.get(i);
            OiiiCompInstallID cid = ocie.getCompInstallID();
            if (!cid.getName().equals(compName)) continue;
            cid.setVersion(version);
            versionChanged = true;
        }
        for (int k = 0; k < comps.size(); ++k) {
            ocie = (OiiiCompInvEntry)comps.get(k);
            OiisDeps deps = ocie.getDeps();
            if (deps == null) continue;
            Vector depRules = deps.getDepRules();
            for (int i = 0; i < depRules.size(); ++i) {
                OiisDepRule rule = (OiisDepRule)depRules.elementAt(i);
                Vector vDepComps = rule.getDepCompIds();
                for (int j = 0; j < vDepComps.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)vDepComps.elementAt(j);
                    if (!cid.getName().equals(compName)) continue;
                    cid.setVersion(version);
                    vDepComps.setElementAt(cid, j);
                }
            }
        }
        if (homeIndex != 0) {
            OiiiOracleHomeInfo oohi = this.m_installInv.getHomeInfo(homeIndex);
            oohi.setDirty(true);
        }
        return versionChanged;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("oracle.installer.oui_loc", "/scratch/sumsanka/apitest/oui");
            OiicStandardInventorySession session = new OiicStandardInventorySession("printhomes", "10.1");
            session.initSession(1);
            OiiiInstallInventory oInventory = session.getInstallAreaControl().getInstallInventory();
            String compName = "oracle.swd.opatch";
            OiiiVersion ver = new OiiiVersion("11.1.0.8.0");
            OiiiUpdateCompsVersion updateComps = new OiiiUpdateCompsVersion(oInventory);
            boolean isVersionChanged = updateComps.updateCompVersion(compName, ver, 3);
            if (isVersionChanged) {
                System.out.println("Version of component " + compName + " changed to " + ver);
            } else {
                System.out.println("Component " + compName + "not found");
            }
            session.getInstallAreaControl().saveInstallInventory();
            session.endSession();
        }
        catch (OiitTargetLockNotAvailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OiiiInventoryDoesNotExistException e) {
            e.printStackTrace();
        }
        catch (OiifbCancelException e) {
            e.printStackTrace();
        }
    }
}

