/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;

public class OiiiStagingAreaInfo
implements Serializable {
    static final long serialVersionUID = 5067806409634959619L;
    private String m_location;
    private String m_exportedFileLoc;
    private String m_httpUrl;

    public OiiiStagingAreaInfo(String location, String exportedLoc, String httpUrl) {
        this.m_location = location;
        this.m_exportedFileLoc = exportedLoc != null ? exportedLoc : "";
        this.m_httpUrl = httpUrl != null ? httpUrl : "";
    }

    public OiiiStagingAreaInfo(String location, String exportedLoc) {
        this(location, exportedLoc, "");
    }

    public OiiiStagingAreaInfo(String location) {
        this(location, "", "");
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setExportedFileLoc(String exportedFileLoc) {
        this.m_exportedFileLoc = exportedFileLoc;
    }

    public String getExportedFileLoc() {
        return this.m_exportedFileLoc;
    }

    public void setHttpUrl(String httpUrl) {
        this.m_httpUrl = httpUrl;
    }

    public String getHttpUrl() {
        return this.m_httpUrl;
    }

    public boolean setAdditionalInfoFrom(OiiiStagingAreaInfo sai) {
        boolean anyUpdate = false;
        if (this.equals(sai)) {
            if ((this.m_exportedFileLoc == null || this.m_exportedFileLoc.equals("")) && !sai.getExportedFileLoc().equals("")) {
                this.m_exportedFileLoc = sai.getExportedFileLoc();
                anyUpdate = true;
            }
            if ((this.m_httpUrl == null || this.m_httpUrl.equals("")) && !sai.getHttpUrl().equals("")) {
                this.m_httpUrl = sai.getHttpUrl();
                anyUpdate = true;
            }
        }
        return anyUpdate;
    }

    public boolean equals(OiiiStagingAreaInfo sai) {
        if (sai != null) {
            return this.m_location.equals(sai.getLocation());
        }
        return false;
    }

    public boolean equals(String name) {
        return this.m_location.equals(name);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiiiStagingAreaInfo) {
                return this.equals((OiiiStagingAreaInfo)obj);
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        return "[ Location : " + String.valueOf(this.m_location) + "; ExportedLoc : " + String.valueOf(this.m_exportedFileLoc) + "; HTTP URL : " + String.valueOf(this.m_httpUrl) + " ]";
    }
}

