/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiConfigXMLWriter;
import oracle.sysman.oii.oiii.OiiiInventoryXMLWriter41;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisInstVer;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisSingleSize;
import oracle.sysman.oii.oiis.OiisSize;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

class OiiiStageXMLWriter
extends OiiiInventoryXMLWriter41 {
    private Vector m_vConfigToolsToGenerate = null;

    OiiiStageXMLWriter(OiiiStageInventory inventory, String stageLocation) {
        super(stageLocation);
        this.m_inventory = inventory;
    }

    void setInventory(OiiiStageInventory inv) {
        this.m_inventory = inv;
    }

    private OiiiStageInventory getStageInventory() {
        return (OiiiStageInventory)this.m_inventory;
    }

    void setStageLocation(String stageLoc) {
        this.m_invLoc = stageLoc;
    }

    @Override
    public void writeAll() throws IOException {
        this.writeComps(-1);
        OiiiConfigXMLWriter cw = OiiiConfigXMLWriter.getWriter();
        if (this.m_vConfigToolsToGenerate != null) {
            String sConfigFileLoc = OiixPathOps.concatPath(this.m_invLoc, "config.xml");
            cw.writeXML(this.m_vConfigToolsToGenerate, sConfigFileLoc);
            this.m_vConfigToolsToGenerate = null;
        }
        this.writeLibs(-1);
        this.writeInvDetails();
        this.cleanup();
    }

    private void cleanup() {
        this.m_vConfigToolsToGenerate = null;
        this.m_inventory = null;
        this.m_invLoc = null;
    }

    @Override
    protected XMLElement getPrdListXMLElement() {
        XMLElement elemPrdList = super.getPrdListXMLElement();
        boolean bOrdered = this.getStageInventory().getCompsOrdered();
        String sOrdered = bOrdered ? "T" : "F";
        elemPrdList.setAttribute("ORDERED", sOrdered);
        return elemPrdList;
    }

    @Override
    protected XMLElement getCompXMLElement(OiiiCompInvEntry compEntry) {
        XMLElement elemComp = super.getCompXMLElement(compEntry);
        OiiiStageCompInvEntry entry = (OiiiStageCompInvEntry)compEntry;
        OiiiCompInstallID cid = entry.getCompInstallID();
        OiisCompProperties compProps = entry.getCompProperties();
        XMLElement stageInfo = this.getStageInfoXML(entry);
        elemComp.appendChild((Node)stageInfo);
        XMLElement defaultifyInfo = this.getDefaultifyXML(entry);
        if (defaultifyInfo != null) {
            elemComp.appendChild((Node)defaultifyInfo);
        }
        XMLElement compJarInfo = this.getCompJarInfoXML(entry);
        elemComp.appendChild((Node)compJarInfo);
        XMLElement locInfo = this.getLocationsInfoXML(entry);
        locInfo.setAttribute("DSK_NO", String.valueOf(entry.getDiskNumber()));
        locInfo.setAttribute("JAR_LOC", this.getJarContentsLoc(entry));
        if (this.isPatchset(entry)) {
            elemComp.appendChild((Node)locInfo);
            OiisPatchSetContents patchSetContents = entry.getPatchSetContents();
            if (patchSetContents != null) {
                Vector vPatches = patchSetContents.getContainedPatches();
                for (int i = 0; i < vPatches.size(); ++i) {
                    OiiiPatchInstallID pid = (OiiiPatchInstallID)vPatches.elementAt(i);
                    XMLElement ps_patch = this.getPatchSetPatchesXML(pid);
                    ps_patch.setAttribute("BASE_PLATS", OiilXMLHelper.platVect2String(pid.getCompPlatforms(), " "));
                    ps_patch.setAttribute("PLAT", OiilXMLHelper.platVect2String(pid.getPlatforms(), " "));
                    elemComp.appendChild((Node)ps_patch);
                }
            }
            return elemComp;
        }
        elemComp.setAttribute("STG_PLAT", OiilXMLHelper.platVect2String(entry.getPlatforms(), " "));
        elemComp.setAttribute("PLAT", OiilXMLHelper.platVect2String(cid.getPlatforms(), " "));
        if (cid.getHomeType() == 1) {
            elemComp.setAttribute("TYPE", "SOH");
        } else if (cid.getHomeType() == 0) {
            elemComp.setAttribute("TYPE", "NOH");
        }
        if (entry.isMerged()) {
            elemComp.setAttribute("MERGED", "T");
            if (entry.getCompInstallID().getCompType() == 1) {
                elemComp.setAttribute("VER_MER", entry.getMergedVersion().getVerString());
            }
        }
        locInfo.setAttribute("FGRP_LOC", entry.getGroupFilesLoc());
        elemComp.appendChild((Node)locInfo);
        elemComp.appendChild((Node)this.getBookNameXML(entry));
        elemComp.appendChild((Node)this.getPreReqXML(entry));
        elemComp.appendChild((Node)this.getProdHomeXML(entry));
        OiisDeps deps = entry.getDeps();
        if (deps != null) {
            elemComp.appendChild((Node)this.getDepGroupsXML(deps));
            elemComp.appendChild((Node)this.getInstallTypesXML(deps));
        }
        elemComp.appendChild((Node)this.getPlatIndexMapXML(entry));
        elemComp.appendChild((Node)this.getLangIndexMapXML(entry));
        elemComp.appendChild((Node)this.getDestIndexMapXML(entry));
        if (entry.isTopLevel()) {
            XMLElement sizes = this.getSizeInfoXML(entry);
            elemComp.appendChild((Node)sizes);
        }
        XMLElement xmlfsi = new XMLElement("STG_FSI");
        OiisFileSizeInfo fsi = entry.getFileSizeInfoEx();
        if (fsi == null) {
            fsi = new OiisFileSizeInfo(entry.getPlatIndexMapping(), entry.getLangIndexMapping(), entry.getDestIndexMapping());
        }
        if (fsi != null) {
            XMLElement destPlatLang = this.getDestPlatLangXML(entry);
            xmlfsi.appendChild((Node)destPlatLang);
            XMLElement offsets = this.getOffsetsXML(fsi);
            xmlfsi.appendChild((Node)offsets);
            XMLElement largestJars = this.getLargestJarsXML(fsi);
            xmlfsi.appendChild((Node)largestJars);
        }
        elemComp.appendChild((Node)xmlfsi);
        XMLElement libDeps = this.getLibDepsXML(compProps);
        elemComp.appendChild((Node)libDeps);
        if (this.isPatch(entry)) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            OiiiStagePatchInvEntry pEntry = (OiiiStagePatchInvEntry)entry;
            elemComp.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
            elemComp.setAttribute("BASE_PLAT", OiilXMLHelper.platVect2String(pid.getCompPlatforms(), " "));
            XMLElement xmlPatchDeps = new XMLElement("PAT_DEP_LIST");
            OiisPatchDeps patchDeps = pEntry.getPatchDeps();
            if (patchDeps != null && patchDeps.getDependeeIDs() != null) {
                Vector vDeps = patchDeps.getDepObjs();
                for (int i = 0; vDeps != null && i < vDeps.size(); ++i) {
                    OiisPatchDepObj patDepObj = (OiisPatchDepObj)vDeps.elementAt(i);
                    xmlPatchDeps.appendChild((Node)this.getPatchDepXML(patDepObj));
                }
                elemComp.appendChild((Node)xmlPatchDeps);
            }
        }
        if (compProps.getConfigToolCount() > 0 || compProps.getConfigToolsToSuppress() != null && compProps.getConfigToolsToSuppress().size() > 0) {
            if (this.m_vConfigToolsToGenerate == null) {
                this.m_vConfigToolsToGenerate = new Vector();
            }
            this.m_vConfigToolsToGenerate.addElement(entry);
        }
        return elemComp;
    }

    private XMLElement getStageInfoXML(OiiiStageCompInvEntry entry) {
        OiisInstVer ver;
        int i;
        XMLElement stageInfo = new XMLElement("STG_INFO");
        stageInfo.setAttribute("OSP_VER", entry.getStageVersion().getVerString());
        OiiiVersion instVer = null;
        boolean bDiff = false;
        Vector vInstVersions = entry.getInstVersions();
        for (i = 0; i < vInstVersions.size(); ++i) {
            ver = (OiisInstVer)vInstVersions.elementAt(i);
            if (instVer == null) {
                instVer = ver.getVersion();
                continue;
            }
            if (instVer.equals(ver.getVersion())) continue;
            bDiff = true;
            break;
        }
        if (!bDiff && instVer != null) {
            XMLElement installerVersion = new XMLElement("INST_VER");
            installerVersion.setAttribute("PLAT", "ALL_PLATS");
            installerVersion.setAttribute("VER", instVer.getVerString());
            stageInfo.appendChild((Node)installerVersion);
        } else {
            for (i = 0; i < vInstVersions.size(); ++i) {
                ver = (OiisInstVer)vInstVersions.elementAt(i);
                if (ver == null) continue;
                XMLElement installerVersion = new XMLElement("INST_VER");
                installerVersion.setAttribute("PLAT", ver.getPlatform().toString());
                installerVersion.setAttribute("VER", ver.getVersion().getVerString());
                stageInfo.appendChild((Node)installerVersion);
            }
        }
        return stageInfo;
    }

    private XMLElement getDefaultifyXML(OiiiStageCompInvEntry entry) {
        XMLElement defaultifyInfo = null;
        boolean bDefaultify = entry.canDefaultify();
        if (!bDefaultify) {
            defaultifyInfo = new XMLElement("DEFAULTIFY");
            defaultifyInfo.setAttribute("ENABLED", "F");
        }
        return defaultifyInfo;
    }

    private XMLElement getPatchDepXML(OiisPatchDepObj patchDep) {
        XMLElement xmlPatDep = new XMLElement("PAT_DEP");
        XMLElement xmlDepId = new XMLElement("DEP_ID");
        xmlDepId.setAttribute("NAME", patchDep.getOrigDepId().getName());
        xmlDepId.setAttribute("VER", patchDep.getOrigDepId().getVersion().getVerString());
        xmlDepId.setAttribute("PLAT", OiilXMLHelper.platVect2String(patchDep.getOrigDepId().getPlatforms(), " "));
        xmlPatDep.appendChild((Node)xmlDepId);
        if (patchDep.isVerUpgraded()) {
            XMLElement xmlUpgradedDepId = new XMLElement("UPGRD_DEP_ID");
            xmlUpgradedDepId.setAttribute("NAME", patchDep.getCurDepId().getName());
            xmlUpgradedDepId.setAttribute("VER", patchDep.getCurDepId().getVersion().getVerString());
            xmlUpgradedDepId.setAttribute("PLAT", OiilXMLHelper.platVect2String(patchDep.getCurDepId().getPlatforms(), " "));
            xmlPatDep.appendChild((Node)xmlUpgradedDepId);
        }
        return xmlPatDep;
    }

    private XMLElement getDepGroupsXML(OiisDeps deps) {
        XMLElement xmlDepGroupList = new XMLElement("DEP_GRP_LIST");
        Vector depRules = deps.getDepRules();
        for (int i = 0; i < depRules.size(); ++i) {
            OiisDepRule rule = (OiisDepRule)depRules.elementAt(i);
            XMLElement xmlDepGrp = new XMLElement("DEP_GRP");
            xmlDepGrp.setAttribute("NAME", rule.getInternalName());
            xmlDepGrp.setAttribute("TYPE", rule.getTypeString());
            XMLElement xmlDepList = new XMLElement("DEP_LIST");
            Vector vDepComps = rule.getDepCompIds();
            for (int j = 0; j < vDepComps.size(); ++j) {
                OiiiCompInstallID cid = (OiiiCompInstallID)vDepComps.elementAt(j);
                XMLElement xmlDep = new XMLElement("DEP");
                xmlDep.setAttribute("NAME", cid.getName());
                xmlDep.setAttribute("VER", cid.getVersion().getVerString());
                xmlDep.setAttribute("PLAT", OiilXMLHelper.platVect2String(cid.getPlatforms(), " "));
                if (this.m_inventory.getCompInvEntry(cid) == null) {
                    xmlDep.setAttribute("HOME_IDX", "-1");
                }
                xmlDepList.appendChild((Node)xmlDep);
            }
            xmlDepGrp.appendChild((Node)xmlDepList);
            xmlDepGroupList.appendChild((Node)xmlDepGrp);
        }
        return xmlDepGroupList;
    }

    private XMLElement getInstallTypesXML(OiisDeps deps) {
        XMLElement installTypes = new XMLElement("INST_TYPE_LIST");
        Vector vDepModes = deps.getDepModes();
        for (int i = 0; i < vDepModes.size(); ++i) {
            OiisDepMode depMode = (OiisDepMode)vDepModes.elementAt(i);
            XMLElement xmlInstallType = new XMLElement("INST_TYPE");
            xmlInstallType.setAttribute("NAME", depMode.getInternalName());
            xmlInstallType.setAttribute("NAME_ID", depMode.getNameID());
            xmlInstallType.setAttribute("DESC_ID", depMode.getDescriptionID());
            Vector vDepRuleProps = depMode.getDepRuleProps();
            if (vDepRuleProps != null) {
                for (int j = 0; j < depMode.getDepRuleProps().size(); ++j) {
                    OiisDepRuleProperty depProps = (OiisDepRuleProperty)depMode.getDepRuleProps().elementAt(j);
                    XMLElement xmlDepProps = new XMLElement("DEP_GRP_PRPS");
                    xmlDepProps.setAttribute("NAME", depProps.getRuleName());
                    xmlDepProps.setAttribute("OPEN", depProps.isOpen() ? "T" : "F");
                    xmlDepProps.setAttribute("ASK", depProps.shouldAsk() ? "T" : "F");
                    Vector depComps = depProps.getDepRuleComps();
                    if (depComps != null) {
                        for (int k = 0; k < depComps.size(); ++k) {
                            OiisDepRuleComp comp = (OiisDepRuleComp)depComps.elementAt(k);
                            XMLElement xmlComp = new XMLElement("DEP_GRP_CMP");
                            xmlComp.setAttribute("NAME", comp.getComp().getName());
                            xmlComp.setAttribute("VER", comp.getComp().getVersion().getVerString());
                            xmlComp.setAttribute("PLAT", OiilXMLHelper.platVect2String(comp.getComp().getPlatforms(), " "));
                            xmlComp.setAttribute("INST_TYPE", comp.getDepModeName());
                            xmlComp.setAttribute("SEL", comp.getSelected() ? "T" : "F");
                            xmlDepProps.appendChild((Node)xmlComp);
                        }
                    }
                    xmlInstallType.appendChild((Node)xmlDepProps);
                }
            }
            installTypes.appendChild((Node)xmlInstallType);
        }
        return installTypes;
    }

    private XMLElement getSizeInfoXML(OiiiStageCompInvEntry entry) {
        XMLElement xmlSizes = new XMLElement("SIZES");
        OiisSize size = entry.getSizeInfo();
        if (size == null) {
            return xmlSizes;
        }
        Vector vSize = size.getSingleSizes();
        for (int i = 0; i < vSize.size(); ++i) {
            OiisSingleSize singleSize = (OiisSingleSize)vSize.elementAt(i);
            XMLElement xmlSingleSize = new XMLElement("SZ");
            xmlSingleSize.setAttribute("PLAT", singleSize.getPlatform().toString());
            xmlSingleSize.setAttribute("INST_TYPE", singleSize.getDepModeName());
            long lSize = singleSize.getLargestFileGroupJarSize();
            xmlSingleSize.setAttribute("LRG_JAR_SZ", String.valueOf(singleSize.getLargestFileGroupJarSize()));
            long[] sizes = singleSize.getSizes();
            if (sizes != null) {
                for (int j = 0; j < sizes.length; ++j) {
                    if (sizes[j] == 0L) continue;
                    XMLElement xmlLang = new XMLElement("LANG_SZ");
                    xmlLang.setAttribute("IDX", String.valueOf(j));
                    xmlLang.setAttribute("SIZE", String.valueOf(sizes[j]));
                    xmlSingleSize.appendChild((Node)xmlLang);
                }
            } else {
                xmlSingleSize.setAttribute("SIZE", singleSize.getSize().toString());
            }
            xmlSizes.appendChild((Node)xmlSingleSize);
        }
        return xmlSizes;
    }

    private XMLElement getDestPlatLangXML(OiiiStageCompInvEntry entry) {
        long[][][] dlpArr;
        OiisFileSizeInfo fileSizeInfo = entry.getFileSizeInfoEx();
        XMLElement xmlDLP = new XMLElement("DST_LNG_PLT_MAP");
        Vector langSets = fileSizeInfo.getLangIndexMapping().getLangSets();
        if (langSets == null && (langSets = fileSizeInfo.getLangSets()) == null) {
            return xmlDLP;
        }
        Vector platSets = fileSizeInfo.getPlatIndexMapping().getPlatSets();
        if (platSets == null && (platSets = fileSizeInfo.getPlatSets()) == null) {
            return xmlDLP;
        }
        OiisDestinationIndexMapping destIndexMap = entry.getDestIndexMapping();
        if (destIndexMap == null) {
            destIndexMap = new OiisDestinationIndexMapping();
            String[] saDests = OiisFileSizeInfo.getDefaultDestVars();
            for (int i = 0; i < saDests.length; ++i) {
                destIndexMap.addDestination(saDests[i]);
            }
            entry.setDestIndexMapping(destIndexMap);
            entry.getFileSizeInfoEx().setDestIndexMapping(destIndexMap);
        }
        if ((dlpArr = fileSizeInfo.get3DSizesArray()) != null) {
            for (int d = 0; d < dlpArr.length; ++d) {
                for (int l = 0; l < dlpArr[0].length; ++l) {
                    for (int p = 0; p < dlpArr[0][0].length; ++p) {
                        if (dlpArr[d][l][p] == 0L) continue;
                        XMLElement id = new XMLElement("ID");
                        id.setAttribute("DST", String.valueOf(d));
                        id.setAttribute("LANG", String.valueOf(l));
                        id.setAttribute("PLAT", String.valueOf(p));
                        id.setAttribute("SIZE", String.valueOf(dlpArr[d][l][p]));
                        xmlDLP.appendChild((Node)id);
                    }
                }
            }
            return xmlDLP;
        }
        long[][] lpArr = fileSizeInfo.get2DSizesArray2x();
        if (lpArr == null) {
            return xmlDLP;
        }
        int index = destIndexMap.getDestinationIndex("%ORACLE_HOME%");
        String sDest = String.valueOf(index);
        for (int l = 0; l < lpArr.length; ++l) {
            for (int p = 0; p < lpArr[0].length; ++p) {
                XMLElement id = new XMLElement("ID");
                id.setAttribute("DST", sDest);
                id.setAttribute("LANG", String.valueOf(l));
                id.setAttribute("PLAT", String.valueOf(p));
                id.setAttribute("SIZE", String.valueOf(lpArr[l][p]));
                xmlDLP.appendChild((Node)id);
            }
        }
        return xmlDLP;
    }

    private XMLElement getOffsetsXML(OiisFileSizeInfo fileSizeInfo) {
        XMLElement offsets = new XMLElement("OFFSETS");
        int numDest = fileSizeInfo.getDestIndexMapping().size();
        Object[] destOffsetsArr = fileSizeInfo.getOffsetArr(1);
        int[] destOffsetTypeArr = fileSizeInfo.getOffsetTypeArr(1);
        Object[] nonInstallOffsetsArr = fileSizeInfo.getOffsetArr(4);
        int[] nonInstallOffsetTypeArr = fileSizeInfo.getOffsetTypeArr(4);
        Object[] tempOffsetsArr = fileSizeInfo.getOffsetArr(2);
        int[] tempOffsetTypeArr = fileSizeInfo.getOffsetTypeArr(2);
        for (int i = 0; i < numDest; ++i) {
            String sType;
            XMLElement offset;
            if (destOffsetsArr != null && destOffsetsArr.length >= i && destOffsetsArr[i] != null && !destOffsetsArr[i].toString().equals("0")) {
                offset = new XMLElement("DST");
                offset.setAttribute("DST", fileSizeInfo.getDestIndexMapping().getDestination(i));
                sType = "NO";
                if (destOffsetTypeArr[i] == 2) {
                    sType = "CONST";
                } else if (destOffsetTypeArr[i] == 6) {
                    sType = "VAR";
                }
                offset.setAttribute("TYPE", sType);
                offset.setAttribute("VAL", destOffsetsArr[i].toString());
                offsets.appendChild((Node)offset);
            }
            if (tempOffsetsArr != null && tempOffsetsArr.length >= i && tempOffsetsArr[i] != null && !tempOffsetsArr[i].toString().equals("0")) {
                offset = new XMLElement("TMP");
                offset.setAttribute("DST", fileSizeInfo.getDestIndexMapping().getDestination(i));
                sType = "NO";
                if (tempOffsetTypeArr[i] == 2) {
                    sType = "CONST";
                } else if (tempOffsetTypeArr[i] == 6) {
                    sType = "VAR";
                }
                offset.setAttribute("TYPE", sType);
                offset.setAttribute("VAL", tempOffsetsArr[i].toString());
                offsets.appendChild((Node)offset);
            }
            if (nonInstallOffsetsArr == null || nonInstallOffsetsArr.length < i || nonInstallOffsetsArr[i] == null || nonInstallOffsetsArr[i].toString().equals("0")) continue;
            offset = new XMLElement("NONINST");
            offset.setAttribute("DST", fileSizeInfo.getDestIndexMapping().getDestination(i));
            sType = "NO";
            if (nonInstallOffsetTypeArr[i] == 2) {
                sType = "CONST";
            } else if (nonInstallOffsetTypeArr[i] == 6) {
                sType = "VAR";
            }
            offset.setAttribute("TYPE", sType);
            offset.setAttribute("VAL", nonInstallOffsetsArr[i].toString());
            offsets.appendChild((Node)offset);
        }
        return offsets;
    }

    private XMLElement getLargestJarsXML(OiisFileSizeInfo fsi) {
        XMLElement xmlJarSize = new XMLElement("JAR_SZ");
        int[] plats = fsi.getPlatIndexMapping().getPlats();
        for (int i = 0; i < plats.length; ++i) {
            XMLElement xmlLargest = new XMLElement("LRG_JAR");
            long lSize = fsi.getLargestFileGroupJar(plats[i]);
            xmlLargest.setAttribute("PLAT", String.valueOf(plats[i]));
            xmlLargest.setAttribute("SIZE", String.valueOf(lSize));
            xmlJarSize.appendChild((Node)xmlLargest);
        }
        return xmlJarSize;
    }

    private XMLElement getLibDepsXML(OiisCompProperties props) {
        XMLElement xmlLibDepList = new XMLElement("LIB_DEP_LST");
        Vector vLibs = props.getLibraryDeps(0);
        XMLElement xmlActionDep = new XMLElement("ACTION_LIST");
        for (int i = 0; i < vLibs.size(); ++i) {
            XMLElement libDep = new XMLElement("LIB_DEP");
            OiiiLibraryID lid = (OiiiLibraryID)vLibs.elementAt(i);
            libDep.setAttribute("NAME", lid.getName());
            libDep.setAttribute("VER", lid.getVersion().getVerString());
            libDep.setAttribute("PLAT", OiilXMLHelper.platVect2String(lid.getPlatforms(), " "));
            libDep.setAttribute("MIN_INST_VER", lid.getInstVer().getVerString());
            libDep.setAttribute("REP_VER", lid.getReplaceVersion().getVerString());
            libDep.setAttribute("DEP_MAP", String.valueOf(props.getPhaseMap(lid, 0)));
            xmlActionDep.appendChild((Node)libDep);
        }
        xmlLibDepList.appendChild((Node)xmlActionDep);
        vLibs = props.getLibraryDeps(1);
        XMLElement xmlQryDep = new XMLElement("QUERY_LIST");
        for (int i = 0; i < vLibs.size(); ++i) {
            XMLElement libDep = new XMLElement("LIB_DEP");
            OiiiLibraryID lid = (OiiiLibraryID)vLibs.elementAt(i);
            libDep.setAttribute("NAME", lid.getName());
            libDep.setAttribute("VER", lid.getVersion().getVerString());
            libDep.setAttribute("PLAT", OiilXMLHelper.platVect2String(lid.getPlatforms(), " "));
            libDep.setAttribute("MIN_INST_VER", lid.getInstVer().getVerString());
            libDep.setAttribute("REP_VER", lid.getReplaceVersion().getVerString());
            libDep.setAttribute("DEP_MAP", String.valueOf(props.getPhaseMap(lid, 1)));
            xmlQryDep.appendChild((Node)libDep);
        }
        xmlLibDepList.appendChild((Node)xmlQryDep);
        vLibs = props.getLibraryDeps(2);
        XMLElement xmlDlgDep = new XMLElement("DIALOG_LIST");
        for (int i = 0; i < vLibs.size(); ++i) {
            XMLElement libDep = new XMLElement("LIB_DEP");
            OiiiLibraryID lid = (OiiiLibraryID)vLibs.elementAt(i);
            libDep.setAttribute("NAME", lid.getName());
            libDep.setAttribute("VER", lid.getVersion().getVerString());
            libDep.setAttribute("PLAT", OiilXMLHelper.platVect2String(lid.getPlatforms(), " "));
            libDep.setAttribute("MIN_INST_VER", lid.getInstVer().getVerString());
            libDep.setAttribute("REP_VER", lid.getReplaceVersion().getVerString());
            libDep.setAttribute("DEP_MAP", String.valueOf(props.getPhaseMap(lid, 2)));
            xmlDlgDep.appendChild((Node)libDep);
        }
        xmlLibDepList.appendChild((Node)xmlDlgDep);
        return xmlLibDepList;
    }

    @Override
    void writeOneoffs(int nHomeIndex, PrintWriter pWriter, boolean bHeader) {
    }

    OiisCompProperties getCompProperties(OiiiCompInvEntry entry) {
        return ((OiiiStageCompInvEntry)entry).getCompProperties();
    }

    @Override
    String getJarContentsLoc(OiiiCompInvEntry entry) {
        return ((OiiiStageCompInvEntry)entry).getJarContentsLoc();
    }

    @Override
    String getCompsFileName() {
        return "products.xml";
    }
}

