/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageArchiveInfo;
import oracle.sysman.oii.oiii.OiiiStageStateInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisInstVer;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiStageCompInvEntry
extends OiiiCompInvEntry
implements Cloneable {
    static final long serialVersionUID = 3518627129394903588L;
    private String m_jarContentsLoc;
    private String m_groupFilesLoc;
    private transient boolean m_createdNow = false;
    private OiisFileSizeInfo m_fileSizeInfo = null;
    private OiiiStageArchiveInfo m_stageArchive;
    private Vector m_instVersions;
    private Integer m_nDisk;
    private OiisPatchSetContents m_patchSetContents;
    private OiiiStageStateInfo m_stageStateInfo;
    private String m_saveTimeTag;
    private BitSet m_unsavedChanges;
    private String m_stageTimeTag;
    private boolean m_bMerged = false;
    private OiiiVersion m_VerOfPat = null;
    private static String DATEFORMAT = "EEE MMM d HH:mm:ss z yyyy";
    private static String s_machineName = null;
    private static SimpleDateFormat s_formatter = new SimpleDateFormat(DATEFORMAT);
    public static final int SAVETAG = 1;
    public static final int STAGETAG = 2;

    public OiiiStageCompInvEntry(OiiiCompInstallID cid, String stageLoc, String groupFilesLoc, Vector langVect, String jarContentsLoc) {
        this(cid, stageLoc, groupFilesLoc, langVect, null, jarContentsLoc, null);
    }

    public OiiiStageCompInvEntry(OiiiCompInstallID cid, String stageLoc, String groupFilesLoc, Vector langVect, String jarContentsLoc, OiiiStageArchiveInfo stageArchive) {
        this(cid, stageLoc, groupFilesLoc, langVect, null, jarContentsLoc, stageArchive);
    }

    public OiiiStageCompInvEntry(OiiiCompInstallID cid, String stageLoc, String groupFilesLoc, Vector langVect, Vector platVect, String jarContentsLoc) {
        this(cid, stageLoc, groupFilesLoc, langVect, platVect, jarContentsLoc, null);
    }

    public OiiiStageCompInvEntry(OiiiCompInstallID cid, String stageLoc, String groupFilesLoc, Vector langVect, Vector platVect, String jarContentsLoc, OiiiStageArchiveInfo stageArchive) {
        this(cid, stageLoc, groupFilesLoc, langVect, platVect, jarContentsLoc, null, stageArchive);
    }

    public OiiiStageCompInvEntry(OiiiCompInstallID cid, String stageLoc, String groupFilesLoc, Vector langVect, Vector platVect, String jarContentsLoc, String installDefnLoc, OiiiStageArchiveInfo stageArchive) {
        super(cid, stageLoc, langVect, platVect);
        this.m_groupFilesLoc = groupFilesLoc;
        this.m_jarContentsLoc = jarContentsLoc;
        super.setInstallDefnLoc(installDefnLoc);
        this.m_createdNow = true;
        this.m_stageArchive = stageArchive;
    }

    public OiiiStageArchiveInfo getStageArchiveInfo() {
        return this.m_stageArchive;
    }

    public void setStageArchiveInfo(OiiiStageArchiveInfo stageArchive) {
        this.m_stageArchive = stageArchive;
    }

    public void setInstallerVersion(String sVersion, int nPlat) {
        OiiiVersion oVer = new OiiiVersion(sVersion);
        Integer oPlat = new Integer(nPlat);
        OiisInstVer insVer = new OiisInstVer(oVer, oPlat);
        if (this.m_instVersions == null) {
            this.m_instVersions = new Vector();
            this.m_instVersions.addElement(insVer);
        } else {
            boolean bToAdd = true;
            for (int i = 0; i < this.m_instVersions.size(); ++i) {
                OiisInstVer insVersion = (OiisInstVer)this.m_instVersions.elementAt(i);
                if (insVersion.getPlatform().compareTo(oPlat) != 0) continue;
                insVersion.setVersion(oVer);
                bToAdd = false;
                break;
            }
            if (bToAdd) {
                this.m_instVersions.addElement(insVer);
            }
        }
    }

    public OiiiVersion getInstallerVersion(int nPlat) {
        return this.getInstallerVersion(nPlat, new OiiiVersion("0"));
    }

    public OiiiVersion getInstallerVersion(int nPlat, OiiiVersion defVersion) {
        int nIndex;
        Integer oPlat = new Integer(nPlat);
        if (this.m_instVersions != null && (nIndex = OiixVectorOps.vectIndexOf(this.m_instVersions, (Object)oPlat)) != -1) {
            OiisInstVer insVer = (OiisInstVer)this.m_instVersions.elementAt(nIndex);
            return insVer.getVersion();
        }
        return defVersion;
    }

    public Vector getInstVersions() {
        return this.m_instVersions;
    }

    public OiiiVersion[] getInstVersionsArray() {
        Vector vVersion = this.getInstVersions();
        if (vVersion == null) {
            return null;
        }
        if (vVersion.isEmpty()) {
            return null;
        }
        int nSize = vVersion.size();
        OiiiVersion[] aoVersion = new OiiiVersion[nSize];
        for (int i = 0; i < nSize; ++i) {
            aoVersion[i] = ((OiisInstVer)vVersion.elementAt(i)).getVersion();
        }
        return aoVersion;
    }

    public void setInstVersions(Vector instVersions) {
        this.m_instVersions = instVersions;
    }

    public void optimizeInstVersion() {
        Vector<OiisInstVer> optimizedVect = new Vector<OiisInstVer>();
        Integer oPlat = new Integer(OiixPlatform.getCurrentPlatform());
        if (this.m_instVersions == null) {
            return;
        }
        int nSize = this.m_instVersions.size();
        for (int i = 0; i < nSize; ++i) {
            OiisInstVer instVer = (OiisInstVer)this.m_instVersions.elementAt(i);
            Integer currentPlat = instVer.getPlatform();
            if (currentPlat.equals(oPlat)) {
                optimizedVect.addElement(instVer);
                continue;
            }
            if (currentPlat >= 0 || !OiixPlatform.isPlatInGroup(currentPlat, oPlat)) continue;
            optimizedVect.addElement(instVer);
        }
        this.m_instVersions = optimizedVect;
    }

    @Override
    public OiisDeps getDeps() {
        OiisDeps oDeps = super.getDeps();
        if (oDeps != null && !oDeps.isResourceBundleSet()) {
            oDeps.setResourceBundle(new OiixJarResourceBundle(this.getResourceBundle()));
        }
        return oDeps;
    }

    public void setJarContentsLoc(String sJarContentsLoc) {
        this.m_jarContentsLoc = sJarContentsLoc;
    }

    @Override
    public String getJarContentsLoc() {
        return this.m_jarContentsLoc;
    }

    public void setGroupFilesLoc(String sGroupFilesLoc) {
        this.m_groupFilesLoc = sGroupFilesLoc;
    }

    public String getGroupFilesLoc() {
        return this.m_groupFilesLoc;
    }

    public void setPatchSetContents(OiisPatchSetContents pSetContents) {
        this.m_patchSetContents = pSetContents;
    }

    public OiisPatchSetContents getPatchSetContents() {
        return this.m_patchSetContents;
    }

    public void setStageStateInfo(OiiiStageStateInfo stageInfo) {
        this.m_stageStateInfo = stageInfo;
    }

    public OiiiStageStateInfo getStageStateInfo() {
        return this.m_stageStateInfo;
    }

    public Object getStageTimeTags() {
        return null;
    }

    public void setStageTimeTags(Object stageTags) {
    }

    public boolean isNewEntry() {
        return this.m_createdNow;
    }

    void setAsNewEntry() {
        this.m_createdNow = true;
    }

    public void setFileSizeInfo(OiisFileSizeInfo fileSizeInfo) {
        this.m_fileSizeInfo = fileSizeInfo;
    }

    public OiisFileSizeInfo getFileSizeInfo() {
        return this.m_fileSizeInfo;
    }

    @Override
    public OiisFileSizeInfo getFileSizeInfoEx() {
        OiisFileSizeInfo fsi = super.getFileSizeInfoEx();
        if (fsi == null) {
            fsi = this.getFileSizeInfo();
        }
        return fsi;
    }

    public String getSaveTimeTag() {
        return this.m_saveTimeTag;
    }

    public void setSaveTimeTag(String saveTimeTag) {
        this.m_saveTimeTag = saveTimeTag;
    }

    public BitSet getUnsavedChanges() {
        return this.m_unsavedChanges;
    }

    public void setUnsavedChanges(BitSet unsavedChanges) {
        this.m_unsavedChanges = unsavedChanges;
    }

    public String getStageTimeTag() {
        return this.m_stageTimeTag;
    }

    public void setStageTimeTag(String stageTimeTag) {
        this.m_stageTimeTag = stageTimeTag;
    }

    @Override
    public void setLocation(String location) {
        super.setLocation(location);
    }

    public void setDiskNumber(int nDisk) {
        this.m_nDisk = new Integer(nDisk);
    }

    public int getDiskNumber() {
        if (this.m_nDisk == null) {
            return 1;
        }
        return this.m_nDisk;
    }

    public void setMerged(boolean bMerged) {
        this.m_bMerged = bMerged;
        if (!this.m_bMerged) {
            this.m_VerOfPat = null;
        }
    }

    public boolean isMerged() {
        return this.m_bMerged;
    }

    public void setMergedVersion(OiiiVersion oVersion) {
        this.m_VerOfPat = oVersion;
    }

    public OiiiVersion getMergedVersion() {
        return this.m_VerOfPat;
    }

    @Override
    public String toString() {
        return super.toString() + ", <" + this.m_jarContentsLoc + "> tag : " + this.m_saveTimeTag + "(" + this.m_unsavedChanges + ", " + this.m_stageTimeTag + ")" + "ProdHome? : " + this.isNoProdHome() + " " + this.getPlatforms() + ", Disk" + this.getDiskNumber();
    }

    public boolean equals(OiiiStageCompInvEntry scie) {
        if (scie != null) {
            return this.equalTags(scie) && super.equals(scie) && OiixVectorOps.vectorsEqual(this.getPlatforms(), scie.getPlatforms());
        }
        return false;
    }

    public boolean equalsIgnoringPlatsnTags(OiiiStageCompInvEntry scie) {
        return this.equalsIgnoringPlatsnTags(scie, true);
    }

    public boolean equalsIgnoringPlatsnTags(OiiiStageCompInvEntry scie, boolean idPlatsMatch) {
        if (scie != null) {
            return idPlatsMatch ? this.getCompInstallID().equals(scie.getCompInstallID()) : this.getCompInstallID().equalsWithPlatInt(scie.getCompInstallID());
        }
        return false;
    }

    public boolean equalTags(OiiiStageCompInvEntry scie) {
        if (scie != null) {
            boolean bSameUSC;
            boolean bSameSTT;
            boolean bl = this.m_saveTimeTag == null ? scie.getSaveTimeTag() == null : (bSameSTT = this.m_saveTimeTag.equals(scie.getSaveTimeTag()));
            boolean bl2 = this.m_unsavedChanges == null ? scie.getUnsavedChanges() == null : (bSameUSC = this.m_unsavedChanges.equals(scie.getUnsavedChanges()));
            boolean bSameGTT = this.m_stageTimeTag == null ? scie.getStageTimeTag() == null : this.m_stageTimeTag.equals(scie.getStageTimeTag());
            return bSameSTT && bSameUSC && bSameGTT;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null) {
            if (obj instanceof OiiiStageCompInvEntry) {
                return this.equals((OiiiStageCompInvEntry)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public boolean conflicts(OiiiStageCompInvEntry scie, boolean idPlatsMatch) {
        if (scie != null) {
            if (!this.equalsIgnoringPlatsnTags(scie, idPlatsMatch)) {
                return false;
            }
            if (!this.equalTags(scie)) {
                OiiiCompInstallID id = scie.getCompInstallID();
                boolean bCheck = true;
                if (id.getCompType() != 4) {
                    bCheck = OiixVectorOps.checkIntersection(this.getPlatforms(), scie.getPlatforms());
                }
                if (bCheck) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean replaces(OiiiStageCompInvEntry scie, boolean idPlatsMatch) {
        if (scie != null && this.equalTags(scie) && this.equalsIgnoringPlatsnTags(scie, idPlatsMatch)) {
            OiiiCompInstallID id = scie.getCompInstallID();
            boolean bCheck = true;
            if (id.getCompType() != 4) {
                bCheck = OiixVectorOps.checkIntersection(this.getPlatforms(), scie.getPlatforms());
            }
            if (bCheck) {
                return true;
            }
        }
        return false;
    }

    public static String generateSaveStageTimeTag() {
        if (s_machineName == null) {
            String sMachineName = "<unknown>";
            InetAddress iAddr = null;
            try {
                iAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                System.out.println(e.getMessage());
            }
            if (iAddr != null) {
                sMachineName = iAddr.getHostName();
            }
            s_machineName = sMachineName;
        }
        String sUserName = System.getProperty("user.name");
        Date oDate = new Date();
        String sTag = s_machineName + ";" + sUserName + ";" + s_formatter.format(oDate);
        return sTag;
    }

    public static Date parseTimeTagDate(String saveStageTimeTag) {
        int dateStartPos;
        Date parsedDate = null;
        if (saveStageTimeTag != null && (dateStartPos = saveStageTimeTag.lastIndexOf(59)) != -1) {
            ParsePosition pos = new ParsePosition(dateStartPos + 1);
            parsedDate = s_formatter.parse(saveStageTimeTag, pos);
        }
        return parsedDate;
    }

    public int compareTagDate(OiiiStageCompInvEntry other, int whichTag) {
        Date otherDate;
        String mytag = null;
        String othertag = null;
        int compVal = 0;
        switch (whichTag) {
            case 1: {
                mytag = this.m_saveTimeTag;
                othertag = other.getSaveTimeTag();
                break;
            }
            case 2: {
                mytag = this.m_stageTimeTag;
                othertag = other.getStageTimeTag();
                break;
            }
        }
        Date myDate = mytag != null ? OiiiStageCompInvEntry.parseTimeTagDate(mytag) : null;
        Date date = otherDate = othertag != null ? OiiiStageCompInvEntry.parseTimeTagDate(othertag) : null;
        compVal = myDate != null ? (otherDate != null ? (int)(myDate.getTime() - otherDate.getTime()) : 1) : (otherDate != null ? -1 : 0);
        return compVal;
    }

    @Override
    public void releaseDeps() {
        super.releaseDeps();
        this.m_fileSizeInfo = null;
        this.releaseSize();
    }

    @Override
    public void optimizePlatList() {
        Vector vDeps = this.getDependees();
        vDeps.removeAllElements();
        super.setDependees(vDeps);
        Vector vRefs = this.getReferencers();
        vRefs.removeAllElements();
        super.setReferencers(vRefs);
        super.optimizePlatList();
        if (this.m_fileSizeInfo != null) {
            this.m_fileSizeInfo.optimizePlatList();
        }
    }

    public void optimize() {
        this.optimizePlatList();
        this.optimizeSizeVector();
        this.optimizeInstVersion();
        this.optimizeStageArchiveInfo();
    }

    @Override
    public void optimizeLangList() {
        super.optimizeLangList();
        if (this.m_fileSizeInfo != null) {
            this.m_fileSizeInfo.optimizeLangList();
        }
    }

    @Override
    public void optimizeSizeVector() {
        super.optimizeSizeVector();
    }

    public void optimizeStageArchiveInfo() {
        this.m_stageArchive = null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_fileSizeInfo = null;
        this.m_patchSetContents = null;
        this.m_stageArchive = null;
        if (this.m_instVersions != null) {
            this.m_instVersions.removeAllElements();
        }
        this.m_instVersions = null;
        this.m_jarContentsLoc = null;
        this.m_groupFilesLoc = null;
    }

    public boolean isStageVersionPreX(String sVersion) {
        OiiiVersion v2 = new OiiiVersion(sVersion);
        OiiiVersion oStageVersion = this.getStageVersion();
        if (oStageVersion != null) {
            return v2.laterThan(oStageVersion);
        }
        return OiiiVersion.isInstVersionPreX(v2, this.getInstVersionsArray());
    }

    public boolean isStageVersionPostX(String sVersion) {
        OiiiVersion v2 = new OiiiVersion(sVersion);
        OiiiVersion oStageVersion = this.getStageVersion();
        if (oStageVersion != null) {
            return oStageVersion.laterThan(v2);
        }
        return OiiiVersion.isInstVersionPostX(v2, this.getInstVersionsArray());
    }

    public boolean isMinInstVersionPreX(String sVersion) {
        OiiiVersion v2 = new OiiiVersion(sVersion);
        boolean bStageVersionPreX = true;
        OiiiVersion oStageVersion = this.getStageVersion();
        if (oStageVersion != null) {
            bStageVersionPreX = v2.laterThan(oStageVersion);
        }
        if (bStageVersionPreX) {
            return OiiiVersion.isInstVersionPreX(v2, this.getInstVersionsArray());
        }
        return false;
    }

    public boolean isMinInstVersionPostX(String sVersion) {
        OiiiVersion v2 = new OiiiVersion(sVersion);
        boolean bStageVersionPostX = true;
        OiiiVersion oStageVersion = this.getStageVersion();
        if (oStageVersion != null) {
            bStageVersionPostX = oStageVersion.laterThan(v2);
        }
        if (bStageVersionPostX) {
            return OiiiVersion.isInstVersionPostX(v2, this.getInstVersionsArray());
        }
        return false;
    }

    @Override
    public Object clone() {
        OiiiStageCompInvEntry oClone = (OiiiStageCompInvEntry)super.clone();
        if (this.m_fileSizeInfo != null) {
            OiisFileSizeInfo oFileSizeInfo = (OiisFileSizeInfo)this.m_fileSizeInfo.clone();
            oClone.setFileSizeInfo(oFileSizeInfo);
        }
        return oClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompResourceBundle(Locale loc, String stgLoc) {
        ResourceBundle rb = null;
        String sSourceRoot = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(stgLoc));
        OiisCompProperties oCompProps = this.getCompProperties();
        OiisCompJarInfo oCompJarInfo = oCompProps.getCompJarInfo();
        String resourceClassName = oCompJarInfo.getResourcesClass();
        String resourceBundleClassName = oCompJarInfo.getResourceBundleClass();
        OiixJarClassLoader oJarClassLoader = null;
        String compLoc = this.getInstallDefnLoc();
        try {
            compLoc = OiixPathOps.concatPath(sSourceRoot, compLoc);
            String sJarName = this.getJarName();
            compLoc = OiixPathOps.concatPath(compLoc, sJarName);
            try {
                compLoc = OiixPathOps.getCanonicalPath(compLoc);
            }
            catch (IOException ioe) {
                compLoc = OiixPathOps.getStandardForm(compLoc);
            }
            oJarClassLoader = OiixJarClassLoader.createLoader(compLoc, false, true);
            rb = OiixJarResourceBundle.extractLanguageBundle(oJarClassLoader, resourceBundleClassName, loc, resourceClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        finally {
            if (oJarClassLoader != null) {
                OiixJarClassLoader.forgetLoader(compLoc);
            }
        }
        this.setResourceBundle(rb);
    }
}

