/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiSourceStageProvider;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInvLoader;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStageXMLReader;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiit.OiitDefaultConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiit.OiitTargetLocker;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceVariants;

public class OiiiSourceAccess
implements OiiiSourceStageProvider {
    private static final boolean s_debug = false;
    private OiiiStageInventory m_stageInv;
    private String m_tempLoc;
    private String m_sourceRoot;
    private OiiofFileLoader m_fileLoader;
    private Hashtable m_dataFileLoaders;
    private OiiiStageInvLoader m_stgLoader;
    private String m_stgLoc;
    private String m_sourceInvLoc;
    private OiixProgressListener m_progressListener;
    private OiitLockHeartbeat m_lockHb;
    private boolean m_bHomeStageMode;
    private Hashtable m_installJarCache;
    public static final boolean S_KEEP_INSTALL_JAR_OPEN = true;
    public static final boolean S_DONOT_KEEP_INSTALL_JAR_OPEN = false;
    private boolean m_bKeepInstallJarOpen = false;
    private static final String LOCKS_DIR_NAME = "locks";
    private Hashtable m_hDiskSources;
    private static final String s_sDefaultExtn = ".txt";
    private static final String s_sConnector = "_";
    private boolean m_bSecure = false;
    private static boolean debug = Boolean.getBoolean("oracle.installer.debug");
    private static boolean inPlaceCloningMode = false;

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, null);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, OiixProgressListener l) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, null, false);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, boolean bRetainPerm) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, bRetainPerm, null, false);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, OiixProgressListener l, boolean bKeepJarsOpen) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, true, l, bKeepJarsOpen);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, boolean bRetainPerm, OiixProgressListener l, boolean bKeepJarsOpen) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, true, l, bKeepJarsOpen, true);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, boolean bRetainPerm, OiixProgressListener l, boolean bKeepJarsOpen, boolean bLockSource) throws IOException, OiitTargetLockNotAvailableException {
        this(sourceInvLoc, tempLoc, bRetainPerm, l, bKeepJarsOpen, bLockSource, false);
    }

    public OiiiSourceAccess(String sourceInvLoc, String tempLoc, boolean bRetainPerm, OiixProgressListener l, boolean bKeepJarsOpen, boolean bLockSource, boolean bSecure) throws IOException, OiitTargetLockNotAvailableException {
        String targetLocksDir;
        this.m_sourceRoot = OiixPathOps.getParentDir(sourceInvLoc);
        this.m_sourceInvLoc = sourceInvLoc;
        this.m_progressListener = l;
        this.m_bKeepInstallJarOpen = bKeepJarsOpen;
        this.m_bSecure = bSecure;
        String targetLocksRoot = targetLocksDir = OiixPathOps.concatPath(this.m_sourceRoot, LOCKS_DIR_NAME);
        File fTargetLocks = new File(targetLocksDir);
        if (!fTargetLocks.exists()) {
            targetLocksRoot = this.m_sourceRoot;
        }
        if (bLockSource && OiiofFileLoaderFactory.isWriteableSource(targetLocksRoot)) {
            OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
            OiitTargetLocker tl = new OiitTargetLocker(this.m_sourceRoot, cl);
            this.m_lockHb = tl.getReaderLock();
        }
        this.m_fileLoader = OiiofFileLoaderFactory.createFileLoader(this.m_sourceRoot, tempLoc, bRetainPerm);
        this.m_stageInv = null;
        this.m_tempLoc = tempLoc;
        this.m_dataFileLoaders = new Hashtable(10);
        this.m_dataFileLoaders.put(new Integer(1), this.m_fileLoader);
        this.m_installJarCache = new Hashtable(5);
        this.m_hDiskSources = new Hashtable(3);
        inPlaceCloningMode = System.getProperty("oracle.installer.cleanUpOnExit", "true").equalsIgnoreCase("false") & new File(this.m_tempLoc).getParentFile().compareTo(new File(this.m_sourceInvLoc).getParentFile().getParentFile()) == 0;
    }

    public void setHomeStageMode(boolean bHomeStageMode) {
        this.m_bHomeStageMode = bHomeStageMode;
    }

    boolean isHomeStageMode() {
        return this.m_bHomeStageMode;
    }

    public static boolean stgAreaExists(String path) {
        if (!(path = OiixPathOps.getStandardForm(path)).endsWith("products.xml")) {
            path = OiixPathOps.concatPath(path, "products.xml");
        }
        return OiiofFileLoaderFactory.pathExists(path);
    }

    public static String getCanonicalForm(String path) {
        String testStr = path.trim();
        String retStr = null;
        try {
            File f = new File(testStr);
            if (f.exists()) {
                retStr = OiixPathOps.getFileCanonicalPath(testStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retStr == null && testStr.startsWith("http:")) {
            retStr = testStr;
        }
        if (retStr == null) {
            retStr = testStr;
        }
        return retStr;
    }

    public static String getAbsoluteForm(String path) {
        String testStr = path.trim();
        String retStr = null;
        try {
            File f = new File(testStr);
            if (f.exists()) {
                retStr = OiixPathOps.getUnexpandedCanonicalPath(testStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retStr == null && testStr.startsWith("http:")) {
            retStr = testStr;
        }
        if (retStr == null) {
            retStr = testStr;
        }
        return retStr;
    }

    protected void finalize() {
    }

    public void disposeStageInventory() {
        if (this.m_stgLoader != null) {
            this.m_stgLoader.dispose();
            this.m_stgLoader = null;
        }
        this.m_stageInv = null;
    }

    public void dispose() {
        if (this.m_fileLoader != null) {
            this.m_fileLoader.dispose();
            this.m_fileLoader = null;
        }
        if (this.m_dataFileLoaders != null) {
            Enumeration loaders = this.m_dataFileLoaders.elements();
            while (loaders.hasMoreElements()) {
                OiiofFileLoader fileLoader = (OiiofFileLoader)loaders.nextElement();
                fileLoader.dispose();
            }
            this.m_dataFileLoaders.clear();
            this.m_dataFileLoaders = null;
        }
        if (this.m_lockHb != null) {
            this.m_lockHb.releaseLock();
            this.m_lockHb = null;
        }
        if (this.m_installJarCache != null) {
            Enumeration oCompJarLoaders = this.m_installJarCache.elements();
            while (oCompJarLoaders.hasMoreElements()) {
                OiisCompJarLoader oCompJarLoader = (OiisCompJarLoader)oCompJarLoaders.nextElement();
                if (oCompJarLoader == null) continue;
                OiixJarClassLoader.forgetLoader(oCompJarLoader.getJarLoc());
            }
            this.m_installJarCache.clear();
            this.m_installJarCache = null;
            if (!Boolean.getBoolean("oracle.installer.silent")) {
                OiixHelp.dispose();
            }
        }
        this.disposeStageInventory();
    }

    public String getSourceRoot() {
        return OiiiSourceAccess.getCanonicalForm(this.m_sourceRoot);
    }

    public String getAbsoluteSourceRoot() {
        return OiiiSourceAccess.getAbsoluteForm(this.m_sourceRoot);
    }

    public void createFileLoader(String sourceRoot, int nDisk) throws IOException {
        if (this.m_dataFileLoaders.get(new Integer(nDisk)) == null) {
            OiiofFileLoader fileLoader = OiiofFileLoaderFactory.createFileLoader(sourceRoot, this.m_tempLoc);
            Integer iDisk = new Integer(nDisk);
            this.m_dataFileLoaders.put(iDisk, fileLoader);
            this.m_hDiskSources.put(iDisk, sourceRoot);
        }
    }

    public String getDiskSourceRoot(int nDisk) {
        String sSourceRoot = (String)this.m_hDiskSources.get(new Integer(nDisk));
        if (sSourceRoot == null) {
            return this.m_sourceRoot;
        }
        return sSourceRoot;
    }

    public String getLocalCopyToDest(String jarName, String localLoc) throws IOException, OiifbCancelException {
        String retLoc = this.m_fileLoader.getLocalCopyToDest(jarName, localLoc);
        if (this.m_bSecure && OiixInstallUtil.isUnix()) {
            try {
                OiipuUnixOps.changePermission(retLoc, 504);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
        return retLoc;
    }

    private OiiiStageInventory loadStageInventory(String invPath, OiixProgressListener l) throws IOException {
        try {
            String jarName = OiixPathOps.getFileName(invPath);
            String localLoc = null;
            if (this.m_tempLoc != null) {
                localLoc = OiixPathOps.concatPath(this.m_tempLoc, jarName);
                if (!inPlaceCloningMode) {
                    File fLocal = new File(localLoc);
                    fLocal.delete();
                }
            }
            String localInv = this.getLocalCopyToDest(jarName, localLoc);
            String sSHPropTmpLoc = null;
            if (OiiiStageInventory.isXMLStage(invPath) && this.m_tempLoc != null) {
                String localfile;
                File fVar;
                File[] xmlfiles;
                String filePath;
                String parDir;
                block21: {
                    parDir = OiixPathOps.getParentDir(invPath);
                    filePath = OiiiStageXMLReader.getReleaseNotesFileName(parDir);
                    this.fetchStageFile(filePath);
                    parDir = OiixPathOps.getParentDir(invPath);
                    filePath = OiiiStageXMLReader.getTopLevelUserActionsPropsName(parDir);
                    if (debug) {
                        OiiolTextLogger.appendText("copying Top Level Properties to :" + filePath);
                    }
                    this.fetchStageFile(filePath);
                    String fileName = OiixPathOps.getFileName(filePath);
                    String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
                    File fFileIntemp = new File(localFile);
                    if (fFileIntemp.exists()) {
                        Properties properties = new Properties();
                        try {
                            properties.load(new FileInputStream(fFileIntemp));
                            OiiolTextLogger.appendText("Loading Properties From File" + fFileIntemp);
                            Enumeration<?> e = properties.propertyNames();
                            while (e.hasMoreElements()) {
                                String ret = (String)e.nextElement();
                                String uaprops_loc = properties.getProperty(ret).trim();
                                ret = this.fetchUserActions(parDir, uaprops_loc);
                                String s_MakeDepsLoc = this.readMakeDepsLoc(ret);
                                File f = new File(uaprops_loc);
                                if (s_MakeDepsLoc == null) continue;
                                StringTokenizer parser = new StringTokenizer(s_MakeDepsLoc, ",");
                                while (parser.hasMoreTokens()) {
                                    String xmlLoc = parser.nextToken().trim();
                                    if (debug) {
                                        OiiolTextLogger.appendText("copying Make Dependencies File From :" + xmlLoc);
                                    }
                                    ret = this.fetchUserActions(parDir, OiixPathOps.concatPath(f.getParent(), xmlLoc));
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!debug) break block21;
                            OiiolTextLogger.appendException(e);
                        }
                    }
                }
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiiiStageXMLReader.getConfigFileName(parDir);
                this.fetchStageFile(filePath);
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiiiStageXMLReader.getLibsFileName(parDir);
                this.fetchStageFile(filePath);
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiiiStageXMLReader.getOUIConfigVarFileName(parDir);
                this.fetchStageFile(filePath);
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiiiStageXMLReader.getInvDetailsFileName(parDir);
                this.fetchStageFile(filePath);
                parDir = OiixPathOps.getParentDir(invPath);
                String sSHPropLoc = OiiiStageXMLReader.getSHPropsFileName(parDir);
                sSHPropTmpLoc = this.fetchShiphomePropXML(sSHPropLoc);
                parDir = OiixPathOps.getParentDir(invPath);
                parDir = OiixPathOps.concatPath(parDir, "buglist");
                File bugDir = new File(parDir);
                if (bugDir.exists() && (xmlfiles = bugDir.listFiles()) != null) {
                    for (int i = 0; i < xmlfiles.length; ++i) {
                        filePath = xmlfiles[i].getPath();
                        this.fetchBugListXML(filePath);
                    }
                }
                if ((fVar = new File(localfile = this.fetchUserActions(parDir = OiixPathOps.getParentDir(invPath), filePath = OiixPathOps.concatPath("globalvariables", "variable.properties")))).exists()) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(localfile));
                    String sVarFiles = props.getProperty("variables_xmls");
                    String[] saVarFile = OiixFunctionOps.explodeString(sVarFiles, ",");
                    for (int i = 0; i < saVarFile.length; ++i) {
                        filePath = OiixPathOps.concatPath("globalvariables", saVarFile[i].trim());
                        OiiolTextLogger.appendText("Going to copy file " + filePath, OiiolTextLogger.LOG_DETAILED);
                        this.fetchUserActions(parDir, filePath);
                    }
                }
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiixPathOps.concatPath(parDir, "instantiate.xml");
                this.fetchStageFile(filePath);
                parDir = OiixPathOps.getParentDir(invPath);
                filePath = OiixPathOps.concatPath(parDir, "desktopactions.xml");
                this.fetchStageFile(filePath);
            }
            this.m_stgLoc = localInv;
            if (this.m_stgLoader == null) {
                this.m_stgLoader = new OiiiStageInvLoader(this.m_stgLoc, l, this);
            }
            OiiiStageInventory stageInv = this.m_stgLoader.getStageInventory();
            stageInv.setSHPropLoc(sSHPropTmpLoc);
            if (OiiiStageInventory.isXMLStage(invPath) && this.m_tempLoc != null) {
                this.fetchConfigAggregates(invPath, stageInv);
            }
            return stageInv;
        }
        catch (Exception e) {
            IOException ioe;
            if (e instanceof SSLHandshakeException) {
                throw new SSLHandshakeException(e.getMessage());
            }
            if (!(e instanceof IOException)) {
                ioe = new IOException(e.getMessage());
            } else {
                Object[] sArgs = new String[]{invPath};
                File f = new File(invPath);
                String sMsgID = !f.exists() ? "S_ERROR_JARFILE_NOT_FOUND" : (f.isDirectory() ? "S_ERROR_JARFILE_DIRECTORY" : "S_ERROR_JARFILE_CORRUPT");
                ioe = new IOException(OiixResourceBundle.getString(sMsgID, sArgs));
            }
            throw ioe;
        }
    }

    private void fetchConfigAggregates(String invPath, OiiiStageInventory oStageInv) throws IOException, OiifbCancelException {
        Vector vTopLevelComps = oStageInv.getTopLevelComps();
        String sParDir = OiixPathOps.getParentDir(invPath);
        String sTopAggXML = "";
        for (int iCompCnt = 0; iCompCnt < vTopLevelComps.size(); ++iCompCnt) {
            OiiiCompInstallID oCompID = (OiiiCompInstallID)vTopLevelComps.elementAt(iCompCnt);
            String sCompVersion = oCompID.getVersion().getVerString();
            sCompVersion = sCompVersion.replace('.', '_');
            sTopAggXML = oCompID.getName().concat(".").concat(sCompVersion).concat(".xml");
            sTopAggXML = OiixPathOps.concatPath(sParDir, sTopAggXML);
            this.fetchStageFile(sTopAggXML);
        }
    }

    private String readMakeDepsLoc(String sFilePath) {
        Properties properties = new Properties();
        String ret = null;
        try {
            properties.load(new FileInputStream(sFilePath));
            OiiolTextLogger.appendText("Loading Properties From File :" + sFilePath);
            ret = properties.getProperty("MakeActionsXML");
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        return ret;
    }

    private String fetchUserActions(String InvLoc, String sFilePath) throws IOException, OiifbCancelException {
        String localFile;
        block10: {
            localFile = null;
            try {
                boolean bHttpStage;
                String completePath = OiixPathOps.concatPath(InvLoc, sFilePath);
                completePath = completePath.trim();
                localFile = OiixPathOps.concatPath(this.m_tempLoc, sFilePath);
                localFile = localFile.trim();
                File fFileIntemp = new File(localFile);
                if (fFileIntemp.exists()) {
                    fFileIntemp.delete();
                }
                if (bHttpStage = this.isHttpStage()) {
                    try {
                        this.getLocalCopyToDest(sFilePath, localFile);
                        OiiolTextLogger.appendText("User Action File copied to:" + localFile);
                    }
                    catch (IOException ioe) {
                        OiiolTextLogger.appendText("Source file not copied :" + completePath);
                        if (debug) {
                            OiiolTextLogger.appendText(ioe.getMessage());
                        }
                        break block10;
                    }
                    catch (OiifbCancelException ex) {
                        OiiolTextLogger.appendText("Source file not copied :" + completePath);
                        if (debug) {
                            OiiolTextLogger.appendText(ex.getMessage());
                        }
                        break block10;
                    }
                }
                File srcFile = new File(completePath);
                if (srcFile.exists()) {
                    this.m_fileLoader.getLocalCopyToDest(sFilePath, localFile);
                    OiiolTextLogger.appendText("User Action File copied to:" + localFile);
                }
            }
            catch (Exception ex) {
                OiiolTextLogger.appendException(ex);
            }
        }
        return localFile;
    }

    private String fetchFileFromStage(String sFilePath) throws IOException, OiifbCancelException {
        block8: {
            String fileName = OiixPathOps.getFileName(sFilePath);
            String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
            String fullPath = OiixPathOps.concatPath(this.getSourceRoot(), sFilePath);
            File fFileIntemp = new File(localFile);
            if (fFileIntemp.exists()) {
                fFileIntemp.delete();
            }
            OiiolTextLogger.appendText("trying to fetch file : " + sFilePath, OiiolTextLogger.LOG_DETAILED);
            boolean bHttpStage = this.isHttpStage();
            if (bHttpStage) {
                try {
                    return this.getLocalCopyToDest(sFilePath, localFile);
                }
                catch (IOException ioe) {
                    OiiolTextLogger.appendText("Source file not copied :" + fileName);
                    if (debug) {
                        OiiolTextLogger.appendText(ioe.getMessage());
                    }
                    break block8;
                }
                catch (OiifbCancelException ex) {
                    OiiolTextLogger.appendText("Source file not copied :" + fileName);
                    if (debug) {
                        OiiolTextLogger.appendText(ex.getMessage());
                    }
                    break block8;
                }
            }
            File srcFile = new File(fullPath);
            if (srcFile.exists()) {
                return this.getLocalCopyToDest(sFilePath, localFile);
            }
        }
        return "";
    }

    private void fetchStageFile(String sFilePath) throws IOException, OiifbCancelException {
        block9: {
            boolean bHttpStage;
            String fileName = OiixPathOps.getFileName(sFilePath);
            String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
            File fFileIntemp = new File(localFile);
            if (fFileIntemp.exists()) {
                if (inPlaceCloningMode) {
                    return;
                }
                fFileIntemp.delete();
            }
            if (bHttpStage = this.isHttpStage()) {
                try {
                    OiiolTextLogger.appendText("fetching stage file " + sFilePath, OiiolTextLogger.LOG_DETAILED);
                    this.getLocalCopyToDest(fileName, localFile);
                }
                catch (IOException ioe) {
                    OiiolTextLogger.appendText("Source file not copied :" + fileName);
                    if (debug) {
                        OiiolTextLogger.appendText(ioe.getMessage());
                    }
                    break block9;
                }
                catch (OiifbCancelException ex) {
                    OiiolTextLogger.appendText("Source file not copied :" + fileName);
                    if (debug) {
                        OiiolTextLogger.appendText(ex.getMessage());
                    }
                    break block9;
                }
            }
            File srcFile = new File(sFilePath);
            if (srcFile.exists()) {
                this.getLocalCopyToDest(fileName, localFile);
            }
        }
    }

    public String fetchFastCopyXML() {
        String localLoc;
        block4: {
            localLoc = null;
            try {
                if (this.m_tempLoc != null) {
                    localLoc = OiixPathOps.concatPath(this.m_tempLoc, "fastcopy.xml");
                    if (!inPlaceCloningMode) {
                        File fLocal = new File(localLoc);
                        fLocal.delete();
                    }
                }
                localLoc = this.getLocalCopyToDest("fastcopy.xml", localLoc);
            }
            catch (Exception ex) {
                if (!debug) break block4;
                ex.printStackTrace();
            }
        }
        return localLoc;
    }

    public String fetchShiphomePropXML(String sFilePath) {
        String localLoc = null;
        try {
            String fileName = OiixPathOps.getFileName(sFilePath);
            String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
            File fFileIntemp = new File(localFile);
            if (fFileIntemp.exists()) {
                fFileIntemp.delete();
            }
            this.fetchStageFile(sFilePath);
            localLoc = localFile;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localLoc;
    }

    public String fetchBugListXML(String sFilePath) {
        String localLoc = null;
        try {
            File srcFile;
            String fileName = OiixPathOps.getFileName(sFilePath);
            fileName = OiixPathOps.concatPath("buglist", fileName);
            String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
            File fFileIntemp = new File(localFile);
            if (fFileIntemp.exists()) {
                fFileIntemp.delete();
            }
            if ((srcFile = new File(sFilePath)).exists()) {
                localLoc = this.m_fileLoader.getLocalCopyToDest(fileName, localFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localLoc;
    }

    public void fetchSHInfoProps() {
        try {
            String filePath = OiiiStageXMLReader.getShipHomeInfoPropertiesFileName(this.getSourceRoot());
            OiiolTextLogger.appendText("fetch the file: " + filePath);
            this.fetchStageFile(filePath);
            String fileName = OiixPathOps.getFileName(filePath);
            String localFile = OiixPathOps.concatPath(this.m_tempLoc, fileName);
            OiiolTextLogger.appendText("fetching the pre copy and post copy script files if they exist");
            this.fetchPreCopyScript(localFile);
            this.fetchPostCopyScript(localFile);
            OiiolTextLogger.appendText("Done fetching the ship home info properties");
        }
        catch (Exception err) {
            err.printStackTrace(System.out);
            OiiolTextLogger.appendText(err.getMessage());
        }
    }

    private void fetchPreCopyScript(String pathToPropsFile) {
        if (Boolean.getBoolean("oracle.installer.suppressPreCopyScript")) {
            return;
        }
        OiiolTextLogger.appendText("Is the file " + pathToPropsFile + " exists?", OiiolTextLogger.LOG_DETAILED);
        if (!new File(pathToPropsFile).exists()) {
            OiiolTextLogger.appendText("the " + pathToPropsFile + " doesnt exists");
            System.setProperty("preCopyScript.install.loc", "");
            return;
        }
        try {
            String sShellPath;
            String sInstantiate;
            Properties props = new Properties();
            FileInputStream fos = new FileInputStream(pathToPropsFile);
            props.load(fos);
            String sPreCopyScriptName = props.getProperty("preCopyScript.install.loc");
            if (null == sPreCopyScriptName) {
                return;
            }
            String sRunAsRoot = props.getProperty("preCopyScript.install.runAsRoot");
            if (sRunAsRoot != null) {
                System.setProperty("preCopyScript.install.runAsRoot", sRunAsRoot);
            }
            if ((sInstantiate = props.getProperty("preCopyScript.install.instantiate")) != null) {
                System.setProperty("preCopyScript.install.instantiate", sInstantiate);
            }
            if ((sShellPath = props.getProperty("preCopyScript.install.shellPath")) != null) {
                System.setProperty("preCopyScript.install.shellPath", sShellPath);
            }
            String filePath = OiixPathOps.concatPath(this.getSourceRoot(), sPreCopyScriptName);
            OiiolTextLogger.appendText("fetching file: " + filePath);
            String localfile = OiixPathOps.concatPath(this.m_tempLoc, OiixPathOps.getFileName(sPreCopyScriptName));
            OiiolTextLogger.appendText("fetching file: " + sPreCopyScriptName + " to " + localfile, OiiolTextLogger.LOG_DETAILED);
            this.getLocalCopyToDest(sPreCopyScriptName, localfile);
            System.setProperty("preCopyScript.install.loc", localfile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
    }

    private void fetchPostCopyScript(String pathToPropsFile) {
        if (Boolean.getBoolean("oracle.installer.suppressPostCopyScript")) {
            OiiolTextLogger.appendText("suppress Post copy script set to true ");
            return;
        }
        OiiolTextLogger.appendText("Is the file " + pathToPropsFile + " exists?", OiiolTextLogger.LOG_DETAILED);
        if (!new File(pathToPropsFile).exists()) {
            OiiolTextLogger.appendText("the " + pathToPropsFile + " doesnt exists");
            System.setProperty("postCopyScript.install.loc", "");
            return;
        }
        try {
            String sShellPath;
            String sInstantiate;
            Properties props = new Properties();
            FileInputStream fos = new FileInputStream(pathToPropsFile);
            props.load(fos);
            String sPostCopyScriptName = props.getProperty("postCopyScript.install.loc");
            if (null == sPostCopyScriptName) {
                return;
            }
            String sRunAsRoot = props.getProperty("postCopyScript.install.runAsRoot");
            if (sRunAsRoot != null) {
                System.setProperty("postCopyScript.install.runAsRoot", sRunAsRoot);
            }
            if ((sInstantiate = props.getProperty("postCopyScript.install.instantiate")) != null) {
                System.setProperty("postCopyScript.install.instantiate", sInstantiate);
            }
            if ((sShellPath = props.getProperty("postCopyScript.install.shellPath")) != null) {
                System.setProperty("postCopyScript.install.shellPath", sShellPath);
            }
            String localfile = OiixPathOps.concatPath(this.m_tempLoc, OiixPathOps.getFileName(sPostCopyScriptName));
            OiiolTextLogger.appendText("fetching file: " + sPostCopyScriptName + " to " + localfile, OiiolTextLogger.LOG_DETAILED);
            this.getLocalCopyToDest(sPostCopyScriptName, localfile);
            System.setProperty("postCopyScript.install.loc", localfile);
            OiiolTextLogger.appendText("postCopyScript.install.loc is set to " + localfile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
    }

    public String fetchShiphomeProperties(String sPathVar, String sPathVal) {
        block10: {
            try {
                String localFile;
                block11: {
                    boolean bHttpStage;
                    File fFileIntemp;
                    sPathVal = sPathVal.trim();
                    String invPath = this.getSourceRoot();
                    String filePath = OiixPathOps.concatPath(invPath, sPathVal);
                    int index = sPathVar.indexOf("_properties");
                    if (index == -1) break block10;
                    localFile = sPathVar.substring(0, index);
                    localFile = localFile + ".properties";
                    localFile = OiixPathOps.concatPath(this.m_tempLoc, localFile);
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("copy " + filePath + " to " + localFile, OiiolTextLogger.LOG_DETAILED);
                    }
                    if ((fFileIntemp = new File(localFile)).exists()) {
                        fFileIntemp.delete();
                    }
                    if (bHttpStage = this.isHttpStage()) {
                        OiiolTextLogger.appendText("shiphome properties file " + sPathVal, OiiolTextLogger.LOG_DETAILED);
                        try {
                            this.getLocalCopyToDest(sPathVal, localFile);
                        }
                        catch (IOException ioe) {
                            OiiolTextLogger.appendText("Source file not copied :" + filePath);
                            if (debug) {
                                OiiolTextLogger.appendText(ioe.getMessage());
                            }
                            break block11;
                        }
                        catch (OiifbCancelException ex) {
                            OiiolTextLogger.appendText("Source file not copied :" + filePath);
                            if (debug) {
                                OiiolTextLogger.appendText(ex.getMessage());
                            }
                            break block11;
                        }
                    }
                    OiiolTextLogger.appendText("non http file copy " + filePath + " to " + localFile, OiiolTextLogger.LOG_DETAILED);
                    OiixFileOps.copyFile(filePath, localFile, true, true);
                }
                OiiolTextLogger.appendText("Going to copy both pre copy and post copy files " + localFile);
                this.fetchPreCopyScript(localFile);
                this.fetchPostCopyScript(localFile);
                return localFile;
            }
            catch (Exception err) {
                OiiolTextLogger.appendText(err.getMessage());
            }
        }
        return null;
    }

    public void fetchDeletionFile(String sFilePath) {
        block4: {
            String fullPath = OiixPathOps.concatPath(this.getSourceRoot(), sFilePath);
            try {
                this.fetchFileFromStage(sFilePath);
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendText("The file " + fullPath + " was not found");
                if (debug) {
                    OiiolTextLogger.appendText(ioe.getMessage());
                }
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendText("The file " + fullPath + " was not found");
                if (!debug) break block4;
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
    }

    public String fetchSummaryFile(String dir, String file, String extn) {
        try {
            File srcFile;
            if (file == null || file.length() == 0) {
                return null;
            }
            if (dir == null) {
                dir = "";
            }
            if (extn == null) {
                extn = s_sDefaultExtn;
            }
            dir = dir.trim();
            file = file.trim();
            extn = extn.trim();
            String destDir = OiixPathOps.concatPath(this.getSourceRoot(), dir);
            Locale locale = OiixLanguage.getDefaultLocale();
            String lang = locale.getLanguage();
            String country = locale.getCountry();
            String filename = file + s_sConnector + lang + s_sConnector + country + extn;
            if (lang.equals("")) {
                filename = file + extn;
            } else {
                srcFile = new File(OiixPathOps.concatPath(destDir, filename));
                if (!srcFile.exists() && !(srcFile = new File(OiixPathOps.concatPath(destDir, filename = file + s_sConnector + lang + extn))).exists()) {
                    filename = file + extn;
                }
            }
            srcFile = new File(OiixPathOps.concatPath(destDir, filename));
            if (srcFile.exists()) {
                String localFile = OiixPathOps.concatPath(this.m_tempLoc, filename);
                filename = OiixPathOps.concatPath(destDir, filename);
                OiiolTextLogger.appendText("copying " + filename + " to " + localFile);
                OiixFileOps.copyFile(filename, localFile, true, true);
                return localFile;
            }
        }
        catch (Exception err) {
            OiiolTextLogger.appendText(err.getMessage());
        }
        return null;
    }

    @Override
    public OiiiStageInventory getStageInventory() {
        OiiiStageInventory stageInv = null;
        try {
            stageInv = this.getStageInventory(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stageInv;
    }

    public OiiiStageInventory getStageInventory(boolean bThrow) throws IOException {
        OiiiStageInventory stageInv = null;
        try {
            stageInv = this.getStageInventoryImpl();
        }
        catch (IOException ioe) {
            if (bThrow) {
                throw ioe;
            }
            System.err.println(ioe.getMessage());
        }
        return stageInv;
    }

    public OiiiStageInventory getStageInventoryImpl() throws IOException {
        if (this.m_stageInv == null) {
            this.m_stageInv = this.loadStageInventory(this.m_sourceInvLoc, this.m_progressListener);
        }
        return this.m_stageInv;
    }

    public OiisCompJarLoader getCompJarLoader(OiiiStageCompInvEntry scie) throws IOException, OiifbCancelException {
        OiisCompJarLoader compJarLoader = null;
        if (!scie.isMinInstVersionPreX("2.0")) {
            compJarLoader = this.getLoaderFromCache(scie);
        } else {
            String compJarLoc = this.fetchCompInsJar(scie, null);
            String compResLoc = this.fetchCompResJar(scie, null);
            String compHelpLoc = this.fetchCompHelpJar(scie, null);
            compJarLoader = new OiisCompJarLoader(compJarLoc);
            compJarLoader.initResHelpLocs(compResLoc, compHelpLoc);
        }
        return compJarLoader;
    }

    private OiisCompJarLoader getLoaderFromCache(OiiiStageCompInvEntry scie) throws IOException, OiifbCancelException {
        OiisCompJarLoader compJarLoader = null;
        String compJarLoc = OiixPathOps.concatPath(scie.getInstallDefnLoc(), scie.getJarName());
        if (this.m_installJarCache.containsKey(compJarLoc)) {
            compJarLoader = (OiisCompJarLoader)this.m_installJarCache.get(compJarLoc);
        } else {
            String sLocalLoc = null;
            if (this.m_tempLoc != null) {
                sLocalLoc = OiixPathOps.concatPath(this.m_tempLoc, scie.getJarName());
                if (!inPlaceCloningMode) {
                    File fLocal = new File(sLocalLoc);
                    fLocal.delete();
                }
            }
            String compJarTempLoc = inPlaceCloningMode ? sLocalLoc : this.fetchCompInstallJar(scie, sLocalLoc);
            compJarLoader = new OiisCompJarLoader(compJarTempLoc, this.m_bKeepInstallJarOpen);
            compJarLoader.initResHelpLocs(compJarTempLoc, compJarTempLoc);
            this.m_installJarCache.put(compJarLoc, compJarLoader);
        }
        OiisCompJarInfo cji = scie.getCompProperties().getCompJarInfo();
        if (cji != null) {
            compJarLoader.setCompJarInfo(cji);
        }
        return compJarLoader;
    }

    private String fetchCompInstallJar(OiiiStageCompInvEntry scie, String localLoc) throws IOException, OiifbCancelException {
        String compJarLoc = OiixPathOps.concatPath(scie.getInstallDefnLoc(), scie.getJarName());
        if (System.getProperty("osp.properties.file") != null) {
            this.m_fileLoader.setRetainPermission(false);
        }
        return this.getLocalCopyToDest(compJarLoc, localLoc);
    }

    public String fetchCompInsJar(OiiiCompInstallID cid, String localLoc) throws IOException, OiifbCancelException {
        return this.fetchCompInsJar(cid, OiiiAreaInventory.getCurPlatVect(), localLoc);
    }

    public String fetchCompInsJar(OiiiCompInstallID cid, Vector plats, String localLoc) throws IOException, OiifbCancelException {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
        return this.fetchCompInsJar(scie, localLoc);
    }

    public String fetchCompInsJar(OiiiStageCompInvEntry scie, String localLoc) throws IOException, OiifbCancelException {
        String compLoc = scie.getLocation();
        String compJarLoc = OiixPathOps.concatPath(compLoc, "compIns.jar");
        return this.m_fileLoader.getLocalCopyToDest(compJarLoc, localLoc);
    }

    public void releaseCompInsJar(String localLoc) {
        this.m_fileLoader.releaseTempFile(localLoc);
    }

    public String fetchCompHelpJar(OiiiCompInstallID cid, String localLoc) throws IOException {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid);
        return this.fetchCompHelpJar(scie, localLoc);
    }

    public String fetchCompHelpJar(OiiiStageCompInvEntry scie, String localLoc) throws IOException {
        String helpLoc = null;
        String retLoc = null;
        String helpPath = OiixPathOps.concatPath(scie.getLocation(), "help");
        Enumeration vars = OiixResourceVariants.genResourceVariants();
        while (vars.hasMoreElements()) {
            helpLoc = "CompHelp" + (String)vars.nextElement() + ".jar";
            helpLoc = OiixPathOps.concatPath(helpPath, helpLoc);
            try {
                retLoc = this.m_fileLoader.getLocalCopyToDest(helpLoc, localLoc);
                if (!new File(retLoc).exists()) continue;
                return retLoc;
            }
            catch (Exception e) {
                retLoc = null;
            }
        }
        return retLoc;
    }

    public void releaseCompHelpJar(String localLoc) {
        this.m_fileLoader.releaseTempFile(localLoc);
    }

    public String fetchCompResJar(OiiiCompInstallID cid, String localLoc) throws IOException {
        return this.fetchCompResJar(cid, OiiiAreaInventory.getCurPlatVect(), localLoc);
    }

    public String fetchCompResJar(OiiiCompInstallID cid, Vector plats, String localLoc) throws IOException {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
        return this.fetchCompResJar(scie, localLoc);
    }

    public String fetchCompResJar(OiiiStageCompInvEntry scie, String localLoc) {
        String loc = null;
        String compResLoc = OiixPathOps.concatPath(scie.getLocation(), "resources");
        compResLoc = OiixPathOps.concatPath(compResLoc, "CompRes.jar");
        try {
            loc = this.m_fileLoader.getLocalCopyToDest(compResLoc, localLoc);
        }
        catch (Exception ioe) {
            loc = null;
        }
        return loc;
    }

    public void releaseCompResJar(String localLoc) {
        this.m_fileLoader.releaseTempFile(localLoc);
    }

    public String fetchCompFilesJar(OiiiCompInstallID cid, String groupJarName, String localLoc) throws IOException, OiifbCancelException {
        return this.fetchCompFilesJar(cid, OiiiAreaInventory.getCurPlatVect(), groupJarName, localLoc);
    }

    public String fetchCompFilesJar(OiiiCompInstallID cid, Vector plats, String groupJarName, String localLoc) throws IOException, OiifbCancelException {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
        int nDisk = scie.getDiskNumber();
        OiiofFileLoader fileLoader = (OiiofFileLoader)this.m_dataFileLoaders.get(new Integer(nDisk));
        if (fileLoader == null) {
            String sMsg = OiixResourceBundle.getString("S_LOADER_NOT_FOUND");
            throw new IOException(sMsg);
        }
        String groupsLoc = scie.getGroupFilesLoc();
        String groupJarLoc = OiixPathOps.concatPath(groupsLoc, groupJarName);
        return fileLoader.getLocalCopyToDest(groupJarLoc, localLoc);
    }

    public String fetchCompFileForExpandedGroup(OiiiCompInstallID cid, String groupRelLoc, String fileLocWithinGrp, String localLoc) throws IOException {
        return this.fetchCompFileForExpandedGroup(cid, OiiiAreaInventory.getCurPlatVect(), groupRelLoc, fileLocWithinGrp, localLoc);
    }

    public String fetchCompFileForExpandedGroup(OiiiCompInstallID cid, Vector plats, String groupRelLoc, String fileLocWithinGrp, String localLoc) throws IOException {
        String sLoc = "";
        try {
            sLoc = this.fetchCompFileForExpandedGroup(cid, plats, groupRelLoc, fileLocWithinGrp, localLoc, true);
        }
        catch (OiifbCancelException ie) {
            throw new IOException(ie.getMessage());
        }
        return sLoc;
    }

    public String fetchCompFileForExpandedGroup(OiiiCompInstallID cid, Vector plats, String groupRelLoc, String fileLocWithinGrp, String localLoc, boolean bThrow) throws IOException, OiifbCancelException {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
        int nDisk = scie.getDiskNumber();
        OiiofFileLoader fileLoader = (OiiofFileLoader)this.m_dataFileLoaders.get(new Integer(nDisk));
        if (fileLoader == null) {
            String sMsg = OiixResourceBundle.getString("S_LOADER_NOT_FOUND");
            throw new IOException(sMsg);
        }
        String groupsLoc = scie.getGroupFilesLoc();
        String groupAbsoLoc = OiixPathOps.concatPath(groupsLoc, "Expanded");
        groupAbsoLoc = OiixPathOps.concatPath(groupAbsoLoc, groupRelLoc);
        String fileAbsoLoc = OiixPathOps.concatPath(groupAbsoLoc, fileLocWithinGrp);
        return fileLoader.getLocalCopyToDest(fileAbsoLoc, localLoc);
    }

    public String fetchCompDllFileForExpandedGroup(OiiiCompInstallID cid, String groupRelLoc, String dllFileLocWithinGrp) throws IOException {
        String retFile = null;
        try {
            Vector plats = OiiiAreaInventory.getCurPlatVect();
            OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(cid, plats);
            int nDisk = scie.getDiskNumber();
            OiiofFileLoader fileLoader = (OiiofFileLoader)this.m_dataFileLoaders.get(new Integer(nDisk));
            if (fileLoader == null) {
                String sMsg = OiixResourceBundle.getString("S_LOADER_NOT_FOUND");
                throw new IOException(sMsg);
            }
            String groupsLoc = scie.getGroupFilesLoc();
            String groupAbsoLoc = OiixPathOps.concatPath(groupsLoc, "Expanded");
            groupAbsoLoc = OiixPathOps.concatPath(groupAbsoLoc, groupRelLoc);
            retFile = fileLoader.fetchDllFile(groupAbsoLoc, dllFileLocWithinGrp);
        }
        catch (OiifbCancelException oce) {
            throw new IOException(oce.getMessage());
        }
        return retFile;
    }

    public void releaseCompFilesJar(String localLoc) {
        this.m_fileLoader.releaseTempFile(localLoc);
    }

    public void releaseCompFilesJar(OiiiCompInstallID id, String localLoc) {
        OiiiStageCompInvEntry scie = this.getStageInventory().getStageCompInvEntry(id);
        int nDisk = scie.getDiskNumber();
        OiiofFileLoader fileLoader = (OiiofFileLoader)this.m_dataFileLoaders.get(new Integer(nDisk));
        if (fileLoader != null) {
            fileLoader.releaseTempFile(localLoc);
        }
    }

    public String fetchLibJar(OiiiLibraryID lid, String localLoc, int libType) throws IOException, OiifbCancelException {
        OiiiLibInvEntry lie = this.getStageInventory().getLibInvEntry(lid, libType);
        String libJarLoc = lie.getLocation();
        return this.m_fileLoader.getLocalCopyToDest(libJarLoc, localLoc);
    }

    public String fetchSourceFile(String remFile, String localLoc) throws IOException, OiifbCancelException {
        return this.m_fileLoader.getLocalCopyToDest(remFile, localLoc);
    }

    public String getLocalStgInvLoc() {
        if (this.m_stgLoc != null) {
            return this.m_stgLoc;
        }
        return "";
    }

    public void backupStageInventory() throws IOException {
    }

    public void restoreStageInventory() throws IOException {
        if (OiiiStageInventory.isXMLStage(this.m_stgLoc)) {
            String sFileLoc = OiixPathOps.getStandardForm(this.m_stgLoc);
            OiiiStageXMLReader reader = OiiiStageXMLReader.getReader();
            this.m_stageInv = reader.readInventory(sFileLoc, null, this.m_stgLoader);
            return;
        }
    }

    public boolean isHttpStage() {
        return this.m_sourceRoot.startsWith("http:") || this.m_sourceRoot.startsWith("https:");
    }
}

