/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiii.OiiiBugListValidate;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisStagedCompHelper;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiiiPatchSetValidate
implements OiicInstallTimeSession {
    private String m_sInvLoc = null;
    private OiiiSourceAccess m_oiSourceAccess;
    private OiiiStageInventory m_stageInv;
    private OiicStandardInventorySession m_oSession = null;
    private OiiiInstallInventory m_inv = null;
    private static String ORACLE_HOME = null;
    private static final String sDir = "OraInstall";
    private static Vector v_removes = new Vector();
    private Hashtable m_IDsToPSets;
    private static int ohIndex = -1;
    private String m_sourceRoot;

    public OiiiPatchSetValidate(String invLoc, String oHome, OiicStandardInventorySession invSession) throws OiifbEndIterateException, OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.m_sInvLoc = OiixPathOps.getStandardForm(invLoc);
        this.m_sourceRoot = OiixPathOps.getParentDir(this.m_sInvLoc);
        ORACLE_HOME = oHome;
        this.m_IDsToPSets = new Hashtable();
        this.m_oSession = invSession;
        if (this.m_oSession == null) {
            this.m_oSession = new OiicStandardInventorySession("installInv", "10.1.0.3.0");
            this.m_oSession.initSession(0);
        }
        this.m_inv = this.m_oSession.getInstallAreaControl().getInstallInventory();
    }

    public void dispose() {
        this.m_oiSourceAccess = null;
        this.m_oSession = null;
        this.m_IDsToPSets.clear();
    }

    public OiixProgressListener getProgressListener() {
        return null;
    }

    @Override
    public OiicSessionPlan getSessionPlan() {
        return null;
    }

    @Override
    public OiicSessionContext getSessionContext() {
        return null;
    }

    @Override
    public void setSessionPlan(OiicSessionPlan sessionPlan) {
    }

    @Override
    public boolean inRollbackMode() {
        return false;
    }

    @Override
    public OiisActionLibLoader getActionLibLoader(OiiiLibraryID lid, int homeIndex) throws OiifbCancelException, IOException {
        return null;
    }

    @Override
    public String getInstCompName(OiiiCompInstallID cid, int OHid) {
        return "";
    }

    @Override
    public String getStgCompName(OiiiCompInstallID cid) {
        return "";
    }

    @Override
    public OiisCompInstallation getCompInstall(OiiiCompInstallID cid) {
        return null;
    }

    @Override
    public OiisPatchSetInstallation getPSetInstall(OiiiPatchSetInstallID psid) {
        OiisPatchSetInstallation psi = null;
        if (!this.m_IDsToPSets.containsKey(psid)) {
            OiiiStageCompInvEntry scie = this.m_stageInv.getStageCompInvEntry(psid);
            if (scie != null) {
                try {
                    psi = this.m_oiSourceAccess == null ? OiisStagedCompHelper.createPatchSetInstall(scie, this.m_sourceRoot) : OiisStagedCompHelper.createPatchSetInstall(scie, this.m_oiSourceAccess);
                    this.m_IDsToPSets.put(psid, psi);
                }
                catch (Exception exp) {
                    System.err.println(exp.getMessage());
                    psi = null;
                }
            }
        } else {
            psi = (OiisPatchSetInstallation)this.m_IDsToPSets.get(psid);
        }
        return psi;
    }

    @Override
    public boolean isInstallMode() {
        return false;
    }

    @Override
    public boolean isDeinstallMode() {
        return false;
    }

    @Override
    public boolean isCloneMode() {
        return false;
    }

    @Override
    public boolean isAddNodeMode() {
        return false;
    }

    @Override
    public int getOHIndex() {
        return ohIndex;
    }

    public void setOHIndex(int idx) {
        ohIndex = idx;
    }

    @Override
    public int getAppltopIndex() {
        return 0;
    }

    @Override
    public OiifmMainFrame getMainFrame() {
        return null;
    }

    @Override
    public OiifwWizDialog getWizardDialog() {
        return null;
    }

    public boolean validatePatchSetBugList() {
        boolean retVal = false;
        try {
            OiipgBootstrap.initScratchLoc(sDir);
            String sInvLoc = OiixPathOps.getStandardForm(this.m_sInvLoc);
            String tempLoc = System.getProperty("oracle.installer.scratchPath");
            this.m_oiSourceAccess = new OiiiSourceAccess(sInvLoc, tempLoc, null, true);
            this.m_stageInv = this.m_oiSourceAccess.getStageInventory();
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            while (vAllComps.hasMoreElements()) {
                OiiiCompInstallID id;
                OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
                if (!invEntry.isTopLevel() || (id = invEntry.getCompInstallID()).getCompType() != 4) continue;
                OiiiCompInstallID[] ids = new OiiiCompInstallID[]{id};
                OiiiOracleHomeInfo oh = this.m_inv.getHomeWithLocation(ORACLE_HOME);
                int idx = oh.getIndex();
                if (idx != -1) {
                    this.setOHIndex(idx);
                } else {
                    System.out.println("Oracle Home" + ORACLE_HOME + "not found in inventory");
                }
                OiiodDepEngine depEngine = new OiiodDepEngine(this, true);
                depEngine.setInventories(this.m_stageInv, this.m_inv);
                depEngine.setCurrentTLIDs(ids);
                depEngine.depBuild();
                depEngine.depModeApply(true);
                Vector ides = depEngine.calcCompsToInstall();
                Vector oneoffRems = depEngine.getOneoffIdOhsToDeinstall();
                Map oConflictingOneOffs = depEngine.getConflictingOneoffs();
                Enumeration remoneoffen = oneoffRems.elements();
                while (remoneoffen.hasMoreElements()) {
                    OiiiOneoffIdOhPair oIdOh = (OiiiOneoffIdOhPair)remoneoffen.nextElement();
                    v_removes.addElement(oIdOh);
                }
                boolean ignorePatchConflicts = System.getProperty("oracle.installer.ignorePatchConflicts", "false").equals("true");
                if (!ignorePatchConflicts && oConflictingOneOffs.size() > 0) {
                    Set oOneOffs = oConflictingOneOffs.keySet();
                    Iterator iter = oOneOffs.iterator();
                    String[] asConflictingOneOffs = new String[oOneOffs.size()];
                    while (iter.hasNext()) {
                        OiiiOneoffIdOhPair oIdOh = (OiiiOneoffIdOhPair)iter.next();
                        v_removes.addElement(oIdOh);
                    }
                }
                boolean isUpgrade = depEngine.isPatchSetUpgrade();
                boolean isReinstall = depEngine.isPatchSetReinstall();
                if (isUpgrade || isReinstall) {
                    OiiiBugListValidate.bStandAlone = true;
                    OiiiBugListValidate.setOneoffRemoves(v_removes);
                    retVal = OiiiBugListValidate.validate(depEngine, this.getOHIndex(), this.m_inv, new Boolean(true));
                    break;
                }
                System.out.println("The application of the patchset" + id.getName() + "will neither result in an upgrade or reinstall");
                System.out.println("No Patch Set Bug List Validation Checks will be performed");
                break;
            }
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return retVal;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java <class> <Source Location> <Oracle Home Location>");
            return;
        }
        try {
            OiiiPatchSetValidate obj = new OiiiPatchSetValidate(args[0], args[1], null);
            System.out.println("\nBegining Patch Set Bug List Validation Checks...");
            obj.validatePatchSetBugList();
            System.out.println("Patch Set Bug List Validation Checks Completed");
        }
        catch (OiitTargetLockNotAvailableException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

