/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;

public class OiiiPatchInstallID
extends OiiiCompInstallID
implements Serializable,
OiiiVersioned {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    static final long serialVersionUID = -6708373788711705403L;
    private static final int BASE_VER_POS = 0;
    private static final int COMP_VER_POS = 1;
    private static final int COMP_PLAT_POS = 2;
    private static final int TOTAL_FIELDS = 3;
    private OiiiVersion m_compVersion;
    private OiiiVersion m_baseVersion;
    private Vector m_compPlatforms;

    public OiiiPatchInstallID(OiiiCompInstallID cid, OiiiVersion version, Vector platforms, boolean bConvertToStdForm) {
        super(cid.getName(), version, platforms, cid.getReplaceVersion(), 2, cid.getOracleHomeType(), cid.getOracleHomeType() > 0, cid.getReleaseLevel(), bConvertToStdForm);
        this.m_baseVersion = cid.getVersion();
        if (cid.getCompType() == 2) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            this.m_compVersion = pid.getCompVersion();
            this.m_compPlatforms = pid.getCompPlatforms();
        } else {
            this.m_compVersion = cid.getVersion();
            this.m_compPlatforms = cid.getPlatforms();
        }
        if (bConvertToStdForm) {
            this.m_baseVersion = OiiiVersion.getStandardForm(this.m_baseVersion);
            this.m_compVersion = OiiiVersion.getStandardForm(this.m_compVersion);
        }
    }

    public OiiiPatchInstallID(OiiiCompInstallID cid, OiiiVersion version, Vector platforms) {
        this(cid, version, platforms, true);
    }

    public OiiiVersion getBaseVersion() {
        return this.m_baseVersion;
    }

    public void setBaseVersion(OiiiVersion baseVersion) {
        this.m_baseVersion = OiiiVersion.getStandardForm(baseVersion);
    }

    public OiiiVersion getCompVersion() {
        return this.m_compVersion;
    }

    public void setCompVersion(OiiiVersion compVersion) {
        this.m_compVersion = OiiiVersion.getStandardForm(compVersion);
    }

    public Vector getCompPlatforms() {
        return this.m_compPlatforms;
    }

    public void setCompPlatforms(Vector compPlatforms) {
        this.m_compPlatforms = compPlatforms;
    }

    public OiiiCompInstallID getCompInstallID() {
        return new OiiiCompInstallID(this.getName(), this.getCompVersion(), this.getCompPlatforms(), this.getReplaceVersion(), 1, this.getOracleHomeType(), this.getReleaseLevel());
    }

    @Override
    public boolean isCompatible(OiiiCompInstallID cid) {
        return this.isCompatible(cid, true);
    }

    @Override
    public boolean isCompatible(OiiiCompInstallID cid, boolean bIgnoreBuild) {
        boolean retVal = false;
        if (cid.getCompType() == 2) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            retVal = super.isCompatible(pid, bIgnoreBuild) && this.getCompVersion().equals(pid.getCompVersion());
        }
        return retVal;
    }

    public boolean isCompatible(OiiiCompInstallID cid, boolean bIgnoreBuild, boolean bCheckCompCompatibility) {
        boolean retVal = false;
        if (cid.getCompType() == 2) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            retVal = super.isCompatible(pid, bIgnoreBuild) && this.getCompVersion().equals(pid.getCompVersion());
        } else if (cid.getCompType() == 1 && bCheckCompCompatibility) {
            retVal = super.isCompatible(cid, bIgnoreBuild) && !cid.getVersion().laterThan(this.getVersion());
        }
        return retVal;
    }

    public Vector getAdditionalInfo() {
        Vector<Serializable> v = new Vector<Serializable>(3);
        v.setSize(3);
        v.setElementAt(this.m_baseVersion, 0);
        v.setElementAt(this.m_compVersion, 1);
        v.setElementAt(this.m_compPlatforms, 2);
        return v;
    }

    @Override
    public OiiiCompInstallID getIDAsCompID() {
        boolean oracleHomeComp = this.getOracleHomeType() > 0;
        OiiiCompInstallID cid = new OiiiCompInstallID(this.getName(), this.getVersion(), this.getPlatforms(), this.getReplaceVersion(), 2, this.getOracleHomeType(), oracleHomeComp, this.getReleaseLevel(), false);
        return cid;
    }

    public static OiiiCompInstallID createInstallID(OiiiCompInstallID id, Vector vAdditionalInfo) {
        OiiiVersion oBaseVer = (OiiiVersion)vAdditionalInfo.elementAt(0);
        OiiiVersion oCompVer = (OiiiVersion)vAdditionalInfo.elementAt(1);
        Vector vPlat = (Vector)vAdditionalInfo.elementAt(2);
        boolean oracleHomeComp = id.getOracleHomeType() > 0;
        OiiiCompInstallID baseId = new OiiiCompInstallID(id.getName(), oBaseVer, vPlat, id.getReplaceVersion(), 1, id.getOracleHomeType(), oracleHomeComp, id.getReleaseLevel(), false);
        OiiiPatchInstallID pid = new OiiiPatchInstallID(baseId, id.getVersion(), id.getPlatforms(), false);
        OiiiCompInstallID id1 = OiiiCompIDPool.getInstance().get(pid);
        return id1;
    }
}

