/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiHomeInvDetails;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiOracleHomeInfo
implements OixsXMLizable {
    static final long serialVersionUID = 5067806409634959619L;
    private static final String s_defName = "";
    private static Vector s_clusterList = new Vector();
    private String m_sLocalNode = null;
    private boolean m_bCRSHome = false;
    private static final boolean s_debug = false;
    private String m_location;
    private String m_sOldLocation = null;
    private int m_index;
    private Vector m_nodeList = null;
    private Vector m_nodeListBigCluster = null;
    private Vector m_suiteList = null;
    private int m_iHomeType = 0;
    private Vector m_DepList = null;
    private Vector m_RefList = null;
    private String m_RefCompositeHome = null;
    private OiiiHomeInvDetails m_invDetails;
    private transient boolean m_bRemoved;
    private transient boolean m_bRenamed;
    private transient boolean m_bMoved;
    private transient boolean m_bRemovedInThisSession;
    public static final int S_ORACLE_HOME = 0;
    public static final int S_APPLTOP = 1;
    public static final int S_VIRTUAL_HOME = 2;
    public static final int S_ORCA_HOME = 3;
    public static final int S_COMPOSITE_HOME = 4;
    private String m_name = "";
    private String m_CompositeHomeTypeName = "";
    private String m_CHPropsXML = null;
    private String m_sOldName = null;
    private transient boolean m_storedInInv = false;
    private transient boolean m_bDirty = false;
    private transient boolean m_bDummyHome = false;
    private transient boolean m_bDuplicateHomeName = false;
    private transient XMLElement m_unknownXMLElement;
    private int m_iARUID = 0;
    private String m_sARUIDDescription = "";
    private String m_sGUID = "";
    private boolean m_bGUIDValueResetRequired = false;
    private boolean m_bSaveSHPropXML = false;
    private Properties additionalProperties = null;
    private Properties additionalCompositeHomeProperties = null;
    private transient Properties m_HomeProperties = null;
    private long m_lDirtyFlags = 0L;
    public static final long CLEAN = 0L;
    private boolean m_PluginHome = false;
    public static final long LOCATION_MODIFIED = 1L;
    public static final long NAME_MODIFIED = 2L;
    public static final long TYPE_MODIFIED = 4L;
    public static final long INDEX_MODIFIED = 8L;
    public static final long LOCALNODE_MODIFIED = 16L;
    public static final long NODELIST_MODIFIED = 32L;
    public static final long ARUID_MODIFIED = 64L;
    public static final long ARU_DESC_MODIFIED = 128L;
    public static final long GUID_MODIFIED = 256L;
    public static final long CRS_STATUS_MODIFIED = 512L;
    public static final long REMOVED_STATUS_MODIFIED = 1024L;
    public static final long ADDED_TO_CENTRAL_INV = 2048L;
    public static final long ADDITIONAL_ORACLEHOME_PROPERTIES_FLAG = 4096L;
    public static final long ADDED_DEP_REF = 8192L;
    public static final long ADDITIONAL_COMPOSITEHOME_PROPERTIES_FLAG = 16384L;
    public static final long SUITELIST_MODIFIED = 32768L;
    public static final long CENTRAL_INVENTORY_DIRTY_MASK = 44587L;
    public static final long HOME_PROPERTIES_DIRTY_MASK = 21488L;

    public OiiiOracleHomeInfo(int index, String location, int iType) {
        this(index, location, s_defName, iType, false);
    }

    public OiiiOracleHomeInfo(int index, String location, int iType, boolean clearNodes) {
        this(index, location, s_defName, iType, clearNodes);
    }

    public OiiiOracleHomeInfo(int index, String location, String name, int iType, boolean clearNodes) {
        this.m_index = index;
        this.m_location = location;
        this.m_name = name;
        this.m_bGUIDValueResetRequired = false;
        this.m_lDirtyFlags = 8235L;
        if (clearNodes) {
            this.m_nodeList = new Vector(0);
        } else {
            this.m_nodeList = new Vector(s_clusterList.size());
            this.m_nodeList.addAll(s_clusterList);
        }
        this.m_suiteList = new Vector();
        this.m_DepList = new Vector();
        this.m_RefList = new Vector();
        this.setHomeType(iType);
        if (iType == 4) {
            this.setCompositeHomeTypeName(name);
        }
    }

    public OiiiOracleHomeInfo(int index, String location, String s_defName, int iType) {
        this(index, location, s_defName, iType, false);
    }

    public void setHomeType(int iType) {
        if (iType != 0 && iType != 2 && iType != 1 && iType != 3 && iType != 4) {
            throw new IllegalArgumentException("Unknown Home type: " + iType);
        }
        if (iType != this.m_iHomeType) {
            this.updateDirtyFlags(4L);
        }
        this.m_iHomeType = iType;
    }

    public boolean wasCreatedInThisSession() {
        return !this.m_storedInInv;
    }

    public void setDummyHome(boolean bDummy) {
        this.m_bDummyHome = bDummy;
    }

    public boolean isDummyHome() {
        return this.m_bDummyHome;
    }

    public boolean isCompositeHome() {
        return this.m_iHomeType == 4;
    }

    public void setDirty(boolean bDirty) {
        this.m_bDirty = bDirty;
    }

    long getDirtyFlags() {
        return this.m_lDirtyFlags;
    }

    public void setDirtyFlags(long lDirty) {
        this.m_lDirtyFlags = lDirty;
    }

    boolean isHomeInCIDirty() {
        return this.isDirty(44587L);
    }

    boolean isHomeInvDirty() {
        return this.isDirty(21488L);
    }

    public void clearHomeInvDirtyFlags() {
        this.m_lDirtyFlags &= 0xFFFFFFFFFFFFAC0FL;
    }

    public boolean isDirty(long lMask) {
        return (this.m_lDirtyFlags & lMask) != 0L;
    }

    public void updateDirtyFlags(long lDirty) {
        this.m_lDirtyFlags |= lDirty;
    }

    String getDirtyFlagsStr() {
        ArrayList<String> oFlags = new ArrayList<String>();
        if (this.m_lDirtyFlags == 0L) {
            return "clean";
        }
        long[] alFlags = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 32768L};
        String[] asFlagNames = new String[]{"location", "name", "type", "index", "localnode", "nodelist", "aruID", "aruDesc", "guid", "crs", "removed", "addedToCI", "additionalOHProps", "suitelist"};
        for (int i = 0; i < alFlags.length; ++i) {
            if ((this.m_lDirtyFlags & alFlags[i]) == 0L) continue;
            oFlags.add(asFlagNames[i]);
        }
        String[] asFlags = OiixVectorOps.list2StrArr(oFlags);
        return OiixFunctionOps.implodeList(asFlags, "|");
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    void setInvDetails(OiiiHomeInvDetails invDetails) {
        this.m_invDetails = invDetails;
    }

    OiiiHomeInvDetails getInvDetails() {
        return this.m_invDetails;
    }

    public void setName(String sName) {
        if (this.m_name == null || !this.m_name.equals(sName)) {
            this.updateDirtyFlags(2L);
        }
        this.m_name = sName;
        this.setDuplicateHomeName(false);
    }

    public String getName() {
        return this.m_name;
    }

    public String getCompositeHomeTypeName() {
        return this.m_CompositeHomeTypeName;
    }

    public void setCompositeHomeTypeName(String sCompHomeTypeName) {
        this.m_CompositeHomeTypeName = sCompHomeTypeName;
    }

    public boolean isDuplicateHomeName() {
        return this.m_bDuplicateHomeName;
    }

    public void setDuplicateHomeName(boolean bDuplicate) {
        this.m_bDuplicateHomeName = bDuplicate;
    }

    public String getUniqueName() {
        if (this.isDuplicateHomeName()) {
            String sLoc = this.getLocation();
            char[] acCharsToReplace = new char[]{':', '/', '\\', ' '};
            char cReplaceWith = '_';
            for (int i = 0; i < acCharsToReplace.length; ++i) {
                sLoc = sLoc.replace(acCharsToReplace[i], cReplaceWith);
            }
            return this.getName() + "_fixme_" + sLoc;
        }
        return this.getName();
    }

    public String getLocalNode() {
        return this.m_sLocalNode;
    }

    public void setLocalNode(String sLocalNode) {
        if (this.m_sLocalNode == null && sLocalNode != null || this.m_sLocalNode != null && sLocalNode == null || this.m_sLocalNode != null && sLocalNode != null && !this.m_sLocalNode.equals(sLocalNode)) {
            this.updateDirtyFlags(16L);
        }
        this.m_sLocalNode = sLocalNode;
    }

    public Vector getNodeList() {
        if (OiixInstallUtil.isOptionSet("oracle.installer.setCustomNodelist")) {
            return this.m_nodeListBigCluster;
        }
        return this.m_nodeList;
    }

    public void setNodeList(String[] nodeList) {
        if (!Boolean.getBoolean("oracle.installer.doNotUpdateNodeList") && !OiixInstallUtil.isOptionSet("DO_NOT_UPDATE_LOCAL_NODE_LIST")) {
            this.m_nodeList = OiixVectorOps.strArr2Vect(nodeList);
            this.updateDirtyFlags(32L);
        }
    }

    public Vector getNodeListBigCluster() {
        return this.m_nodeListBigCluster;
    }

    public void setNodeListBigCluster(String[] nodeListBigCluster) {
        if (!Boolean.getBoolean("oracle.installer.doNotUpdateNodeList") && !OiixInstallUtil.isOptionSet("DO_NOT_UPDATE_LOCAL_NODE_LIST")) {
            this.m_nodeListBigCluster = OiixVectorOps.strArr2Vect(nodeListBigCluster);
            this.setNodeList(nodeListBigCluster);
            this.updateDirtyFlags(32L);
        }
    }

    public List getDepHomeList() {
        return this.m_DepList;
    }

    public void setDepHomeList(String[] depList) {
        this.m_DepList = OiixVectorOps.strArr2Vect(depList);
        this.updateDirtyFlags(8192L);
    }

    public Vector getRefHomeList() {
        return this.m_RefList;
    }

    public void setRefHomeList(String[] RefList) {
        this.m_RefList = OiixVectorOps.strArr2Vect(RefList);
        this.updateDirtyFlags(8192L);
    }

    public static void setDefaultNodeList(String[] nodeList) {
        s_clusterList.removeAllElements();
        for (int i = 0; i < nodeList.length; ++i) {
            s_clusterList.addElement(nodeList[i]);
        }
    }

    public void addNode(String nodeName) {
        int idx = OiixVectorOps.vectIndexOf(this.m_nodeList, (Object)nodeName);
        if (idx == -1) {
            this.m_nodeList.addElement(nodeName);
            this.updateDirtyFlags(32L);
        }
    }

    public void addDepHome(String homeLoc) {
        int idx = OiixVectorOps.vectIndexOf(this.m_DepList, (Object)homeLoc);
        if (idx == -1) {
            this.m_DepList.addElement(homeLoc);
            this.updateDirtyFlags(8192L);
        }
    }

    public void addRefHome(String homeLoc) {
        int idx = OiixVectorOps.vectIndexOf(this.m_RefList, (Object)homeLoc);
        if (idx == -1) {
            this.m_RefList.addElement(homeLoc);
            this.updateDirtyFlags(8192L);
        }
    }

    public void addRefCompositeHome(String homeLoc) {
        this.m_RefCompositeHome = homeLoc;
    }

    public String getRefCompositeHome() {
        return this.m_RefCompositeHome;
    }

    public boolean isRefCompositeHome() {
        return this.m_RefCompositeHome != null;
    }

    public void removeDepHome(String homeLoc) {
        int idx = OiixVectorOps.vectIndexOf(this.m_DepList, (Object)homeLoc);
        if (idx != -1) {
            this.m_DepList.removeElementAt(idx);
            this.updateDirtyFlags(8192L);
        }
    }

    public void removeRefHome(String homeLoc) {
        int idx = OiixVectorOps.vectIndexOf(this.m_RefList, (Object)homeLoc);
        if (idx != -1) {
            this.m_RefList.removeElementAt(idx);
            this.updateDirtyFlags(8192L);
        }
    }

    public String getLocation() {
        return this.m_location;
    }

    void setLocation(String sLocation) {
        if (this.m_location == null || !this.m_location.equals(sLocation)) {
            this.updateDirtyFlags(1L);
        }
        this.m_location = sLocation;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int getHomeType() {
        return this.m_iHomeType;
    }

    public static String getHomeTypeString(int iType) {
        String sHomeTypeString = s_defName;
        switch (iType) {
            case 0: {
                sHomeTypeString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORACLE_HOME");
                break;
            }
            case 1: {
                sHomeTypeString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_APPLTOP");
                break;
            }
            case 2: {
                sHomeTypeString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_VIRTUAL_HOME");
                break;
            }
            case 3: {
                sHomeTypeString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ORCA_HOME");
                break;
            }
            case 4: {
                sHomeTypeString = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_COMPOSITE_HOME");
                break;
            }
        }
        return sHomeTypeString;
    }

    public static int getOHIndex(Vector ohs, String location) {
        int numOHs = ohs.size();
        int retIndex = -1;
        for (int i = 0; i < numOHs; ++i) {
            OiipgFileSystem fs = new OiipgFileSystem();
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)ohs.elementAt(i);
            if (!fs.areLocsSame(location, ohi.getLocation())) continue;
            retIndex = ohi.getIndex();
            break;
        }
        return retIndex;
    }

    public static int getCompOHIndex(Vector ohs, String location) {
        int numOHs = ohs.size();
        int retIndex = -1;
        for (int i = 0; i < numOHs; ++i) {
            OiipgFileSystem fs = new OiipgFileSystem();
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)ohs.elementAt(i);
            if (!fs.areLocsSame(location, ohi.getLocation())) continue;
            retIndex = i;
            break;
        }
        return retIndex;
    }

    public static String getDefBaseLocation() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                break;
            }
            case -1: {
                for (int i = 1; i <= 9; ++i) {
                    String path = "/u0" + i;
                    if (!new File(path).exists()) continue;
                    return path + File.separator + "app" + File.separator + OiixEnvironmentOps.ssgetUidNameux();
                }
                break;
            }
        }
        OiipgFileSystem fs = new OiipgFileSystem();
        return fs.getDefBaseLocation();
    }

    public static String getDefHomeLocation(int nHomeType) {
        String location = null;
        switch (nHomeType) {
            case 0: {
                location = OiixOraparam.getOraparamProfileString("DEFAULT_HOME_LOCATION", null);
                if (location != null && location.trim().length() != 0) break;
                location = "/OraHome";
                break;
            }
            case 1: {
                location = OiixOraparam.getOraparamProfileString("DEFAULT_APPLTOP_LOCATION", null);
                if (location != null && location.trim().length() != 0) break;
                location = "/Appltop";
            }
        }
        OiipgFileSystem fs = new OiipgFileSystem();
        return fs.getDefHomeLocation(location);
    }

    public static String getDefHomeName(OiiiInstallInventory inv, int nHomeType) {
        return OiiiOracleHomeInfo.getDefHomeName(inv, nHomeType, null);
    }

    public static String getDefHomeName(OiiiInstallInventory inv, int nHomeType, String defName) {
        String name = null;
        String defaultName = null;
        defaultName = defName != null && defName.length() > 0 ? defName : "OraHome";
        switch (nHomeType) {
            case 0: {
                name = OiixOraparam.getOraparamProfileString("DEFAULT_HOME_NAME", defaultName);
                if (name.length() != 0) break;
                name = defaultName;
                break;
            }
            case 1: {
                name = "ApplTop";
            }
        }
        return name;
    }

    public void setCRSHome(boolean bCRS) {
        if (this.m_bCRSHome != bCRS) {
            this.updateDirtyFlags(512L);
        }
        this.m_bCRSHome = bCRS;
    }

    public boolean isCRSHome() {
        return this.m_bCRSHome;
    }

    public static String getHomeEnvVar(int nHomeType) {
        String sEnvVar = "ORACLE_HOME";
        switch (nHomeType) {
            case 0: {
                sEnvVar = "ORACLE_HOME";
                break;
            }
            case 1: {
                sEnvVar = "APPLTOP";
            }
        }
        return sEnvVar;
    }

    public static String getBaseEnvVar() {
        String sEnvVar = System.getProperty("oracle.installer.ORACLE_BASEenvVar", "ORACLE_BASE");
        return sEnvVar;
    }

    public boolean equals(String location) {
        return this.m_location.equals(location);
    }

    public void setStoredInInv(boolean flag) {
        this.m_storedInInv = flag;
    }

    public boolean equals(Integer ohIndex) {
        return ohIndex == this.m_index;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            if (obj instanceof Integer) {
                return this.equals((Integer)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public XMLElement toXML() {
        boolean isCompositeHome = this.isCompositeHome();
        return this.buildDOMTree(isCompositeHome);
    }

    @Override
    public void writeXML(PrintWriter out) throws IOException {
        boolean isCompositeHome = this.isCompositeHome();
        XMLElement element = this.buildDOMTree(isCompositeHome);
        element.print(out);
    }

    private XMLElement buildDOMTree(boolean isCompositeHome) {
        XMLElement homeElement = null;
        if (!isCompositeHome) {
            int i;
            homeElement = this.getUnknownXMLElement();
            homeElement = homeElement == null ? new XMLElement("HOME") : (XMLElement)homeElement.cloneNode(true);
            homeElement.setAttribute("NAME", this.m_name);
            homeElement.setAttribute("LOC", this.m_location);
            String sType = "O";
            if (this.m_iHomeType == 1) {
                sType = "A";
            } else if (this.m_iHomeType == 2) {
                sType = "V";
            }
            homeElement.setAttribute("TYPE", sType);
            homeElement.setAttribute("IDX", s_defName + this.m_index);
            if (this.m_bCRSHome) {
                homeElement.setAttribute("CRS", String.valueOf(this.m_bCRSHome));
            }
            if (this.m_nodeList != null && !this.m_nodeList.isEmpty()) {
                XMLElement elemNodeList = new XMLElement("NODE_LIST");
                homeElement.appendChild((Node)elemNodeList);
                for (i = 0; i < this.m_nodeList.size(); ++i) {
                    XMLElement elemNode = new XMLElement("NODE");
                    elemNode.setAttribute("NAME", (String)this.m_nodeList.elementAt(i));
                    elemNodeList.appendChild((Node)elemNode);
                }
            }
            if (this.m_DepList != null && !this.m_DepList.isEmpty()) {
                XMLElement elemDepList = new XMLElement("DEPHOMELIST");
                homeElement.appendChild((Node)elemDepList);
                for (i = 0; i < this.m_DepList.size(); ++i) {
                    XMLElement depHome = new XMLElement("DEPHOME");
                    depHome.setAttribute("LOC", (String)this.m_DepList.elementAt(i));
                    elemDepList.appendChild((Node)depHome);
                }
            }
            if (this.m_RefList != null && !this.m_RefList.isEmpty()) {
                XMLElement elemRefList = new XMLElement("REFHOMELIST");
                homeElement.appendChild((Node)elemRefList);
                for (i = 0; i < this.m_RefList.size(); ++i) {
                    XMLElement RefHome = new XMLElement("REFHOME");
                    RefHome.setAttribute("LOC", (String)this.m_RefList.elementAt(i));
                    elemRefList.appendChild((Node)RefHome);
                }
            }
            if (this.m_suiteList != null && !this.m_suiteList.isEmpty()) {
                XMLElement elemSuiteList = new XMLElement("SUITE_LIST");
                homeElement.appendChild((Node)elemSuiteList);
                for (i = 0; i < this.m_suiteList.size(); ++i) {
                    XMLElement elemSuite = new XMLElement("SUITE");
                    elemSuite.setAttribute("NAME", (String)this.m_suiteList.elementAt(i));
                    elemSuiteList.appendChild((Node)elemSuite);
                }
            }
            if (this.m_bRemoved) {
                homeElement.setAttribute("REMOVED", "T");
            }
            if (this.isPluginHome()) {
                homeElement.setAttribute("PLUGIN", "T");
            }
        } else {
            homeElement = this.getUnknownXMLElement();
            homeElement = homeElement == null ? new XMLElement("COMPOSITEHOME") : (XMLElement)homeElement.cloneNode(true);
            homeElement.setAttribute("TYPE", this.m_CompositeHomeTypeName);
            homeElement.setAttribute("LOC", this.m_location);
            if (this.m_nodeList != null && !this.m_nodeList.isEmpty()) {
                XMLElement elemNodeList = new XMLElement("NODE_LIST");
                homeElement.appendChild((Node)elemNodeList);
                for (int i = 0; i < this.m_nodeList.size(); ++i) {
                    XMLElement elemNode = new XMLElement("NODE");
                    elemNode.setAttribute("NAME", (String)this.m_nodeList.elementAt(i));
                    elemNodeList.appendChild((Node)elemNode);
                }
            }
            if (this.m_bRemoved) {
                homeElement.setAttribute("REMOVED", "T");
            }
            if (this.isPluginHome()) {
                homeElement.setAttribute("PLUGIN", "T");
            }
        }
        return homeElement;
    }

    void setUnknownXMLElement(XMLElement element) {
        this.m_unknownXMLElement = element;
    }

    XMLElement getUnknownXMLElement() {
        return this.m_unknownXMLElement;
    }

    void renameTo(String sNewName) {
        if (this.m_bMoved) {
            throw new IllegalStateException("This home has already been moved in this session. The inventory must be saved before renaming it.");
        }
        this.m_sOldName = this.m_name;
        this.m_name = sNewName;
        this.m_bRenamed = true;
        this.updateDirtyFlags(2L);
    }

    public boolean isRenamed() {
        return this.m_bRenamed;
    }

    void setRenamed(boolean bRenamed) {
        if (!bRenamed) {
            this.m_sOldName = null;
        }
        this.m_bRenamed = bRenamed;
    }

    void moveTo(String sNewLocation) {
        if (this.m_bRenamed) {
            throw new IllegalStateException("This home has already been renamed in this session. The inventory must be saved before moving it.");
        }
        this.m_sOldLocation = this.m_location;
        this.m_location = sNewLocation;
        this.m_bMoved = true;
        this.updateDirtyFlags(1L);
    }

    public boolean isMoved() {
        return this.m_bMoved;
    }

    void setMoved(boolean bMoved) {
        if (!bMoved) {
            this.m_sOldLocation = null;
        }
        this.m_bMoved = bMoved;
    }

    String getOldLocation() {
        return this.m_sOldLocation;
    }

    String getOldName() {
        return this.m_sOldName;
    }

    void setRemoved(boolean bRemoved) {
        this.m_bRemoved = bRemoved;
    }

    public boolean isRemoved() {
        return this.m_bRemoved;
    }

    void setAddedThisSession(boolean bAddedInThisSession) {
        if (bAddedInThisSession) {
            this.updateDirtyFlags(2048L);
        }
    }

    void setRemovedInThisSession(boolean bRemovedInThisSession) {
        this.m_bRemovedInThisSession = bRemovedInThisSession;
        this.updateDirtyFlags(1024L);
    }

    boolean isRemovedInThisSession() {
        if (!this.isRemoved()) {
            return false;
        }
        return this.m_bRemovedInThisSession;
    }

    public int getARUID() {
        return this.m_iARUID;
    }

    public void setARUID(int iARUID) {
        if (this.m_iARUID != iARUID) {
            this.updateDirtyFlags(64L);
        }
        this.m_iARUID = iARUID;
    }

    public String getARUIDDescription() {
        return this.m_sARUIDDescription;
    }

    public void setARUIDDescription(String sARUIDDescription) {
        if (this.m_sARUIDDescription == null || !this.m_sARUIDDescription.equals(sARUIDDescription)) {
            this.updateDirtyFlags(128L);
        }
        this.m_sARUIDDescription = sARUIDDescription;
    }

    public void setSaveSHPropXML(boolean bSaveSHPropXML) {
        this.m_bSaveSHPropXML = bSaveSHPropXML;
    }

    public boolean getSaveSHPropXML() {
        return this.m_bSaveSHPropXML;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(s_defName);
        sb.append("Location:");
        sb.append(this.m_location);
        sb.append(":");
        sb.append("Name:");
        sb.append(this.m_name);
        sb.append(":");
        sb.append("Index:");
        sb.append(this.m_index);
        sb.append(":");
        sb.append("Is CRS:");
        sb.append(this.m_bCRSHome);
        sb.append(":");
        sb.append("ARUID:");
        sb.append(this.m_iARUID);
        sb.append(":");
        sb.append("ARUID Desc:");
        sb.append(this.m_sARUIDDescription);
        sb.append(":");
        sb.append("Local node:");
        sb.append(this.m_sLocalNode);
        sb.append(":");
        sb.append("Nodes:");
        sb.append(this.m_nodeList);
        sb.append(":");
        sb.append("isRemoved:");
        sb.append(this.isRemoved());
        sb.append("isCompositeHome");
        sb.append(this.isCompositeHome());
        return sb.toString();
    }

    public Properties getHomeProperties() {
        return this.m_HomeProperties;
    }

    public void setHomeProperties(Properties props) {
        this.m_HomeProperties = props;
    }

    public boolean getBoolPropertyValue(String propName) {
        String val;
        boolean propValue = Boolean.getBoolean(propName);
        if (this.m_HomeProperties != null && (val = this.m_HomeProperties.getProperty(propName)) != null) {
            propValue = val.equalsIgnoreCase("true");
        }
        return propValue;
    }

    public void setPluginHome(boolean isPluginHome) {
        this.m_PluginHome = isPluginHome;
    }

    public boolean isPluginHome() {
        return this.m_PluginHome;
    }

    public static String calculateGUIDValue(String ip, String OHPath, String nodeName) {
        String sTime = String.valueOf(System.currentTimeMillis());
        String sIP = " ";
        String ohCanonPath = " ";
        String sLocalNode = " ";
        if (ip == null) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiiiOracleHomeInfo :Found IP as null while calculating GUID,taking IP as single space string for calculations", OiiolTextLogger.LOG_DETAILED);
            }
            sIP = " ";
        } else {
            sIP = ip;
        }
        if (OHPath == null) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("OiiiOracleHomeInfo :Found Oracle home location as null while calculating GUID, taking OHCanonicalPath as single space string for calculations", OiiolTextLogger.LOG_DETAILED);
            }
            ohCanonPath = " ";
        } else {
            try {
                ohCanonPath = new File(OHPath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = sLocalNode = nodeName == null ? " " : nodeName;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("GUID Parameter Values : " + sTime + sIP + ohCanonPath + sLocalNode, OiiolTextLogger.LOG_DETAILED);
        }
        String param1 = sTime.concat(sLocalNode);
        String param2 = sIP.concat(ohCanonPath);
        int hash1 = param1.hashCode();
        int absHash1 = Math.abs(hash1);
        int hash2 = param2.hashCode();
        int absHash2 = Math.abs(hash2);
        String pad1 = absHash1 == hash1 ? s_defName : "#";
        String part1 = String.valueOf(absHash1).concat(pad1);
        String pad2 = absHash2 == hash2 ? s_defName : "#";
        String part2 = pad2.concat(String.valueOf(absHash2));
        return part1.concat(".").concat(part2);
    }

    public void setGUID(String sGUID) {
        if (this.m_sGUID == null || !this.m_sGUID.equals(sGUID)) {
            this.updateDirtyFlags(256L);
        }
        this.m_sGUID = sGUID;
    }

    public String getGUID() {
        return this.m_sGUID;
    }

    public void setGUIDValueResetRequired(boolean bGUIDValueResetRequired) {
        this.m_bGUIDValueResetRequired = bGUIDValueResetRequired;
    }

    public boolean isGUIDValueResetRequired() {
        return this.m_bGUIDValueResetRequired;
    }

    public Properties getAdditionalOracleHomeProperties() {
        return this.additionalProperties;
    }

    public String getAdditionalOracleHomeProperty(String name) {
        if (this.additionalProperties != null) {
            return this.additionalProperties.getProperty(name);
        }
        return null;
    }

    public void setAdditionalOracleHomeProperty(String name, String value) {
        if (name != null && value != null) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new Properties();
            }
            this.additionalProperties.setProperty(name, value);
            this.updateDirtyFlags(4096L);
        }
    }

    public Properties getAdditionalCompositeHomeProperties() {
        return this.additionalCompositeHomeProperties;
    }

    public String getAdditionalCompositeHomeProperty(String name) {
        if (this.additionalCompositeHomeProperties != null) {
            return this.additionalCompositeHomeProperties.getProperty(name);
        }
        return null;
    }

    public void setAdditionalCompositeHomeProperty(String name, String value) {
        if (name != null && value != null) {
            if (this.additionalCompositeHomeProperties == null) {
                this.additionalCompositeHomeProperties = new Properties();
            }
            this.additionalCompositeHomeProperties.setProperty(name, value);
            this.updateDirtyFlags(16384L);
        }
    }

    public String getCHPropsXML() {
        if (this.m_CHPropsXML == null) {
            String inventoryLoc = OiixPathOps.concatPath(this.getLocation(), "inventory");
            String ContentsXMLDir = OiixPathOps.concatPath(inventoryLoc, "ContentsXML");
            this.m_CHPropsXML = OiixPathOps.concatPath(ContentsXMLDir, "compositehomeproperties.xml");
        }
        return this.m_CHPropsXML;
    }

    public void setCHPropsXML(String propsXML) {
        this.m_CHPropsXML = propsXML;
    }

    public Vector getSuiteList() {
        return this.m_suiteList;
    }

    public void setSuiteList(String[] suiteList) {
        this.m_suiteList = OiixVectorOps.strArr2Vect(suiteList);
        this.updateDirtyFlags(32768L);
    }

    public void addSuite(String suite) {
        int idx = OiixVectorOps.vectIndexOf(this.m_suiteList, (Object)suite);
        if (idx == -1) {
            this.m_suiteList.addElement(suite);
            this.updateDirtyFlags(32768L);
        }
    }

    public void removeSuite(String suite) {
        int idx = OiixVectorOps.vectIndexOf(this.m_suiteList, (Object)suite);
        if (idx > -1) {
            this.m_suiteList.removeElement(suite);
            this.updateDirtyFlags(32768L);
        }
    }
}

