/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiLibraryIDPool;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiLibsXMLHandler
extends OixsDefaultHandler {
    private Vector[] m_libs;
    private int m_nPlatform;
    private Vector m_vInvPlat;
    private OiiiLibElementHandler m_handlerLib;
    private OixsElementHandler m_handlerLibList;
    private OixsElementHandler m_handlerQueryList;
    private OixsElementHandler m_handlerActionList;
    private OixsElementHandler m_handlerDialogList;
    private boolean m_bStageSession = false;

    public OiiiLibsXMLHandler(int nPlatform) throws SAXException {
        this.init();
        this.m_nPlatform = nPlatform;
        this.m_vInvPlat = new Vector(1);
        this.m_vInvPlat.addElement(new Integer(this.m_nPlatform));
    }

    public OiiiLibsXMLHandler(boolean bStageSession) throws SAXException {
        this.m_bStageSession = true;
        this.init();
    }

    private void init() {
        this.m_libs = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_libs[i] = new Vector();
        }
    }

    public Vector[] getLibraries() {
        return this.m_libs;
    }

    @Override
    protected OixsElementHandler createElementHandlers() {
        this.m_handlerLibList = new OixsElementHandler("LIB_LIST");
        this.m_handlerLib = new OiiiLibElementHandler("LIB");
        this.m_handlerQueryList = new OixsElementHandler("QUERY_LIST"){

            @Override
            public void onStart(String name, AttributeList atts) {
                OiiiLibsXMLHandler.this.m_handlerLib.setLibsVect(OiiiLibsXMLHandler.this.m_libs[1]);
            }
        };
        this.m_handlerDialogList = new OixsElementHandler("DIALOG_LIST"){

            @Override
            public void onStart(String name, AttributeList atts) {
                OiiiLibsXMLHandler.this.m_handlerLib.setLibsVect(OiiiLibsXMLHandler.this.m_libs[2]);
            }
        };
        this.m_handlerActionList = new OixsElementHandler("ACTION_LIST"){

            @Override
            public void onStart(String name, AttributeList atts) {
                OiiiLibsXMLHandler.this.m_handlerLib.setLibsVect(OiiiLibsXMLHandler.this.m_libs[0]);
            }
        };
        this.m_handlerLibList.addChildHandler("QUERY_LIST", this.m_handlerQueryList);
        this.m_handlerLibList.addChildHandler("DIALOG_LIST", this.m_handlerDialogList);
        this.m_handlerLibList.addChildHandler("ACTION_LIST", this.m_handlerActionList);
        this.m_handlerQueryList.addChildHandler("LIB", this.m_handlerLib);
        this.m_handlerDialogList.addChildHandler("LIB", this.m_handlerLib);
        this.m_handlerActionList.addChildHandler("LIB", this.m_handlerLib);
        return this.m_handlerLibList;
    }

    private Vector getInventoryPlatform() {
        return this.m_vInvPlat;
    }

    public Hashtable getUnknownElementsTable() {
        Hashtable<String, XMLElement> ht = new Hashtable<String, XMLElement>();
        XMLElement elLibList = this.m_handlerLibList.getUnknownXMLElement();
        XMLElement elQueryList = this.m_handlerQueryList.getUnknownXMLElement();
        XMLElement elActionList = this.m_handlerActionList.getUnknownXMLElement();
        XMLElement elDialogList = this.m_handlerDialogList.getUnknownXMLElement();
        if (!OixsXMLOps.isEmpty(elLibList)) {
            ht.put("LIB_LIST", elLibList);
        }
        if (!OixsXMLOps.isEmpty(elActionList)) {
            ht.put("ACTION_LIST", elActionList);
        }
        if (!OixsXMLOps.isEmpty(elQueryList)) {
            ht.put("QUERY_LIST", elQueryList);
        }
        if (!OixsXMLOps.isEmpty(elDialogList)) {
            ht.put("DIALOG_LIST", elDialogList);
        }
        return ht;
    }

    private class OiiiLibElementHandler
    extends OixsElementHandler {
        private Vector m_libs;
        private OiiiLibInvEntry m_curLibInvEntry;

        public OiiiLibElementHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            OiiiLibraryID lid;
            String sName = atts.getValue("NAME");
            OiiiVersion version = new OiiiVersion(atts.getValue("VER"));
            OiiiVersion repVer = new OiiiVersion(atts.getValue("REP_VER"));
            OiiiVersion instVer = new OiiiVersion(atts.getValue("MIN_INST_VER"));
            if (OiiiLibsXMLHandler.this.m_bStageSession) {
                String sPlats = atts.getValue("PLAT");
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                lid = new OiiiLibraryID(sName, version, vPlats, repVer);
            } else {
                lid = new OiiiLibraryID(sName, version, OiiiLibsXMLHandler.this.getInventoryPlatform(), repVer);
            }
            lid.setInstVer(instVer);
            lid = OiiiLibraryIDPool.getInstance().get(lid);
            String sLoc = atts.getValue("INV_LOC");
            this.m_curLibInvEntry = new OiiiLibInvEntry(lid, sLoc);
            this.m_libs.addElement(this.m_curLibInvEntry);
        }

        @Override
        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_curLibInvEntry.setUnknownXMLElement(element);
            }
        }

        void setLibsVect(Vector libs) {
            this.m_libs = libs;
        }
    }
}

