/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibType;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiis.OiisLibraryLoader;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiiiLibraryUpdater {
    private OiiiInstallAreaControl m_oInstallAreaControl;
    private int m_iHomeIdx;

    OiiiLibraryUpdater(OiiiInstallAreaControl iac, int homeIndex) {
        this.m_oInstallAreaControl = iac;
        this.m_iHomeIdx = homeIndex;
    }

    ArrayList addLibrariesToInv(File oLibLoc, boolean bRecurse) throws IOException {
        ArrayList<String> alLibsNotAdded = new ArrayList<String>();
        if (oLibLoc != null && oLibLoc.exists()) {
            if (oLibLoc.isDirectory()) {
                File[] aoFilesList = oLibLoc.listFiles();
                for (int i = 0; i < aoFilesList.length; ++i) {
                    if (aoFilesList[i].isDirectory()) {
                        try {
                            if (!bRecurse) continue;
                            ArrayList al = this.addLibrariesToInv(aoFilesList[i], bRecurse);
                            alLibsNotAdded.addAll(al);
                        }
                        catch (IOException e) {
                            System.out.println(e.getMessage());
                        }
                        continue;
                    }
                    try {
                        this.addLibraryToInv(aoFilesList[i]);
                        continue;
                    }
                    catch (IOException e) {
                        alLibsNotAdded.add(aoFilesList[i].getAbsolutePath());
                        continue;
                    }
                    catch (OiifbCancelException e) {
                        alLibsNotAdded.add(aoFilesList[i].getAbsolutePath());
                    }
                }
            } else {
                try {
                    this.addLibraryToInv(oLibLoc);
                }
                catch (IOException e) {
                    alLibsNotAdded.add(oLibLoc.getAbsolutePath());
                }
                catch (OiifbCancelException e) {
                    alLibsNotAdded.add(oLibLoc.getAbsolutePath());
                }
            }
        } else {
            throw new IOException(OiixResourceBundle.getString("S_INCORRECT_LIB_LOCATION_SPECIFIED", new Object[]{oLibLoc.getPath()}));
        }
        return alLibsNotAdded;
    }

    boolean addLibraryToInv(File oLibLoc) throws IOException, OiifbCancelException {
        boolean bAddedToInv = false;
        if (oLibLoc.isFile()) {
            String sLibLoc = oLibLoc.getCanonicalPath();
            OiisLibraryLoader lLoader = new OiisLibraryLoader(sLibLoc);
            OiiiLibraryID lid = lLoader.getLibraryID();
            lid.optimizePlatList();
            if (lid.getPlatforms().size() == 0 || lid.forPlatform(OiixPlatform.getCurrentPlatform())) {
                int iLibType = lLoader.getLibraryMap().getLibType();
                if (OiiiLibType.validType(iLibType)) {
                    OiiiLibInvEntry oCompatLibEntry;
                    OiiiInstallInventory oInventory = this.m_oInstallAreaControl.getInstallInventory();
                    if (oInventory != null && (oCompatLibEntry = oInventory.getCompatLibInvEntry(lid, iLibType, this.m_iHomeIdx)) == null) {
                        String relativeFileLoc = this.m_oInstallAreaControl.getXMLLibRelativeLoc(lid, iLibType, this.m_iHomeIdx);
                        relativeFileLoc = OiixPathOps.concatPath(relativeFileLoc, oLibLoc.getName());
                        String sInvLoc = this.m_oInstallAreaControl.getInventoryLocForHome(this.m_iHomeIdx);
                        String localFileLoc = OiixPathOps.concatPath(sInvLoc, relativeFileLoc);
                        OiiiLibInvEntry localLib = new OiiiLibInvEntry(lid, relativeFileLoc);
                        OiixFileOps.copyFileRec(sLibLoc, localFileLoc, true);
                        oInventory.addLibInvEntry(localLib, iLibType, this.m_iHomeIdx);
                        bAddedToInv = true;
                    }
                } else {
                    throw new IOException(OiixResourceBundle.getString("S_INVALID_LIBRARY_TYPE", new Object[]{oLibLoc.getCanonicalPath()}));
                }
            }
        }
        return bAddedToInv;
    }

    public static void main(String[] argv) throws Exception {
        String LIBRARY_UPDATE = "libraryUpdate";
        if (argv.length < 2) {
            System.out.println("Usage: <home path> <filename|directory> <recurse or not>");
            System.exit(1);
        }
        String sOracleHome = argv[0];
        String sLibLoc = argv[1];
        boolean bRecurse = false;
        if (argv.length > 3) {
            bRecurse = Boolean.valueOf(argv[2]);
        }
        boolean iLibsAdded = false;
        OiicStandardInventorySession session = new OiicStandardInventorySession("libraryUpdate", "2.3");
        OiiiCompInstallID.setShouldOptimize(true);
        OiiiLibraryID.setShouldOptimize(true);
        try {
            session.initSession(1);
            OiiiInstallAreaControl iac = session.getInstallAreaControl();
            OiiiInstallInventory inventory = iac.getInstallInventory();
            OiiiOracleHomeInfo ohi = inventory.getHomeWithLocation(sOracleHome);
            if (ohi != null) {
                int iHomeIndex = ohi.getIndex();
                OiiiLibraryUpdater oLibUpdater = new OiiiLibraryUpdater(iac, iHomeIndex);
                ArrayList al = oLibUpdater.addLibrariesToInv(new File(sLibLoc), bRecurse);
                if (al.size() > 0) {
                    System.out.println("Libraries not added:" + al);
                }
                iac.saveInstallInventory();
            } else {
                System.out.println("Specified home is not registered with the central inventory. Cannot add library to install inventory.");
            }
        }
        catch (OiitTargetLockNotAvailableException e) {
            System.out.println("Couldn't lock master inventory: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Couldn't access master inventory: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Unknown error obtaining inventory lock:: " + e.getMessage());
        }
        OiiiCompIDPool.getInstance().clearPool();
        session.endSession();
        System.exit(0);
    }
}

