/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibType;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiLibrariesInfo {
    private Vector[] m_libsInfo;

    public OiiiLibrariesInfo() {
        this.m_libsInfo = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_libsInfo[i] = new Vector();
        }
    }

    public OiiiLibrariesInfo(Vector[] libsInfo) {
        this.m_libsInfo = libsInfo;
    }

    public Vector getLibrariesOfType(int type) {
        if (!OiiiLibType.validType(type)) {
            throw new IllegalArgumentException("Invalid library type: " + type);
        }
        return this.m_libsInfo[type];
    }

    public void setLibrariesOfType(int type, Vector libs) {
        if (!OiiiLibType.validType(type)) {
            throw new IllegalArgumentException("Invalid library type: " + type);
        }
        this.m_libsInfo[type] = libs;
    }

    public void addLibInvEntry(OiiiLibInvEntry libEntry, int type) {
        if (!OiiiLibType.validType(type)) {
            throw new IllegalArgumentException("Invalid library type: " + type);
        }
        Vector vLibs = this.getLibrariesOfType(type);
        vLibs.addElement(libEntry);
    }

    public OiiiLibInvEntry getLibInvEntry(OiiiLibraryID lid, int type) {
        if (!OiiiLibType.validType(type)) {
            throw new IllegalArgumentException("Invalid library type: " + type);
        }
        Vector vLibs = this.getLibrariesOfType(type);
        int idx = OiixVectorOps.vectIndexOf(vLibs, (Object)lid);
        if (idx != -1) {
            return (OiiiLibInvEntry)vLibs.elementAt(idx);
        }
        return null;
    }

    public OiiiLibInvEntry getCompatLibInvEntry(OiiiLibraryID lid, int type, OiiiVersion runningInstVer) {
        if (!OiiiLibType.validType(type)) {
            throw new IllegalArgumentException("Invalid library type: " + type);
        }
        Vector vLibs = this.getLibrariesOfType(type);
        OiiiVersion maxVer = null;
        OiiiLibInvEntry maxVerEntry = null;
        Enumeration enum_1 = vLibs.elements();
        while (enum_1.hasMoreElements()) {
            OiiiLibInvEntry curEntry = (OiiiLibInvEntry)enum_1.nextElement();
            if (!curEntry.isCompatible(lid)) continue;
            OiiiVersion curVer = curEntry.getVersion();
            OiiiVersion libInstVer = curEntry.getLibraryID().getInstVer();
            if (runningInstVer != null && !libInstVer.equals(runningInstVer) && libInstVer.laterThan(runningInstVer) || maxVer != null && !curVer.laterThan(maxVer)) continue;
            maxVer = curVer;
            maxVerEntry = curEntry;
        }
        return maxVerEntry;
    }
}

