/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixResourceVariants;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;

public class OiiiLibInvEntry
implements OiiiVersioned,
OixsXMLizable {
    static final long serialVersionUID = -3349004741929318813L;
    private static final boolean s_debug = false;
    private OiiiLibraryID m_lid;
    private String m_loc;
    private transient ResourceBundle m_resBundle = null;
    private transient XMLElement m_unknownXMLElement;

    public OiiiLibInvEntry(OiiiLibraryID lid, String location) {
        this.m_lid = lid;
        this.m_loc = location;
    }

    public OiiiLibraryID getLibraryID() {
        return this.m_lid;
    }

    @Override
    public OiiiVersion getVersion() {
        return this.m_lid.getVersion();
    }

    public String getLocation() {
        return this.m_loc;
    }

    protected void setLocation(String location) {
        this.m_loc = location;
    }

    public boolean isCompatible(OiiiLibraryID lid) {
        return this.m_lid.equals(lid) || this.m_lid.replaces(lid);
    }

    public boolean equals(OiiiLibInvEntry lie) {
        if (lie != null) {
            if (this.m_lid.equals(lie.m_lid) && this.m_loc.equals(lie.m_loc)) {
                if (this.m_lid.equalsWithMinInstallerVer(lie.m_lid)) {
                    return true;
                }
                lie.m_lid = this.m_lid;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean equals(OiiiLibraryID lid) {
        return this.m_lid.equals(lid);
    }

    public boolean equals(String name) {
        return this.m_lid.equals(name);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiiiLibInvEntry) {
                return this.equals((OiiiLibInvEntry)obj);
            }
            if (obj instanceof OiiiLibraryID) {
                return this.equals((OiiiLibraryID)obj);
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        return "{" + this.m_lid.toString() + "}, " + this.m_loc;
    }

    public void setResourceBundle(ResourceBundle resBundle) {
        this.m_resBundle = resBundle;
    }

    private void loadBundle() throws IOException {
        OiixJarClassLoader jcl = OiixJarClassLoader.createLoader(this.m_loc);
        String resourceBase = "resources/LibID";
        PropertyResourceBundle rb = null;
        boolean foundResource = false;
        Enumeration vars = OiixResourceVariants.genResourceVariants();
        while (vars.hasMoreElements()) {
            String resLoc = resourceBase + (String)vars.nextElement() + ".properties";
            InputStream is = jcl.getLocalResourceAsStream(resLoc);
            if (is != null) {
                foundResource = true;
                rb = new PropertyResourceBundle(is);
                is.close();
            }
            if (!foundResource) continue;
            break;
        }
        if (foundResource) {
            this.m_resBundle = rb;
        }
    }

    public String getDisplayName() {
        String sName = this.m_lid.getName() + " " + this.m_lid.getVersion();
        return sName;
    }

    public String getDescription() {
        if (this.m_resBundle == null) {
            try {
                this.loadBundle();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return this.m_resBundle.getString("Description");
    }

    @Override
    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    @Override
    public void writeXML(PrintWriter out) throws IOException {
        XMLElement element = this.buildDOMTree();
        element.print(out);
    }

    protected XMLElement buildDOMTree() {
        XMLElement elemLib = this.getUnknownXMLElement();
        elemLib = elemLib == null ? new XMLElement("LIB") : (XMLElement)elemLib.cloneNode(true);
        elemLib.setAttribute("NAME", this.m_lid.getName());
        elemLib.setAttribute("VER", this.m_lid.getVersion().getVerString());
        elemLib.setAttribute("REP_VER", this.m_lid.getReplaceVersion().getVerString());
        elemLib.setAttribute("MIN_INST_VER", this.m_lid.getInstVer().getVerString());
        elemLib.setAttribute("INV_LOC", this.m_loc);
        return elemLib;
    }

    void setUnknownXMLElement(XMLElement element) {
        this.m_unknownXMLElement = element;
    }

    XMLElement getUnknownXMLElement() {
        return this.m_unknownXMLElement;
    }
}

