/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.BitSet;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

abstract class OiiiInventoryXMLHandler41
extends OixsDefaultHandler {
    protected OiiiAreaInventory m_inventory;
    protected OiiiCompInvEntry m_curEntry;
    protected boolean m_bStageSession = false;
    protected String m_invLoc;

    OiiiInventoryXMLHandler41() throws SAXException {
    }

    public OiiiAreaInventory getInventory() {
        return this.m_inventory;
    }

    abstract OiisCompProperties getCompProperties(OiiiCompInvEntry var1);

    protected class OiiiProdHomeHandler
    extends OixsElementHandler {
        public OiiiProdHomeHandler() {
            super("PROD_HOME");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sDef = atts.getValue("DEF");
            if (sDef != null) {
                OiisCompProperties props = OiiiInventoryXMLHandler41.this.getCompProperties(OiiiInventoryXMLHandler41.this.m_curEntry);
                boolean bDefined = sDef.equalsIgnoreCase("true");
                props.setNoProdHomeAvailable(!bDefined);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiPreReqHandler
    extends OixsElementHandler {
        public OiiiPreReqHandler() {
            super("PRE_REQ");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sDef = atts.getValue("DEF");
            if (sDef != null) {
                OiisCompProperties props = OiiiInventoryXMLHandler41.this.getCompProperties(OiiiInventoryXMLHandler41.this.m_curEntry);
                boolean bDefined = sDef.equalsIgnoreCase("true");
                props.setNoPreReqAvailable(!bDefined);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiBookHandler
    extends OixsElementHandler {
        public OiiiBookHandler() {
            super("BOOK");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            if (sName != null) {
                OiisCompProperties props = OiiiInventoryXMLHandler41.this.getCompProperties(OiiiInventoryXMLHandler41.this.m_curEntry);
                props.setHelpBookName(sName);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiDestHandler
    extends OixsElementHandler {
        public OiiiDestHandler() {
            super("DST");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sDestList = atts.getValue("LIST");
            StringTokenizer st = new StringTokenizer(sDestList, " ");
            OiisDestinationIndexMapping dim = OiiiInventoryXMLHandler41.this.m_curEntry.getDestIndexMapping();
            if (dim == null) {
                dim = new OiisDestinationIndexMapping();
                OiiiInventoryXMLHandler41.this.m_curEntry.setDestIndexMapping(dim);
            }
            while (st.hasMoreTokens()) {
                String sDest = st.nextToken();
                dim.addDestination(sDest);
            }
            dim.commitInserts();
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiLangSetHandler
    extends OixsElementHandler {
        public OiiiLangSetHandler() {
            super("LANGSET");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sIdx = atts.getValue("IDX");
            String sBitSet = atts.getValue("BITSET");
            OiisLangIndexMapping lim = OiiiInventoryXMLHandler41.this.m_curEntry.getLangIndexMapping();
            if (lim == null) {
                lim = new OiisLangIndexMapping();
                OiiiInventoryXMLHandler41.this.m_curEntry.setLangIndexMapping(lim);
            }
            BitSet bs = OiilXMLHelper.getBitSetFromString(sBitSet);
            lim.addLangSet(bs);
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiLangHandler
    extends OixsElementHandler {
        public OiiiLangHandler() {
            super("LANG");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sList = atts.getValue("LIST");
            if (sList != null) {
                OiisLangIndexMapping lim = OiiiInventoryXMLHandler41.this.m_curEntry.getLangIndexMapping();
                if (lim == null) {
                    lim = new OiisLangIndexMapping();
                    OiiiInventoryXMLHandler41.this.m_curEntry.setLangIndexMapping(lim);
                }
                Vector vLangs = OiixLanguage.strToVect(sList);
                Locale[] langs = new Locale[vLangs.size()];
                for (int i = 0; i < vLangs.size(); ++i) {
                    langs[i] = (Locale)vLangs.elementAt(i);
                }
                lim.addLangs(langs);
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiPlatSetHandler
    extends OixsElementHandler {
        public OiiiPlatSetHandler() {
            super("PLATSET");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sIdx = atts.getValue("IDX");
            String sBitSet = atts.getValue("BITSET");
            OiisPlatIndexMapping pim = OiiiInventoryXMLHandler41.this.m_curEntry.getPlatIndexMapping();
            if (pim == null) {
                pim = new OiisPlatIndexMapping();
                OiiiInventoryXMLHandler41.this.m_curEntry.setPlatIndexMapping(pim);
            }
            BitSet bs = OiilXMLHelper.getBitSetFromString(sBitSet);
            pim.addPlatSet(bs);
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiPlatHandler
    extends OixsElementHandler {
        public OiiiPlatHandler() {
            super("PLAT");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sList = atts.getValue("LIST");
            if (sList != null) {
                OiisPlatIndexMapping pim = OiiiInventoryXMLHandler41.this.m_curEntry.getPlatIndexMapping();
                if (pim == null) {
                    pim = new OiisPlatIndexMapping();
                    OiiiInventoryXMLHandler41.this.m_curEntry.setPlatIndexMapping(pim);
                }
                pim.addPlats(OiilXMLHelper.getIntArrFromString(sList, " "));
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiCompJarInfoHandler
    extends OixsElementHandler {
        Properties m_properties;

        public OiiiCompJarInfoHandler() {
            super("CMP_JAR_INFO");
            this.m_properties = new Properties();
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            Properties prop;
            String sName = atts.getValue("NAME");
            String sValue = atts.getValue("VAL");
            OiisCompProperties compProps = OiiiInventoryXMLHandler41.this.getCompProperties(OiiiInventoryXMLHandler41.this.m_curEntry);
            OiisCompJarInfo cji = compProps.getCompJarInfo();
            if (cji == null) {
                cji = new OiisCompJarInfo();
                compProps.setCompJarInfo(cji);
            }
            if ((prop = cji.getProperties()) == null) {
                prop = new Properties();
                cji.setProperties(prop);
            }
            prop.setProperty(sName, sValue);
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiLocationsInfoHandler
    extends OixsElementHandler {
        public OiiiLocationsInfoHandler() {
            super("LOC_INFO");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sJarContentsLoc = atts.getValue("JAR_LOC");
            String sDiskNo = atts.getValue("DSK_NO");
            String sJarName = atts.getValue("JAR_NAME");
            String sFileGroupLoc = atts.getValue("FGRP_LOC");
            String sInstDefnLoc = atts.getValue("INST_DFN_LOC");
            if (OiiiInventoryXMLHandler41.this.m_bStageSession) {
                OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiInventoryXMLHandler41.this.m_curEntry;
                stgEntry.setJarContentsLoc(sJarContentsLoc);
                stgEntry.setLocation(sJarContentsLoc);
                stgEntry.setJarName(sJarName);
                try {
                    stgEntry.setDiskNumber(Integer.valueOf(sDiskNo));
                }
                catch (NumberFormatException e) {
                    stgEntry.setDiskNumber(1);
                }
                stgEntry.setGroupFilesLoc(sFileGroupLoc);
                stgEntry.setInstallDefnLoc(sInstDefnLoc);
                if (stgEntry.getResourceBundle() == null) {
                    stgEntry.setCompResourceBundle(null, OiiiInventoryXMLHandler41.this.m_invLoc);
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    protected class OiiiPatchsetPatchHandler
    extends OixsElementHandler {
        public OiiiPatchsetPatchHandler() {
            super("PS_PATCH");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sBaseVer = atts.getValue("BASE_VER");
            String sPlats = atts.getValue("PLAT");
            String sBasePlats = atts.getValue("BASE_PLAT");
            if (OiiiInventoryXMLHandler41.this.m_bStageSession) {
                Vector vErrs = new Vector();
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", vErrs);
                Vector vBasePlats = OiilXMLHelper.platCommonNames2IntVector(sBasePlats, " ", vErrs);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, new OiiiVersion(sBaseVer), vBasePlats);
                cid = OiiiCompIDPool.getInstance().get(cid);
                OiiiPatchInstallID pid = new OiiiPatchInstallID(cid, new OiiiVersion(sVer), vPlats);
                pid = (OiiiPatchInstallID)OiiiCompIDPool.getInstance().get(pid);
                OiiiStageCompInvEntry stgEntry = (OiiiStageCompInvEntry)OiiiInventoryXMLHandler41.this.m_curEntry;
                OiisPatchSetContents pstContents = stgEntry.getPatchSetContents();
                if (pstContents == null) {
                    Vector<OiiiPatchInstallID> vPatches = new Vector<OiiiPatchInstallID>();
                    vPatches.addElement(pid);
                    pstContents = new OiisPatchSetContents(vPatches);
                    stgEntry.setPatchSetContents(pstContents);
                } else {
                    pstContents.addPatch(pid);
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }
}

