/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimCompInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OiiiInstallUpdate {
    public static final int ARU_PRODUCTS_API = 0;
    public static final int ARU_RELEASES_API = 1;
    public static final int ARU_PLATFORMS_API = 2;
    public static final int ARU_LANGUAGES_API = 3;
    public static final int ARU_PRODUCT_GROUPS_API = 4;
    public static final int ARU_PRODUCT_RELEASES_API = 5;
    public static final int ARU_OUI_COMPONENTS_API = 6;
    public static final int ARU_BUG_ADVISORIES_API = 7;
    public static final int ARU_TABLE_SIZE = 8;
    public static final String[] s_aruConnectionLookup = new String[8];
    public static final String[] s_aruDirectoryLookup;
    public static final String ALL_PATCHES = "all";
    public static final String PATCH_PATCHES = "patch";
    public static final String PATCHSET_PATCHES = "patchset";
    private static final String ERROR_TAG = "error";
    private static final String PATCH_TAG = "patch";
    private static final String TOTAL_TAG = "total";
    private static final String RESULTS_TAG = "results";
    private static final String DATE_TAG = "date";
    private static final String ID_TAG = "id";
    private static final String TYPE_TAG = "type";
    private static final String PRODUCT_TAG = "product";
    private static final String STATUS_TAG = "status";
    private static final String ABSTRACT_TAG = "abstract";
    private static final String COMMENTS_TAG = "comments";
    private static final String BUG_TAG = "bug";
    private static final String PLATFORM_TAG = "platform";
    private static final String LANGUAGE_TAG = "language";
    private static final String RELEASE_TAG = "release";
    private static final String README_URL_TAG = "readme_url";
    private static final String PATCH_URL_TAG = "patch_url";
    private static final String SIZE_TAG = "size";
    private static final String OUI_COMPONENT_ID_TAG = "component_release";
    private static final String OUI_COMPONENT_NAME_TAG = "component_name";
    private static final String OUI_COMPONENT_RELEASE_TAG = "release_name";
    private static final String RELEASE_ID_TAG = "release_id";
    private static final String RELEASE_NAME_TAG = "release_name";
    private static final String ADV_PATCHES_TAG = "patches";
    private static final String ADV_BUGS_TAG = "bugs";
    private static final String ADV_ADVISORIES_TAG = "advisories";
    private static final String ADV_ADVISORY_TAG = "advisory";
    private static final String ADV_PATCH_TAG = "patch";
    private static final String ADV_ID_TAG = "id";
    private static final String ADV_VERSION_TAG = "version";
    private static final String ADV_IMPACT_TAG = "impact";
    private static final String ADV_SEVERITY_TAG = "severity";
    private static final String ADV_URL_TAG = "url";
    private static final String ADV_ABSTRACT_TAG = "abstract";
    private static final String ADV_ADVISORY_NAME_TAG = "name";
    private static final String ADV_RELEASE_DATE_TAG = "release_date";
    private static final String ADV_FIXESBUGS_TAG = "fixesbugs";
    private static final String ADV_FIXESBUG_TAG = "fixesbug";
    private static final String ADV_COMPONENTS_TAG = "components";
    private static final String ADV_COMPONENT_RELEASE_TAG = "component_release";
    private static final String ADV_BUG_TAG = "bug";
    private static final String ADV_RELEASE_TAG = "release";
    private static final String ADV_PLATFORMS_TAG = "platforms";
    private static final String ADV_PLATFORM_TAG = "platform";
    private static final String ADV_PRODUCT_TAG = "product";
    private static final String ADV_LANGUAGE_TAG = "language";
    private static final String ADV_TYPE_TAG = "type";
    private static String m_downloadDir;
    private static boolean m_bUseLocalCopy;
    private static boolean m_bRemove;
    public static ArrayList compsList;
    public static ARUAdvisoryBugData m_bugData;
    public static String m_cpuUrl;

    public static List getApplicableCPUList(String homeLoc) throws ParseException, IOException, SAXException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = null;
        if (null == iac) {
            throw new IOException(OiixResourceBundle.getString("S_LOG_INV_READ_HOME_ERROR", new Object[]{homeLoc}));
        }
        instInv = iac.getInstallInventory();
        if (null == instInv) {
            throw new IOException(OiixResourceBundle.getString("S_LOG_INV_READ_HOME_ERROR", new Object[]{homeLoc}));
        }
        OiiiOracleHomeInfo ohInfo = instInv.getHomeWithLocation(homeLoc);
        if (null == ohInfo) {
            throw new IOException(OiixResourceBundle.getString("S_HOME_LOC_NOT_FOUND", new Object[]{homeLoc}));
        }
        Vector vComps = instInv.getAllCompsVect(ohInfo.getIndex());
        ArrayList<OiiiCompInstallID> compList = new ArrayList<OiiiCompInstallID>();
        for (int i = 0; i < vComps.size(); ++i) {
            OiiiCompInvEntry cie = (OiiiCompInvEntry)vComps.elementAt(i);
            compList.add(cie.getCompInstallID());
        }
        List cpus = OiiiInstallUpdate.getApplicableCPUList(compList, instInv.getPlatform());
        return cpus;
    }

    public static List getApplicableCPUList(List componentList, int platform) throws ParseException, IOException, SAXException {
        if (null == componentList) {
            return null;
        }
        ArrayList compsListARU = new ArrayList();
        ArrayList releasesList = new ArrayList();
        ArrayList bugList = new ArrayList();
        ArrayList patchList = new ArrayList();
        OiiiInstallUpdate.parseARUXmls(compsListARU, releasesList, bugList, patchList);
        List compRelIDs = OiiiInstallUpdate.getCompReleaseIDs(compsListARU, componentList);
        int currentPlat = platform;
        ArrayList<OiiiPatchMetadata> cpuList = new ArrayList<OiiiPatchMetadata>();
        block0: for (int i = 0; i < patchList.size(); ++i) {
            int j;
            ARUAdvisoryData patchElement = (ARUAdvisoryData)patchList.get(i);
            ArrayList fixesBugList = patchElement.getFixesBugs();
            ArrayList platforms = patchElement.getPlatformIds();
            boolean bMatch = false;
            for (j = 0; j < platforms.size(); ++j) {
                int platId = OiiiInstallUpdate.parseInt((String)platforms.get(j));
                if (platId != currentPlat) continue;
                bMatch = true;
                break;
            }
            if (!bMatch) continue;
            for (j = 0; j < fixesBugList.size(); ++j) {
                ARUAdvisoryFixesBugData fixesbug = (ARUAdvisoryFixesBugData)fixesBugList.get(j);
                ArrayList AdvComps = fixesbug.getOuiComponents();
                int nMatches = 0;
                block3: for (int k = 0; k < AdvComps.size(); ++k) {
                    ARUAdvisoryOUIComponentData AdvComp = (ARUAdvisoryOUIComponentData)AdvComps.get(k);
                    bMatch = false;
                    for (int l = 0; l < compRelIDs.size(); ++l) {
                        int comp = (Integer)compRelIDs.get(l);
                        if (comp != AdvComp.getOuiComponentId()) continue;
                        ++nMatches;
                        continue block3;
                    }
                }
                if (nMatches != AdvComps.size()) continue;
                int bugno = patchElement.getPatchId();
                String version = OiiiInstallUpdate.getPatchVersion(releasesList, patchElement.getReleaseId());
                OiiiPatchMetadata patchMetadata = new OiiiPatchMetadata(bugno, currentPlat, version);
                patchMetadata.setType("cpus");
                cpuList.add(patchMetadata);
                bMatch = true;
                continue block0;
            }
        }
        return cpuList;
    }

    public static List getAllCPURequiredXmls() {
        ArrayList<String> xmlList = new ArrayList<String>();
        xmlList.add(s_aruDirectoryLookup[7]);
        xmlList.add(s_aruDirectoryLookup[6]);
        xmlList.add(s_aruDirectoryLookup[1]);
        return xmlList;
    }

    private static List getCompReleaseIDs(List compList, List compInstallIDs) {
        ArrayList<Integer> compReleaseIDs = new ArrayList<Integer>();
        block0: for (int i = 0; i < compInstallIDs.size(); ++i) {
            Object o = compInstallIDs.get(i);
            String name = "";
            String version = "";
            if (o instanceof OiiiCompInstallID) {
                OiiiCompInstallID compID = (OiiiCompInstallID)o;
                name = compID.getName().trim();
                version = compID.getVersion().getVerString().trim();
            } else if (o instanceof OiimCompInfo) {
                OiimCompInfo cID = (OiimCompInfo)o;
                name = cID.getName();
                version = cID.getVersion();
            }
            for (int j = 0; j < compList.size(); ++j) {
                ARUTableData ouiComp = (ARUTableData)compList.get(j);
                if (!name.equalsIgnoreCase(ouiComp.getOuiComponentName().trim()) || !version.equalsIgnoreCase(ouiComp.getOuiComponentRelease().trim())) continue;
                compReleaseIDs.add(new Integer(ouiComp.getOuiComponentId()));
                continue block0;
            }
        }
        return compReleaseIDs;
    }

    private static String getPatchVersion(List releaseList, int patchReleaseId) {
        for (int i = 0; i < releaseList.size(); ++i) {
            ARUTableData releaseElement = (ARUTableData)releaseList.get(i);
            if (releaseElement.getReleaseId() != patchReleaseId) continue;
            return releaseElement.getReleaseName();
        }
        return null;
    }

    private static void parseARUXmls(ArrayList compsList, ArrayList releasesList, ArrayList bugList, ArrayList patchList) throws ParseException, IOException, SAXException {
        if (null == compsList || null == releasesList || null == bugList || null == patchList) {
            return;
        }
        if (null == m_downloadDir || m_downloadDir.trim().length() == 0) {
            throw new IOException("Error: Download directory value can't be null");
        }
        String queryFile = OiixPathOps.concatPath(m_downloadDir, s_aruDirectoryLookup[7]);
        String componentsFile = OiixPathOps.concatPath(m_downloadDir, s_aruDirectoryLookup[6]);
        String releasesFile = OiixPathOps.concatPath(m_downloadDir, s_aruDirectoryLookup[1]);
        OiimARUConnection aruConn = null;
        if (m_bUseLocalCopy) {
            if (!new File(queryFile).exists()) {
                OiiolTextLogger.appendText("Flag is set to read from local copy ,but ARU XMLs are not found " + queryFile);
                throw new IOException("File Not found" + queryFile);
            }
            if (!new File(componentsFile).exists()) {
                OiiolTextLogger.appendText("Flag is set to read from local copy ,but ARU XMLs are not found" + componentsFile);
                throw new IOException("File Not found" + componentsFile);
            }
            if (!new File(releasesFile).exists()) {
                OiiolTextLogger.appendText("Flag is set to read from local copy ,but ARU XMLs are not found " + releasesFile);
                throw new IOException("File Not found" + releasesFile);
            }
        }
        if (!(m_bUseLocalCopy && new File(queryFile).exists() && new File(queryFile).exists())) {
            try {
                aruConn = OiimARUConnection.getAruConnection();
                if (m_cpuUrl == null) {
                    OiiolTextLogger.appendText("No CPU Tags mentioned in downloaded metadata xml,No CPUs will be downloaded");
                    return;
                }
                aruConn.downloadARUData(m_downloadDir, m_cpuUrl.trim());
            }
            catch (OiimARUAuthException e) {
                OiiolTextLogger.appendException(e);
                aruConn = null;
            }
        } else {
            OiiolTextLogger.appendText("Local copy has been set,not downloading ARU XMLs");
        }
        OiiolTextLogger.appendText("parsing " + queryFile);
        OiiiInstallUpdate.getAdvisoryData(queryFile, bugList, patchList);
        ARUAdvisoryBugData bugData = (ARUAdvisoryBugData)bugList.get(0);
        OiiiInstallUpdate.setAdvisoryBugData(bugData);
        OiiolTextLogger.appendText("parsing " + componentsFile);
        OiiiInstallUpdate.getARUComponentsList(componentsFile, compsList);
        OiiolTextLogger.appendText("parsing " + releasesFile);
        OiiiInstallUpdate.getARUReleasesList(releasesFile, releasesList);
        if (null != aruConn && m_bRemove) {
            aruConn.removeARUData(m_downloadDir);
        }
    }

    public static void setAdvisoryBugData(ARUAdvisoryBugData bugData) {
        m_bugData = bugData;
    }

    public static String getAbstract() {
        if (m_bugData != null) {
            return m_bugData.getAbstract();
        }
        return "";
    }

    public static String getImpact() {
        if (m_bugData != null) {
            return m_bugData.getImpact();
        }
        return "";
    }

    public static String getReleaseDate() {
        if (m_bugData != null) {
            return m_bugData.getReleaseDate();
        }
        return "";
    }

    public static int getSeverity() {
        if (m_bugData != null) {
            return m_bugData.getSeverity();
        }
        return 0;
    }

    public static String getUrl() {
        if (m_bugData != null) {
            return m_bugData.getUrl();
        }
        return "";
    }

    public static String getDisplayName() {
        if (m_bugData != null) {
            return m_bugData.getDisplayName();
        }
        return "";
    }

    public static void setDownloadDir(String dir) {
        m_downloadDir = dir;
    }

    public static void setFlagUseLocalCopy(boolean bLocal) {
        m_bUseLocalCopy = bLocal;
    }

    public static void removeARUXMLsAfterDownload(boolean bRemove) {
        m_bRemove = bRemove;
    }

    public static void setCPUUrl(String CPUUrl) {
        m_cpuUrl = CPUUrl;
    }

    private static void getARUComponentsList(String sFilename, List tableList) throws IOException, SAXException {
        ARUTableData tableData = new ARUTableData(7);
        Document theXMLDoc = null;
        try {
            theXMLDoc = OixdDOMReader.getDocument(sFilename);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        if (theXMLDoc.hasChildNodes()) {
            Node firstChild = theXMLDoc.getFirstChild();
            Node rowsetNode = firstChild.getNextSibling();
            if (rowsetNode == null) {
                rowsetNode = firstChild;
            }
            NodeList nl = rowsetNode.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node rowNode = nl.item(i);
                NodeList pl = rowNode.getChildNodes();
                for (int j = 0; j < pl.getLength(); ++j) {
                    Node child = pl.item(j);
                    if (child.getNodeName().equals("component_release")) {
                        tableData.setOuiComponentId(OiiiInstallUpdate.parseInt(child.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (child.getNodeName().equals(OUI_COMPONENT_NAME_TAG)) {
                        tableData.setOuiComponentName(child.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!child.getNodeName().equals("release_name")) continue;
                    tableData.setOuiComponentRelease(child.getFirstChild().getNodeValue());
                }
                if (!tableData.isValid()) continue;
                tableList.add(tableData);
                tableData = new ARUTableData(7);
            }
        }
    }

    public static ArrayList getCompsToInstall(String topLevel, String installType, String sourceLoc) throws IOException, SAXException {
        int i;
        String xmlPath = sourceLoc + File.separator + "ComponentList";
        xmlPath = xmlPath + File.separator + topLevel + "_" + installType + ".xml";
        Document theXMLDoc = null;
        try {
            theXMLDoc = OixdDOMReader.getDocument(xmlPath);
        }
        catch (ParserConfigurationException e) {
            OiiolTextLogger.appendException(e);
        }
        NodeList pl = theXMLDoc.getChildNodes();
        XMLElement comps = null;
        NodeList nl = null;
        for (i = 0; i < pl.getLength(); ++i) {
            Node child = pl.item(i);
            if (!child.getNodeName().equalsIgnoreCase("COMPS_LIST")) continue;
            comps = (XMLElement)child;
            nl = comps.getChildrenByTagName("COMP");
            break;
        }
        compsList.clear();
        for (i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            XMLElement child = (XMLElement)childNode;
            String name = child.getAttribute("NAME");
            String version = child.getAttribute("VERSION");
            compsList.add(new OiimCompInfo(name, version));
        }
        return compsList;
    }

    private static void getARUReleasesList(String sFilename, List tableList) throws IOException, SAXException {
        ARUTableData tableData = new ARUTableData(4);
        Document theXMLDoc = null;
        try {
            theXMLDoc = OixdDOMReader.getDocument(sFilename);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        if (theXMLDoc.hasChildNodes()) {
            Node firstChild = theXMLDoc.getFirstChild();
            Node rowsetNode = firstChild.getNextSibling();
            if (rowsetNode == null) {
                rowsetNode = firstChild;
            }
            NodeList nl = rowsetNode.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node rowNode = nl.item(i);
                NodeList pl = rowNode.getChildNodes();
                for (int j = 0; j < pl.getLength(); ++j) {
                    Node child = pl.item(j);
                    if (child.getNodeName().equals(RELEASE_ID_TAG)) {
                        tableData.setReleaseId(OiiiInstallUpdate.parseInt(child.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (!child.getNodeName().equals("release_name")) continue;
                    tableData.setReleaseName(child.getFirstChild().getNodeValue());
                }
                if (!tableData.isValid()) continue;
                tableList.add(tableData);
                tableData = new ARUTableData(4);
            }
        }
    }

    private static void getAdvisoryData(String sFilename, ArrayList o_bugList, ArrayList o_patchList) throws SAXException, IOException, ParseException {
        if (o_bugList == null || o_patchList == null) {
            return;
        }
        Document theXMLDoc = null;
        try {
            theXMLDoc = OixdDOMReader.getDocument(sFilename);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        if (theXMLDoc.hasChildNodes()) {
            XMLElement results = (XMLElement)theXMLDoc.getFirstChild();
            NodeList advisoriesList = results.getChildrenByTagName(ADV_ADVISORIES_TAG);
            for (int j = 0; j < advisoriesList.getLength(); ++j) {
                XMLElement advisories = (XMLElement)advisoriesList.item(j);
                String impact = advisories.getAttribute(ADV_IMPACT_TAG);
                ARUAdvisoryBugData bugData = null;
                NodeList nl = advisories.getChildrenByTagName(ADV_ADVISORY_TAG);
                for (int i = 0; i < nl.getLength(); ++i) {
                    XMLElement advisoryNode = (XMLElement)nl.item(i);
                    bugData = OiiiInstallUpdate.getAdvisoryBugDataFromXMLDoc(advisoryNode, impact);
                    o_bugList.add(bugData);
                }
            }
            XMLElement patches = (XMLElement)results.getChildrenByTagName(ADV_PATCHES_TAG).item(0);
            ARUAdvisoryData patchData = null;
            NodeList nl = patches.getChildrenByTagName("patch");
            for (int i = 0; i < nl.getLength(); ++i) {
                XMLElement patchNode = (XMLElement)nl.item(i);
                if (!patchNode.getAttribute("type").trim().equalsIgnoreCase("Patch")) continue;
                patchData = OiiiInstallUpdate.getAdvisoryDataFromXMLDoc(patchNode);
                o_patchList.add(patchData);
            }
        }
    }

    private static ARUAdvisoryBugData getAdvisoryBugDataFromXMLDoc(XMLElement advisoryNode, String impact) throws ParseException {
        int severity = Integer.parseInt(advisoryNode.getAttribute(ADV_SEVERITY_TAG));
        String url = advisoryNode.getAttribute(ADV_URL_TAG);
        String abstractText = advisoryNode.getAttribute("abstract");
        String displayName = advisoryNode.getAttribute(ADV_ADVISORY_NAME_TAG);
        String releaseDate = advisoryNode.getAttribute(ADV_RELEASE_DATE_TAG);
        ArrayList<String> bugIDList = new ArrayList<String>();
        XMLElement bugs = (XMLElement)advisoryNode.getChildrenByTagName(ADV_BUGS_TAG).item(0);
        NodeList nl = bugs.getChildrenByTagName("bug");
        for (int i = 0; i < nl.getLength(); ++i) {
            XMLElement bugNode = (XMLElement)nl.item(i);
            bugIDList.add(bugNode.getAttribute("id"));
        }
        ARUAdvisoryBugData bugData = new ARUAdvisoryBugData(bugIDList, impact, severity, url, abstractText, displayName, releaseDate);
        return bugData;
    }

    private static ARUAdvisoryData getAdvisoryDataFromXMLDoc(XMLElement patchNode) throws ParseException {
        int patchId = Integer.parseInt(patchNode.getAttribute("bug"));
        int releaseId = Integer.parseInt(patchNode.getAttribute("release"));
        int productId = Integer.parseInt(patchNode.getAttribute("product"));
        int languageId = 0;
        String languageStr = patchNode.getAttribute("language");
        if (languageStr != null && languageStr.length() > 0) {
            languageId = Integer.parseInt(languageStr);
        }
        String patchType = patchNode.getAttribute("type");
        XMLElement platforms = (XMLElement)patchNode.getChildrenByTagName(ADV_PLATFORMS_TAG).item(0);
        NodeList nl = platforms.getChildrenByTagName("platform");
        ArrayList<String> platformList = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            XMLElement platformNode = (XMLElement)nl.item(i);
            platformList.add(platformNode.getAttribute("id"));
        }
        XMLElement fixesBugs = (XMLElement)platforms.getChildrenByTagName(ADV_FIXESBUGS_TAG).item(0);
        ARUAdvisoryData patchData = new ARUAdvisoryData(patchId, releaseId, platformList, productId, languageId, patchType, OiiiInstallUpdate.getFixesBugInfo(fixesBugs));
        return patchData;
    }

    private static ArrayList getFixesBugInfo(XMLElement i_fixesBugsEl) {
        ArrayList<ARUAdvisoryFixesBugData> fixesBugs = new ArrayList<ARUAdvisoryFixesBugData>();
        if (i_fixesBugsEl == null) {
            return fixesBugs;
        }
        NodeList nll = i_fixesBugsEl.getChildrenByTagName(ADV_FIXESBUG_TAG);
        for (int i = 0; i < nll.getLength(); ++i) {
            XMLElement fixesBugEl = (XMLElement)nll.item(i);
            int bugId = Integer.parseInt(fixesBugEl.getAttribute("id"));
            ArrayList<ARUAdvisoryOUIComponentData> ouiComponents = new ArrayList<ARUAdvisoryOUIComponentData>();
            XMLElement ouiComponentsEl = (XMLElement)fixesBugEl.getChildrenByTagName(ADV_COMPONENTS_TAG).item(0);
            NodeList ouiNl = ouiComponentsEl.getChildrenByTagName("component_release");
            for (int j = 0; j < ouiNl.getLength(); ++j) {
                XMLElement ouiComponent = (XMLElement)ouiNl.item(j);
                int ouiId = Integer.parseInt(ouiComponent.getAttribute("id"));
                ouiComponents.add(new ARUAdvisoryOUIComponentData(ouiId));
            }
            ARUAdvisoryFixesBugData fixesBug = new ARUAdvisoryFixesBugData(bugId, ouiComponents);
            fixesBugs.add(fixesBug);
        }
        return fixesBugs;
    }

    private static int parseInt(String intStr) {
        int intVal = -1;
        if (intStr != null && intStr.trim().length() > 0) {
            try {
                intVal = Integer.parseInt(intStr.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return intVal;
    }

    public static void main(String[] args) {
        ArrayList<OiiiCompInstallID> comps = new ArrayList<OiiiCompInstallID>();
        OiiiVersion version = new OiiiVersion("10.1.0.3.0");
        OiiiCompInstallID cid1 = new OiiiCompInstallID("oracle.sysman.console.oms", version, null);
        comps.add(cid1);
        try {
            OiiiInstallUpdate.setDownloadDir("/home/radhinar/temp");
            List cpus = OiiiInstallUpdate.getApplicableCPUList(comps, 2000);
            System.out.println(cpus.size());
            for (int i = 0; i < cpus.size(); ++i) {
                OiiiPatchMetadata meta = (OiiiPatchMetadata)cpus.get(i);
                System.out.println(meta.getPatchBugNumber() + "," + meta.getVersion());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    static {
        OiiiInstallUpdate.s_aruConnectionLookup[0] = "/ARULink/XMLAPI/download_seed_data?table=aru_products";
        OiiiInstallUpdate.s_aruConnectionLookup[1] = "/ARULink/XMLAPI/download_seed_data?table=aru_releases";
        OiiiInstallUpdate.s_aruConnectionLookup[2] = "/ARULink/XMLAPI/download_seed_data?table=aru_platforms";
        OiiiInstallUpdate.s_aruConnectionLookup[3] = "/ARULink/XMLAPI/download_seed_data?table=aru_languages";
        OiiiInstallUpdate.s_aruConnectionLookup[4] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_groups";
        OiiiInstallUpdate.s_aruConnectionLookup[5] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_releases";
        OiiiInstallUpdate.s_aruConnectionLookup[6] = "/ARULink/XMLAPI/download_seed_data?table=aru_component_releases";
        OiiiInstallUpdate.s_aruConnectionLookup[7] = "/ARULink/XMLAPI/query_advisories";
        s_aruDirectoryLookup = new String[8];
        OiiiInstallUpdate.s_aruDirectoryLookup[0] = "aru_products.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[1] = "aru_releases.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[2] = "aru_platforms.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[3] = "aru_languages.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[4] = "aru_product_groups.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[5] = "aru_product_releases.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[6] = "aru_component_releases.xml";
        OiiiInstallUpdate.s_aruDirectoryLookup[7] = "query_advisories.xml";
        m_downloadDir = System.getProperty("oracle.installer.scratchPath");
        m_bUseLocalCopy = false;
        m_bRemove = true;
        compsList = new ArrayList();
        m_bugData = null;
        m_cpuUrl = null;
    }

    private static class ARUAdvisoryFixesBugData {
        private int m_bugId;
        private ArrayList m_ouiComponents;

        public ARUAdvisoryFixesBugData(int bugId, ArrayList ouiComponents) {
            this.m_bugId = bugId;
            this.m_ouiComponents = ouiComponents;
        }

        public int getBugId() {
            return this.m_bugId;
        }

        public ArrayList getOuiComponents() {
            return this.m_ouiComponents;
        }
    }

    private static class ARUAdvisoryOUIComponentData {
        private int m_ouiComponentId;

        public ARUAdvisoryOUIComponentData(int ouiComponentId) {
            this.m_ouiComponentId = ouiComponentId;
        }

        public int getOuiComponentId() {
            return this.m_ouiComponentId;
        }
    }

    private static class ARUAdvisoryBugData {
        private ArrayList m_bugIdList;
        private String m_impact;
        private int m_severity;
        private String m_url;
        private String m_abstract;
        private String m_displayName;
        private String m_releaseDate;

        public ARUAdvisoryBugData(ArrayList bugIdList, String impact, int severity, String url, String abstractText, String displayName, String releaseDate) {
            this.m_bugIdList = bugIdList;
            this.m_impact = impact;
            this.m_severity = severity;
            this.m_url = url;
            this.m_abstract = abstractText;
            this.m_displayName = displayName;
            this.m_releaseDate = releaseDate;
        }

        public ArrayList getBugIdList() {
            return this.m_bugIdList;
        }

        public String getImpact() {
            return this.m_impact;
        }

        public int getSeverity() {
            return this.m_severity;
        }

        public String getUrl() {
            return this.m_url;
        }

        public String getAbstract() {
            return this.m_abstract;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getReleaseDate() {
            return this.m_releaseDate;
        }
    }

    private static class ARUAdvisoryData {
        private int m_patchId;
        private ArrayList m_platformIds;
        private int m_productId;
        private int m_releaseId;
        private int m_languageId;
        private String m_patchType;
        private ArrayList m_fixesBugs = new ArrayList();

        public ARUAdvisoryData() {
        }

        public ARUAdvisoryData(int patchId, int releaseId, ArrayList platformIds, int productId, int languageId, String patchType, ArrayList fixesBugs) {
            this.m_patchId = patchId;
            this.m_platformIds = platformIds;
            this.m_productId = productId;
            this.m_releaseId = releaseId;
            this.m_languageId = languageId;
            this.m_patchType = patchType;
            this.m_fixesBugs = fixesBugs;
        }

        public int getPatchId() {
            return this.m_patchId;
        }

        public ArrayList getPlatformIds() {
            return this.m_platformIds;
        }

        public int getProductId() {
            return this.m_productId;
        }

        public int getReleaseId() {
            return this.m_releaseId;
        }

        public int getLanguageId() {
            return this.m_languageId;
        }

        public String getPatchType() {
            return this.m_patchType;
        }

        public ArrayList getFixesBugs() {
            return this.m_fixesBugs;
        }

        public void addFixesBug(ARUAdvisoryBugData fixesBug) {
            this.m_fixesBugs.add(fixesBug);
        }
    }

    private static class ARUTableData {
        public static final int S_ARU_PRODUCTS = 1;
        public static final int S_ARU_PLATFORMS = 2;
        public static final int S_ARU_LANGUAGES = 3;
        public static final int S_ARU_RELEASES = 4;
        public static final int S_ARU_PRODUCT_RELEASES = 5;
        public static final int S_ARU_PRODUCT_GROUPS = 6;
        public static final int S_ARU_OUI_COMPONENTS = 7;
        public static final int S_ARU_BUG_ADVISORIES = 8;
        public static final int S_FAMILY_ID_MASK = 1;
        public static final int S_FAMILY_NAME_MASK = 2;
        public static final int S_LANGUAGE_ID_MASK = 4;
        public static final int S_LANGUAGE_NAME_MASK = 8;
        public static final int S_PLATFORM_ID_MASK = 16;
        public static final int S_PLATFORM_NAME_MASK = 32;
        public static final int S_PRODUCT_ID_MASK = 64;
        public static final int S_PRODUCT_NAME_MASK = 128;
        public static final int S_RELEASE_ID_MASK = 256;
        public static final int S_RELEASE_NAME_MASK = 512;
        public static final int S_OUI_COMPONENT_ID_MASK = 1024;
        public static final int S_OUI_COMPONENT_NAME_MASK = 2048;
        public static final int S_OUI_COMPONENT_RELEASE_MASK = 4096;
        private int m_type = -1;
        private int m_mask = 0;
        private int m_familyId = -1;
        private String m_familyName = null;
        private int m_languageId = -1;
        private String m_languageName = null;
        private int m_platformId = -1;
        private String m_platformName = null;
        private int m_productId = -1;
        private String m_productName = null;
        private int m_releaseId = -1;
        private String m_releaseName = null;
        private int m_ouiComponentId = -1;
        private String m_ouiComponentName = null;
        private String m_ouiComponentRelease = null;

        public ARUTableData(int type) {
            this.m_type = type;
        }

        public int getType() {
            return this.m_type;
        }

        public void setType(int type) {
            this.m_type = type;
        }

        public int getMask() {
            return this.m_mask;
        }

        public void setMask(int mask) {
            this.m_mask = mask;
        }

        public int getFamilyId() {
            return this.m_familyId;
        }

        public void setFamilyId(int familyId) {
            this.m_familyId = familyId;
            this.m_mask |= 1;
        }

        public String getFamilyName() {
            return this.m_familyName;
        }

        public void setFamilyName(String familyName) {
            if (familyName != null) {
                this.m_familyName = familyName.trim();
                this.m_mask |= 2;
            }
        }

        public int getLanguageId() {
            return this.m_languageId;
        }

        public void setLanguageId(int languageId) {
            this.m_languageId = languageId;
            this.m_mask |= 4;
        }

        public String getLanguageName() {
            return this.m_languageName;
        }

        public void setLanguageName(String languageName) {
            if (languageName != null) {
                this.m_languageName = languageName.trim();
                this.m_mask |= 8;
            }
        }

        public int getPlatformId() {
            return this.m_platformId;
        }

        public void setPlatformId(int platformId) {
            this.m_platformId = platformId;
            this.m_mask |= 0x10;
        }

        public String getPlatformName() {
            return this.m_platformName;
        }

        public void setPlatformName(String platformName) {
            if (platformName != null) {
                this.m_platformName = platformName.trim();
                this.m_mask |= 0x20;
            }
        }

        public int getProductId() {
            return this.m_productId;
        }

        public void setProductId(int productId) {
            this.m_productId = productId;
            this.m_mask |= 0x40;
        }

        public String getProductName() {
            return this.m_productName;
        }

        public void setProductName(String productName) {
            if (productName != null) {
                this.m_productName = productName.trim();
                this.m_mask |= 0x80;
            }
        }

        public int getReleaseId() {
            return this.m_releaseId;
        }

        public void setReleaseId(int releaseId) {
            this.m_releaseId = releaseId;
            this.m_mask |= 0x100;
        }

        public String getReleaseName() {
            return this.m_releaseName;
        }

        public void setReleaseName(String releaseName) {
            if (releaseName != null) {
                this.m_releaseName = releaseName.trim();
                this.m_mask |= 0x200;
            }
        }

        public int getOuiComponentId() {
            return this.m_ouiComponentId;
        }

        public void setOuiComponentId(int componentId) {
            this.m_ouiComponentId = componentId;
            this.m_mask |= 0x400;
        }

        public String getOuiComponentName() {
            return this.m_ouiComponentName;
        }

        public void setOuiComponentName(String componentName) {
            if (componentName != null) {
                this.m_ouiComponentName = componentName.trim();
                this.m_mask |= 0x800;
            }
        }

        public String getOuiComponentRelease() {
            return this.m_ouiComponentRelease;
        }

        public void setOuiComponentRelease(String componentRelease) {
            if (componentRelease != null) {
                this.m_ouiComponentRelease = componentRelease.trim();
                this.m_mask |= 0x1000;
            }
        }

        public boolean isValid() {
            int mask = -1;
            switch (this.getType()) {
                case 1: {
                    mask = 192;
                    break;
                }
                case 2: {
                    mask = 48;
                    break;
                }
                case 3: {
                    mask = 12;
                    break;
                }
                case 4: {
                    mask = 768;
                    break;
                }
                case 5: {
                    mask = 320;
                    break;
                }
                case 6: {
                    mask = 65;
                    break;
                }
                case 7: {
                    mask = 7168;
                }
            }
            return (this.getMask() & mask) == mask;
        }
    }
}

