/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiiiInstallPatchSetInvEntry
extends OiiiInstallCompInvEntry {
    private Vector m_patches = null;

    public OiiiInstallPatchSetInvEntry(OiiiPatchSetInstallID psid, String installLoc) {
        super(psid, installLoc, new Vector(), new Vector(), null);
        Integer curPlat = new Integer(OiixPlatform.getCurrentPlatform());
        Vector<Integer> v = new Vector<Integer>(1);
        v.addElement(curPlat);
        this.setPlatforms(v);
        this.m_patches = new Vector();
    }

    public Vector getPatches() {
        return this.m_patches;
    }

    public void setPatches(Vector patches) {
        this.m_patches = patches;
    }

    public void removePatch(OiiiPatchInstallID pid) {
        int pIndex = OiixVectorOps.vectIndexOf(this.m_patches, (Object)pid);
        if (pIndex != -1) {
            this.m_patches.removeElementAt(pIndex);
        }
    }

    public void addPatch(OiiiPatchInstallID pid) {
        int pIndex = OiixVectorOps.vectIndexOf(this.m_patches, (Object)pid);
        if (pIndex != -1) {
            this.m_patches.addElement(pid);
        }
    }

    public boolean hasNoPatches() {
        return this.m_patches.isEmpty();
    }

    @Override
    protected XMLElement buildDOMTree() {
        XMLElement elemPS = super.buildDOMTree();
        elemPS.removeAttribute("LANGS");
        elemPS.removeAttribute("REP_VER");
        elemPS.removeAttribute("INST_LOC");
        for (int i = 0; i < this.m_patches.size(); ++i) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)this.m_patches.elementAt(i);
            XMLElement elemPSPatch = pid.getUnknownXMLElement();
            elemPSPatch = elemPSPatch == null ? new XMLElement("PS_PATCH") : (XMLElement)elemPSPatch.cloneNode(true);
            elemPSPatch.setAttribute("NAME", pid.getName());
            elemPSPatch.setAttribute("VER", pid.getVersion().getVerString());
            elemPSPatch.setAttribute("BASE_VER", pid.getBaseVersion().getVerString());
            if (pid.getHomeType() == 0) {
                elemPSPatch.setAttribute("NOH", "T");
            }
            elemPS.appendChild((Node)elemPSPatch);
        }
        return elemPS;
    }

    @Override
    protected XMLElement createXMLElement() {
        XMLElement element = this.getUnknownXMLElement("PATCHSET");
        element = element == null ? new XMLElement("PATCHSET") : (XMLElement)element.cloneNode(true);
        return element;
    }

    @Override
    public Vector getOneoffsVect() {
        return null;
    }
}

