/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffFile;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.AttributeList;

class OiiiInstallOneoffElementHandler
extends OixsElementHandler {
    private Vector m_vOneoffs;
    private Vector m_vReferencers;
    private Vector m_vBugList;
    private Vector m_vPrereqList;
    private Properties m_PropertyList;
    private int m_nHomeIndex;
    private int m_nCompHomeType;
    private Vector m_vInvPlat;
    private OiiiOneoffChildElementHandler m_handlerOneoff = new OiiiOneoffChildElementHandler("ONEOFF");
    private Hashtable m_hUnknownOneoffElements;

    public OiiiInstallOneoffElementHandler(String sName) {
        super(sName);
        this.addChildHandler("ONEOFF", this.m_handlerOneoff);
        this.m_vOneoffs = new Vector();
    }

    public void setHomeIndex(int homeIndex) {
        this.m_nHomeIndex = homeIndex;
    }

    Vector getOneoffs() {
        return this.m_vOneoffs;
    }

    void setCompHomeType(int compHomeType) {
        this.m_nCompHomeType = compHomeType;
    }

    void setInventoryPlatform(int invPlat) {
        this.m_vInvPlat = new Vector(1);
        this.m_vInvPlat.addElement(new Integer(invPlat));
    }

    private Vector getInventoryPlatform() {
        return this.m_vInvPlat;
    }

    private OiiiCompIdOhPair createCompIdOhPair(AttributeList atts) {
        String sName = atts.getValue("NAME");
        OiiiVersion version = new OiiiVersion(atts.getValue("VER"));
        String sHomeIndex = atts.getValue("HOME_IDX");
        int nHomeIndex = Integer.parseInt(sHomeIndex);
        OiiiCompInstallID cid = new OiiiCompInstallID(sName, version, this.getInventoryPlatform());
        if (nHomeIndex == 0) {
            cid.setHomeType(0);
        } else if (nHomeIndex == this.m_nHomeIndex) {
            cid.setHomeType(this.m_nCompHomeType);
        } else {
            cid.setHomeType(2);
        }
        cid = OiiiCompIDPool.getInstance().getElement(cid);
        OiiiCompIdOhPair cidOh = new OiiiCompIdOhPair(cid, nHomeIndex);
        return cidOh;
    }

    private class OiiiOneoffFileElementHandler
    extends OixsElementHandler {
        private Vector m_vFileList;
        private OiiiOneoffFile m_curFile;

        OiiiOneoffFileElementHandler(String name) {
            super(name);
            this.m_vFileList = new Vector(2);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String parentPath = atts.getValue("PARENT_PATH");
            String childFile = atts.getValue("CHILD_PATH");
            this.m_curFile = new OiiiOneoffFile(parentPath, childFile);
            if (!this.m_vFileList.contains(this.m_curFile)) {
                this.m_vFileList.addElement(this.m_curFile);
            }
        }

        @Override
        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_curFile.setUnknownXMLElement(element);
            }
        }

        void setFiles(Vector files) {
            this.m_vFileList = files;
        }

        Vector getFileList() {
            return this.m_vFileList;
        }
    }

    private class OiiiOneoffIDElementHandler
    extends OixsTextElementHandler {
        private OiiiInstallOneoffInvEntry m_curOneoffInvEntry;
        private Vector m_vLangs;
        private String m_uniqID;
        private String m_oId;
        private Vector m_vOneOffList;

        OiiiOneoffIDElementHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            this.m_oId = atts.getValue("REF_ID");
            this.m_uniqID = atts.getValue("UNIQ_ID");
            this.m_vLangs = OiixLanguage.strToVect(atts.getValue("LANGS"));
        }

        @Override
        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("", element);
            }
            try {
                this.m_curOneoffInvEntry = new OiiiInstallOneoffInvEntry(this.m_oId, new Vector(), false, OiiiInstallOneoffElementHandler.this.m_nHomeIndex, "", new Vector(), this.m_vLangs, this.m_uniqID);
            }
            catch (OiiiOneoffException e) {
                e.printStackTrace();
            }
            this.m_vOneOffList.addElement(this.m_curOneoffInvEntry);
        }

        void setOneOffList(Vector vOneOffList) {
            this.m_vOneOffList = vOneOffList;
        }

        Vector getOneOffList() {
            return this.m_vOneOffList;
        }
    }

    private class OiiiOneoffPropertyElementHandler
    extends OixsTextElementHandler {
        private Properties m_vPropertyList;

        OiiiOneoffPropertyElementHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String propName = atts.getValue("NAME");
            String propValue = atts.getValue("VAL");
            this.m_vPropertyList.setProperty(propName, propValue);
        }

        @Override
        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                // empty if block
            }
        }

        void setPropertiesList(Properties propertyList) {
            this.m_vPropertyList = propertyList;
        }

        Properties getPropertiesList() {
            return this.m_vPropertyList;
        }
    }

    private class OiiiOneoffPrereqElementHandler
    extends OixsTextElementHandler {
        private Vector m_vPrereqList;

        OiiiOneoffPrereqElementHandler(String name) {
            super(name);
        }

        @Override
        public void onEnd(String name) {
            super.onEnd(name);
            String sId = this.getText();
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put(sId, element);
            }
            this.m_vPrereqList.addElement(this.getText());
        }

        void setPrereqList(Vector prereqList) {
            this.m_vPrereqList = prereqList;
        }

        Vector getPrereqList() {
            return this.m_vPrereqList;
        }
    }

    private class OiiiOneoffBugElementHandler
    extends OixsTextElementHandler {
        private Vector m_vBugList;

        OiiiOneoffBugElementHandler(String name) {
            super(name);
        }

        @Override
        public void onEnd(String name) {
            super.onEnd(name);
            String sId = this.getText();
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put(sId, element);
            }
            this.m_vBugList.addElement(this.getText());
        }

        void setBugList(Vector bugList) {
            this.m_vBugList = bugList;
        }

        Vector getBugList() {
            return this.m_vBugList;
        }
    }

    private class OiiiOneoffRefElementHandler
    extends OixsElementHandler {
        private Vector m_vReferencers;
        private OiiiCompIdOhPair m_curRef;

        OiiiOneoffRefElementHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            this.m_curRef = OiiiInstallOneoffElementHandler.this.createCompIdOhPair(atts);
            this.m_vReferencers.addElement(this.m_curRef);
        }

        @Override
        public void onEnd(String name) {
            XMLElement element = this.getUnknownXMLElement();
            if (!OixsXMLOps.isEmpty(element)) {
                this.m_curRef.setUnknownXMLElement(element);
            }
        }

        void setReferencers(Vector referencers) {
            this.m_vReferencers = referencers;
        }

        Vector getReferencers() {
            return this.m_vReferencers;
        }
    }

    private class OiiiOneoffChildElementHandler
    extends OixsElementHandler {
        private OiiiInstallOneoffInvEntry m_curOneoffInvEntry;
        private String m_sOneoffId;
        private String m_uniqID;
        private String m_langs;
        private boolean m_bRollback;
        private Date m_dInstallTime;
        private String m_sXMLInvLoc;
        private OiiiVersion m_instVer;
        private OixsElementHandler m_handlerRefList;
        private OixsElementHandler m_handlerBugList;
        private OixsElementHandler m_handlerFileList;
        private OixsElementHandler m_handlerPrereqIDList;
        private OixsElementHandler m_handlerPropertyList;
        private OiiiOneoffRefElementHandler m_handlerRef;
        private OiiiOneoffBugElementHandler m_handlerBug;
        private OiiiOneoffPrereqElementHandler m_handlerPrereqID;
        private OiiiOneoffPropertyElementHandler m_handlerProperty;
        private OiiiOneoffFileElementHandler m_handlerFile;
        private OixsElementHandler m_handlerSupersedes;
        private OixsElementHandler m_handlerSupersededBy;
        private OiiiOneoffIDElementHandler m_handlerOneOffID_Supersedes;
        private OiiiOneoffIDElementHandler m_handlerOneOffID_SupersededBy;
        private OixsTextElementHandler m_handlerDesc;

        public OiiiOneoffChildElementHandler(String sName) {
            super(sName);
            this.m_handlerDesc = new OixsTextElementHandler();
            this.m_handlerRefList = new OixsElementHandler("REF_LIST");
            this.m_handlerBugList = new OixsElementHandler("BUG_LIST");
            this.m_handlerPrereqIDList = new OixsElementHandler("PREREQID_LIST");
            this.m_handlerPropertyList = new OixsElementHandler("PROPERTY_LIST");
            this.m_handlerFileList = new OixsElementHandler("FILE_LIST");
            this.m_handlerSupersedes = new OixsElementHandler("SUPERSEDES");
            this.m_handlerSupersededBy = new OixsElementHandler("SUPERSEDED_BY");
            this.m_handlerRef = new OiiiOneoffRefElementHandler("REF");
            this.m_handlerBug = new OiiiOneoffBugElementHandler("BUG");
            this.m_handlerPrereqID = new OiiiOneoffPrereqElementHandler("PREREQID");
            this.m_handlerProperty = new OiiiOneoffPropertyElementHandler("PROPERTY");
            this.m_handlerFile = new OiiiOneoffFileElementHandler("FILE");
            this.m_handlerOneOffID_Supersedes = new OiiiOneoffIDElementHandler("REF_ID");
            this.m_handlerOneOffID_SupersededBy = new OiiiOneoffIDElementHandler("REF_ID");
            this.addChildHandler("REF_LIST", this.m_handlerRefList);
            this.addChildHandler("BUG_LIST", this.m_handlerBugList);
            this.addChildHandler("PREREQID_LIST", this.m_handlerPrereqIDList);
            this.addChildHandler("PROPERTY_LIST", this.m_handlerPropertyList);
            this.addChildHandler("FILE_LIST", this.m_handlerFileList);
            this.addChildHandler("DESC", this.m_handlerDesc);
            this.addChildHandler("SUPERSEDES", this.m_handlerSupersedes);
            this.addChildHandler("SUPERSEDED_BY", this.m_handlerSupersededBy);
            this.m_handlerRefList.addChildHandler("REF", this.m_handlerRef);
            this.m_handlerBugList.addChildHandler("BUG", this.m_handlerBug);
            this.m_handlerPrereqIDList.addChildHandler("PREREQID", this.m_handlerPrereqID);
            this.m_handlerPropertyList.addChildHandler("PROPERTY", this.m_handlerProperty);
            this.m_handlerFileList.addChildHandler("FILE", this.m_handlerFile);
            this.m_handlerSupersedes.addChildHandler("REF_ID", this.m_handlerOneOffID_Supersedes);
            this.m_handlerSupersededBy.addChildHandler("REF_ID", this.m_handlerOneOffID_SupersededBy);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sVersion;
            this.m_handlerRef.setReferencers(new Vector());
            this.m_handlerBug.setBugList(new Vector());
            this.m_handlerPrereqID.setPrereqList(new Vector());
            this.m_handlerProperty.setPropertiesList(new Properties());
            this.m_handlerFile.setFiles(new Vector());
            this.m_handlerOneOffID_Supersedes.setOneOffList(new Vector());
            this.m_handlerOneOffID_SupersededBy.setOneOffList(new Vector());
            OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements = new Hashtable();
            this.m_sOneoffId = atts.getValue("REF_ID");
            this.m_uniqID = atts.getValue("UNIQ_ID");
            String sBoolean = atts.getValue("ROLLBACK");
            if (sBoolean.equals("T")) {
                this.m_bRollback = true;
            }
            this.m_sXMLInvLoc = atts.getValue("XML_INV_LOC");
            String sInstallTime = atts.getValue("INSTALL_TIME");
            if (sInstallTime != null && sInstallTime.length() > 0) {
                try {
                    this.m_dInstallTime = new SimpleDateFormat("yyyy.MMM.dd HH:mm:ss zzz", OiixLanguage.ENGLISH).parse(sInstallTime);
                }
                catch (ParseException e) {
                    System.err.println("sInstallTime = >" + sInstallTime + "<");
                    e.printStackTrace();
                }
            }
            if ((sVersion = atts.getValue("ACT_INST_VER")) != null) {
                this.m_instVer = new OiiiVersion(sVersion);
            }
            this.m_langs = atts.getValue("LANGS");
        }

        @Override
        public void onEnd(String name) {
            try {
                Vector languages = OiixLanguage.strToVect(this.m_langs);
                this.m_curOneoffInvEntry = new OiiiInstallOneoffInvEntry(this.m_sOneoffId, OiiiInstallOneoffElementHandler.this.m_vBugList, this.m_bRollback, OiiiInstallOneoffElementHandler.this.m_nHomeIndex, "", OiiiInstallOneoffElementHandler.this.m_vPrereqList, languages, this.m_uniqID);
                this.m_curOneoffInvEntry.setXmlInventoryLocation(this.m_sXMLInvLoc);
                this.m_curOneoffInvEntry.setBaseComps(this.m_handlerRef.getReferencers());
                Vector vBugList = this.m_handlerBug.getBugList();
                if (vBugList.size() == 1) {
                    String sBugsList = (String)vBugList.elementAt(0);
                    StringTokenizer st = new StringTokenizer(sBugsList, " ");
                    Vector<String> vFixedBugList = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        String sBug = st.nextToken().trim();
                        if (sBug.length() <= 0) continue;
                        vFixedBugList.addElement(sBug);
                    }
                    this.m_curOneoffInvEntry.setBugList(vFixedBugList);
                } else {
                    this.m_curOneoffInvEntry.setBugList(this.m_handlerBug.getBugList());
                }
                this.m_curOneoffInvEntry.setPrereqList(this.m_handlerPrereqID.getPrereqList());
                this.m_curOneoffInvEntry.setPropertyList(this.m_handlerProperty.getPropertiesList());
                this.m_curOneoffInvEntry.setDescription(this.m_handlerDesc.getText());
                this.m_curOneoffInvEntry.setInvFilesList(this.m_handlerFile.getFileList());
                this.m_curOneoffInvEntry.setTimestamp(this.m_dInstallTime);
                this.m_curOneoffInvEntry.setSupersededOneOffsList(this.m_handlerOneOffID_Supersedes.getOneOffList());
                this.m_curOneoffInvEntry.setSupersededByOneOffsList(this.m_handlerOneOffID_SupersededBy.getOneOffList());
                this.m_curOneoffInvEntry.setInstallerVersion(this.m_instVer);
                XMLElement element = this.getUnknownXMLElement();
                if (!OixsXMLOps.isEmpty(element)) {
                    this.m_curOneoffInvEntry.setUnknownXMLElement(element);
                }
                XMLElement refListEl = this.m_handlerRefList.getUnknownXMLElement();
                XMLElement bugListEl = this.m_handlerBugList.getUnknownXMLElement();
                XMLElement prereqListEl = this.m_handlerPrereqIDList.getUnknownXMLElement();
                XMLElement propertyListEl = this.m_handlerPropertyList.getUnknownXMLElement();
                XMLElement fileListEl = this.m_handlerFileList.getUnknownXMLElement();
                if (!OixsXMLOps.isEmpty(refListEl)) {
                    OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("REF_LIST", refListEl);
                }
                if (!OixsXMLOps.isEmpty(bugListEl)) {
                    OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("BUG_LIST", bugListEl);
                }
                if (!OixsXMLOps.isEmpty(prereqListEl)) {
                    OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("PREREQID_LIST", prereqListEl);
                }
                if (!OixsXMLOps.isEmpty(propertyListEl)) {
                    OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("PROPERTY_LIST", propertyListEl);
                }
                if (!OixsXMLOps.isEmpty(fileListEl)) {
                    OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements.put("FILE_LIST", fileListEl);
                }
                this.m_curOneoffInvEntry.setUnknownXMLElementTable(OiiiInstallOneoffElementHandler.this.m_hUnknownOneoffElements);
                OiiiInstallOneoffElementHandler.this.m_vOneoffs.addElement(this.m_curOneoffInvEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

