/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLInstallLog;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiiiInstallLogManipulator {
    private static final int[] PHASES = new int[]{1, 2, 8};
    OiiiCompIdOhPair m_IdOh = null;
    OiiiInstallCompInvEntry m_icie = null;
    private boolean m_bInstall = true;

    public OiiiInstallLogManipulator(OiiiInstallCompInvEntry icie, OiiiCompIdOhPair IdOh, boolean bInstall) {
        this.m_IdOh = IdOh;
        this.m_icie = icie;
        this.m_bInstall = bInstall;
    }

    public static int[] getPhases(boolean bInstall) {
        int[] iaPhases = bInstall ? new int[]{1, 2, 8} : new int[]{8, 2, 1, 16};
        return iaPhases;
    }

    public static OiiiVersion getSinglePhaseVersion() {
        return new OiiiVersion("2.3.0.2.0");
    }

    public Vector getInstallLogManipulators() {
        return this.get23InstallLogManipulators();
    }

    public Vector getInstallLogManipulator(int phase) {
        Vector<OiiolXMLInstallLog> logManips = new Vector<OiiolXMLInstallLog>();
        if (phase == 16 && !this.m_bInstall) {
            return this.getLangAddOnManipulator(logManips);
        }
        String sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), phase);
        if (sLogLoc != null) {
            logManips.addElement(new OiiolXMLInstallLog(sLogLoc));
        }
        return logManips;
    }

    private Vector getLangAddOnManipulator(Vector logManips) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String[] langAddonLogFiles = iac.getLangAddonXMLLogLocationsForDeinstall(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory());
        if (langAddonLogFiles != null) {
            logManips.removeAllElements();
            for (int i = 0; i < langAddonLogFiles.length; ++i) {
                logManips.addElement(new OiiolXMLInstallLog(langAddonLogFiles[i]));
            }
        }
        return logManips;
    }

    public Vector get23InstallLogManipulators() {
        OiiiInstallAreaControl iac;
        Vector<OiiolXMLInstallLog> logManips = new Vector<OiiolXMLInstallLog>(PHASES.length);
        String sLogLoc = null;
        int j = 0;
        for (int i = PHASES.length - 1; j < PHASES.length && i >= 0; ++j, --i) {
            if (this.m_bInstall ? (sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), PHASES[j])) == null : (sLogLoc = this.get23LogLoc(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory(), PHASES[i])) == null) continue;
            logManips.addElement(new OiiolXMLInstallLog(sLogLoc));
        }
        String[] langAddonLogFiles = null;
        if (!this.m_bInstall && (langAddonLogFiles = (iac = OiiiInstallAreaControl.getInstallAreaControl()).getLangAddonXMLLogLocationsForDeinstall(this.m_IdOh.getOHIndex(), this.m_icie.getLocationInXMLInventory())) != null) {
            int i;
            Vector normalLogManips = (Vector)logManips.clone();
            logManips.removeAllElements();
            for (i = 0; i < langAddonLogFiles.length; ++i) {
                logManips.addElement(new OiiolXMLInstallLog(langAddonLogFiles[i]));
            }
            for (i = 0; i < normalLogManips.size(); ++i) {
                logManips.addElement((OiiolXMLInstallLog)normalLogManips.elementAt(i));
            }
        }
        return logManips;
    }

    private String get23LogLoc(int index, String location, int phase) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -3 && phase == PHASES[1]) {
            return null;
        }
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLogLoc = iac.getXMLLogLoc(index, location, phase);
        return sLogLoc;
    }
}

