/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.sysman.oii.oiii.OiiiCompsXMLHandler;
import oracle.sysman.oii.oiii.OiiiDetailedHomeInfo;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLReader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiHomeInventoryUtil {
    private static Map aruMap = new HashMap(1);
    private static Map platMap = new HashMap(1);

    public static int getAruId(String homeLocation) {
        OiiiOracleHomeInfo homeInfo = new OiiiOracleHomeInfo(0, homeLocation, 0);
        String xml = OiiiInstallAreaControl.getOHPropertiesFileLoc(homeLocation);
        OiiiOracleHomeInfoXMLReader xmlReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
        xmlReader.updateHomeProperties(homeInfo, xml);
        return homeInfo.getARUID();
    }

    public static int getPlatformId(int aruId) {
        return OiiiHomeInventoryUtil.getMap(aruMap, aruId);
    }

    public static int getAruId(int platformId) {
        return OiiiHomeInventoryUtil.getMap(platMap, platformId);
    }

    private static int getMap(Map map, int id) {
        if (map.containsKey(id)) {
            return (Integer)map.get(id);
        }
        return id;
    }

    public static boolean isValid(int platformId, String home) {
        return OiiiHomeInventoryUtil.getAruId(home) == OiiiHomeInventoryUtil.getAruId(platformId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OiiiDetailedHomeInfo readComps(String homeLocation, String compName) throws IOException {
        if (homeLocation != null && !homeLocation.equals("")) {
            String compsFilePath = OiixPathOps.concatPath(homeLocation, "inventory");
            compsFilePath = OiixPathOps.concatPath(compsFilePath, "ContentsXML");
            compsFilePath = OiixPathOps.directorify(compsFilePath);
            compsFilePath = OiixPathOps.concatPath(compsFilePath, "comps.xml");
            compsFilePath = OiixPathOps.getStandardForm(compsFilePath);
            OiiolTextLogger.appendText("comps.xml file path = " + compsFilePath);
            OiiiCompsXMLHandler handler = null;
            FileInputStream fReader = null;
            BufferedInputStream bReader = null;
            try {
                Parser parser;
                block10: {
                    parser = OixsXMLOps.createSAXParser();
                    handler = new OiiiCompsXMLHandler();
                    parser.setDocumentHandler(handler);
                    parser.setErrorHandler(handler);
                    try {
                        fReader = new FileInputStream(compsFilePath);
                        bReader = new BufferedInputStream(fReader);
                    }
                    catch (FileNotFoundException e) {
                        Object[] sArgs = new String[]{compsFilePath};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INV_READ_ERROR", sArgs));
                        File fComps = new File(compsFilePath);
                        if (!fComps.exists() || fComps.canRead()) break block10;
                        throw new IOException(e.getMessage());
                    }
                }
                parser.parse(new InputSource(bReader));
                OiiiDetailedHomeInfo oiiiDetailedHomeInfo = handler.getDetailedCompsInfo(compName);
                return oiiiDetailedHomeInfo;
            }
            catch (SAXException se) {
                OiiolTextLogger.appendException(se);
            }
            finally {
                if (fReader != null) {
                    fReader.close();
                }
                if (bReader != null) {
                    bReader.close();
                }
            }
        }
        return null;
    }

    public static OiiiDetailedHomeInfo readComps(String homeLocation) throws IOException {
        return OiiiHomeInventoryUtil.readComps(homeLocation, "");
    }

    static {
        aruMap.put(319, 610);
        platMap.put(615, 912);
        platMap.put(50, 912);
        platMap.put(249, 227);
        platMap.put(522, 293);
        platMap.put(601, 912);
        platMap.put(610, 319);
    }
}

