/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiiFileMapInventory {
    private Vector m_perHomeFileMaps;
    private OiiiFileMap m_nohFileMap;

    public OiiiFileMapInventory(Vector homes, String sCentralInvLoc) {
        OiiiOracleHomeInfo nohInfo = new OiiiOracleHomeInfo(0, sCentralInvLoc, "Independent Products", 2);
        this.m_nohFileMap = new OiiiFileMap(nohInfo, sCentralInvLoc);
        int nHomeCount = homes.size();
        this.m_perHomeFileMaps = new Vector(nHomeCount);
        for (int i = 0; i < nHomeCount; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
            String sHomeLoc = OiixPathOps.getStandardForm(homeInfo.getLocation());
            String sHomeInvLoc = OiixPathOps.concatPath(sHomeLoc, "inventory");
            OiiiFileMap fileMap = new OiiiFileMap(homeInfo, sHomeInvLoc);
            this.m_perHomeFileMaps.addElement(fileMap);
        }
    }

    public OiiiFileMap getFileMapForHome(String sHomeLoc) {
        int idx = OiixVectorOps.vectIndexOf(this.m_perHomeFileMaps, (Object)sHomeLoc);
        OiiiFileMap fileMap = null;
        if (idx != -1) {
            fileMap = (OiiiFileMap)this.m_perHomeFileMaps.elementAt(idx);
        } else if (this.m_nohFileMap.equals(sHomeLoc)) {
            fileMap = this.m_nohFileMap;
        }
        return fileMap;
    }

    public OiiiFileMap createFileMapForHome(String sHomeLoc) {
        OiiiOracleHomeInfo homeInfo = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory().getHomeWithLocation(sHomeLoc);
        String sHomeInvLoc = OiixPathOps.concatPath(sHomeLoc, "inventory");
        OiiiFileMap fileMap = new OiiiFileMap(homeInfo, sHomeInvLoc);
        this.m_perHomeFileMaps.addElement(fileMap);
        return fileMap;
    }

    public OiiiFileMap createNOHFileMap(String sCentralInvLoc) {
        return null;
    }

    public void save() throws IOException {
        this.m_nohFileMap.save();
        Enumeration en = this.m_perHomeFileMaps.elements();
        while (en.hasMoreElements()) {
            OiiiFileMap fileMap = (OiiiFileMap)en.nextElement();
            fileMap.save();
        }
    }

    public void saveLeastUsed() throws IOException {
        this.m_nohFileMap.saveLeastUsed();
        Enumeration en = this.m_perHomeFileMaps.elements();
        while (en.hasMoreElements()) {
            OiiiFileMap fileMap = (OiiiFileMap)en.nextElement();
            fileMap.saveLeastUsed();
        }
    }
}

