/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiConfigToolID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class OiiiConfigXMLHandler
extends OixsDefaultHandler {
    OixsElementHandler m_handlerConfigTools;
    OixsElementHandler m_handlerComp;
    OixsElementHandler m_handlerPatch;
    private OiiiAreaInventory m_inventory;
    private OiiiCompInvEntry m_curEntry;
    private int m_homeIndex;

    OiiiConfigXMLHandler(OiiiAreaInventory inv) throws SAXException {
        this(inv, 0);
    }

    OiiiConfigXMLHandler(OiiiAreaInventory inv, int homeIndex) throws SAXException {
        this.m_inventory = inv;
        this.m_homeIndex = homeIndex;
    }

    @Override
    public OixsElementHandler createElementHandlers() {
        this.m_handlerConfigTools = new OixsElementHandler("CONFIG_LIST");
        this.m_handlerComp = new OiiiCompHandler("COMP");
        this.m_handlerPatch = new OiiiPatchHandler("PATCH");
        this.m_handlerConfigTools.addChildHandler("COMP", this.m_handlerComp);
        this.m_handlerConfigTools.addChildHandler("PATCH", this.m_handlerPatch);
        return this.m_handlerConfigTools;
    }

    private class OiiiSuppressConfigToolHandler
    extends OixsElementHandler {
        OiiiSuppressConfigToolHandler() {
            super("SUP_CT");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiiiConfigXMLHandler.this.m_curEntry != null) {
                String sIntName = atts.getValue("INT_NAME");
                String sCompName = atts.getValue("CMP_NAME");
                String sVer = atts.getValue("VER");
                String sPlats = atts.getValue("PLAT");
                if (sIntName != null && sCompName != null && sVer != null) {
                    OiiiVersion oVer = new OiiiVersion(sVer);
                    Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                    OiiiCompInstallID cid = new OiiiCompInstallID(sCompName, oVer, vPlats);
                    OiiiConfigToolID cfgid = new OiiiConfigToolID(sIntName, cid);
                    OiisCompProperties props = OiiiConfigXMLHandler.this.m_curEntry.getCompProperties();
                    if (props != null) {
                        props.addConfigToolToSuppress(cfgid);
                    }
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiConfigToolHandler
    extends OixsElementHandler {
        OiiiConfigToolHandler() {
            super("CT");
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            if (OiiiConfigXMLHandler.this.m_curEntry != null) {
                String sName = atts.getValue("NAME");
                String sNameID = atts.getValue("NAME_ID");
                String sDescID = atts.getValue("DESC_ID");
                String sLoc = atts.getValue("LOC");
                String sPlat = atts.getValue("PLAT");
                String sAggregateName = atts.getValue("AGGREGATE_NAME");
                String sClassName = atts.getValue("CLS_NAME");
                int[] iaPlats = OiilXMLHelper.platCommonNames2IntArray(sPlat, " ", null);
                OiiiConfigToolID cid = new OiiiConfigToolID(sName, OiiiConfigXMLHandler.this.m_curEntry.getCompInstallID());
                OiisConfigToolDetails configToolDetails = new OiisConfigToolDetails(cid, sNameID, sDescID);
                if (sLoc != null) {
                    configToolDetails.setLocation(sLoc);
                }
                configToolDetails.setPlatforms(iaPlats);
                configToolDetails.setAggregateName(sAggregateName);
                configToolDetails.setToolClassName(sClassName);
                OiisCompProperties props = OiiiConfigXMLHandler.this.m_curEntry.getCompProperties();
                if (props != null) {
                    props.addConfigToolDetails(configToolDetails);
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiPatchHandler
    extends OiiiCompHandler {
        OiiiPatchHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            String sBaseVer = atts.getValue("BASE_VER");
            String sBasePlats = atts.getValue("BASE_PLAT");
            if (sName != null && sBaseVer != null) {
                OiiiVersion oBaseVer = new OiiiVersion(sBaseVer);
                Vector vBasePlats = OiilXMLHelper.platCommonNames2IntVector(sBasePlats, " ", null);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oBaseVer, vBasePlats);
                if (sVer != null) {
                    OiiiVersion oVer = new OiiiVersion(sVer);
                    Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                    OiiiPatchInstallID pid = new OiiiPatchInstallID(cid, oVer, vPlats);
                    if (System.getProperty("osp.properties.file") != null) {
                        OiiiConfigXMLHandler.this.m_curEntry = OiiiConfigXMLHandler.this.m_inventory.getCompInvEntry(pid, OiiiConfigXMLHandler.this.m_homeIndex, vPlats);
                    } else {
                        OiiiConfigXMLHandler.this.m_curEntry = OiiiConfigXMLHandler.this.m_inventory.getCompInvEntry(pid, OiiiConfigXMLHandler.this.m_homeIndex);
                    }
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }

    private class OiiiCompHandler
    extends OixsElementHandler {
        private OixsElementHandler m_handlerConfigTool;
        private OixsElementHandler m_handlerSuppressConfigTool;

        OiiiCompHandler(String name) {
            super(name);
            this.m_handlerConfigTool = new OiiiConfigToolHandler();
            this.m_handlerSuppressConfigTool = new OiiiSuppressConfigToolHandler();
            this.addChildHandler("CT", this.m_handlerConfigTool);
            this.addChildHandler("SUP_CT", this.m_handlerSuppressConfigTool);
        }

        @Override
        public void onStart(String name, AttributeList atts) {
            String sName = atts.getValue("NAME");
            String sVer = atts.getValue("VER");
            String sPlats = atts.getValue("PLAT");
            if (sName != null && sVer != null) {
                OiiiVersion oVer = new OiiiVersion(sVer);
                Vector vPlats = OiilXMLHelper.platCommonNames2IntVector(sPlats, " ", null);
                OiiiCompInstallID cid = new OiiiCompInstallID(sName, oVer, vPlats);
                if (OiiiConfigXMLHandler.this.m_homeIndex != 0) {
                    cid.setHomeType(2);
                }
                if (System.getProperty("osp.properties.file") != null) {
                    OiiiConfigXMLHandler.this.m_curEntry = OiiiConfigXMLHandler.this.m_inventory.getCompInvEntry(cid, OiiiConfigXMLHandler.this.m_homeIndex, vPlats);
                } else {
                    OiiiConfigXMLHandler.this.m_curEntry = OiiiConfigXMLHandler.this.m_inventory.getCompInvEntry(cid, OiiiConfigXMLHandler.this.m_homeIndex);
                }
            }
        }

        @Override
        public void onEnd(String name) {
        }
    }
}

