/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.oii.oiii.AggregateNSResolver;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OiiiConfigAggregateXMLWriter {
    private static final String MASTER_AGGREGATE = "agg:ComplexAggregate";
    private static final String SIMPLEST_AGGREGATE = "agg:SimplestAggregate";
    private static final String ACTION = "agg:Action";
    private static final String ACTIONSTEP = "agg:ActionStep";
    private static final String ACTION_AGG_REF = "agg:AggregateActionRef";
    private static final String DESCRIPTIONS = "agg:Descriptions";
    private static final String DESCRIPTION_ATT_NS_KEY = "xmlns:agg";
    private static final String DESCRIPTION_ATT_NS_VAL = "http://www.oracle.com/sysman/emCfg/AggregateDescriptions";
    private static final String DESCRIPTION_ATT_XSI_KEY = "xmlns:xsi";
    private static final String DESCRIPTION_ATT_XSI_VAL = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String DESCRIPTION_ATT_XSD_KEY = "xsi:schemaLocation";
    private static final String DESCRIPTION_ATT_XSD_VAL = "http://www.oracle.com/sysman/emCfg/AggregateDescriptions";
    private static final String DESCRIPTION_ATT_VER_KEY = "version";
    private static final String DESCRIPTION_ATT_VER_VAL = "1.0.0";
    private static final String DESCRIPTION_ATT_PLAT_KEY = "platform";
    private static final String AGG_REF = "agg:SimpleAggregateRef";
    private static final String ID = "id";
    private static final String USECOMMANDARRAY = "use_command_array";
    private static final String IDREF = "idref";
    private static final String OWNER = "owner";
    private static final String PARAMETER = "agg:Parameter";
    private static final String SIMPLEST_AGG_REF = "agg:SimplestAggregateRef";
    private static final String SIMPLEST_PARAM = "agg:SimplestParam";
    private static final String OUICONFIGVARS = "OuiConfigVariables";
    private static final String VIRTUAL_PARAMETER = "agg:VirtualParameter";
    private static final String PARAM_VALUE = "agg:ParamValue";
    private static final String PARAM_DATA_TYPE = "agg:ParamValueDataType";
    private static final String TRANSIENT = "transient";
    private static final String STRING_DATA_TYPE = "xsd:string";
    private static final String CONSTRAINT = "agg:Constraint";
    private static final String JAVACLASS_METHOD = "agg:JavaClassMethod";
    private static final String EQUALITY = "CommonUtil:equality";
    private static final String SIMPLEST_PARAM_REF = "agg:SimplestParameterRef";
    private static final String SELFDEPENDENCY = "agg:SelfDependency";
    private static final String ASSIGN = "CommonUtil:assign";
    private static final String MODE = "mode";
    private static final String DERIVED = "derived";
    private static final String EXPAND = "expand";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String PLUGIN = "agg:PlugIn";
    private static final String ACTION_TYPES = "types";
    private static final String CMDEXEC = "agg:CmdExec";
    private static final String IGNORE_REFERENCES = "ignore_duplicate_references";
    private static final String SIMPLEST_PARAM_MODEL_REF = "agg:SimplestParameterModelRef";
    private static final String SELF_DEPENDENCY_COPY_FROM = "agg:SelfDependencyCopyFrom";
    private static final String PARAM_REF = "agg:ParameterRef";
    private static final String PLUGIN_INVOCATION = "agg:PlugInInvocation";
    private static final String PLUGIN_REF = "agg:PlugInRef";
    private static final String REQUIRED = "required";
    private static final String PURGING_DRASTIC = "purging:drastic";
    private static final String COUNT = "count";
    private static final String PRIORITY = "priority";
    private static final String SIMPLEST_ARRAY_PARAM_MODEL = "agg:SimplestArrayParamModel";
    private static final String SIMPLEST_PARAM_MODEL = "agg:SimplestParameterModelRef";
    private static final String SIMPLE_PARAM_MODEL = "agg:SimpleParameterModelRef";
    public static final String XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output method=\"xml\"/><xsl:param name=\"indent-increment\" select=\"'   '\" /><xsl:template match=\"*\"><xsl:param name=\"indent\" select=\"'&#xA;'\"/><xsl:value-of select=\"$indent\"/><xsl:copy><xsl:copy-of select=\"@*\" /><xsl:apply-templates><xsl:with-param name=\"indent\" select=\"concat($indent, $indent-increment)\"/></xsl:apply-templates><xsl:if test=\"*\"><xsl:value-of select=\"$indent\"/></xsl:if></xsl:copy></xsl:template><xsl:template match=\"comment()|processing-instruction()\"><xsl:copy /></xsl:template><!-- WARNING: this is dangerous. Handle with care --><xsl:template match=\"text()[normalize-space()='']\"/></xsl:stylesheet>";
    private DOMParser m_parser;
    private XMLDocument m_xmldoc;
    private Hashtable m_hRefAggs = new Hashtable();
    private Vector m_vRefPlugins = new Vector();
    private Hashtable m_vRefPluginsState = new Hashtable();
    private String m_sAggID;
    private String m_sAggFileName;
    private boolean m_bSimplestAgg = false;
    private XMLElement m_eMasterXMLRootElement = null;
    private XMLElement m_eAggregateRootElement = null;
    private boolean m_bUpdateConfig = false;
    private boolean m_bTransformXML = false;
    private String[] sAggRefList = new String[]{"agg:SimplestAggregateRef", "agg:SimplestArrayAggregateRef", "agg:SimpleAggregateRef", "agg:SimpleArrayAggregateRef", "agg:ComplexAggregateRef", "agg:ArrayAggregateRef"};
    private String[] sAggTypes = new String[]{"agg:SimplestAggregate", "agg:SimplestArrayAggregate", "agg:SimpleAggregate", "agg:SimpleArrayAggregate", "agg:ArrayAggregate"};

    public OiiiConfigAggregateXMLWriter(String sMasterXMLFile, String sAggregateID, boolean bSimple, boolean bOverwrite) throws IOException, SAXException {
        this.m_sAggFileName = sMasterXMLFile;
        File f = new File(sMasterXMLFile);
        if (!bOverwrite && null != f && f.exists()) {
            this.createDOMParser();
            this.m_eMasterXMLRootElement = this.getRootFromXMLFile(sMasterXMLFile);
            NodeList children = this.m_eMasterXMLRootElement.getChildrenByTagName(MASTER_AGGREGATE);
            if (children.getLength() >= 1) {
                this.m_eAggregateRootElement = (XMLElement)children.item(0);
            } else {
                XMLElement otherAggElement = this.getRootElementOfOtherType(this.m_eMasterXMLRootElement);
                this.createMasterRootElement();
                this.m_eAggregateRootElement = new XMLElement(MASTER_AGGREGATE);
                this.m_eAggregateRootElement = (XMLElement)otherAggElement.cloneNode(true);
                this.m_eAggregateRootElement.setTagName("http://www.oracle.com/sysman/emCfg/AggregateDescriptions", MASTER_AGGREGATE);
                this.m_eAggregateRootElement.setAttribute(ID, otherAggElement.getAttribute(ID));
                this.m_eMasterXMLRootElement.removeChild((Node)otherAggElement);
                this.m_eMasterXMLRootElement.appendChild((Node)this.m_eAggregateRootElement);
            }
            this.m_bTransformXML = true;
        } else {
            this.createMasterRootElement();
            this.setAggregateID(sAggregateID);
        }
        this.m_bSimplestAgg = bSimple;
    }

    public void updateReferences() {
        this.m_bUpdateConfig = true;
        this.checkAndAddReferences();
    }

    private XMLElement getRootElementOfOtherType(XMLElement node) {
        for (int i = 0; i < this.sAggTypes.length; ++i) {
            NodeList children = this.m_eMasterXMLRootElement.getChildrenByTagName(this.sAggTypes[i]);
            if (children.getLength() < 1) continue;
            return (XMLElement)children.item(0);
        }
        return null;
    }

    private void createDOMParser() {
        this.m_parser = OixsXMLOps.createDOMParser();
        this.m_parser.showWarnings(true);
    }

    public void setPlatforms(String sPlats) {
        String sPlatforms = this.m_eMasterXMLRootElement.getAttribute(DESCRIPTION_ATT_PLAT_KEY).trim();
        if (null == sPlatforms || sPlatforms.length() <= 0) {
            this.m_eMasterXMLRootElement.setAttribute(DESCRIPTION_ATT_PLAT_KEY, sPlats);
        }
    }

    private XMLElement isNodePresent(XMLElement eRootNode2Search, String sNodeName, String sNodeAttribute, String sNodeValue) {
        XMLElement eResult = null;
        if (null != eRootNode2Search) {
            NodeList nChildList = eRootNode2Search.getChildrenByTagName(sNodeName);
            Node nChildNode1 = null;
            Node nChildNode2 = null;
            NamedNodeMap nChildAttr = null;
            if (null != nChildList && nChildList.getLength() > 0) {
                for (int i = 0; i < nChildList.getLength(); ++i) {
                    nChildNode1 = nChildList.item(i);
                    if (sNodeAttribute == null) {
                        eResult = (XMLElement)nChildNode1;
                        break;
                    }
                    nChildAttr = nChildNode1.getAttributes();
                    nChildNode2 = nChildAttr.getNamedItem(sNodeAttribute);
                    if (null != sNodeValue) {
                        if (sNodeValue.compareToIgnoreCase(nChildNode2.getNodeValue().trim()) != 0) continue;
                        eResult = (XMLElement)nChildNode1;
                        break;
                    }
                    eResult = (XMLElement)nChildNode1;
                    break;
                }
            }
        }
        return eResult;
    }

    private void setAggregateID(String sId) {
        XMLElement bCheckNodePresent = null;
        boolean bSetValue = false;
        if (!this.m_bSimplestAgg) {
            bCheckNodePresent = this.isNodePresent(this.m_eAggregateRootElement, MASTER_AGGREGATE, ID, sId);
            if (null == bCheckNodePresent) {
                bSetValue = true;
            }
        } else {
            bCheckNodePresent = this.isNodePresent(this.m_eAggregateRootElement, SIMPLEST_AGGREGATE, ID, sId);
            if (null == bCheckNodePresent) {
                bSetValue = true;
            }
        }
        this.m_sAggID = sId;
        if (bSetValue) {
            this.m_eAggregateRootElement = !this.m_bSimplestAgg ? new XMLElement(MASTER_AGGREGATE) : new XMLElement(SIMPLEST_AGGREGATE);
            this.m_eAggregateRootElement.setAttribute(ID, this.m_sAggID);
            this.m_eMasterXMLRootElement.appendChild((Node)this.m_eAggregateRootElement);
        }
    }

    private void checkAndAddReferences() {
        for (int i = 0; i < this.sAggRefList.length; ++i) {
            NodeList nChildList = this.m_eAggregateRootElement.getChildrenByTagName(this.sAggRefList[i]);
            Node nChildNode1 = null;
            Object nChildNode2 = null;
            if (null == nChildList || nChildList.getLength() <= 0) continue;
            for (int j = 0; j < nChildList.getLength(); ++j) {
                nChildNode1 = nChildList.item(j);
                this.m_hRefAggs.put(((XMLElement)nChildNode1).getAttributeNode(IDREF).getNodeValue(), nChildNode1.getNodeName());
            }
        }
    }

    public void addPlugin(String sPluginID, String sJavaClassName, boolean isRequired) {
        XMLElement ePlugin = new XMLElement(PLUGIN);
        ePlugin.setAttribute(ID, sPluginID);
        XMLElement eJavaClass = new XMLElement(CMDEXEC);
        eJavaClass.addText(sJavaClassName);
        eJavaClass.setAttribute(EXPAND, TRUE);
        ePlugin.appendChild((Node)eJavaClass);
        if (!this.m_vRefPlugins.contains(sPluginID)) {
            this.m_vRefPlugins.addElement(sPluginID);
        }
        this.m_vRefPluginsState.put(sPluginID, new Boolean(isRequired));
        this.m_eAggregateRootElement.appendChild((Node)ePlugin);
    }

    public void addPlugin(String sPluginID, String sJavaClassName, boolean isRequired, boolean isUseCommandArray) {
        XMLElement ePlugin = new XMLElement(PLUGIN);
        ePlugin.setAttribute(ID, sPluginID);
        ePlugin.setAttribute(USECOMMANDARRAY, new Boolean(isUseCommandArray).toString());
        XMLElement eJavaClass = new XMLElement(CMDEXEC);
        eJavaClass.addText(sJavaClassName);
        eJavaClass.setAttribute(EXPAND, TRUE);
        ePlugin.appendChild((Node)eJavaClass);
        if (!this.m_vRefPlugins.contains(sPluginID)) {
            this.m_vRefPlugins.addElement(sPluginID);
        }
        this.m_vRefPluginsState.put(sPluginID, new Boolean(isRequired));
        this.m_eAggregateRootElement.appendChild((Node)ePlugin);
    }

    public void addPlugin(String sPluginID, String sJavaClassName) {
        this.addPlugin(sPluginID, sJavaClassName, true);
    }

    public void addActionsToPlugin(String sActiontype) {
        XMLElement eAction = new XMLElement(ACTION);
        eAction.setAttribute(ID, this.removeSplChars(sActiontype));
        eAction.setAttribute(ACTION_TYPES, sActiontype);
        eAction.setAttribute(IGNORE_REFERENCES, TRUE);
        if (null != this.m_vRefPlugins && this.m_vRefPlugins.size() > 0) {
            for (int i = 0; i < this.m_vRefPlugins.size(); ++i) {
                XMLElement eActionStep = new XMLElement(ACTIONSTEP);
                XMLElement ePluginInvocation = new XMLElement(PLUGIN_INVOCATION);
                XMLElement ePluginRef = new XMLElement(PLUGIN_REF);
                ePluginRef.setAttribute(IDREF, (String)this.m_vRefPlugins.elementAt(i));
                boolean required = (Boolean)this.m_vRefPluginsState.get(this.m_vRefPlugins.elementAt(i));
                ePluginInvocation.appendChild((Node)ePluginRef);
                eActionStep.setAttribute(REQUIRED, String.valueOf(required));
                eActionStep.appendChild((Node)ePluginInvocation);
                eAction.appendChild((Node)eActionStep);
            }
            this.m_eAggregateRootElement.appendChild((Node)eAction);
        }
    }

    public void updateActionsToMaster(String sActionType, Hashtable hActionSteps, Hashtable hAggTypes) {
        AggregateNSResolver ns = new AggregateNSResolver();
        if (null != hActionSteps && !hActionSteps.isEmpty()) {
            Enumeration eKeys = hActionSteps.keys();
            while (eKeys.hasMoreElements()) {
                String sAggID = (String)eKeys.nextElement();
                String priority = (String)hActionSteps.get(sAggID);
                if (sActionType.compareToIgnoreCase(PURGING_DRASTIC) == 0) {
                    priority = "-" + priority;
                }
                try {
                    String nodePath = "//agg:Action[@types='" + sActionType + "']/agg:ActionStep/agg:AggregateActionRef[@owner='" + sAggID + "']";
                    Node aggRefnode = this.m_xmldoc.selectSingleNode(nodePath, (NSResolver)ns);
                    if (null == aggRefnode) continue;
                    XMLElement actionStepNode = (XMLElement)aggRefnode.getParentNode();
                    actionStepNode.setAttribute(PRIORITY, priority);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addActionsToMaster(String sActionType, Hashtable hActionSteps, Hashtable hAggTypes) {
        Object eActionTag = null;
        XMLElement eActionTag2 = this.isNodePresent(this.m_eAggregateRootElement, ACTION, ACTION_TYPES, sActionType);
        XMLElement eActionStep = null;
        if (null != hActionSteps && !hActionSteps.isEmpty()) {
            Enumeration eKeys = hActionSteps.keys();
            while (eKeys.hasMoreElements()) {
                String sAggID = (String)eKeys.nextElement();
                eActionStep = new XMLElement(ACTIONSTEP);
                eActionStep.setAttribute(REQUIRED, TRUE);
                if (sActionType.compareToIgnoreCase(PURGING_DRASTIC) == 0) {
                    eActionStep.setAttribute(PRIORITY, "-" + (String)hActionSteps.get(sAggID));
                } else {
                    eActionStep.setAttribute(PRIORITY, (String)hActionSteps.get(sAggID));
                }
                XMLElement eActionAggRef = new XMLElement(ACTION_AGG_REF);
                eActionAggRef.setAttribute(OWNER, sAggID);
                if (null != eActionTag2) {
                    NodeList childList = eActionTag2.getChildrenByTagName(ACTIONSTEP);
                    if (null != childList) {
                        for (int i = 0; i < childList.getLength(); ++i) {
                            XMLElement eChild1 = (XMLElement)childList.item(i);
                            XMLElement eChild2 = this.isNodePresent(eChild1, ACTION_AGG_REF, OWNER, sAggID);
                            if (null == eChild2) continue;
                            eActionTag2.removeChild((Node)eChild1);
                        }
                    }
                } else {
                    eActionTag2 = new XMLElement(ACTION);
                    eActionTag2.setAttribute(ID, this.removeSplChars(sActionType));
                    eActionTag2.setAttribute(ACTION_TYPES, sActionType);
                    eActionTag2.setAttribute(IGNORE_REFERENCES, TRUE);
                }
                if (null != hAggTypes && !hAggTypes.isEmpty() && !this.m_hRefAggs.containsKey(sAggID)) {
                    this.m_hRefAggs.put(sAggID, (String)hAggTypes.get(sAggID));
                }
                eActionStep.appendChild((Node)eActionAggRef);
                eActionTag2.appendChild((Node)eActionStep);
            }
            this.m_eAggregateRootElement.appendChild((Node)eActionTag2);
        }
    }

    private String removeSplChars(String sInput) {
        int size = sInput.length();
        StringBuffer formatted = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            if (!Character.isLetterOrDigit(sInput.charAt(i))) continue;
            formatted.append(sInput.charAt(i));
        }
        return formatted.toString();
    }

    private void createMasterRootElement() {
        if (null == this.m_eMasterXMLRootElement) {
            this.m_eMasterXMLRootElement = new XMLElement(DESCRIPTIONS);
            this.m_eMasterXMLRootElement.setAttribute(DESCRIPTION_ATT_VER_KEY, DESCRIPTION_ATT_VER_VAL);
            this.m_eMasterXMLRootElement.setAttribute(DESCRIPTION_ATT_NS_KEY, "http://www.oracle.com/sysman/emCfg/AggregateDescriptions");
            this.m_eMasterXMLRootElement.setAttribute(DESCRIPTION_ATT_XSI_KEY, DESCRIPTION_ATT_XSI_VAL);
            this.m_eMasterXMLRootElement.setAttribute(DESCRIPTION_ATT_XSD_KEY, "http://www.oracle.com/sysman/emCfg/AggregateDescriptions");
        }
    }

    private XMLElement getRootFromXMLFile(String sXMLFile) throws SAXException, IOException {
        XMLElement eResult;
        block6: {
            eResult = null;
            try {
                File f = new File(sXMLFile);
                if (!f.exists()) break block6;
                FileInputStream m_iStream = new FileInputStream(f);
                String sXsdFile = System.getProperty("Config_XSD_Location");
                if (null != sXsdFile) {
                    if (new File(sXsdFile).exists()) {
                        try {
                            XSDBuilder builder = new XSDBuilder();
                            URL url = this.createURL(sXsdFile);
                            XMLSchema schemadoc = builder.build(url);
                            this.m_parser.setValidationMode(3);
                            this.m_parser.setXMLSchema((Object)schemadoc);
                        }
                        catch (XSDException xse) {
                            throw new SAXException("Error with XSD building and Validation");
                        }
                        this.m_parser.parse(new InputSource(m_iStream));
                        this.m_xmldoc = this.m_parser.getDocument();
                        eResult = (XMLElement)this.m_xmldoc.getDocumentElement();
                        break block6;
                    }
                    throw new IOException("XSD File " + sXsdFile + " not found");
                }
                throw new IOException("Config_XSD_Location property not set by default");
            }
            catch (FileNotFoundException e) {
                throw new IOException("XML file not found");
            }
        }
        return eResult;
    }

    private void addAggregateReferences() {
        this.m_hRefAggs.put(OUICONFIGVARS, SIMPLEST_AGG_REF);
        if (null != this.m_hRefAggs && !this.m_hRefAggs.isEmpty()) {
            Enumeration eAggKeys = this.m_hRefAggs.keys();
            while (eAggKeys.hasMoreElements()) {
                String sIdref = (String)eAggKeys.nextElement();
                String sTag = (String)this.m_hRefAggs.get(sIdref);
                XMLElement eAggRefPresent = this.isNodePresent(this.m_eAggregateRootElement, sTag, IDREF, sIdref);
                if (null != eAggRefPresent) {
                    this.m_eAggregateRootElement.removeChild((Node)eAggRefPresent);
                }
                eAggRefPresent = new XMLElement((String)this.m_hRefAggs.get(sIdref));
                eAggRefPresent.setAttribute(IDREF, sIdref);
                this.m_eAggregateRootElement.appendChild((Node)eAggRefPresent);
            }
        }
    }

    public void addParameterModelsForBasicTypes(String sId, String sType) {
        XMLElement paramModelNode = new XMLElement("agg:SimplestParamModel");
        paramModelNode.setAttribute(ID, sId);
        XMLElement paramTypeNode = new XMLElement(PARAM_DATA_TYPE);
        paramTypeNode.addText(sType);
        paramModelNode.appendChild((Node)paramTypeNode);
        this.m_eMasterXMLRootElement.insertBefore((Node)paramModelNode, (Node)this.m_eAggregateRootElement);
    }

    public void addParameterModelForStringList(String sId, String sStringParamID) {
        XMLElement paramModelNode = new XMLElement(SIMPLEST_ARRAY_PARAM_MODEL);
        paramModelNode.setAttribute(ID, sId);
        paramModelNode.setAttribute(COUNT, "-1");
        XMLElement paramTypeNode = new XMLElement("agg:SimplestParameterModelRef");
        paramTypeNode.setAttribute(IDREF, sStringParamID);
        paramModelNode.appendChild((Node)paramTypeNode);
        this.m_eMasterXMLRootElement.insertBefore((Node)paramModelNode, (Node)this.m_eAggregateRootElement);
    }

    public void addVariable(String sName, boolean bSecure, String sParamModelRef) {
        XMLElement paramNode = new XMLElement(VIRTUAL_PARAMETER);
        paramNode.setAttribute(ID, sName);
        paramNode.setAttribute(TRANSIENT, new Boolean(bSecure).toString());
        XMLElement paramModelRefNode = new XMLElement(SIMPLE_PARAM_MODEL);
        paramModelRefNode.setAttribute(IDREF, sParamModelRef);
        paramNode.appendChild((Node)paramModelRefNode);
        this.m_eAggregateRootElement.appendChild((Node)paramNode);
    }

    public void addSessionVariables(Hashtable hSessionVars) {
        if (null != hSessionVars && !hSessionVars.isEmpty()) {
            Enumeration eSessionKeys = hSessionVars.keys();
            while (eSessionKeys.hasMoreElements()) {
                XMLElement eParam = new XMLElement(VIRTUAL_PARAMETER);
                String sVarName = (String)eSessionKeys.nextElement();
                eParam.setAttribute(ID, sVarName);
                XMLElement eNode = this.isNodePresent(this.m_eAggregateRootElement, VIRTUAL_PARAMETER, ID, sVarName);
                if (null != eNode) continue;
                XMLElement eType = new XMLElement(SIMPLEST_PARAM);
                eType.setAttribute(ID, sVarName + "_PARAM");
                XMLElement eVal = new XMLElement(PARAM_DATA_TYPE);
                eVal.addText((String)hSessionVars.get(sVarName));
                eType.appendChild((Node)eVal);
                eParam.appendChild((Node)eType);
                this.m_eAggregateRootElement.appendChild((Node)eParam);
            }
        }
    }

    public void addVirtualParameters(String sCompParamName, String sCompParamType, String sRefCompName, String sRefCompParamName) {
        if (null != sCompParamName && sCompParamName.length() > 0 && null != sCompParamType && sCompParamType.length() > 0 && null != sRefCompName && sRefCompName.length() > 0 && null != sRefCompParamName && sRefCompParamName.length() > 0) {
            XMLElement eVirtualParameter = new XMLElement(VIRTUAL_PARAMETER);
            eVirtualParameter.setAttribute(ID, sCompParamName);
            eVirtualParameter.setAttribute(MODE, DERIVED);
            XMLElement eParamModelRef = new XMLElement("agg:SimplestParameterModelRef");
            eParamModelRef.setAttribute(IDREF, sCompParamType);
            XMLElement eSelfDependency = new XMLElement(SELF_DEPENDENCY_COPY_FROM);
            XMLElement eParamRef = new XMLElement(PARAM_REF);
            eParamRef.setAttribute(OWNER, sRefCompName);
            eParamRef.setAttribute(IDREF, sRefCompParamName);
            eSelfDependency.appendChild((Node)eParamRef);
            eVirtualParameter.appendChild((Node)eParamModelRef);
            eVirtualParameter.appendChild((Node)eSelfDependency);
            this.m_eAggregateRootElement.appendChild((Node)eVirtualParameter);
        }
    }

    public void addVirtualParameters(String sParamName, Hashtable hReferences) {
        if (null != hReferences && !hReferences.isEmpty()) {
            XMLElement eVP = new XMLElement(VIRTUAL_PARAMETER);
            eVP.setAttribute(ID, sParamName);
            XMLElement eParamModel = new XMLElement(SIMPLEST_PARAM);
            eParamModel.setAttribute(ID, sParamName + "StringParam");
            XMLElement eParamType = new XMLElement(PARAM_DATA_TYPE);
            eParamType.setTextContent(STRING_DATA_TYPE);
            eParamModel.appendChild((Node)eParamType);
            eVP.appendChild((Node)eParamModel);
            XMLElement eConstraint = new XMLElement(CONSTRAINT);
            eConstraint.setAttribute(ID, sParamName);
            XMLElement eJavaClassCT = new XMLElement(JAVACLASS_METHOD);
            eJavaClassCT.addText(EQUALITY);
            eConstraint.appendChild((Node)eJavaClassCT);
            Enumeration eKeys1 = hReferences.keys();
            while (eKeys1.hasMoreElements()) {
                String sOwner1 = (String)eKeys1.nextElement();
                String sIdref1 = (String)hReferences.get(sOwner1);
                XMLElement eParamRef1 = new XMLElement(SIMPLEST_PARAM_REF);
                eParamRef1.setAttribute(OWNER, sOwner1);
                if (!this.m_hRefAggs.contains(sOwner1)) {
                    this.m_hRefAggs.put(sOwner1, SIMPLEST_AGG_REF);
                }
                eParamRef1.setAttribute(IDREF, sIdref1);
                eConstraint.appendChild((Node)eParamRef1);
            }
            XMLElement eSelfDependency = new XMLElement(SELFDEPENDENCY);
            eSelfDependency.setAttribute(ID, sParamName);
            XMLElement eJavaClassSD = new XMLElement(JAVACLASS_METHOD);
            eJavaClassSD.addText(ASSIGN);
            eSelfDependency.appendChild((Node)eJavaClassSD);
            Enumeration eKeys = hReferences.keys();
            while (eKeys.hasMoreElements()) {
                String sOwner = (String)eKeys.nextElement();
                String sIdref = (String)hReferences.get(sOwner);
                XMLElement eParamRef = new XMLElement(SIMPLEST_PARAM_REF);
                eParamRef.setAttribute(OWNER, sOwner);
                eParamRef.setAttribute(IDREF, sIdref);
                eSelfDependency.appendChild((Node)eParamRef);
            }
            eVP.appendChild((Node)eConstraint);
            eVP.appendChild((Node)eSelfDependency);
            this.m_eAggregateRootElement.appendChild((Node)eVP);
        }
    }

    private void checkAndRemoveAdditionalReferences() {
        for (int k = 0; k < this.sAggRefList.length; ++k) {
            NodeList list = this.m_eAggregateRootElement.getChildrenByTagName(this.sAggRefList[k]);
            if (null == list) continue;
            for (int i = 0; i < list.getLength(); ++i) {
                this.m_eAggregateRootElement.removeChild(list.item(i));
            }
        }
        NodeList nActionList = this.m_eAggregateRootElement.getChildrenByTagName(ACTION);
        if (null != nActionList) {
            for (int k = 0; k < nActionList.getLength(); ++k) {
                XMLElement actionNode = (XMLElement)nActionList.item(k);
                NodeList nActionStepsList = actionNode.getChildrenByTagName(ACTIONSTEP);
                if (null == nActionStepsList) continue;
                for (int j = 0; j < nActionStepsList.getLength(); ++j) {
                    XMLElement actionRef = (XMLElement)nActionStepsList.item(j);
                    NodeList nActionAggRefList = actionRef.getChildrenByTagName(ACTION_AGG_REF);
                    if (null == nActionAggRefList) continue;
                    for (int p = 0; p < nActionAggRefList.getLength(); ++p) {
                        String sOwner = ((XMLElement)nActionAggRefList.item(p)).getAttribute(OWNER);
                        if (null == sOwner) continue;
                        if (null != this.m_hRefAggs && !this.m_hRefAggs.isEmpty()) {
                            if (this.m_hRefAggs.containsKey(sOwner)) continue;
                            actionRef.removeChild(nActionAggRefList.item(p));
                            continue;
                        }
                        actionRef.removeChild(nActionAggRefList.item(p));
                    }
                }
            }
        }
    }

    public void updateXML() throws IOException {
        this.addAggregateReferences();
        this.writeXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML() throws IOException {
        FileOutputStream oFileWriter = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        PrintWriter oPrintWriter = null;
        try {
            oFileWriter = new FileOutputStream(new File(this.m_sAggFileName));
            oWriter = new OutputStreamWriter((OutputStream)oFileWriter, "UTF-8");
            oBufferedWriter = new BufferedWriter(oWriter);
            oPrintWriter = new PrintWriter(oBufferedWriter);
            oPrintWriter.println(OixsXMLOps.createXMLDirective(true));
            oPrintWriter.println(OixsXMLOps.getStandardHeader());
            if (null != this.m_eMasterXMLRootElement) {
                this.m_eMasterXMLRootElement.print(oPrintWriter);
            }
        }
        finally {
            if (oPrintWriter != null) {
                oPrintWriter.close();
            }
            if (oBufferedWriter != null) {
                oBufferedWriter.close();
            }
            if (oWriter != null) {
                oWriter.close();
            }
            if (oFileWriter != null) {
                oFileWriter.close();
            }
        }
        try {
            if (this.m_bTransformXML) {
                this.getTransformedXML((Node)this.getRootFromXMLFile(this.m_sAggFileName), this.m_sAggFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateXML() throws IOException {
        this.checkAndRemoveAdditionalReferences();
        this.addAggregateReferences();
        this.updateXML();
    }

    private URL createURL(String fileName) throws IOException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                OiiolTextLogger.appendText("Cannot create url for: " + fileName);
                throw new IOException(" Cannot create url for: " + fileName);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTransformedXML(Node n, String outputFileName) {
        ByteArrayInputStream bis = null;
        FileOutputStream fis = null;
        try {
            bis = new ByteArrayInputStream(XSL.getBytes());
            InputSource is = new InputSource(bis);
            DOMParser parser = new DOMParser();
            parser.parse(is);
            XMLDocument doc = parser.getDocument();
            DOMSource xslsource = new DOMSource((Node)doc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xslsource);
            transformer.setOutputProperty("standalone", "yes");
            fis = new FileOutputStream(outputFileName);
            StreamResult result = new StreamResult(fis);
            DOMSource source = new DOMSource(n);
            transformer.transform(source, result);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLParseException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != bis) {
                    bis.close();
                }
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }
}

