/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.sysman.oii.oiii.OiiiConfigAggregateXMLHandler;
import oracle.sysman.oii.oiis.OiisConfigAggregate;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OiiiConfigAggregateXMLReader {
    private OiiiConfigAggregateXMLReader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OiisConfigAggregate loadConfigAggregate(String sFile, boolean bMaster) throws IOException, SAXException {
        OiisConfigAggregate oAggregate = null;
        try {
            SAXParser parser = new SAXParser();
            OiiiConfigAggregateXMLHandler handler = null;
            FileInputStream fReader = null;
            InputStreamReader oReader = null;
            BufferedReader bReader = null;
            handler = new OiiiConfigAggregateXMLHandler(bMaster);
            parser.setDocumentHandler((DocumentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            String sXsdFile = System.getProperty("Config_XSD_Location");
            if (null == sXsdFile) throw new IOException("No XML Schema defined for Aggregate XML");
            if (!new File(sXsdFile).exists()) throw new IOException("XML Schema file not found");
            try {
                XSDBuilder builder = new XSDBuilder();
                URL url = OiiiConfigAggregateXMLReader.createURL(sXsdFile);
                XMLSchema schemadoc = builder.build(url);
                parser.setValidationMode(3);
                parser.setXMLSchema((Object)schemadoc);
            }
            catch (XSDException xse) {
                throw new SAXException("Error with XSD building and Validation");
            }
            if (null == sFile) return oAggregate;
            if (!new File(sFile).exists()) return oAggregate;
            fReader = new FileInputStream(sFile);
            oReader = new InputStreamReader((InputStream)fReader, "UTF-8");
            bReader = new BufferedReader(oReader);
            parser.parse(new InputSource(bReader));
            return handler.getAggregate();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Aggregate XML \"" + sFile + "\" file not found");
        }
    }

    private static URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot create url for: " + fileName);
                System.exit(0);
            }
        }
        return url;
    }
}

