/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class OiiiCompsXMLWriter {
    private static final String INVENTORY = "inventory";
    private static final String CONTENTSXML = "ContentsXML";
    private static final String COMPSXML = "comps.xml";

    public static void writeComps(OiiiCompInvEntry compInvEntry, String location) throws IOException {
        OiiiCompInvEntry comp;
        String sCompsFileLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(location, INVENTORY));
        sCompsFileLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sCompsFileLoc, CONTENTSXML));
        sCompsFileLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(sCompsFileLoc, COMPSXML));
        Hashtable hTags = null;
        XMLElement elPrdList = OiiiCompsXMLWriter.getElementFromTable("PRD_LIST", hTags);
        XMLElement elTLList = OiiiCompsXMLWriter.getElementFromTable("TL_LIST", hTags);
        XMLElement elCompList = OiiiCompsXMLWriter.getElementFromTable("COMP_LIST", hTags);
        OiixFileOps.createDirForDest(OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sCompsFileLoc)));
        FileWriter fWriter = new FileWriter(sCompsFileLoc);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective(true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        OiiiCompsXMLWriter.writeNodesWithoutEndTag(elPrdList, pWriter);
        OiiiCompsXMLWriter.writeNodesWithoutEndTag(elTLList, pWriter);
        if (compInvEntry.isTopLevel()) {
            comp = compInvEntry;
            comp.writeXML(pWriter);
        }
        pWriter.println("</TL_LIST>");
        OiiiCompsXMLWriter.writeNodesWithoutEndTag(elCompList, pWriter);
        if (!compInvEntry.isTopLevel()) {
            comp = compInvEntry;
            comp.writeXML(pWriter);
        }
        pWriter.println("</COMP_LIST>");
        pWriter.println("</PRD_LIST>");
        pWriter.close();
        bWriter.close();
        fWriter.close();
    }

    private static void writeNodesWithoutEndTag(XMLElement element, PrintWriter pWriter) throws IOException {
        String sCurrentTag = OixsXMLOps.getStartTag(element);
        pWriter.println(sCurrentTag);
        NodeList nl = element.getChildNodes();
        if (nl != null) {
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                XMLElement el = (XMLElement)nl.item(i);
                el.print(pWriter);
            }
        }
    }

    private static XMLElement getElementFromTable(String name, Hashtable tagstable) {
        if (tagstable == null) {
            return new XMLElement(name);
        }
        XMLElement el = (XMLElement)tagstable.get(name);
        if (el == null) {
            el = new XMLElement(name);
        }
        return el;
    }
}

