/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiClusterException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiCompositeHomeInventory;
import oracle.sysman.oii.oiii.OiiiFileMap;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiFileMapInventory;
import oracle.sysman.oii.oiii.OiiiHomeInvDetails;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReader;
import oracle.sysman.oii.oiii.OiiiInstallXMLReader;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceStageProvider;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceVariants;
import oracle.sysman.oii.oiix.OiixUtil;

public class OiiiCompositeAreaControl
extends OiiiTargetAreaControl {
    public static final String PLATFORM_FILE_NAME = "install.platform";
    public static final String SECTION_NAME = "Platform";
    public static final String VARIABLE_NAME = "ID";
    public static final int INV_FILE_SIZE = 102400;
    public static final int INV_PLATFORM_FILE_SIZE = 1024;
    protected static OiiiTargetAreaControl s_invAreaControl;
    private static final boolean s_debug = false;
    public static final String RESOURCES_DIR = "resources";
    public static final String INVENTORY_DIR = "inventory";
    public static final String INVENTORY_BACKUP_DIR = "backup";
    public static final String XML_INSTALLLOG_FILENAME = "installlog.xml";
    public static final String XML_INVENTORY_FILENAME = "inventory.xml";
    public static final String XML_CONTENTS_DIR = "ContentsXML";
    public static final String XML_MAKE_DIR = "make";
    public static final String XML_COMPS_FILENAME = "comps.xml";
    public static final String XML_COMPS_NEW_FILENAME = "comps.new.xml";
    public static final String XML_COMPS_BACKUP_FILENAME = "comps.xml.bak";
    static final String XML_LIBS_FILENAME = "libs.xml";
    public static final String XML_OHINFO_FILENAME = "oraclehomeproperties.xml";
    private static final String XML_ACTIONS_DIR = "Actions21";
    private static final String XML_DIALOGS_DIR = "Dialogs21";
    private static final String XML_QUERIES_DIR = "Queries21";
    public static final String XML_COMPCONTEXT_FILENAME = "context.xml";
    public static final String XML_CONFIGLOG_FILENAME = "configlog.xml";
    public static final String XML_CONFIGTOOLS_FILENAME = "configtools.xml";
    public static final String XML_HOME_CENTRAL_INVENTORY = "central_inventory";
    public static final String XML_IP1_INSTALL_LOG_FILENAME = "installIP1Log.xml";
    public static final String XML_IP2_INSTALL_LOG_FILENAME = "installIP2Log.xml";
    public static final String XML_LINK_INSTALL_LOG_FILENAME = "installLinkLog.xml";
    public static final String XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX = "installLangAddonLog";
    public static final char XML_LANGADDON_INSTALL_LOG_FILENAME_SEPARATOR = '_';
    public static final String OH_LOG_DIR = "cfgtoollogs";
    public static final String CFGFW_LOG_DIR = "cfgfw";
    static final String XML_COMPONENTS_DIR = "Components21";
    static final String XML_PATCHES_DIR = "Patches21";
    static final String XML_PATCHSETS_DIR = "PatchSets21";
    static final String ONEOFFS_BINARY_FILENAME = "oneoffs";
    static final String ONEOFFS_BINARY_EXT = ".oo";
    static final String XML_ONEOFFS_DIR = "oneoffs";
    public static final String SCRIPTS_DIR = "Scripts";
    static final String PREREQS_DIR = "prereqs";
    static final String TEMPLATES_DIR = "Templates";
    static final String REMOVED_FILES_DIR = "RemovedFiles";
    public static final String COMPUTE_AT_CLONE_VARS_LIST = "computeAtCloneVars.txt";
    public static final String EXECUTE_TOOLS_AT_CLONE_LIST = "executeToolsAtClone.txt";
    public static final String CLONE_DIR = "Clone";
    private static final String CLONE_FILENAME = "clone.xml";
    private static final String ROOTSH_FILENAME = "root.sh";
    private static final String ORAINST_FILENAME = "oraInst.loc";
    private static final String GLOBALCONTEXT_FILENAME = "install/chainedInstall/globalcontext.xml";
    private static final String CONFIG_XML_DIR_RLT_PATH = "inventory/ContentsXML/ConfigXML/";
    private static final String OUI_CONFIG_VARIABLES_XML_FILE_NAME = "OuiConfigVariables";
    private static final String ADD_LANGUAGE_AGGREGATE_NAME = "AddLanguage";
    private static final String ENV_VARS_PROPERTIES_FILENAME = "envVars.properties";
    private static final String ENV_VARS_PROPERTIES_FILE_RLT_LOC = "install/";
    public static final int ACCESSLEVEL_READ = 0;
    public static final int ACCESSLEVEL_READWRITE = 1;
    private int m_nAccessLevel = 1;
    private static OiiiCompositeAreaControl s_instAreaControl;
    private transient OiiiInventoryEnvUpdater m_invEnvUpdater = null;
    private OiiiFileMapInventory m_fileMapInv = null;
    private OiiiSourceStageProvider m_sourceStageProvider = null;
    private boolean m_bDeinstallMode = false;
    private boolean m_bSaveCloneXMLInfo = false;

    private OiiiCompositeAreaControl(String installRoot) throws IOException {
        super(installRoot);
    }

    public void loadInstallInventory() throws IOException {
        OiiiCompositeHomeInventory installInv = this.initInstallInv();
        if (installInv != null) {
            installInv.setAreaControl(this);
            this.setAreaInventory(installInv);
        }
    }

    private OiiiCompositeHomeInventory loadPartialInstallInv() throws IOException {
        OiiiCompositeHomeInventory inv = new OiiiCompositeHomeInventory(this);
        this.setAreaInventory(inv);
        inv.readHomes();
        inv.initPartialLoad(inv.getHomes().size());
        return inv;
    }

    private OiiiCompositeHomeInventory initInstallInv() throws IOException {
        OiixDebug.debug("OiiiCompositeAreaControl", "**** Partial loading ***");
        return this.loadPartialInstallInv();
    }

    private void initFileMapInventory() {
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        if (installInv != null) {
            this.m_fileMapInv = new OiiiFileMapInventory(installInv.getHomes(), this.getAreaRoot());
        }
    }

    public OiiiFileMapInventory getFileMapInventory() {
        return this.m_fileMapInv;
    }

    @Override
    public ResourceBundle getResourceBundle(OiiiCompInvEntry ce) {
        PropertyResourceBundle rb = null;
        if (ce instanceof OiiiInstallCompInvEntry) {
            OiiiInstallCompInvEntry ice = (OiiiInstallCompInvEntry)ce;
            String resourceBaseXML = null;
            String sXMLInvLoc = ice.getLocationInXMLInventory();
            if (sXMLInvLoc != null) {
                resourceBaseXML = OiixPathOps.concatPath(this.getInventoryLocForHome(ice.getOHIndex()), sXMLInvLoc);
                resourceBaseXML = OiixPathOps.concatPath(resourceBaseXML, RESOURCES_DIR);
                resourceBaseXML = OiixPathOps.concatPath(resourceBaseXML, "CompID");
            }
            String resourceBase = this.genLogLoc(OiixPathOps.concatPath(ice.getLocation(), "resources/CompID"));
            boolean foundResource = false;
            Enumeration vars = OiixResourceVariants.genResourceVariants();
            while (!foundResource && vars.hasMoreElements()) {
                String sVariant = (String)vars.nextElement();
                String resLoc = null;
                String natResLoc = null;
                boolean bCheckXMLLoc = resourceBaseXML != null;
                boolean bCheckBinLoc = true;
                if (bCheckXMLLoc) {
                    resLoc = resourceBaseXML + sVariant + ".properties";
                    natResLoc = OiixPathOps.getNativeForm(resLoc);
                    foundResource = new File(natResLoc).exists();
                    boolean bl = bCheckBinLoc = !foundResource;
                }
                if (bCheckBinLoc) {
                    resLoc = resourceBase + sVariant + ".properties";
                    natResLoc = OiixPathOps.getNativeForm(resLoc);
                    if (!new File(natResLoc).exists()) continue;
                    foundResource = true;
                }
                try {
                    FileInputStream is = new FileInputStream(natResLoc);
                    rb = new PropertyResourceBundle(is);
                    is.close();
                }
                catch (Exception exp) {
                    System.out.println("Cannot load resource for " + ice);
                    exp.printStackTrace();
                }
            }
        }
        return rb;
    }

    public OiiiCompositeHomeInventory getInstallInventory() {
        return (OiiiCompositeHomeInventory)this.getAreaInventory();
    }

    public static OiiiTargetAreaControl getInventoryAreaControl() {
        return s_invAreaControl;
    }

    public void propagateInventoryToNodes(String oracleHome, String[] nodeList) throws OiiiClusterException {
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        if (installInv != null) {
            installInv.propagateInventoryToNodes(oracleHome, nodeList);
        }
    }

    public void saveInstallInventory() throws IOException, OiifbCancelException {
        this.saveInstallInventory(null);
    }

    public void saveInstallInventory(String[] nodeList) throws IOException, OiifbCancelException {
        OiiolTextLogger.appendText("Saving the install inventory which has the access of " + this.m_nAccessLevel);
        if (this.m_nAccessLevel < 1) {
            throw new IOException("Current access level does not allow writing to the inventory");
        }
        OiiiCompositeHomeInventory installInv = this.getInstallInventory();
        this.writeInstallInv(nodeList);
        if (this.m_invEnvUpdater != null) {
            this.m_invEnvUpdater.updateEnv(installInv);
        }
        installInv.logInvToLogFile();
        Vector oracleHomes = installInv.getHomes();
        int nSize = oracleHomes != null ? oracleHomes.size() : 0;
        for (int i = 0; i < nSize; ++i) {
            OiiiOracleHomeInfo ohi = (OiiiOracleHomeInfo)oracleHomes.elementAt(i);
            ohi.setDirty(false);
        }
    }

    private void writeInstallInv(String[] nodeList) throws IOException, OiifbCancelException {
        OiiiCompositeHomeInventory verDepInstallInv = this.getInstallInventory();
        this.updateHomes(verDepInstallInv);
        verDepInstallInv.saveInventory();
    }

    private void updateHomes(OiiiCompositeHomeInventory instInv) {
        Vector vHomes = instInv.getAllOUIHomes();
        Vector<OiiiOracleHomeInfo> vUpdatedHomes = new Vector<OiiiOracleHomeInfo>(vHomes.size());
        for (int i = 0; i < vHomes.size(); ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)vHomes.elementAt(i);
            try {
                if (homeInfo.isRemoved()) {
                    OiipgOracleHomes.removeHome(homeInfo.getLocation(), homeInfo.getName());
                    continue;
                }
                vUpdatedHomes.add(homeInfo);
                if (homeInfo.isRenamed()) {
                    OiipgOracleHomes.updateHomeName(homeInfo.getOldName(), homeInfo.getLocation(), homeInfo.getName());
                    homeInfo.setRenamed(false);
                    continue;
                }
                if (!homeInfo.isMoved()) continue;
                OiipgOracleHomes.updateHomePath(homeInfo.getName(), homeInfo.getLocation());
                homeInfo.setMoved(false);
                continue;
            }
            catch (OiilNativeException ne) {
                ne.printStackTrace();
            }
        }
        instInv.setHomes(vUpdatedHomes);
    }

    public void setInvEnvUpdater(OiiiInventoryEnvUpdater invEnvUpdater) {
        this.m_invEnvUpdater = invEnvUpdater;
    }

    OiiiStageInventory getSourceStageInventory() {
        OiiiStageInventory stageInv = null;
        if (this.m_sourceStageProvider != null) {
            stageInv = this.m_sourceStageProvider.getStageInventory();
        }
        return stageInv;
    }

    public void setSourceStageProvider(OiiiSourceStageProvider stageProvider) {
        this.m_sourceStageProvider = stageProvider;
    }

    String getAvailableInstallJarName(int homeIndex, int startIndex) {
        String sScriptsLoc = this.getScriptsLoc(homeIndex);
        String sInstall = "install";
        String sDotJar = ".jar";
        String sRetVal = null;
        boolean bFound = false;
        int index = startIndex;
        while (!bFound) {
            String sCurName = sInstall + index + sDotJar;
            String sLoc = OiixPathOps.concatPath(sScriptsLoc, sCurName);
            File f = new File(sLoc = OiixPathOps.getNativeForm(sLoc));
            if (f.exists()) {
                ++index;
                continue;
            }
            sRetVal = sCurName;
            bFound = true;
        }
        return sRetVal;
    }

    public static OiiiCompositeAreaControl getInstallAreaControl() {
        return s_instAreaControl;
    }

    public static void dispose() {
        s_instAreaControl = null;
    }

    private void setAccessLevel(int nAccessLevel) {
        if (nAccessLevel != 0 && nAccessLevel != 1) {
            throw new IllegalArgumentException("Invalid access level: " + nAccessLevel);
        }
        this.m_nAccessLevel = nAccessLevel;
    }

    public int getAccessLevel() {
        return this.m_nAccessLevel;
    }

    public boolean isReadOnlySession() {
        return this.getAccessLevel() == 0;
    }

    public static void setInventoryAreaControl(OiiiTargetAreaControl invAreaCtrl) {
        s_invAreaControl = invAreaCtrl;
    }

    public static void initAreaControl(int nAccessLevel) throws IOException, OiiiInventoryDoesNotExistException {
        File oInvDir;
        String invLoc = OiiiInstallAreaControl.getInventoryLocation();
        if (new OiipgBootstrap().isCleanMachine()) {
            try {
                OiiiCompositeAreaControl.createInventory(invLoc, null);
            }
            catch (IOException e) {
                OiiolTextLogger.appendErrorText(e.getMessage(), OiiolTextLogger.LOG_WITHOUT_LEVEL);
            }
            catch (OiiiInventoryException e) {
                OiiolTextLogger.appendErrorText(e.getMessage(), OiiolTextLogger.LOG_WITHOUT_LEVEL);
            }
        }
        if (!(oInvDir = new File(invLoc)).exists() && nAccessLevel == 0) {
            throw new OiiiInventoryDoesNotExistException(OiixResourceBundle.getString("S_ERROR_INVENTORY_LOC_NOT_EXIST", new String[]{invLoc}));
        }
        if (oInvDir.exists() && (!oInvDir.canRead() || oInvDir.list() == null)) {
            String sMsg = OiixResourceBundle.getString("S_ERR_INV_LOC_NOT_READABLE");
            Object[] arg = new Object[]{invLoc};
            sMsg = MessageFormat.format(sMsg, arg);
            throw new OiiiInstallInventoryReadException(sMsg);
        }
        OiiiCompositeAreaControl.initAreaControl(invLoc, nAccessLevel);
    }

    public static void initAreaControl(String invLoc) throws IOException {
        OiiiCompositeAreaControl.initAreaControl(invLoc, 1);
    }

    public static void initAreaControl(String invLoc, int nAccessLevel) throws IOException {
        OiiiCompositeAreaControl.initAreaControl(invLoc, nAccessLevel, false);
    }

    public static void initAreaControl(String invLoc, int nAccessLevel, boolean bcreateDirectories) throws IOException {
        try {
            OiiiCompositeAreaControl retval = null;
            try {
                File inFile = new File(invLoc);
                if (bcreateDirectories && !inFile.exists()) {
                    OiixFileOps.mkdirs(inFile);
                }
                retval = new OiiiCompositeAreaControl(invLoc);
                retval.setAccessLevel(nAccessLevel);
                OiiolTextLogger.appendText("Install area Control created with access level  " + nAccessLevel);
                s_instAreaControl = retval;
                retval.loadInstallInventory();
                retval.initFileMapInventory();
            }
            catch (OiiiInstallInventoryReadException e) {
                throw e;
            }
            catch (IOException ioe) {
                retval = null;
            }
            if (retval != null) {
                // empty if block
            }
            OiiiCompositeAreaControl.setInventoryAreaControl(retval);
            s_instAreaControl = retval;
            if (OiiiCompositeAreaControl.getInstallAreaControl().getInstallInventory() != null) {
                OiiiCompositeAreaControl.assignOracleHomeNames();
            }
        }
        catch (OiiiInstallInventoryReadException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void assignOracleHomeNames() {
        String[] homeNames = null;
        try {
            homeNames = OiipgOracleHomes.getAllOracleHomeNames();
        }
        catch (OiilNativeException oiilNativeException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int runningCount = 1;
        Vector homes = OiiiCompositeAreaControl.getInstallAreaControl().getInstallInventory().getHomes();
        int nHomes = homes != null ? homes.size() : 0;
        for (int i = 0; i < nHomes; ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
            String name = homeInfo.getName();
            if (name != null && !name.equals("")) continue;
            do {
                name = "ORACLE_HOME" + runningCount;
                ++runningCount;
            } while (OiiiCompositeAreaControl.isDuplicateName(name, homeNames));
            homeInfo.setName(name);
        }
    }

    private static boolean isDuplicateName(String name, String[] homeNames) {
        if (homeNames == null) {
            return false;
        }
        for (int i = 0; i < homeNames.length; ++i) {
            if (!homeNames[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void writeOHInvLoc(String sOHLoc) {
        block11: {
            if (!OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                return;
            }
            String sInvPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            if (sInvPtrLoc == null) {
                return;
            }
            try {
                String fLoc = OiixPathOps.concatPath(sOHLoc, ORAINST_FILENAME);
                if (OiipgFileSystem.equalPathStrs(sInvPtrLoc, fLoc)) break block11;
                File fInvPtrLocFile = new File(sInvPtrLoc);
                String inventoryLoc = System.getProperty("oracle.installer.custom_inventory");
                if (fInvPtrLocFile.exists() && (inventoryLoc == null || inventoryLoc == "")) {
                    OiixFileOps.copyFile(sInvPtrLoc, fLoc, true, false, false, true, "0640", null, null, null, false);
                    break block11;
                }
                String invLoc = OiiiCompositeAreaControl.getInstallAreaControl().genFileSysLoc(ORAINST_FILENAME);
                OiipgBootstrap bs = new OiipgBootstrap();
                if (new File(invLoc).exists()) {
                    OiixFileOps.copyFile(invLoc, fLoc, true, false, false, true, "0640", null, null, null, false);
                } else {
                    String sDefInvLoc = OiiiCompositeAreaControl.getDefaultInventoryLocation();
                    try {
                        bs.updateInventoryLoc(null, sDefInvLoc, null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    bs.modifyUnixInstallFile(sDefInvLoc, fLoc);
                }
                if (!Boolean.getBoolean("oracle.installer.attachHome")) {
                    return;
                }
                Object[] argV = new String[]{OiipgBootstrap.S_UNIX_ROOT_SCRIPT_NAME};
                if (!OiixUtil.isNullOrBlank(argV[0], true)) {
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_BS_EXEC_ROOTSH_ATTACHHOME", argV);
                    OiiolTextLogger.writeMessageToConsole(sMsg);
                    OiiolTextLogger.appendText(sMsg);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void writeOraInstLocFile(String sOHLoc, String sInvLoc) throws IOException {
        String fLoc = OiixPathOps.concatPath(sOHLoc, ORAINST_FILENAME);
        FileOutputStream fOut = new FileOutputStream(fLoc);
        Properties propsout = new Properties();
        propsout.put("inventory_loc", sInvLoc);
        propsout.store(fOut, null);
        fOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInvDetails(int homeIndex) throws IOException {
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        String outFile = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "invDetails.properties");
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(outFile);
            invDetails.write(fos);
        }
    }

    public String getXMLCompRelativeLoc(OiiiCompInstallID cid, int homeIndex) {
        String sXMLLoc = this.getXMLCollectionDir(cid.getCompType()) + "/" + cid.getName() + "/" + cid.getVersion() + "/";
        return sXMLLoc;
    }

    public String getXMLCompFullLoc(OiiiCompInstallID cid, int homeIndex) {
        String sLoc = this.getXMLCompRelativeLoc(cid, homeIndex);
        sLoc = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), sLoc);
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLOneoffsLoc(int homeIndex) {
        String sLoc = OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "oneoffs");
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getOHInventoryLoc(String homeLoc) {
        String standardOHPath = OiixPathOps.getStandardForm(homeLoc);
        standardOHPath = OiixPathOps.directorify(standardOHPath);
        String invDir = OiixPathOps.concatPath(standardOHPath, INVENTORY_DIR);
        return OiixPathOps.getNativeForm(invDir);
    }

    public String getXMLHomeLogsDir(int homeIndex) {
        String sLoc = this.getInstallInventory().getHomeLocation(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, OH_LOG_DIR);
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLOneoffFullLoc(OiiiOneoffInstallID oid, int homeIndex) {
        String sLoc = "oneoffs";
        sLoc = OiixPathOps.concatPath(sLoc, oid.getID());
        sLoc = OiixPathOps.directorify(sLoc);
        return OiixPathOps.getStandardForm(sLoc);
    }

    public String getXMLLibRelativeLoc(OiiiLibraryID lid, int type, int homeIndex) {
        String sDir = "";
        switch (type) {
            case 0: {
                sDir = XML_ACTIONS_DIR;
                break;
            }
            case 1: {
                sDir = XML_QUERIES_DIR;
                break;
            }
            case 2: {
                sDir = XML_DIALOGS_DIR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown library type: " + type);
            }
        }
        String sXMLLoc = sDir + "/" + lid.getName() + "/" + lid.getVersion() + "/";
        return sXMLLoc;
    }

    private String getXMLCollectionDir(int compType) {
        switch (compType) {
            case 1: {
                return XML_COMPONENTS_DIR;
            }
            case 2: {
                return XML_PATCHES_DIR;
            }
            case 4: {
                return XML_PATCHSETS_DIR;
            }
        }
        throw new IllegalArgumentException("Unknown component type: " + compType);
    }

    public String getInventoryFileLoc(String invLoc) {
        if (invLoc == null) {
            return this.getInventoryFileLoc();
        }
        String invFileLoc = OiixPathOps.getStandardForm(invLoc);
        invFileLoc = OiixPathOps.directorify(invFileLoc);
        invFileLoc = invFileLoc + XML_CONTENTS_DIR + '/' + XML_INVENTORY_FILENAME;
        return invFileLoc;
    }

    public String getInventoryFileLoc() {
        String sFileName = XML_INVENTORY_FILENAME;
        String sPath = this.getContentsDir(0);
        return OiixPathOps.concatPath(sPath, sFileName);
    }

    String getContentsDir(int homeIndex) {
        String sPath = "";
        if (homeIndex == 0) {
            sPath = this.genFileSysLoc(XML_CONTENTS_DIR);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(homeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, XML_CONTENTS_DIR);
            sPath = OiixPathOps.directorify(sPath);
        }
        return sPath;
    }

    public String getXMLCompsFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getCompsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLCompsFileLoc(String sHomeLoc) {
        String sLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        String sDetailsLoc = OiixPathOps.concatPath(sLoc, "invDetails.properties");
        sDetailsLoc = OiixPathOps.getNativeForm(sDetailsLoc);
        OiiiHomeInvDetails invDetails = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sDetailsLoc);
            invDetails = OiiiHomeInvDetails.load(fis);
        }
        catch (IOException e) {
            invDetails = OiiiHomeInvDetails.getDefault();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        sLoc = OiixPathOps.concatPath(sLoc, XML_CONTENTS_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getCompsFileName());
        return sLoc;
    }

    public static String getConfigToolLogsLoc(String sHomeLoc) {
        String sConfigToolLogsLoc = OiixPathOps.concatPath(sHomeLoc, OH_LOG_DIR);
        String sCfggwLogsLoc = OiixPathOps.concatPath(sConfigToolLogsLoc, CFGFW_LOG_DIR);
        return sCfggwLogsLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOHPropertiesFileLoc(String sHomeLoc) {
        String sOHPropertiesFileLoc = null;
        String sLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        String sDetailsLoc = OiixPathOps.concatPath(sLoc, "invDetails.properties");
        sDetailsLoc = OiixPathOps.getNativeForm(sDetailsLoc);
        OiiiHomeInvDetails invDetails = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sDetailsLoc);
            invDetails = OiiiHomeInvDetails.load(fis);
        }
        catch (IOException e) {
            invDetails = OiiiHomeInvDetails.getDefault();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        sOHPropertiesFileLoc = OiiiCompositeAreaControl.getContentsDirForHome(sHomeLoc);
        sOHPropertiesFileLoc = OiixPathOps.concatPath(sOHPropertiesFileLoc, invDetails.getOHPropsFileName());
        return sOHPropertiesFileLoc;
    }

    public String getOHPropertiesFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getOHPropsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    public String getCHPropertiesFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getOHPropsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    private static String getContentsDirForHome(String sHomeLoc) {
        String sContentsXMLLoc = null;
        sContentsXMLLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sContentsXMLLoc = OiixPathOps.concatPath(sContentsXMLLoc, XML_CONTENTS_DIR);
        sContentsXMLLoc = OiixPathOps.directorify(sContentsXMLLoc);
        return sContentsXMLLoc;
    }

    public static String getMakeDirForHome(String sHomeLoc) {
        String sMakeXMLLoc = null;
        sMakeXMLLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sMakeXMLLoc = OiixPathOps.concatPath(sMakeXMLLoc, XML_MAKE_DIR);
        sMakeXMLLoc = OiixPathOps.directorify(sMakeXMLLoc);
        return sMakeXMLLoc;
    }

    public String getXMLLibsFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getLibsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    String getCloneFileLoc(int homeIndex) {
        String sLoc = this.getInventoryLocForHome(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_FILENAME);
        return sLoc;
    }

    String getCloneFileLoc(String sHomeLoc) {
        String sLoc = OiixPathOps.concatPath(sHomeLoc, INVENTORY_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_DIR);
        sLoc = OiixPathOps.concatPath(sLoc, CLONE_FILENAME);
        return sLoc;
    }

    public String getPrereqsLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), PREREQS_DIR);
    }

    public String getScriptsLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), SCRIPTS_DIR);
    }

    String getComputeAtCloneFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), COMPUTE_AT_CLONE_VARS_LIST);
    }

    public String getExecuteToolsAtCloneFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), EXECUTE_TOOLS_AT_CLONE_LIST);
    }

    public String getTemplatesLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), TEMPLATES_DIR);
    }

    public String getRemovedFilesLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), REMOVED_FILES_DIR);
    }

    String getInvDetailsFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getInventoryLocForHome(homeIndex), "invDetails.properties");
    }

    String getStageInventoryFileLoc(int homeIndex) {
        return OiixPathOps.concatPath(this.getScriptsLoc(homeIndex), "products.xml");
    }

    public void setDeinstallMode(boolean mode) {
        this.m_bDeinstallMode = mode;
    }

    public boolean isDeinstallMode() {
        return this.m_bDeinstallMode;
    }

    public void setSaveCloneXMLInfo(boolean bSaveCloneXMLInfo) {
        this.m_bSaveCloneXMLInfo = bSaveCloneXMLInfo;
    }

    public boolean canSaveCloneXMLInfo() {
        return this.m_bSaveCloneXMLInfo;
    }

    public OiiiInstallInventoryReader getReaderForHome(int homeIndex) {
        return this.getReaderForOracleHomes();
    }

    public OiiiInstallInventoryReader getReaderForOracleHomes() {
        return OiiiInstallXMLReader.getReader();
    }

    public String getXMLLogLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_INSTALLLOG_FILENAME);
    }

    public String getXMLLogLoc(int homeIndex, String compLoc, int phase) {
        String sFileName = null;
        switch (phase) {
            case 1: {
                sFileName = XML_IP1_INSTALL_LOG_FILENAME;
                break;
            }
            case 8: {
                sFileName = XML_IP2_INSTALL_LOG_FILENAME;
                break;
            }
            case 2: {
                sFileName = XML_LINK_INSTALL_LOG_FILENAME;
            }
        }
        return this.getXMLInvFileLoc(homeIndex, compLoc, sFileName);
    }

    public String getLangAddonXMLLogLoc(int nHomeIndex, String sCompLoc) {
        String sFileName = null;
        String sPath = "";
        if (nHomeIndex == 0) {
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
        }
        File installLogParentDir = new File(sPath);
        sFileName = this.getLogFileForLangAddonInstall(installLogParentDir);
        sPath = OiixPathOps.directorify(sPath);
        sPath = OiixPathOps.concatPath(sPath, sFileName);
        return sPath;
    }

    private String getLogFileForLangAddonInstall(File directoryLocation) {
        File[] allLogFiles = directoryLocation.listFiles();
        int maxSequence = 0;
        int currentSequence = 0;
        for (int i = 0; i < allLogFiles.length; ++i) {
            String logFileName = allLogFiles[i].getName();
            if (logFileName.indexOf(XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) continue;
            String sequenceString = logFileName.substring(logFileName.lastIndexOf(95) + 1, logFileName.indexOf(46));
            try {
                currentSequence = Integer.decode(sequenceString);
                if (currentSequence <= maxSequence) continue;
                maxSequence = currentSequence;
                continue;
            }
            catch (NumberFormatException nfe) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                OiiolTextLogger.appendText("Invalid lang addon log file name encountered" + nfe.getMessage(), OiiolTextLogger.LOG_DETAILED);
            }
        }
        String newInstallLogFile = "installLangAddonLog_" + (maxSequence + 1) + ".xml";
        return newInstallLogFile;
    }

    public String[] getLangAddonXMLLogLocationsForDeinstall(int nHomeIndex, String sCompLoc) {
        String sPath = "";
        if (nHomeIndex == 0) {
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
        }
        File installLogParentDir = new File(sPath);
        String[] fNames = this.getLangAddonLogFilesForDeinstall(installLogParentDir);
        String[] logFilesWithPath = null;
        if (fNames == null) {
            return null;
        }
        logFilesWithPath = new String[fNames.length];
        for (int i = 0; i < logFilesWithPath.length; ++i) {
            sPath = OiixPathOps.directorify(sPath);
            logFilesWithPath[i] = OiixPathOps.concatPath(sPath, fNames[i]);
        }
        return logFilesWithPath;
    }

    public String[] getLangAddonLogFilesForDeinstall(File directoryLocation) {
        File[] allLogFiles = directoryLocation.listFiles();
        if (allLogFiles == null) {
            return null;
        }
        Vector<String> langAddonLogFiles = new Vector<String>();
        for (int i = 0; i < allLogFiles.length; ++i) {
            String logFileName = allLogFiles[i].getName();
            if (logFileName.indexOf(XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) continue;
            langAddonLogFiles.add(logFileName);
        }
        String[] langAddonLogFilesArray = null;
        if (langAddonLogFiles.size() > 0) {
            String[] dummy = new String[1];
            langAddonLogFilesArray = langAddonLogFiles.toArray(dummy);
            Arrays.sort(langAddonLogFilesArray, new LangAddonLogFileComparator());
        }
        return langAddonLogFilesArray;
    }

    public String getXMLContextLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_COMPCONTEXT_FILENAME);
    }

    public String getXMLConfigLogLoc(int homeIndex, String compLoc) {
        return this.getXMLInvFileLoc(homeIndex, compLoc, XML_CONFIGLOG_FILENAME);
    }

    public String getXMLConfigToolsLoc(int homeIndex) {
        String contentDir = this.getContentsDir(homeIndex);
        return OiixPathOps.concatPath(contentDir, XML_CONFIGTOOLS_FILENAME);
    }

    public String getXMLConfigFileLoc(int homeIndex) {
        String sLoc = this.getContentsDir(homeIndex);
        OiiiHomeInvDetails invDetails = this.getInstallInventory().getInvDetails(homeIndex);
        sLoc = OiixPathOps.concatPath(sLoc, invDetails.getConfigToolsFileName());
        sLoc = OiixPathOps.getStandardForm(sLoc);
        return sLoc;
    }

    private String getXMLInvFileLoc(int nHomeIndex, String sCompLoc, String sFileName) {
        String sPath = "";
        if (nHomeIndex == 0) {
            sCompLoc = OiixPathOps.concatPath(sCompLoc, sFileName);
            sPath = this.genLogLoc(sCompLoc);
        } else {
            OiiiCompositeHomeInventory installInv = this.getInstallInventory();
            sPath = installInv.getHomeLocation(nHomeIndex);
            sPath = OiixPathOps.concatPath(sPath, INVENTORY_DIR);
            sPath = OiixPathOps.concatPath(sPath, sCompLoc);
            sPath = OiixPathOps.directorify(sPath);
            sPath = OiixPathOps.concatPath(sPath, sFileName);
        }
        return sPath;
    }

    public String getInventoryLocForHome(int homeIndex) {
        String sLoc = null;
        if (homeIndex == 0) {
            sLoc = this.getAreaRoot();
        } else {
            sLoc = this.getInstallInventory().getHomeLocation(homeIndex);
            sLoc = OiixPathOps.concatPath(sLoc, INVENTORY_DIR);
        }
        return sLoc;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sFilePath, OiiiCompInstallID cid) {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sParentPath, String sChildPath, OiiiCompInstallID cid) {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sFilePath, OiiiOneoffInstallID oid) throws OiiiOneoffException {
        return null;
    }

    public OiiiFileMapFileEntry registerFile(String sHomePath, String sParentPath, String sChildPath, OiiiOneoffInstallID oid) throws OiiiOneoffException {
        return null;
    }

    public void deregisterFile(String sHomePath, String sFilePath, OiiiCompInstallID cid) {
    }

    public void deregisterFile(String sHomePath, String sFilePath, OiiiOneoffInstallID oid) {
    }

    public void deregisterFile(String sHomePath, String sParentPath, String sChildPath, OiiiCompInstallID cid) {
    }

    public void deregisterFile(String sHomePath, String sParentPath, String sChildPath, OiiiOneoffInstallID oid) {
    }

    public Vector getReferencerComponentsForFile(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry fileEntry = fileMap.getFileEntry(sFilePath);
            vComps = fileEntry.getReferencerComponents();
        }
        return vComps;
    }

    public Vector getReferencerOneoffsForFile(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry fileEntry = fileMap.getFileEntry(sFilePath);
            vComps = fileEntry.getReferencerOneoffs();
        }
        return vComps;
    }

    public Vector getReferencerComponentsForFile(String sHomePath, String sParentPath, String sChildPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry parentEntry = fileMap.getFileEntry(sParentPath);
            OiiiFileMapFileEntry childEntry = parentEntry.getFileEntry(sChildPath);
            vComps = childEntry.getReferencerComponents();
        }
        return vComps;
    }

    public Vector getReferencerOneoffsForFile(String sHomePath, String sParentPath, String sChildPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        Vector vComps = null;
        if (fileMap != null) {
            OiiiFileMapFileEntry parentEntry = fileMap.getFileEntry(sParentPath);
            OiiiFileMapFileEntry childEntry = parentEntry.getFileEntry(sChildPath);
            vComps = childEntry.getReferencerComponents();
        }
        return vComps;
    }

    void cleanupHomeDir(OiiiOracleHomeInfo homeInfo) throws IOException {
        int nHomeIndex = homeInfo.getIndex();
        String sHomeLoc = this.getInstallInventory().getHomeLocation(nHomeIndex);
        File ohFile = new File(sHomeLoc);
        if (!ohFile.exists()) {
            return;
        }
        String sInvLoc = this.getInventoryLocForHome(nHomeIndex);
        OiixFileOps.cleanupdelete(new File(sInvLoc));
        String sCfgToolsLogDir = this.getXMLHomeLogsDir(nHomeIndex);
        OiixFileOps.cleanupdelete(new File(sCfgToolsLogDir));
        String sRootSHLoc = OiixPathOps.concatPath(sHomeLoc, ROOTSH_FILENAME);
        File fRootSH = new File(sRootSHLoc);
        fRootSH.delete();
        String sOraInstLoc = OiixPathOps.concatPath(sHomeLoc, ORAINST_FILENAME);
        File fOraInst = new File(sOraInstLoc);
        fOraInst.delete();
        String sGlobalContextLoc = OiixPathOps.concatPath(sHomeLoc, GLOBALCONTEXT_FILENAME);
        File fGlobalContext = new File(sGlobalContextLoc);
        fGlobalContext.delete();
        OiixFileOps.deleteParentDirs(sGlobalContextLoc);
        String sPlatFileLoc = OiixPathOps.concatPath(homeInfo.getLocation(), PLATFORM_FILE_NAME);
        File f = new File(sPlatFileLoc);
        if (!f.exists() || f.delete()) {
            f = new File(homeInfo.getLocation());
            f.delete();
        }
    }

    public OiiiFileMapFileEntry getFileMapFileEntry(String sHomePath, String sFilePath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        OiiiFileMapFileEntry fileEntry = null;
        if (fileMap != null) {
            fileEntry = fileMap.getFileEntry(sFilePath);
        }
        return fileEntry;
    }

    public void loadFiles(String sHomePath, String sDirPath) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        if (fileMap != null) {
            fileMap.loadFileMapDir(sDirPath);
        }
    }

    public void loadFiles(String sHomePath, String sDirPath, String sChildFile) {
        OiiiFileMap fileMap = this.m_fileMapInv.getFileMapForHome(sHomePath);
        if (fileMap != null) {
            fileMap.loadFileMapDir(sDirPath, sChildFile);
        }
    }

    private static boolean hasWritePermissions(String sLoc) {
        try {
            OiipgFileSystem.checkWritablePath(sLoc);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void createInventory(String sInvLoc, String sGroup) throws OiiiInventoryException, IOException {
        OiipgBootstrap pg;
        if (sInvLoc == null) {
            sInvLoc = OiiiCompositeAreaControl.getDefaultInventoryLocation();
        }
        if (!(pg = new OiipgBootstrap()).isCleanMachine()) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 1);
        }
        String errString = null;
        if (!OiiiCompositeAreaControl.hasWritePermissions(sInvLoc)) {
            Object[] args = new Object[]{sInvLoc};
            errString = OiixResourceBundle.getString("S_INV_LOC_RECOV_ERR", args);
            throw new OiiiInventoryException(errString, 2);
        }
        pg.updateInventoryLoc(null, sInvLoc, sGroup);
    }

    public void createCompositeHomeInventory(String sInvLoc) throws OiiiInventoryException, IOException {
        if (sInvLoc == null) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 4);
        }
        OiiiCompositeHomeInventory instInv = this.getInstallInventory();
        OiiiOracleHomeInfo homeInfo = instInv.getCompositeHomeWithLocation(sInvLoc);
        if (homeInfo != null) {
            Object[] args = new Object[]{sInvLoc};
            String sErrorString = OiixResourceBundle.getString("S_INV_CREATE_API_ERR", args);
            throw new OiiiInventoryException(sErrorString, 1);
        }
        String errString = null;
        if (!OiiiCompositeAreaControl.hasWritePermissions(sInvLoc)) {
            Object[] args = new Object[]{sInvLoc};
            errString = OiixResourceBundle.getString("S_INV_LOC_RECOV_ERR", args);
            throw new OiiiInventoryException(errString, 2);
        }
    }

    public static boolean isCleanMachine() {
        return new OiipgBootstrap().isCleanMachine();
    }

    private static String getDefaultInventoryLocation() {
        String locationFileLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
        try {
            locationFileLoc = OiixPathOps.getUnexpandedCanonicalPath(locationFileLoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locationFileLoc;
    }

    public static String getConfigXMLDirRltPath() {
        return CONFIG_XML_DIR_RLT_PATH;
    }

    public static String getOuiConfigVariablesXMLFileName() {
        return OUI_CONFIG_VARIABLES_XML_FILE_NAME;
    }

    public static String getAddLanguageAggregateName() {
        return ADD_LANGUAGE_AGGREGATE_NAME;
    }

    public static String getEnvVarsPropertiesFileName() {
        return ENV_VARS_PROPERTIES_FILENAME;
    }

    public static String getEnvVarsPropertiesFileRltLoc() {
        return ENV_VARS_PROPERTIES_FILE_RLT_LOC;
    }

    public static void main(String[] args) {
    }

    static {
        s_instAreaControl = null;
    }

    private class LangAddonLogFileComparator
    implements Comparator {
        private LangAddonLogFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String logFileName1 = (String)o1;
            String logFileName2 = (String)o2;
            String sequenceString1 = "";
            String sequenceString2 = "";
            int value1 = -3;
            int value2 = -4;
            if (logFileName1.indexOf(OiiiCompositeAreaControl.XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) {
                throw new ClassCastException("Invalid log file name :" + logFileName1);
            }
            sequenceString1 = logFileName1.substring(logFileName1.lastIndexOf(95) + 1, logFileName1.indexOf(46));
            if (logFileName2.indexOf(OiiiCompositeAreaControl.XML_LANGADDON_INSTALL_LOG_FILENAME_PREFIX) <= -1) {
                throw new ClassCastException("Invalid log file name" + logFileName2);
            }
            sequenceString2 = logFileName2.substring(logFileName2.lastIndexOf(95) + 1, logFileName2.indexOf(46));
            try {
                value1 = Integer.decode(sequenceString1);
                value2 = Integer.decode(sequenceString2);
            }
            catch (NumberFormatException nfe) {
                throw new ClassCastException("Invalid sequence number in log file " + nfe.getMessage());
            }
            return value1 > value2 ? -1 : (value1 == value2 ? 0 : 1);
        }
    }
}

