/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.bali.share.nls.StringUtils;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInventoryHelper;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiis.OiisSize;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;

public class OiiiCompInvEntry
implements OiiiVersioned,
Cloneable,
OixsXMLizable {
    static final long serialVersionUID = -822756281938553156L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4096;
    private OiiiCompInstallID m_cid;
    private String m_loc;
    private Vector m_langVect;
    private OiisSize m_oSize;
    private transient ResourceBundle m_resBundle;
    private transient OiiiTargetAreaControl m_oAreaCtrl;
    private OiisFileSizeInfo m_oFileSizeInfo = null;
    private OiisPlatIndexMapping m_oPlatIndMap = null;
    private OiisLangIndexMapping m_oLangIndMap = null;
    private OiisDestinationIndexMapping m_oDestIndMap = null;
    private boolean m_topLevel;
    private boolean m_clonable;
    protected Vector m_dependees;
    protected Vector m_referencers;
    protected Vector m_platVect;
    private String m_updateSiteLoc = null;
    private transient boolean m_bDeleted = false;
    private String m_descResourceId;
    private String m_externalName;
    private String m_description;
    private Boolean m_bIsNoPreReq;
    private Boolean m_bIsNoProdHome;
    private transient OiisDepInfo m_oDepInfo;
    private OiisDeps m_oDeps;
    private OiiiVersion m_oStageVersion = null;
    private OiiiVersion m_oOrigStageVersion = null;
    private String m_sInstallDefnLoc;
    private String m_jarName;
    private boolean m_bDefaultify = true;
    private OiisCompProperties m_compProps;
    private boolean m_bCreatedInThisSession = false;

    public OiiiCompInvEntry(OiiiCompInstallID cid, String location, Vector langVect) {
        this(cid, location, langVect, null);
    }

    public OiiiCompInvEntry(OiiiCompInstallID cid, String location, Vector langVect, Vector platVect) {
        this.m_cid = cid;
        this.m_loc = location;
        this.m_langVect = langVect;
        this.m_platVect = platVect == null ? cid.getPlatforms() : platVect;
        this.m_dependees = new Vector();
        this.m_referencers = new Vector();
        this.m_topLevel = false;
        this.m_clonable = true;
        this.m_bIsNoPreReq = OiixUtilityOps.booleanValueOf(false);
        this.m_oDeps = null;
        this.m_bCreatedInThisSession = true;
    }

    protected void updateLanguages(Vector vLangs) {
        this.m_langVect.addAll(vLangs);
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_cid;
    }

    @Override
    public OiiiVersion getVersion() {
        return this.m_cid.getVersion();
    }

    public int getReleaseLevel() {
        return this.m_cid.getReleaseLevel();
    }

    public String getLocation() {
        return this.m_loc;
    }

    public void setLanguages(Vector vLangVect) {
        this.m_langVect = vLangVect;
    }

    public boolean wasCreatedInThisSession() {
        return this.m_bCreatedInThisSession;
    }

    void setCreatedInThisSession(boolean bCreatedInThisSession) {
        this.m_bCreatedInThisSession = bCreatedInThisSession;
    }

    public Vector getLanguages() {
        if (this.getCompInstallID().getCompType() == 4) {
            if (this.m_langVect.size() == 0) {
                Locale l = Locale.getDefault();
                this.m_langVect.addElement(l);
            }
        } else {
            if (this.m_langVect == null) {
                this.m_langVect = new Vector(1);
            }
            if (this.m_langVect.size() == 0) {
                this.m_langVect.addElement(OiixLanguage.ENGLISH);
            }
        }
        return this.m_langVect;
    }

    public void setPlatforms(Vector vPlatVect) {
        this.m_platVect = vPlatVect;
    }

    public void optimizePlatList() {
        OiiiCompIdOhPair c;
        Enumeration e;
        this.setPlatforms(OiixPlatform.getOptimizedPlatformVector(this.m_platVect));
        if (this.m_dependees != null) {
            e = this.m_dependees.elements();
            while (e.hasMoreElements()) {
                c = (OiiiCompIdOhPair)e.nextElement();
                c.optimizePlatList();
            }
        }
        if (this.m_referencers != null) {
            e = this.m_referencers.elements();
            while (e.hasMoreElements()) {
                c = (OiiiCompIdOhPair)e.nextElement();
                c.optimizePlatList();
            }
        }
        if (this.m_oSize != null) {
            this.m_oSize.optimize();
        }
        if (this.m_oDeps != null) {
            this.m_oDeps.optimizePlatList();
        }
    }

    public void setFileSizeInfoEx(OiisFileSizeInfo fileSizeInfo) {
        this.m_oFileSizeInfo = fileSizeInfo;
    }

    public OiisFileSizeInfo getFileSizeInfoEx() {
        return this.m_oFileSizeInfo;
    }

    public OiisDestinationIndexMapping getDestIndexMapping() {
        return this.m_oDestIndMap;
    }

    public OiisPlatIndexMapping getPlatIndexMapping() {
        return this.m_oPlatIndMap;
    }

    public OiisLangIndexMapping getLangIndexMapping() {
        return this.m_oLangIndMap;
    }

    public void setDestIndexMapping(OiisDestinationIndexMapping destIndMap) {
        this.m_oDestIndMap = destIndMap;
    }

    public void setPlatIndexMapping(OiisPlatIndexMapping platIndMap) {
        this.m_oPlatIndMap = platIndMap;
    }

    public void setLangIndexMapping(OiisLangIndexMapping langIndMap) {
        this.m_oLangIndMap = langIndMap;
    }

    public void optimizeLangList() {
        Vector vLangs = this.getLanguages();
        if (vLangs != null) {
            int size = vLangs.size();
            Locale l = null;
            for (int i = 0; i < size; ++i) {
                l = (Locale)vLangs.elementAt(i);
                vLangs.setElementAt(OiixLanguage.getLocaleInstance(l), i);
            }
        }
    }

    public void optimizeSizeVector() {
        if (!this.isTopLevel()) {
            this.releaseSize();
        }
        if (this.m_oDeps != null) {
            this.m_oDeps.optimizeSizeVector();
        }
    }

    public Vector getPlatforms() {
        if (this.m_platVect == null) {
            this.m_platVect = this.m_cid.getPlatforms();
        }
        return this.m_platVect;
    }

    public boolean isSupportedOnPlat(int plat) {
        if (this.getCompInstallID().getCompType() == 4) {
            return true;
        }
        boolean retval = this.getPlatforms().contains(new Integer(plat));
        return retval;
    }

    protected void setLocation(String location) {
        this.m_loc = location;
    }

    public void setReferencers(Vector referencers) {
        this.m_referencers = referencers;
    }

    public void addReferencer(OiiiCompIdOhPair cIdOh) {
        if (!this.m_referencers.contains(cIdOh)) {
            this.m_referencers.addElement(cIdOh);
        }
    }

    public void removeReferencer(OiiiCompIdOhPair cIdOh) {
        this.m_referencers.removeElement(cIdOh);
    }

    public Vector getReferencers() {
        return this.m_referencers;
    }

    public OiiiCompIdOhPair getReferencer(OiiiCompIdOhPair referencer) {
        int refIndex = this.m_referencers.indexOf(referencer);
        if (refIndex != -1) {
            return (OiiiCompIdOhPair)this.m_referencers.elementAt(refIndex);
        }
        return null;
    }

    public void addDependee(OiiiCompIdOhPair cIdOh) {
        if (!this.m_dependees.contains(cIdOh)) {
            this.m_dependees.addElement(cIdOh);
        }
    }

    public void removeDependee(OiiiCompIdOhPair cIdOh) {
        this.m_dependees.removeElement(cIdOh);
    }

    public void setDependees(Vector dependees) {
        this.m_dependees = dependees;
    }

    public Vector getDependees() {
        return this.m_dependees;
    }

    public Vector getDependees(String sDepGroup) {
        int iDeps = this.m_dependees.size();
        Vector<OiiiCompIdOhPair> vDeps = new Vector<OiiiCompIdOhPair>();
        for (int i = 0; i < iDeps; ++i) {
            OiiiCompIdOhPair oDep = (OiiiCompIdOhPair)this.m_dependees.elementAt(i);
            if (!sDepGroup.equalsIgnoreCase(oDep.getDepGroup())) continue;
            vDeps.addElement(oDep);
        }
        return vDeps;
    }

    public OiiiCompIdOhPair getDependee(OiiiCompIdOhPair dependee) {
        int depIndex = this.m_dependees.indexOf(dependee);
        if (depIndex != -1) {
            return (OiiiCompIdOhPair)this.m_dependees.elementAt(depIndex);
        }
        return null;
    }

    public boolean equals(OiiiCompInstallID cid) {
        return this.m_cid.equalsWithPlatInt(cid);
    }

    public boolean equals(String name) {
        return this.m_cid.equals(name);
    }

    public boolean equals(OiiiCompInvEntry cie) {
        if (cie != null) {
            if (this == cie) {
                return true;
            }
            return this.m_cid.equals(cie.getCompInstallID()) && this.m_loc.equals(cie.getLocation());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiiiCompInstallID) {
                return this.equals((OiiiCompInstallID)obj);
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            if (obj instanceof OiiiCompInvEntry) {
                return this.equals((OiiiCompInvEntry)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer langStr = new StringBuffer();
        if (this.m_langVect != null) {
            Enumeration langs = this.m_langVect.elements();
            while (langs.hasMoreElements()) {
                langStr.append(langs.nextElement() + " ");
            }
        }
        return "[" + this.m_cid.toString() + "], " + this.m_loc + ", [ " + langStr + "]";
    }

    public void setResourceBundle(ResourceBundle resBundle) {
        this.m_resBundle = resBundle;
    }

    public ResourceBundle getResourceBundle(Locale loc) {
        if (this.m_oAreaCtrl != null) {
            return this.m_oAreaCtrl.getResourceBundle(this, loc);
        }
        return null;
    }

    public ResourceBundle getResourceBundle() {
        if (this.m_resBundle == null && this.m_oAreaCtrl != null) {
            this.setResourceBundle(this.m_oAreaCtrl.getResourceBundle(this));
        }
        return this.m_resBundle;
    }

    public void setDescResourceId(String descId) {
        this.m_descResourceId = descId;
    }

    public void setDescription(String desc) {
        this.m_description = desc;
    }

    public String getDescResourceId() {
        if (this.m_descResourceId != null) {
            return this.m_descResourceId;
        }
        return "Description";
    }

    public void setAreaControl(OiiiTargetAreaControl oAreaCtrl) {
        this.m_oAreaCtrl = oAreaCtrl;
    }

    public OiiiTargetAreaControl getAreaControl() {
        return this.m_oAreaCtrl;
    }

    public void setName(String extName) {
        this.m_externalName = extName;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean bStripMnemonics) {
        if (this.m_externalName == null) {
            ResourceBundle rb = null;
            rb = !Locale.getDefault().equals(OiixLanguage.ENGLISH) ? this.getResourceBundle(OiixLanguage.ENGLISH) : this.getResourceBundle();
            if (rb != null) {
                this.m_externalName = rb.getString("Name");
            }
            if (this.m_externalName == null) {
                this.m_externalName = this.m_cid.getName();
            }
        }
        return bStripMnemonics ? StringUtils.stripMnemonic((String)this.m_externalName) : this.m_externalName;
    }

    public String getFullDisplayName() {
        return this.getFullDisplayName(OiixOraparam.canIgnoreBuildNumber(), true);
    }

    public String getFullDisplayName(boolean bIgnoreBuild) {
        return this.getFullDisplayName(bIgnoreBuild, true);
    }

    public String getFullDisplayName(boolean bIgnoreBuild, boolean bStripMnemonics) {
        Object[] s = new String[]{this.getName(bStripMnemonics), this.getVersion().getVerString(bIgnoreBuild), ""};
        if (OiiiReleaseLevels.DisplayReleaseLevel(this.getReleaseLevel())) {
            s[2] = OiiiReleaseLevels.getReleaseLevelString(this.getReleaseLevel());
        }
        String fullName = OiixResourceBundle.getString("S_COMP_FULL_DISPLAY_NAME", s);
        return fullName;
    }

    public String getDescription(Locale loc) {
        String descId = "Description";
        String sDesc = "";
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (loc.equals(OiixLanguage.ENGLISH) && this.m_description != null) {
            sDesc = this.m_description;
        } else {
            String[] asResourceIDs;
            if (this.m_descResourceId != null) {
                descId = OiisGenericConstant.formDefaultName(this.m_descResourceId);
            }
            ResourceBundle rb = null;
            rb = !loc.equals(Locale.getDefault()) ? this.getResourceBundle(loc) : this.getResourceBundle();
            sDesc = this.getValue(rb, asResourceIDs = new String[]{descId, this.m_descResourceId, "Description"});
            if (sDesc == null) {
                sDesc = this.m_description != null ? this.m_description : "";
            }
        }
        return sDesc;
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    private String getValue(ResourceBundle rb, String[] asResourceIDs) {
        String sValue = null;
        boolean bFound = false;
        if (rb != null) {
            for (int i = 0; !bFound && i < asResourceIDs.length; ++i) {
                try {
                    sValue = rb.getString(asResourceIDs[i]);
                    bFound = true;
                    continue;
                }
                catch (MissingResourceException e) {
                    bFound = false;
                    continue;
                }
                catch (NullPointerException e) {
                    bFound = false;
                }
            }
        }
        return sValue;
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    public void setNoPreReq(boolean bNoPreReq) {
        this.m_bIsNoPreReq = OiixUtilityOps.booleanValueOf(bNoPreReq);
    }

    public boolean isNoPreReq() {
        if (this.m_bIsNoPreReq == null) {
            this.m_bIsNoPreReq = OiixUtilityOps.booleanValueOf(false);
        }
        return this.m_bIsNoPreReq;
    }

    public void setNoProdHome(boolean bNoProdHome) {
        this.m_bIsNoProdHome = OiixUtilityOps.booleanValueOf(bNoProdHome);
    }

    public boolean isNoProdHome() {
        if (this.m_bIsNoProdHome == null) {
            this.m_bIsNoProdHome = OiixUtilityOps.booleanValueOf(false);
        }
        return this.m_bIsNoProdHome;
    }

    public void setClonable(boolean clonable) {
        this.m_clonable = clonable;
    }

    public boolean isClonable() {
        return this.m_clonable;
    }

    public String getUpdateSiteLoc() {
        return this.m_updateSiteLoc;
    }

    public void setUpdateSiteLoc(String updateSiteLoc) {
        this.m_updateSiteLoc = updateSiteLoc;
    }

    public void setSize(Integer plat, String sDepMode, Long nSize) {
        if (this.m_oSize == null) {
            this.m_oSize = new OiisSize();
        }
        this.m_oSize.setSize(plat, sDepMode, nSize);
    }

    public void resetSize() {
        this.m_oSize = null;
    }

    public void updateSize(Integer plat, String sDepMode, long[] alSizes) {
        if (this.m_oSize == null) {
            this.m_oSize = new OiisSize();
        }
        this.m_oSize.updateSize(plat, sDepMode, alSizes);
    }

    public void updateLargestJarSize(Integer plat, String sDepMode, long lSz) {
        if (this.m_oSize == null) {
            this.m_oSize = new OiisSize();
        }
        this.m_oSize.updateLargestFileGroupJarSize(plat, sDepMode, lSz);
    }

    public Long getSize(Integer plat, String sDepMode) {
        if (this.m_oSize == null) {
            return new Long(0L);
        }
        return this.m_oSize.getSize(plat, sDepMode);
    }

    public OiisSize getSizeInfo() {
        return this.m_oSize;
    }

    public void setSizeInfo(OiisSize oSize) {
        this.m_oSize = oSize;
    }

    public void setSize(Integer plat, Long nSize) {
        if (this.m_oSize == null) {
            this.m_oSize = new OiisSize();
        }
        this.m_oSize.setSize(plat, "Custom", nSize);
    }

    public Long getSize(Integer plat) {
        return this.getSize(plat, "Custom");
    }

    public void setSize(Long nSize) {
        this.setSize(new Integer(-1), nSize);
    }

    public Long getSize() {
        return this.getSize(new Integer(-1));
    }

    public void releaseSize() {
        this.m_oSize = null;
    }

    public OiisDepInfo getDepInfo() {
        if (this.m_oDepInfo == null && this.m_oDeps != null) {
            this.m_oDepInfo = new OiisDepInfo(this.getDeps());
        }
        return this.m_oDepInfo;
    }

    public void setDepInfo(OiisDepInfo depInfo) {
        this.m_oDepInfo = depInfo;
    }

    public void setDepModeName(String sModeName) {
        if (this.getDepInfo() != null) {
            this.getDepInfo().setDepModeName(sModeName);
        }
    }

    public void setDeps(OiisDeps deps) {
        this.m_oDeps = deps;
    }

    public OiisDeps getDeps() {
        return this.m_oDeps;
    }

    public void setStageVersion(OiiiVersion oVersion) {
        if (this.m_oStageVersion != null) {
            this.m_oOrigStageVersion = this.m_oStageVersion;
        }
        this.m_oStageVersion = oVersion;
    }

    public OiiiVersion getStageVersion() {
        return this.m_oStageVersion;
    }

    void setOriginalStageVersion(OiiiVersion oVersion) {
        this.m_oOrigStageVersion = oVersion;
    }

    OiiiVersion getOriginalStageVersion() {
        return this.m_oOrigStageVersion;
    }

    public void setInstallDefnLoc(String sInstallDefnLoc) {
        this.m_sInstallDefnLoc = sInstallDefnLoc;
    }

    public String getInstallDefnLoc() {
        return this.m_sInstallDefnLoc == null ? this.getJarContentsLoc() : this.m_sInstallDefnLoc;
    }

    protected String getJarContentsLoc() {
        return null;
    }

    public void setJarName(String jarName) {
        this.m_jarName = jarName;
    }

    public String getJarName() {
        return this.m_jarName;
    }

    public boolean canDefaultify() {
        return this.m_bDefaultify;
    }

    public void setCanDefaultify(boolean bDefaultify) {
        this.m_bDefaultify = bDefaultify;
    }

    public void setCompProperties(OiisCompProperties cp) {
        this.m_compProps = cp;
    }

    public OiisCompProperties getCompProperties() {
        return this.m_compProps;
    }

    public void releaseDeps() {
        this.m_oDeps = null;
    }

    public void dispose() {
        if (this.m_langVect != null) {
            this.m_langVect.removeAllElements();
        }
        if (this.m_platVect != null) {
            this.m_platVect.removeAllElements();
        }
        this.m_dependees = null;
        this.m_referencers = null;
        this.m_langVect = null;
        this.m_oSize = null;
        this.m_platVect = null;
        this.m_resBundle = null;
        this.m_oAreaCtrl = null;
        this.m_bIsNoPreReq = null;
        this.m_bIsNoProdHome = null;
        this.m_oDeps = null;
        this.m_jarName = null;
        this.m_compProps = null;
    }

    public void setDeleted(boolean bDeleted) {
        this.m_bDeleted = bDeleted;
    }

    public boolean isDeleted() {
        return this.m_bDeleted;
    }

    @Override
    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    @Override
    public void writeXML(PrintWriter out) throws IOException {
        XMLElement element = this.buildDOMTree();
        element.print(out);
    }

    protected XMLElement buildDOMTree() {
        XMLElement elemComp = this.createXMLElement();
        elemComp.setAttribute("NAME", this.m_cid.getName());
        elemComp.setAttribute("VER", this.m_cid.getVersion().getVerString());
        elemComp.setAttribute("BUILD_NUMBER", Integer.toString(this.m_cid.getVersion().getBuildNumber()));
        elemComp.setAttribute("REP_VER", this.m_cid.getReplaceVersion().getVerString());
        String sRelName = "";
        try {
            sRelName = OiiiReleaseLevels.getReleaseLevelName(this.m_cid.getReleaseLevel());
        }
        catch (OiixEnumException oiixEnumException) {
            // empty catch block
        }
        elemComp.setAttribute("RELEASE", sRelName);
        elemComp.setAttribute("INV_LOC", this.m_loc);
        elemComp.setAttribute("LANGS", OiixLanguage.vectToStr(this.m_langVect));
        if (!this.m_clonable) {
            elemComp.setAttribute("CLONABLE", "F");
        }
        XMLElement elemExtName = new XMLElement("EXT_NAME");
        elemExtName.appendChild((Node)new XMLText(this.getName()));
        XMLElement elemDesc = new XMLElement("DESC");
        elemDesc.appendChild((Node)new XMLText(this.getDescription(OiixLanguage.ENGLISH)));
        XMLElement elemDescID = new XMLElement("DESCID");
        elemDescID.appendChild((Node)new XMLText(this.getDescResourceId()));
        XMLElement elemStageInfo = new XMLElement("STG_INFO");
        if (this.m_oStageVersion != null) {
            elemStageInfo.setAttribute("OSP_VER", this.m_oStageVersion.getVerString());
        }
        XMLElement elemLocationsInfo = OiiiInventoryHelper.getLocationsInfoXML(this);
        XMLElement elemCompJarInfo = OiiiInventoryHelper.getCompJarInfoXML(this);
        XMLElement elemBook = OiiiInventoryHelper.getBookNameXML(this);
        XMLElement elemPreReq = OiiiInventoryHelper.getPreReqXML(this);
        XMLElement elemProdHome = OiiiInventoryHelper.getProdHomeXML(this);
        XMLElement elemLangIndexMap = OiiiInventoryHelper.getLangIndexMapXML(this);
        XMLElement elemPlatIndexMap = OiiiInventoryHelper.getPlatIndexMapXML(this);
        XMLElement elemDestIndexMap = OiiiInventoryHelper.getDestIndexMapXML(this);
        elemComp.appendChild((Node)elemExtName);
        elemComp.appendChild((Node)elemDesc);
        elemComp.appendChild((Node)elemDescID);
        elemComp.appendChild((Node)elemStageInfo);
        elemComp.appendChild((Node)elemCompJarInfo);
        elemComp.appendChild((Node)elemLocationsInfo);
        elemComp.appendChild((Node)elemBook);
        elemComp.appendChild((Node)elemPreReq);
        elemComp.appendChild((Node)elemProdHome);
        elemComp.appendChild((Node)elemLangIndexMap);
        elemComp.appendChild((Node)elemPlatIndexMap);
        if (elemDestIndexMap != null) {
            elemComp.appendChild((Node)elemDestIndexMap);
        }
        return elemComp;
    }

    protected XMLElement createXMLElement() {
        return new XMLElement("COMP");
    }

    public void setSelectedLanguages(Vector vLangs) {
        if (this.m_oLangIndMap != null) {
            this.m_oLangIndMap.setSelectedLanguages(vLangs);
        }
    }

    public Object clone() {
        OiiiCompInvEntry oClone = null;
        try {
            oClone = (OiiiCompInvEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        oClone.setPlatforms((Vector)this.m_platVect.clone());
        if (this.m_compProps != null) {
            oClone.m_compProps = (OiisCompProperties)this.m_compProps.clone();
        }
        return oClone;
    }
}

