/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompType;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersioned;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.xml.parser.v2.XMLElement;

public class OiiiCompInstallID
implements Serializable,
OiiiVersioned {
    static final long serialVersionUID = -9065560263812660771L;
    private String m_name;
    private OiiiVersion m_version;
    private OiiiVersion m_replaceVer;
    private int m_releaseLevel;
    private Vector m_platforms;
    private int m_compType;
    private boolean m_extDep;
    private String m_depHome;
    public static final int S_NON_ORACLE_HOME = 0;
    public static final int S_SINGLE_ORACLE_HOME = 1;
    public static final int S_MULTIPLE_ORACLE_HOME = 2;
    public static final int S_APPLTOP = 3;
    public static final int S_COMPONENT_TYPES = 4;
    private int m_oracleHomeType = 2;
    private static transient boolean s_bShouldOptimize = false;
    private transient XMLElement m_unknownXMLElement;

    public OiiiCompInstallID(String name, OiiiVersion version, Vector platforms, OiiiVersion replaceVer, int compType, int oracleHomeType, boolean oracleHomeComp, int releaseLevel, boolean bConvert) {
        this(name, version, platforms, replaceVer, compType, oracleHomeType, releaseLevel, bConvert);
    }

    public OiiiCompInstallID(String name, OiiiVersion version, Vector platforms, OiiiVersion replaceVer, int compType, int oracleHomeType, int releaseLevel) {
        this(name, version, platforms, replaceVer, compType, oracleHomeType, releaseLevel, true);
    }

    public OiiiCompInstallID(String name, OiiiVersion version, Vector platforms, OiiiVersion replaceVer, int compType, int oracleHomeType, int releaseLevel, boolean bConvert) {
        this(name, version, platforms, replaceVer, compType, oracleHomeType, releaseLevel, bConvert, false, "");
    }

    public OiiiCompInstallID(String name, OiiiVersion version, Vector platforms, OiiiVersion replaceVer, int compType, int oracleHomeType, int releaseLevel, boolean bConvert, boolean bExtDep, String homeLoc) {
        this.m_name = name;
        this.m_version = version;
        this.m_platforms = platforms;
        this.m_replaceVer = replaceVer;
        this.setCompType(compType);
        this.m_oracleHomeType = oracleHomeType;
        this.m_releaseLevel = releaseLevel;
        if (bConvert) {
            this.m_version = OiiiVersion.getStandardForm(this.m_version);
            this.m_replaceVer = OiiiVersion.getStandardForm(this.m_replaceVer);
        }
        this.m_extDep = bExtDep;
        this.m_depHome = homeLoc;
    }

    public OiiiCompInstallID(String name, OiiiVersion version, Vector vPlatforms) {
        this(name, version, vPlatforms, new OiiiVersion("0.0.0.0.0"), 1, 0, 0);
    }

    public OiiiCompInstallID(String name, OiiiVersion version, Vector vPlatforms, boolean bExtDep, String depHome) {
        this(name, version, vPlatforms, new OiiiVersion("0.0.0.0.0"), 1, 0, 0, true, bExtDep, depHome);
    }

    public void setName(String sName) {
        this.m_name = sName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setVersion(OiiiVersion sVersion) {
        this.m_version = OiiiVersion.getStandardForm(sVersion);
    }

    @Override
    public OiiiVersion getVersion() {
        return this.m_version;
    }

    public int getReleaseLevel() {
        return this.m_releaseLevel;
    }

    public int getCompType() {
        if (this.m_compType == 0) {
            this.m_compType = 1;
        }
        return this.m_compType;
    }

    public boolean isOracleHomeComp() {
        return this.m_oracleHomeType == 1 || this.m_oracleHomeType == 2;
    }

    public boolean isNOHComp() {
        return this.m_oracleHomeType == 0;
    }

    public boolean isAppltopComponent() {
        return this.m_oracleHomeType == 3;
    }

    public int getOracleHomeType() {
        return this.getHomeType();
    }

    public int getHomeType() {
        return this.m_oracleHomeType;
    }

    public void setOracleHomeType(int ohType) {
        this.setHomeType(ohType);
    }

    public void setHomeType(int ohType) {
        if (ohType != 2 && ohType != 0 && ohType != 1 && ohType != 3) {
            throw new IllegalArgumentException("Unknown Home type: " + ohType);
        }
        this.m_oracleHomeType = ohType;
    }

    public void setReleaseLevel(int releaseLevel) throws OiixEnumException {
        OiiiReleaseLevels.validateReleaseLevel(releaseLevel);
        this.m_releaseLevel = releaseLevel;
    }

    public void setCompType(int compType) {
        if (compType == 0) {
            this.m_compType = 1;
        } else if (OiiiCompType.validType(compType)) {
            this.m_compType = compType;
        }
    }

    public OiiiVersion getReplaceVersion() {
        return this.m_replaceVer;
    }

    public void setReplaceVersion(OiiiVersion ver) {
        this.m_replaceVer = OiiiVersion.getStandardForm(ver);
    }

    public Vector getPlatforms() {
        return this.m_platforms;
    }

    public void setPlatforms(Vector platforms) {
        this.m_platforms = platforms;
    }

    public boolean forPlatform(String platform) {
        return this.m_platforms.contains(platform);
    }

    public void optimizePlatList() {
        if (s_bShouldOptimize) {
            this.setPlatforms(OiixPlatform.getOptimizedPlatformVector(this.getPlatforms()));
        }
    }

    public static void setShouldOptimize(boolean bShouldOptimize) {
        s_bShouldOptimize = bShouldOptimize;
    }

    public OiiiCompInstallID getIDAsCompID() {
        return this;
    }

    public boolean isCompatible(OiiiCompInstallID cid) {
        return this.isCompatible(cid, true);
    }

    public boolean isCompatible(OiiiCompInstallID cid, boolean bIgnoreBuild) {
        if (cid != null) {
            if (cid == this) {
                return true;
            }
            if (this.m_name.equalsIgnoreCase(cid.getName()) && !this.m_replaceVer.laterThan(cid.getVersion()) && (this.m_version.equals(cid.getVersion(), bIgnoreBuild) || this.m_version.laterThan(cid.getVersion(), bIgnoreBuild))) {
                if (this.getCompType() == 4) {
                    return true;
                }
                if (OiixVectorOps.checkIntersection(this.m_platforms, cid.getPlatforms())) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean inSameVersionRange(OiiiCompInstallID cid) {
        if (cid == this) {
            return true;
        }
        if (cid != null) {
            return this.m_name.equalsIgnoreCase(cid.getName()) && (cid.getReplaceVersion().equals(this.m_replaceVer) || !this.m_replaceVer.laterThan(cid.getVersion()) && !cid.getReplaceVersion().laterThan(this.m_version));
        }
        return false;
    }

    public boolean canReplace(OiiiCompInstallID cid, int nPlatform) {
        return this.canReplace(cid, nPlatform, true);
    }

    public boolean canReplace(OiiiCompInstallID cid, int nPlatform, boolean bIgnoreBuild) {
        if (cid != null) {
            if (cid == this) {
                return true;
            }
            if (this.m_name.equalsIgnoreCase(cid.getName()) && !this.m_replaceVer.laterThan(cid.getVersion()) && (this.m_version.equals(cid.getVersion(), bIgnoreBuild) || this.m_version.laterThan(cid.getVersion(), bIgnoreBuild))) {
                if (this.getCompType() == 4) {
                    return true;
                }
                if (OiixVectorOps.vectIndexOf(this.m_platforms, (Object)new Integer(nPlatform)) != -1) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean canReplace(OiiiCompInstallID cid) {
        return this.canReplace(cid, OiixPlatform.getCurrentPlatform());
    }

    public boolean equalsWithPlatInt(OiiiCompInstallID cid) {
        return this.equalsWithPlatInt(cid, true);
    }

    public boolean equalsWithPlatInt(OiiiCompInstallID cid, boolean bIgnoreBuild) {
        if (cid != null) {
            if (cid == this) {
                return true;
            }
            if (this.m_name.equalsIgnoreCase(cid.getName()) && this.m_version.equals(cid.getVersion(), bIgnoreBuild)) {
                if (this.getCompType() == 4) {
                    return true;
                }
                if (OiixVectorOps.checkIntersection(this.m_platforms, cid.getPlatforms())) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean equalsNoPlat(OiiiCompInstallID cid, int nPlatform) {
        return this.equalsNoPlat(cid, nPlatform, true);
    }

    public boolean equalsNoPlat(OiiiCompInstallID cid, int nPlatform, boolean bIgnoreBuild) {
        if (cid != null) {
            if (cid == this) {
                return true;
            }
            return this.m_name.equalsIgnoreCase(cid.getName()) && this.m_version.equals(cid.getVersion(), bIgnoreBuild) && (this.getCompType() == 4 || nPlatform == 0 || OiixVectorOps.vectIndexOf(this.m_platforms, (Object)new Integer(nPlatform)) != -1);
        }
        return false;
    }

    public boolean equals(String name) {
        return this.m_name.equalsIgnoreCase(name);
    }

    public boolean equals(OiiiCompInstallID cid) {
        return this.equals(cid, true);
    }

    public boolean equals(OiiiCompInstallID cid, boolean bIgnoreBuild) {
        if (cid == this) {
            return true;
        }
        if (cid != null) {
            return this.m_name.equalsIgnoreCase(cid.getName()) && this.m_version.equals(cid.getVersion(), bIgnoreBuild) && OiixVectorOps.vectorsEqual(this.m_platforms, cid.getPlatforms()) && this.m_extDep == cid.isExtDep();
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            if (obj instanceof OiiiCompInstallID) {
                return this.equals((OiiiCompInstallID)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer platStr = new StringBuffer();
        Integer type = new Integer(this.m_oracleHomeType);
        Enumeration plats = this.m_platforms.elements();
        while (plats.hasMoreElements()) {
            platStr.append((Integer)plats.nextElement() + " ");
        }
        return this.m_name + ", " + this.m_version.getVerString(OiixOraparam.canIgnoreBuildNumber()) + ", >" + this.m_replaceVer.toString() + ", [ " + platStr + "]" + "[OH:" + type.toString() + "]";
    }

    private String toHashCode() {
        StringBuffer platStr = new StringBuffer();
        Enumeration plats = this.m_platforms.elements();
        while (plats.hasMoreElements()) {
            platStr.append((Integer)plats.nextElement() + " ");
        }
        return this.m_name + ", " + this.m_version.toHashCode() + ", >" + this.m_replaceVer.toHashCode() + ", [ " + platStr + "]";
    }

    public int hashCode() {
        return this.toHashCode().hashCode();
    }

    void setUnknownXMLElement(XMLElement element) {
        this.m_unknownXMLElement = element;
    }

    XMLElement getUnknownXMLElement() {
        return this.m_unknownXMLElement;
    }

    public static void main(String[] args) {
        Vector<Integer> plat = new Vector<Integer>();
        plat.addElement(new Integer(912));
        OiiiCompInstallID id1 = new OiiiCompInstallID("Comp A", new OiiiVersion("1.0"), plat, new OiiiVersion("0.0"), 1, 2, 0);
        OiiiCompInstallID id2 = new OiiiCompInstallID("Comp A", new OiiiVersion("2.0"), plat, new OiiiVersion("0.0"), 1, 2, 0);
        System.out.println("case 1 id1 <1.0,0.0>, id2 <2.0, 0.0> : " + id1.inSameVersionRange(id2));
        System.out.println("case 2 id1 <2.0,0.0>, id2 <1.0, 0.0> : " + id2.inSameVersionRange(id1));
        id1 = new OiiiCompInstallID("Comp A", new OiiiVersion("1.0"), plat, new OiiiVersion("0.5"), 1, 2, 0);
        System.out.println("case 3 id1 <1.0,0.5>, id2 <2.0, 0.0> : " + id1.inSameVersionRange(id2));
        System.out.println("case 4 id1 <2.0,0.0>, id2 <1.0, 0.5> : " + id2.inSameVersionRange(id1));
        id1 = new OiiiCompInstallID("Comp A", new OiiiVersion("1.0"), plat, new OiiiVersion("0.0"), 1, 2, 0);
        id2 = new OiiiCompInstallID("Comp A", new OiiiVersion("2.0"), plat, new OiiiVersion("1.0"), 1, 2, 0);
        System.out.println("case 5 id1 <1.0,0.0>, id2 <2.0, 1.0> : " + id1.inSameVersionRange(id2));
        System.out.println("case 6 id1 <2.0,1.0>, id2 <1.0, 0.0> : " + id2.inSameVersionRange(id1));
        id2 = new OiiiCompInstallID("Comp A", new OiiiVersion("2.0"), plat, new OiiiVersion("1.1"), 1, 2, 0);
        System.out.println("case 7 id1 <1.0,0.0>, id2 <2.0, 1.0> : " + id1.inSameVersionRange(id2));
        System.out.println("case 8 id1 <2.0,1.0>, id2 <1.0, 0.0> : " + id2.inSameVersionRange(id1));
    }

    public boolean isExtDep() {
        return this.m_extDep;
    }

    public void setExtDep(boolean dep) {
        this.m_extDep = dep;
    }

    public String getDepHome() {
        return this.m_depHome;
    }

    public void setDepHome(String home) {
        this.m_depHome = home;
    }
}

