/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.xml.parser.v2.XMLElement;

public class OiiiCompIdOhPair {
    static final long serialVersionUID = 7017210981878717213L;
    private final OiiiCompInstallID m_compID;
    private int m_ohIndex;
    private int m_depType;
    private transient int m_compType;
    private String m_sDepGroup;
    private transient boolean m_bDeinstall;
    private int m_hashCode = 0;
    private transient XMLElement m_unknownXMLElement;

    public OiiiCompIdOhPair(OiiiCompInstallID compID, int ohIndex) {
        this.m_compID = compID;
        this.m_ohIndex = ohIndex;
        this.m_hashCode = this.calcHashCode();
        this.m_depType = 0;
        this.m_compType = 4;
    }

    private int calcHashCode() {
        String hashString = "" + this.m_ohIndex + "::" + this.m_compID.toString();
        return hashString.hashCode();
    }

    public void optimizePlatList() {
        this.m_compID.optimizePlatList();
    }

    public int getOHIndex() {
        return this.m_ohIndex;
    }

    void setOHIndex(int homeIndex) {
        this.m_ohIndex = homeIndex;
    }

    public OiiiCompInstallID getCompID() {
        return this.m_compID;
    }

    public int getDepType() {
        return this.m_depType;
    }

    public void setDepType(int nDepType) {
        this.m_depType = nDepType;
    }

    public String getDepGroup() {
        return this.m_sDepGroup;
    }

    public void setDepGroup(String sDepGroup) {
        this.m_sDepGroup = sDepGroup;
    }

    public int getCompInstallType() {
        return this.m_compType;
    }

    public void setCompInstallType(int compType) {
        this.m_compType = compType;
    }

    public boolean isDeinstalled() {
        return this.m_bDeinstall;
    }

    public void setDeinstalled(boolean bFlag) {
        this.m_bDeinstall = bFlag;
    }

    public boolean equals(OiiiCompIdOhPair cIdOh) {
        if (cIdOh != null) {
            return this.m_compID.equals(cIdOh.getCompID()) && this.m_ohIndex == cIdOh.getOHIndex();
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof OiiiCompIdOhPair) {
                return this.equals((OiiiCompIdOhPair)obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return "" + this.m_ohIndex + "::" + this.m_compID.toString();
    }

    public static Vector createCompIdOhVector(Vector compIds, int ohIndex) {
        Vector<OiiiCompIdOhPair> retVect = new Vector<OiiiCompIdOhPair>();
        int numIDs = compIds.size();
        for (int i = 0; i < numIDs; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)compIds.elementAt(i);
            int compOhIndex = cid.isNOHComp() ? 0 : ohIndex;
            retVect.addElement(new OiiiCompIdOhPair(cid, compOhIndex));
        }
        return retVect;
    }

    public static Vector createCompIdOhVector(Vector compIds, Vector depTypes, Vector compTypes, int ohIndex) {
        Vector<OiiiCompIdOhPair> retVect = new Vector<OiiiCompIdOhPair>();
        int numIDs = compIds.size();
        for (int i = 0; i < numIDs; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)compIds.elementAt(i);
            int compOhIndex = cid.isNOHComp() ? 0 : ohIndex;
            OiiiCompIdOhPair id = new OiiiCompIdOhPair(cid, compOhIndex);
            id.setDepType((Integer)depTypes.elementAt(i));
            id.setCompInstallType((Integer)compTypes.elementAt(i));
            retVect.addElement(id);
        }
        return retVect;
    }

    void setUnknownXMLElement(XMLElement element) {
        this.m_unknownXMLElement = element;
    }

    public XMLElement getXMLElement() {
        return this.m_unknownXMLElement;
    }
}

