/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Enumeration;
import oracle.sysman.oii.oiii.OiiiCompIDComparator;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixObjectPool;
import oracle.sysman.oii.oiix.OiixSet;

public class OiiiCompIDPool
extends OiixObjectPool {
    private static OiiiCompIDPool m_pool = null;
    private OiixSet m_compIDSet;
    private OiixSet m_patchIDSet;

    private OiiiCompIDPool() {
        try {
            this.m_compIDSet = new OiixSet("oracle.sysman.oii.oiii.OiiiCompInstallID", OiiiCompIDComparator.getComparator());
            this.m_patchIDSet = new OiixSet("oracle.sysman.oii.oiii.OiiiPatchInstallID", OiiiCompIDComparator.getComparator());
        }
        catch (OiixInvalidDataException e) {
            this.m_compIDSet = null;
            e.printStackTrace();
        }
    }

    public static OiiiCompIDPool getInstance() {
        if (m_pool == null) {
            m_pool = new OiiiCompIDPool();
        }
        return m_pool;
    }

    public Object get(Object obj) {
        if (!(obj instanceof OiiiCompInstallID)) {
            throw new IllegalArgumentException("Illegal object type: " + obj.getClass().getName());
        }
        return this.get((OiiiCompInstallID)obj);
    }

    public OiiiCompInstallID get(OiiiCompInstallID id) {
        if (id.getCompType() == 2) {
            if (!(id instanceof OiiiPatchInstallID)) {
                id.setCompType(1);
                id = new OiiiPatchInstallID(id, id.getVersion(), id.getPlatforms(), false);
            }
        } else if (id.getCompType() == 4) {
            id = new OiiiPatchSetInstallID(id.getName(), id.getVersion(), false);
        }
        OiiiCompInstallID existingID = null;
        try {
            id.optimizePlatList();
            existingID = (OiiiCompInstallID)this.addElement(id);
        }
        catch (OiixInvalidDataException e) {
            throw new IllegalArgumentException("Invalid object type: " + id.getClass().getName());
        }
        if (existingID != id) {
            this.updateID(existingID, id);
        }
        return existingID;
    }

    @Override
    public void clearPool() {
        this.m_compIDSet.removeAllElements();
        this.m_patchIDSet.removeAllElements();
    }

    OiiiCompInstallID getElement(OiiiCompInstallID id) {
        OiiiCompInstallID retID = null;
        Enumeration eComps = this.m_compIDSet.elements();
        while (eComps.hasMoreElements()) {
            OiiiCompInstallID oID = (OiiiCompInstallID)eComps.nextElement();
            if (!oID.getName().equalsIgnoreCase(id.getName()) || !oID.getVersion().equals(id.getVersion()) || oID.getHomeType() != id.getHomeType()) continue;
            retID = oID;
            break;
        }
        if (retID != null) {
            return retID;
        }
        Enumeration ePatches = this.m_patchIDSet.elements();
        while (ePatches.hasMoreElements()) {
            OiiiCompInstallID oID = (OiiiCompInstallID)ePatches.nextElement();
            if (!oID.getName().equalsIgnoreCase(id.getName()) || !oID.getVersion().equals(id.getVersion()) || oID.getHomeType() != id.getHomeType()) continue;
            retID = oID;
            break;
        }
        if (retID != null) {
            return retID;
        }
        return this.get(id);
    }

    private void updateID(OiiiCompInstallID targetID, OiiiCompInstallID sourceID) {
        if (targetID instanceof OiiiPatchInstallID && sourceID instanceof OiiiPatchInstallID) {
            OiiiVersion baseVersion = ((OiiiPatchInstallID)sourceID).getBaseVersion();
            OiiiVersion compVersion = ((OiiiPatchInstallID)sourceID).getCompVersion();
            OiiiVersion patchVersion = ((OiiiPatchInstallID)sourceID).getVersion();
            if (patchVersion.laterThan(baseVersion)) {
                ((OiiiPatchInstallID)targetID).setBaseVersion(baseVersion);
            }
            if (patchVersion.laterThan(compVersion)) {
                ((OiiiPatchInstallID)targetID).setCompVersion(compVersion);
            }
            ((OiiiPatchInstallID)targetID).setCompPlatforms(((OiiiPatchInstallID)sourceID).getCompPlatforms());
        }
        OiiiVersion targetReplaceVersion = targetID.getReplaceVersion();
        OiiiVersion sourceReplaceVersion = sourceID.getReplaceVersion();
        if (sourceReplaceVersion.laterThan(targetReplaceVersion)) {
            targetID.setReplaceVersion(sourceReplaceVersion);
        }
        if (targetID.getOracleHomeType() < sourceID.getOracleHomeType()) {
            targetID.setOracleHomeType(sourceID.getOracleHomeType());
        }
    }

    private Object addElement(Object obj) throws OiixInvalidDataException {
        if (obj instanceof OiiiPatchInstallID) {
            return this.m_patchIDSet.addElement(obj);
        }
        return this.m_compIDSet.addElement(obj);
    }
}

