/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiii.OiiiVersionFormatException;
import oracle.sysman.oii.oiix.OiixEnumException;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.sysman.oix.oixs.OixsTextElementHandler;
import org.xml.sax.AttributeList;

class OiiiCompBaseElementHandler
extends OixsElementHandler {
    private String m_sName;
    private OiiiVersion m_version;
    private OiiiVersion m_replaceVersion;
    private String m_sInvLoc;
    private Vector m_vLangs = new Vector();
    private int m_nReleaseLevel = 0;

    public OiiiCompBaseElementHandler(String name) {
        super(name);
        OixsTextElementHandler handlerExtName = new OixsTextElementHandler();
        OixsTextElementHandler handlerDesc = new OixsTextElementHandler();
        OixsTextElementHandler handlerDescID = new OixsTextElementHandler();
        this.addChildHandler("EXT_NAME", handlerExtName);
        this.addChildHandler("DESC", handlerDesc);
        this.addChildHandler("DESCID", handlerDescID);
    }

    @Override
    public void onStart(String name, AttributeList atts) {
        this.m_sName = atts.getValue("NAME");
        this.m_version = new OiiiVersion(atts.getValue("VER"));
        String sBuildNumber = atts.getValue("BUILD_NUMBER");
        int iBuildNumber = 0;
        if (sBuildNumber != null) {
            if ((sBuildNumber = sBuildNumber.trim()).length() > 0) {
                try {
                    iBuildNumber = Integer.parseInt(sBuildNumber);
                }
                catch (NumberFormatException e) {
                    System.err.println("Incorrect build number specified. Build number ignored.");
                    iBuildNumber = 0;
                }
            } else {
                iBuildNumber = 0;
            }
        }
        try {
            this.m_version.setBuildNumber(iBuildNumber);
        }
        catch (OiiiVersionFormatException e) {
            System.err.println(e.getMessage());
        }
        this.m_replaceVersion = new OiiiVersion(atts.getValue("REP_VER"));
        this.m_sInvLoc = atts.getValue("INV_LOC");
        String sLangs = atts.getValue("LANGS");
        this.m_vLangs = OiixLanguage.strToVect(sLangs);
        String sReleaseLevel = atts.getValue("RELEASE");
        if (sReleaseLevel == null) {
            sReleaseLevel = "";
        }
        sReleaseLevel = sReleaseLevel.trim();
        try {
            this.m_nReleaseLevel = OiiiReleaseLevels.getReleaseLevelID(sReleaseLevel);
        }
        catch (OiixEnumException e) {
            System.err.println("Incorrect release level detected. USing Production instead.");
            this.m_nReleaseLevel = 0;
        }
    }

    protected String getCompName() {
        return this.m_sName;
    }

    protected OiiiVersion getVersion() {
        return this.m_version;
    }

    protected OiiiVersion getReplaceVersion() {
        return this.m_replaceVersion;
    }

    protected String getExternalName() {
        OixsTextElementHandler handlerExtName = (OixsTextElementHandler)this.getChildHandler("EXT_NAME");
        return handlerExtName.getText();
    }

    protected String getDescription() {
        OixsTextElementHandler handlerDesc = (OixsTextElementHandler)this.getChildHandler("DESC");
        return handlerDesc.getText();
    }

    protected String getDescriptionID() {
        OixsTextElementHandler handlerDescID = (OixsTextElementHandler)this.getChildHandler("DESCID");
        return handlerDescID.getText();
    }

    protected Vector getLanguages() {
        return this.m_vLangs;
    }

    protected int getReleaseLevel() {
        return this.m_nReleaseLevel;
    }

    protected String getLocationInInventory() {
        return this.m_sInvLoc;
    }
}

