/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiii.OiiiCompsXMLHandler;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLReader;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiii.OiiiRemoteInventoryXMLHandler;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oix.oixs.OixsXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiiClusterInstallInventory {
    private static final String DOT = ".";
    private HashMap m_remoteNodeInvRead = null;
    private HashMap m_oInvLocNoHomesAttached = null;
    private HashMap m_oHomesAttached = null;
    private boolean read6432bitHomes = false;

    public OiiiClusterInstallInventory(String[] remoteNodes) {
        this.initializeHomes(remoteNodes);
    }

    public OiiiClusterInstallInventory(String[] remoteNodes, boolean read6432bitHomes) {
        this.read6432bitHomes = read6432bitHomes;
        this.initializeHomes(remoteNodes);
    }

    public OiiiClusterInstallInventory() {
    }

    private void initializeHomes(String[] remoteNodes) {
        try {
            this.initialize(remoteNodes);
        }
        catch (OiiiInstallInventoryReadException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public HashMap getInventoryLocsRemote() {
        return this.m_oInvLocNoHomesAttached;
    }

    public HashMap getRemoteHomesAttached() {
        return this.m_oHomesAttached;
    }

    private void initialize(String[] remoteNodes) throws OiipgRemoteOpsException, OiiiInstallInventoryReadException, IOException {
        if (!OiixUtil.isEmpty(remoteNodes)) {
            for (int i = 0; i < remoteNodes.length; ++i) {
                this.initialize(remoteNodes[i]);
            }
        }
    }

    private void initialize(String remoteNode) throws OiipgRemoteOpsException, OiiiInstallInventoryReadException, IOException {
        String invLoc = OiipgClusterInvSetup.getInventoryLocationOnNode(remoteNode);
        this.readHomesOnNode(invLoc, remoteNode);
        if (this.read6432bitHomes) {
            invLoc = OiipgClusterInvSetup.getInventoryLocationOnNode(remoteNode, this.read6432bitHomes);
            this.readHomesOnNode(invLoc, remoteNode);
        }
    }

    private void readHomesOnNode(String invLoc, String remoteNode) throws OiipgRemoteOpsException, IOException {
        OiiolTextLogger.appendText("Location of invPtr on remote node " + remoteNode + " is " + invLoc, OiiolTextLogger.LOG_TRACE);
        if (OiixUtil.isNullOrBlank(invLoc, true)) {
            OiiolTextLogger.appendText("No central inventory available on remote node " + remoteNode);
            return;
        }
        String invFileLoc = OiixPathOps.getStandardForm(invLoc);
        invFileLoc = OiixPathOps.directorify(invFileLoc);
        invFileLoc = invFileLoc + "ContentsXML" + '/' + "inventory.xml";
        OiiolTextLogger.appendText("Location of inventory.xml on remote node " + remoteNode + " is " + invFileLoc, OiiolTextLogger.LOG_TRACE);
        if (OiipgClusterOps.fileExistsOnNode(remoteNode, invFileLoc)) {
            String invFileLocOnLocal = OiiiClusterInstallInventory.generateInvFileLocOnLocal(remoteNode, this.read6432bitHomes);
            OiipgClusterOps.transferFileFromNode(remoteNode, invFileLoc, invFileLocOnLocal);
            if (!this.readHomes(invFileLocOnLocal, remoteNode)) {
                if (OiixUtil.isNull(this.m_oInvLocNoHomesAttached)) {
                    this.m_oInvLocNoHomesAttached = new HashMap();
                }
                this.m_oInvLocNoHomesAttached.put(remoteNode, invLoc);
            }
        } else {
            if (OiixUtil.isNull(this.m_oInvLocNoHomesAttached)) {
                this.m_oInvLocNoHomesAttached = new HashMap();
            }
            this.m_oInvLocNoHomesAttached.put(remoteNode, invLoc);
        }
        if (OiixUtil.isNull(this.m_remoteNodeInvRead)) {
            this.m_remoteNodeInvRead = new HashMap();
        }
        this.m_remoteNodeInvRead.put(remoteNode, new Boolean(true));
    }

    private boolean readHomes(String sFile, String remoteNode) throws OiiiInstallInventoryReadException, IOException {
        try {
            FileReader fReader = new FileReader(sFile);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            OiiiRemoteInventoryXMLHandler handler = null;
            try {
                handler = new OiiiRemoteInventoryXMLHandler();
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new OiiiInstallInventoryReadException(e, e.getMessage());
            }
            bReader.close();
            fReader.close();
            OiiiVersion minVer = handler.getMinOUIVersion();
            if (minVer.laterThan(OiicInstVersion.getInstallerVersion())) {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERR_INVENTORY_VERSION");
                sMsg = MessageFormat.format(sMsg, minVer.getVerString());
                throw new OiiiInstallInventoryReadException(sMsg);
            }
            Vector homesAttached = handler.getAllHomes();
            if (!OiixUtil.isEmpty(homesAttached)) {
                if (this.m_oHomesAttached == null) {
                    this.m_oHomesAttached = new HashMap();
                }
                if (this.m_oHomesAttached.get(remoteNode) != null) {
                    homesAttached.addAll((Vector)this.m_oHomesAttached.get(remoteNode));
                }
                this.m_oHomesAttached.put(remoteNode, homesAttached);
            }
            return handler.isAttached();
        }
        catch (FileNotFoundException e) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INV_READ_HOMELIST_ERROR"));
            return false;
        }
    }

    public List getHomes(String nodeName) {
        boolean bRead = false;
        if (this.m_remoteNodeInvRead != null && this.m_remoteNodeInvRead.get(nodeName) != null) {
            bRead = (Boolean)this.m_remoteNodeInvRead.get(nodeName);
        }
        if (!bRead) {
            try {
                this.initialize(nodeName);
            }
            catch (OiiiInstallInventoryReadException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
            catch (OiipgRemoteOpsException e) {
                e.printStackTrace();
                OiiolTextLogger.appendException(e);
            }
        }
        Vector remoteHomesAttached = null;
        if (this.m_oHomesAttached != null) {
            remoteHomesAttached = (Vector)this.m_oHomesAttached.get(nodeName);
        }
        if (!OiixUtil.isEmpty(remoteHomesAttached)) {
            Vector<String> homeLocs = new Vector<String>();
            for (int i = 0; i < remoteHomesAttached.size(); ++i) {
                OiiiRemoteHome remoteHome = (OiiiRemoteHome)remoteHomesAttached.elementAt(i);
                if (remoteHome.getLocation() == null) continue;
                homeLocs.add(remoteHome.getLocation());
            }
            return homeLocs;
        }
        return null;
    }

    public OiiiRemoteHome getRemoteHome(String nodeName, String homeLoc) {
        if (!this.isHomeAttached(nodeName, homeLoc)) {
            return null;
        }
        OiiiRemoteHome remoteHome = null;
        Vector vRemoteHomes = null;
        String tempHomeLoc = OiixPathOps.directifyNativeWay(homeLoc);
        if (!OiixUtil.isEmpty(this.m_oHomesAttached) && !OiixUtil.isEmpty(vRemoteHomes = (Vector)this.m_oHomesAttached.get(nodeName))) {
            for (int i = 0; i < vRemoteHomes.size(); ++i) {
                remoteHome = (OiiiRemoteHome)vRemoteHomes.elementAt(i);
                if (remoteHome == null || !OiixUtil.equals(remoteHome.getLocation(), homeLoc, OiixInstallUtil.isWindows()) && !OiixUtil.equals(remoteHome.getLocation(), tempHomeLoc, OiixInstallUtil.isWindows())) continue;
                return this.initHome(nodeName, homeLoc, remoteHome);
            }
        }
        return null;
    }

    private OiiiRemoteHome initHome(String nodeName, String homeLoc, OiiiRemoteHome remoteHome) {
        if (!remoteHome.isHomePropsRead()) {
            this.readOracleHomeProperties(nodeName, homeLoc, remoteHome);
        }
        if (!remoteHome.isCompsRead()) {
            this.readComps(nodeName, homeLoc, remoteHome);
        }
        return remoteHome;
    }

    private boolean isHomeAttached(String nodeName, String homeLoc) {
        List remoteHomes = this.getHomes(nodeName);
        if (OiixUtil.isEmpty(remoteHomes)) {
            return false;
        }
        String tempHomeLoc = OiixPathOps.directifyNativeWay(homeLoc);
        OiiolTextLogger.appendText(" The local home loc is : " + homeLoc + " After modifying  = " + tempHomeLoc);
        if (!OiixInstallUtil.isWindows()) {
            boolean status = remoteHomes.contains(homeLoc) || remoteHomes.contains(tempHomeLoc);
            OiiolTextLogger.appendText(" Platform is not Windows . Status  = " + status);
            return status;
        }
        for (int i = 0; i < remoteHomes.size(); ++i) {
            OiiolTextLogger.appendText(" Platform is Windows . Remote Home Loc  = " + remoteHomes.get(i) + " Status1 = " + OiixUtil.equals((String)remoteHomes.get(i), homeLoc, true) + " Status2 = " + OiixUtil.equals((String)remoteHomes.get(i), tempHomeLoc, true));
            if (!OiixUtil.equals((String)remoteHomes.get(i), homeLoc, true) && !OiixUtil.equals((String)remoteHomes.get(i), tempHomeLoc, true)) continue;
            return true;
        }
        return false;
    }

    private void readOracleHomeProperties(String remoteNode, String homeLoc, OiiiRemoteHome remoteHome) {
        String remoteOHPropsFile = OiiiClusterInstallInventory.remotePath(homeLoc, "oraclehomeproperties.xml");
        try {
            if (OiipgClusterOps.fileExistsOnNode(remoteNode, remoteOHPropsFile)) {
                String localOHPropsFile = OiiiClusterInstallInventory.transferFileFromNode(remoteOHPropsFile, remoteNode, remoteHome.getName(), "oraclehomeproperties.xml");
                OiiiOracleHomeInfoXMLReader OHInfoReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
                OHInfoReader.updateHomeProperties(remoteHome, localOHPropsFile);
                remoteHome.setHomePropsRead(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readComps(String remoteNode, String homeLoc, OiiiRemoteHome remoteHome) {
        block6: {
            String remoteCompsFile = OiiiClusterInstallInventory.remotePath(homeLoc, "comps.xml");
            try {
                if (!OiipgClusterOps.fileExistsOnNode(remoteNode, remoteCompsFile)) break block6;
                String localCompsFile = OiiiClusterInstallInventory.transferFileFromNode(remoteCompsFile, remoteNode, remoteHome.getName(), "comps.xml");
                int homeIndex = remoteHome.getIndex();
                int homeType = remoteHome.getHomeType();
                int platform = OiixPlatform.getCurrentPlatform();
                OiiiCompsXMLHandler handler = null;
                FileReader fReader = null;
                BufferedReader bReader = null;
                try {
                    Parser parser = OixsXMLOps.createSAXParser();
                    handler = new OiiiCompsXMLHandler(homeIndex, homeType, platform);
                    handler.setUseCompIdPool(false);
                    parser.setDocumentHandler(handler);
                    parser.setErrorHandler(handler);
                    try {
                        fReader = new FileReader(localCompsFile);
                        bReader = new BufferedReader(fReader);
                    }
                    catch (FileNotFoundException e) {
                        Object[] sArgs = new String[]{localCompsFile};
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_INV_READ_ERROR", sArgs));
                    }
                    parser.parse(new InputSource(bReader));
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
                bReader.close();
                fReader.close();
                remoteHome.setInvInfo(handler.getComps());
                remoteHome.setCompsRead(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String remotePath(String homeLoc, String file) {
        String loc = OiixPathOps.concatPath(homeLoc, "inventory");
        loc = OiixPathOps.concatPath(loc, "ContentsXML");
        return OiiiClusterInstallInventory.getFullPath(loc, file);
    }

    private static String transferFileFromNode(String srcFile, String node, String homeName, String file) throws OiipgRemoteOpsException {
        String destFile = OiiiClusterInstallInventory.getScratchFile(file);
        destFile = destFile + DOT + node + DOT + homeName;
        OiipgClusterOps.transferFileFromNode(node, srcFile, destFile);
        return destFile;
    }

    private static String generateInvFileLocOnLocal(String node, boolean read6432bitHomes) {
        String loc = OiiiClusterInstallInventory.getScratchFile("inventory.xml");
        String arch = read6432bitHomes ? "64" : "32";
        loc = loc + DOT + node + arch;
        return loc;
    }

    private static String getScratchFile(String file) {
        String scratch = System.getProperty("oracle.installer.scratchPath");
        return OiiiClusterInstallInventory.getFullPath(scratch, file);
    }

    private static String getFullPath(String dir, String file) {
        String loc = OiixPathOps.getStandardForm(dir);
        loc = OiixPathOps.directorify(loc);
        loc = OiixPathOps.getNativeForm(loc + file);
        return loc;
    }
}

