/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatchauto.core.binary.BinarySessionException;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinary;
import oracle.opatchauto.core.binary.OPatchAutoException;
import oracle.opatchauto.core.binary.OracleTarget;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.SessionResults;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiiiApplyUpdates {
    public static String fs = File.separator;
    public static String PATCH_BASE_FILE = "pbfile.txt";
    private OiicPullSession m_Session;
    private static final String OPATCH_DIR = "OPatch";

    public OiiiApplyUpdates(OiicISession session) {
        this.m_Session = (OiicPullSession)session;
    }

    public void storeLocationInHashMap(String Loc, HashMap bid_location) {
        File dir;
        if (Loc != null && (dir = new File(Loc)).isDirectory() && !dir.getName().startsWith(".ade_path")) {
            String[] fileList = dir.list();
            String fileName = null;
            for (int i = 0; i < fileList.length; ++i) {
                fileName = fileList[i];
                String filePath = dir.getAbsolutePath() + fs + fileName;
                File f = new File(filePath);
                if (!f.isDirectory() || f.getName().startsWith(".ade_path")) continue;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".ade_path");
                    }
                };
                String[] fullPath = f.list(filter);
                int numberOfFilesAndDirs = 0;
                if (fullPath != null) {
                    numberOfFilesAndDirs = fullPath.length;
                }
                ArrayList<String> locationList = new ArrayList<String>();
                for (int k = 0; k < numberOfFilesAndDirs; ++k) {
                    String val = f.getAbsolutePath() + fs + fullPath[k];
                    if (!new File(val).isDirectory()) continue;
                    locationList.add(val);
                }
                if (!bid_location.containsKey(fileName)) continue;
                bid_location.put(fileName, locationList);
            }
        }
    }

    public static String getLatestUpdatesLoc(String dest, String type) {
        String destDir = "";
        String LATEST_UPDATES = "LatestUpdates";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, type);
        destDir = dest != null && dest.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(dest, concatPath);
        return destDir;
    }

    public Object getSessionValue(String varName) {
        if (this.m_Session != null) {
            return this.m_Session.getSessionVarValue(varName);
        }
        return null;
    }

    public boolean applyOneOffs(String ohome, ArrayList bid) {
        return this.applyOneOffs("", "", ohome, bid);
    }

    public boolean applyOneOffs(String ohome, ArrayList bid, String[] args) {
        return this.applyOneOffs("", "", ohome, bid, args);
    }

    public boolean applyOneOffs(String CPULoc, String OneOffLoc, String ohome, ArrayList bid) {
        return this.applyOneOffs(CPULoc, OneOffLoc, ohome, bid, null);
    }

    public boolean applyOneOffs(String CPULoc, String OneOffLoc, String ohome, ArrayList bid, String[] args) {
        String defOPatchLoc = ohome + fs + OPATCH_DIR;
        return this.applyOneOffs(CPULoc, OneOffLoc, ohome, bid, args, defOPatchLoc);
    }

    public boolean applyOneOffs(String cpuLoc, String oneOffLoc, String ohome, ArrayList bid, String[] args, String OPatchLoc) {
        OACLogger.setupLogging((String)ohome);
        OiiolTextLogger.setEnabled(true);
        if (bid == null || bid.size() == 0) {
            OiiolTextLogger.appendText("You haven't specified any bug-number to apply to this home.Please specify the bug-number");
            return false;
        }
        ArrayList patchParentLocationList = new ArrayList();
        HashMap<String, Object> bid_location = new HashMap<String, Object>();
        if (bid != null && bid.size() > 0) {
            for (int i = 0; i < bid.size(); ++i) {
                OiiiPatchMetadata pm = (OiiiPatchMetadata)bid.get(i);
                Integer intObj = new Integer(pm.getPatchBugNumber());
                bid_location.put(intObj.toString(), null);
            }
        }
        List patches1 = this.getPatchFromCurrentDirectory(cpuLoc, bid_location);
        List patches2 = this.getPatchFromCurrentDirectory(oneOffLoc, bid_location);
        OiiolTextLogger.appendText(" Patches 1 size = :" + patches1.size());
        OiiolTextLogger.appendText(" Patches 2 size = :" + patches2.size());
        patchParentLocationList.addAll(patches1);
        patchParentLocationList.addAll(patches2);
        return this.applyOneOffs(patchParentLocationList, ohome);
    }

    public boolean applyOneOffs(List patchLocations, String ohome, String targetType) {
        OracleTarget ot = null;
        OiiolTextLogger.setEnabled(true);
        OACLogger.setupLogging((String)ohome);
        if (null == patchLocations || patchLocations.size() == 0 || null == ohome || ohome.equals("")) {
            OiiolTextLogger.appendText(" Required arguments are missing !! Please check the arguments passed.");
            OiiolTextLogger.appendText(" Oracle Home location = " + ohome);
            if (patchLocations != null) {
                OiiolTextLogger.appendText(" You haven't specified any valid patch locations to apply to this home.");
            }
            return false;
        }
        try {
            ot = new OracleTarget(ohome);
        }
        catch (OPatchAutoException oe) {
            OiiolTextLogger.appendException(oe);
            return false;
        }
        if (null != targetType && !targetType.equals("")) {
            ot.setTargetType(targetType);
        }
        PatchingSessionOptions options = new PatchingSessionOptions(ot);
        SessionPatches patches = new SessionPatches();
        for (int i = 0; i < patchLocations.size(); ++i) {
            File locationDir = new File((String)patchLocations.get(i));
            if (patchLocations.get(i) == null || ((String)patchLocations.get(i)).equalsIgnoreCase("") || !locationDir.isDirectory() || locationDir.list().length <= 0) continue;
            patches.addPatch((String)patchLocations.get(i));
        }
        try {
            OPatchAutoBinary binaryPatching = new OPatchAutoBinary(options);
            SessionResults results = binaryPatching.apply(patches);
            if (results == null || results.getFailedPatches().size() > 0) {
                return false;
            }
        }
        catch (OPatchException ope) {
            OiiolTextLogger.appendException(ope);
            return false;
        }
        catch (BinarySessionException bse) {
            OiiolTextLogger.appendException(bse);
            return false;
        }
        return true;
    }

    public boolean applyOneOffs(List patchLocations, String ohome) {
        return this.applyOneOffs(patchLocations, ohome, "");
    }

    public static boolean updateOPatch(String ohome, String downloadLoc, int OPatchBugID) {
        try {
            String oPatchDownloadLoc = OiiiApplyUpdates.getLatestUpdatesLoc(downloadLoc, "Shiphome");
            oPatchDownloadLoc = OiixPathOps.concatPath(oPatchDownloadLoc + File.separator + OPatchBugID, OPATCH_DIR);
            String dest = OiixPathOps.concatPath(ohome, OPATCH_DIR);
            boolean backup = false;
            boolean changePermissions = false;
            OiixFileOps.copyDirWithPermissions(new File(oPatchDownloadLoc), new File(dest), backup, changePermissions);
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        return true;
    }

    private List getPatchFromCurrentDirectory(String path, Map bid_location) {
        ArrayList<String> list = new ArrayList<String>();
        if (bid_location != null && bid_location.size() == 0) {
            OiiolTextLogger.appendText("User doesn't specify any specific patch to apply to this home.Please specify the bug-number you want to install in this Oracle Home");
            return list;
        }
        File file = new File(path);
        String[] fullPath = file.list();
        if (fullPath == null) {
            return list;
        }
        SessionPatches patches = new SessionPatches();
        for (int i = 0; i < fullPath.length; ++i) {
            File innerFile = new File(path + File.separator + fullPath[i]);
            if (!innerFile.exists() || !innerFile.isDirectory()) continue;
            if (SessionPatches.isPatchValid((String)innerFile.getAbsolutePath())) {
                OiiolTextLogger.appendText(innerFile.getAbsolutePath() + " is a patch");
                if (bid_location.size() <= 0) continue;
                if (bid_location.containsKey(fullPath[i])) {
                    list.add(innerFile.getAbsolutePath());
                    OiiolTextLogger.appendText("Selected the user specified patch: '" + innerFile.getAbsolutePath() + "' ");
                    continue;
                }
                OiiolTextLogger.appendText("Discarded the patch: '" + innerFile.getAbsolutePath() + "' as the user doesn't specify this patch to apply.");
                continue;
            }
            OiiolTextLogger.appendText(innerFile.getAbsolutePath() + " is not a patch. Trying to iterate over this directory...");
            List innerList = this.getPatchFromCurrentDirectory(innerFile.getAbsolutePath(), bid_location);
            list.addAll(innerList);
        }
        return list;
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    OiiolTextLogger.appendText(line);
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendText(ioe.getMessage(), OiiolTextLogger.LOG_TRACE);
            }
        }
    }
}

