/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.InputStream;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigException;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIRegHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpMultiHandler;
import oracle.sysman.oix.oixp.OixpXmlParserFactory;

public class OiigXmlResultReader
implements OixpIRegHandler {
    private int m_returnCode = 50;
    private OixpMultiHandler m_xmlHandlers = new OixpMultiHandler();
    private Vector m_lsMgr = new Vector();
    private OixpIXmlParser m_parser = null;

    public void readResult(InputStream in) throws OiigException {
        try {
            OixpIXmlParser parser = this.getXmlParser();
            parser.setInputStream(in);
            OixpIElement oixpIElement = parser.readXML();
        }
        catch (Exception e) {
            throw new OiigException(e.getMessage());
        }
    }

    public OixpIXmlParser getXmlParser() throws OiigException {
        if (this.m_parser != null) {
            return this.m_parser;
        }
        try {
            OixpMultiHandler hndl = new OixpMultiHandler();
            this.m_parser = OixpXmlParserFactory.createXmlParser();
            this.m_parser.setHandler(this);
        }
        catch (Exception e) {
            throw new OiigException(e.getMessage());
        }
        return this.m_parser;
    }

    public void addXmlHandler(String type, OixpIHandler hndl) {
        this.m_xmlHandlers.registerHandler(type, hndl);
    }

    public void addXmlHandler(OixpIRegHandler hndl) {
        this.m_xmlHandlers.registerHandler(hndl);
    }

    @Override
    public boolean doStartTag(OixpIElement el) {
        if (!el.getType().equalsIgnoreCase("OSPUBRLT")) {
            return this.m_xmlHandlers.doStartTag(el);
        }
        OixpIAttribute[] attrs = el.getAllAttributes();
        if (attrs == null) {
            return false;
        }
        if (attrs.length < 1) {
            return false;
        }
        this.setReturnCode(Integer.parseInt(attrs[0].getValue()));
        return false;
    }

    @Override
    public boolean doText(OixpIElement el, String text) {
        return this.m_xmlHandlers.doText(el, text);
    }

    @Override
    public boolean doEndTag(OixpIElement el) {
        if (!el.getType().equalsIgnoreCase("OSPUBRLT")) {
            return this.m_xmlHandlers.doEndTag(el);
        }
        return true;
    }

    @Override
    public String[] getTagsForRegistration() {
        String[] ar = new String[]{"OSPUBRLT"};
        return ar;
    }

    private void setReturnCode(int code) {
        this.m_returnCode = code;
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }
}

