/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiig.OiigRequest;
import oracle.sysman.oii.oiig.OiigRequestStatusListener;
import oracle.sysman.oii.oiig.OiigSendRequestFailException;
import oracle.sysman.oii.oiig.OiigXmlSimpleParamHolder;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;
import oracle.sysman.oix.oixx.OixxLoggingPrintWriter;

public class OiigXmlRequest
extends OiigRequest {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 2048;

    public OiigXmlRequest() {
    }

    public OiigXmlRequest(int id) {
        this.setID(id);
    }

    @Override
    public void reinitialize() {
        this.setID(-1);
        this.getParametersVector().setSize(0);
    }

    @Override
    public void addParameter(int parm) {
        OiigXmlSimpleParamHolder val = new OiigXmlSimpleParamHolder(parm);
        this.getParametersVector().addElement(val);
    }

    @Override
    public void addParameter(long parm) {
        OiigXmlSimpleParamHolder val = new OiigXmlSimpleParamHolder(parm);
        this.getParametersVector().addElement(val);
    }

    @Override
    public void addParameter(boolean parm) {
        OiigXmlSimpleParamHolder val = new OiigXmlSimpleParamHolder(parm);
        this.getParametersVector().addElement(val);
    }

    @Override
    public void addParameter(String parm) {
        OiigXmlSimpleParamHolder val = new OiigXmlSimpleParamHolder(parm);
        this.getParametersVector().addElement(val);
    }

    @Override
    public void addParameter(Object parm) {
        this.getParametersVector().addElement(parm);
    }

    public void addElement(Object obj) {
        this.getParametersVector().addElement(obj);
    }

    public void writeHeader(PrintWriter writer) {
        writer.println("<OSPUBREQ>");
    }

    public void writeEnd(PrintWriter writer) {
        writer.println("</OSPUBREQ>");
    }

    @Override
    public InputStream sendRequest(String dest) throws OiigSendRequestFailException {
        return this.sendRequest(dest, null, null);
    }

    public InputStream sendRequest(String dest, OiigRequestStatusListener lsnr, OiifbProgressControl progCtrl) throws OiigSendRequestFailException {
        InputStream in = null;
        OutputStream output = null;
        PrintWriter writer = null;
        URLConnection con = null;
        try {
            this.checkCancel(progCtrl);
            URL url = new URL(this.getQueryString(dest));
            con = url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            output = con.getOutputStream();
            writer = new PrintWriter(output);
            if (Boolean.getBoolean("LOGSTREAMS")) {
                String filename = OiixPathOps.getNativeForm("/tmp/requests.log");
                writer = new OixxLoggingPrintWriter(filename, "sendRequest in " + this.getClass(), writer);
            }
            this.checkCancel(progCtrl);
            this.writeHeader(writer);
            this.writeParameters(writer);
            this.writeEnd(writer);
            if (lsnr != null) {
                lsnr.onSendComplete();
            }
        }
        catch (Exception e) {
            if (lsnr != null) {
                lsnr.onErrorDuringSend(e);
            }
            throw new OiigSendRequestFailException(e.getMessage());
        }
        finally {
            try {
                if (null != writer) {
                    writer.flush();
                }
                if (null != output) {
                    output.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.checkCancel(progCtrl);
            in = con.getInputStream();
        }
        catch (Exception e) {
            if (lsnr != null) {
                lsnr.onErrorDuringReply(e);
            }
            throw new OiigSendRequestFailException(e.getMessage());
        }
        return in;
    }

    private void checkCancel(OiifbProgressControl progCtrl) throws OiifbCancelException {
        if (progCtrl != null && !progCtrl.canContinue()) {
            throw new OiifbCancelException("User cancelled", true);
        }
    }

    public void writeParameters(PrintWriter writer) throws Exception {
        Vector v = this.getParametersVector();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof OiigXmlSimpleParamHolder) {
                OixwXmlWriterOps.writeXmlForm(obj, writer);
                continue;
            }
            writer.println("<PARAM>");
            OixwXmlWriterOps.writeXmlForm(obj, writer);
            writer.println("</PARAM>");
        }
    }

    public String toString() {
        return "OiigXmlRequest";
    }
}

