/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigSetInfo
implements OiigSetContent,
OixwIXmlWriter {
    private Vector m_childSets;
    private Vector m_childComps;
    private String m_setName;
    private String m_description;
    private long m_index;
    private boolean m_topLevel;
    private boolean m_mandatory;
    public static final String SET_TAG = "Set";
    public static final String CSETS_TAG = "CSets";
    public static final String CCOMPS_TAG = "CComps";
    private static final String SETNAME_ATTR = "SetName";
    private static final String INDEX_ATTR = "Index";
    private static final String TOPLEVEL_ATTR = "TopLevel";
    private static final String MANDATORY_ATTR = "Mandatory";

    public OiigSetInfo(String setName, long index) {
        this.m_setName = setName;
        this.m_description = "";
        this.m_index = index;
        this.m_topLevel = false;
        this.m_mandatory = false;
        this.m_childSets = new Vector();
        this.m_childComps = new Vector();
    }

    public OiigSetInfo(OixpIElement el) {
        this(el.getAttribValue(SETNAME_ATTR), Long.parseLong(el.getAttribValue(INDEX_ATTR)));
        boolean topLevel = Boolean.valueOf(el.getAttribValue(TOPLEVEL_ATTR));
        this.setTopLevel(topLevel);
        boolean mandatory = Boolean.valueOf(el.getAttribValue(MANDATORY_ATTR));
        this.setMandatory(mandatory);
    }

    public String getSetName() {
        return this.m_setName;
    }

    @Override
    public long getIndex() {
        return this.m_index;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setTopLevel(boolean topLevel) {
        this.m_topLevel = topLevel;
    }

    public boolean isTopLevel() {
        return this.m_topLevel;
    }

    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public void addChildSet(long cSetInd) {
        this.m_childSets.addElement(new Long(cSetInd));
    }

    public void addChildComp(long cCompInd) {
        this.m_childComps.addElement(new Long(cCompInd));
    }

    public void setChildrenSets(long[] cSetInds) {
        this.m_childSets.removeAllElements();
        int numCSets = cSetInds != null ? cSetInds.length : 0;
        for (int i = 0; i < numCSets; ++i) {
            this.m_childSets.addElement(new Long(cSetInds[i]));
        }
    }

    public long[] getChildSetIDs() {
        int numChildSets = this.m_childSets.size();
        long[] retIntArr = new long[numChildSets];
        for (int i = 0; i < numChildSets; ++i) {
            Long csetID = (Long)this.m_childSets.elementAt(i);
            retIntArr[i] = csetID;
        }
        return retIntArr;
    }

    public void setChildrenComps(long[] cCompInds) {
        this.m_childComps.removeAllElements();
        int numCComps = cCompInds != null ? cCompInds.length : 0;
        for (int i = 0; i < numCComps; ++i) {
            this.m_childComps.addElement(new Long(cCompInds[i]));
        }
    }

    public long[] getChildCompIDs() {
        int numChildComps = this.m_childComps.size();
        long[] retIntArr = new long[numChildComps];
        for (int i = 0; i < numChildComps; ++i) {
            Long ccompID = (Long)this.m_childComps.elementAt(i);
            retIntArr[i] = ccompID;
        }
        return retIntArr;
    }

    public String toString() {
        return "\n[Set " + this.m_index + " : " + (this.m_topLevel ? " topLevel : " : "") + this.m_setName + " contains the sets : " + this.m_childSets + " and the comps : " + this.m_childComps + "]";
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<Set SetName=\"" + OixwXmlWriterOps.encodeSplChars(this.m_setName) + "\" " + INDEX_ATTR + "=\"" + this.m_index + "\" " + TOPLEVEL_ATTR + "=\"" + this.m_topLevel + "\" " + MANDATORY_ATTR + "=\"" + this.m_mandatory + "\">");
        long[] cSetIDs = this.getChildSetIDs();
        long[] cCompIDs = this.getChildCompIDs();
        int numCSets = cSetIDs.length;
        int numCComps = cCompIDs.length;
        if (numCSets > 0) {
            pw.println("<CSets> " + OiigXmlOps.stringWithNumArr(cSetIDs) + "</" + CSETS_TAG + "> ");
        }
        if (numCComps > 0) {
            pw.println("<CComps> " + OiigXmlOps.stringWithNumArr(cCompIDs) + "</" + CCOMPS_TAG + "> ");
        }
        pw.println("</Set>");
    }
}

