/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiig.OiigAvailSoftRequest;
import oracle.sysman.oii.oiig.OiigAvailSoftXmlHandler;
import oracle.sysman.oii.oiig.OiigAvailSoftware;
import oracle.sysman.oii.oiig.OiigException;
import oracle.sysman.oii.oiig.OiigExtAuthCatXmlHandler;
import oracle.sysman.oii.oiig.OiigLoginFailedException;
import oracle.sysman.oii.oiig.OiigNotifRequest;
import oracle.sysman.oii.oiig.OiigRemoteException;
import oracle.sysman.oii.oiig.OiigRequestStatusListener;
import oracle.sysman.oii.oiig.OiigSendRequestFailException;
import oracle.sysman.oii.oiig.OiigXmlGetAvailSWRequest;
import oracle.sysman.oii.oiig.OiigXmlGetPubAreaLocRequest;
import oracle.sysman.oii.oiig.OiigXmlGetUpgradeNotifRequest;
import oracle.sysman.oii.oiig.OiigXmlHandShakeRequest;
import oracle.sysman.oii.oiig.OiigXmlLogonRequest;
import oracle.sysman.oii.oiig.OiigXmlLogoutRequest;
import oracle.sysman.oii.oiig.OiigXmlRequest;
import oracle.sysman.oii.oiig.OiigXmlResultReader;
import oracle.sysman.oii.oiig.OiigXmlSimpleResultHandler;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixx.OixxLoggingInputStream;

public class OiigPubClient {
    private String m_encodedURL;
    private String m_pubURL;
    public static final String OSPUB_REPLY = "OSPublisher";

    public OiigPubClient(String pubURL) {
        this.m_encodedURL = this.m_pubURL = pubURL;
    }

    public String getPubURL() {
        return this.m_pubURL;
    }

    public static Vector getPubURLAuthCats(String url) {
        Vector authCats = new Vector();
        try {
            if (url.toLowerCase().startsWith("http")) {
                OiigXmlHandShakeRequest request = new OiigXmlHandShakeRequest();
                OiigXmlResultReader reader = new OiigXmlResultReader();
                OiigExtAuthCatXmlHandler hnd = new OiigExtAuthCatXmlHandler();
                reader.addXmlHandler(hnd);
                OiigPubClient.sendRequestAndGetReply(request, reader, url);
                authCats = hnd.getAuthCategories();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (OiigRemoteException oiigRemoteException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return authCats;
    }

    public void logon(String category, String userName, String passwd) throws IOException, OiigLoginFailedException {
        try {
            OiigXmlLogonRequest request = new OiigXmlLogonRequest(category, userName, passwd);
            OiigXmlResultReader reader = new OiigXmlResultReader();
            OiigXmlSimpleResultHandler handler = new OiigXmlSimpleResultHandler();
            reader.addXmlHandler(handler);
            OiigPubClient.sendRequestAndGetReply(request, reader, this.m_pubURL);
            this.m_encodedURL = handler.getResultString();
        }
        catch (OiigRemoteException e) {
            throw new OiigLoginFailedException(e.getMessage());
        }
    }

    public void logoff() throws IOException {
        try {
            OiigXmlLogoutRequest outRqs = new OiigXmlLogoutRequest();
            OiigXmlResultReader reader = new OiigXmlResultReader();
            OiigXmlSimpleResultHandler handler = new OiigXmlSimpleResultHandler();
            reader.addXmlHandler(handler);
            this.sendRequestAndGetReply(outRqs, reader);
            this.m_encodedURL = this.m_pubURL;
        }
        catch (OiigRemoteException oiigRemoteException) {
            // empty catch block
        }
    }

    public String getSubsetStgURL() throws IOException, OiigRemoteException {
        OiigXmlGetPubAreaLocRequest locReq = new OiigXmlGetPubAreaLocRequest();
        OiigXmlResultReader reader = new OiigXmlResultReader();
        OiigXmlSimpleResultHandler handler = new OiigXmlSimpleResultHandler();
        reader.addXmlHandler(handler);
        this.sendRequestAndGetReply(locReq, reader);
        return handler.getResultString();
    }

    public OiigAvailSoftware getAvailSoftware() throws IOException, OiigRemoteException {
        OiigXmlGetAvailSWRequest request = new OiigXmlGetAvailSWRequest();
        OiigXmlResultReader reader = new OiigXmlResultReader();
        OiigAvailSoftXmlHandler hnd = new OiigAvailSoftXmlHandler();
        reader.addXmlHandler("AvailSoft", hnd);
        this.sendRequestAndGetReply(request, reader);
        return hnd.getAvailSoftware();
    }

    public OiigAvailSoftware getAvailSoftwareEx(OiigAvailSoftRequest availReq, OiigAvailSoftXmlHandler hnd) throws IOException, OiigRemoteException {
        OiigXmlGetAvailSWRequest request = new OiigXmlGetAvailSWRequest(availReq);
        OiigXmlResultReader reader = new OiigXmlResultReader();
        reader.addXmlHandler("AvailSoft", hnd);
        this.sendRequestAndGetReply(request, reader);
        return hnd.getAvailSoftware();
    }

    public static String sendUpgradeReq(String pubURL, OiigNotifRequest notifReq, OiigRequestStatusListener lsnr, OiifbProgressControl progCtrl) throws IOException, OiigRemoteException {
        OiigXmlGetUpgradeNotifRequest request = new OiigXmlGetUpgradeNotifRequest(notifReq);
        OiigXmlResultReader reader = new OiigXmlResultReader();
        OiigXmlSimpleResultHandler handler = new OiigXmlSimpleResultHandler();
        reader.addXmlHandler(handler);
        OiigPubClient.sendRequestAndGetReply(request, reader, pubURL, lsnr, progCtrl);
        return handler.getResultString();
    }

    protected void sendRequestAndGetReply(OiigXmlRequest req, OiigXmlResultReader reader) throws IOException, OiigRemoteException {
        OiigPubClient.sendRequestAndGetReply(req, reader, this.m_encodedURL);
    }

    private static void sendRequestAndGetReply(OiigXmlRequest req, OiigXmlResultReader reader, String url) throws IOException, OiigRemoteException {
        OiigPubClient.sendRequestAndGetReply(req, reader, url, null, null);
    }

    private static void sendRequestAndGetReply(OiigXmlRequest req, OiigXmlResultReader reader, String url, OiigRequestStatusListener lsnr, OiifbProgressControl progCtrl) throws IOException, OiigRemoteException {
        try {
            InputStream in = req.sendRequest(url, lsnr, progCtrl);
            if (null == reader) {
                return;
            }
            if (progCtrl != null && !progCtrl.canContinue()) {
                throw new OiigException("User cancelled");
            }
            InputStream logStream = null;
            if (Boolean.getBoolean("LOGSTREAMS")) {
                String filename = OiixPathOps.getNativeForm("/tmp/replies.log");
                in = logStream = new OixxLoggingInputStream(filename, "sendRequest of " + req.getClass(), in);
            }
            reader.readResult(in);
            if (lsnr != null) {
                lsnr.onReplyComplete();
            }
            if (logStream != null) {
                logStream.close();
            }
            if (reader.getReturnCode() != 0) {
                throw new OiigRemoteException();
            }
        }
        catch (OiigException e) {
            if (lsnr != null) {
                lsnr.onErrorDuringReply(e);
            }
            throw new IOException(e.getMessage());
        }
        catch (OiigSendRequestFailException e) {
            throw new IOException(e.getMessage());
        }
    }
}

