/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;

public class OiigPSetContInfo
implements OiigSetContent,
OixwIXmlWriter {
    private Vector m_contPatches;
    private long m_index;
    public static final String PSETCONT_TAG = "PSetCont";
    public static final String CPATCHES_TAG = "CPatches";
    private static final String INDEX_ATTR = "Index";

    public OiigPSetContInfo(long index) {
        this.m_index = index;
        this.m_contPatches = new Vector();
    }

    public OiigPSetContInfo(OixpIElement el) {
        this(Long.parseLong(el.getAttribValue(INDEX_ATTR)));
    }

    @Override
    public long getIndex() {
        return this.m_index;
    }

    public void addContPatch(long cPatchInd) {
        this.m_contPatches.addElement(new Long(cPatchInd));
    }

    public void setContPatchIDs(long[] cPatchInds) {
        this.m_contPatches.removeAllElements();
        int numCPatches = cPatchInds != null ? cPatchInds.length : 0;
        for (int i = 0; i < numCPatches; ++i) {
            this.m_contPatches.addElement(new Long(cPatchInds[i]));
        }
    }

    public long[] getContPatchIDs() {
        int numContPatches = this.m_contPatches.size();
        long[] retIntArr = new long[numContPatches];
        for (int i = 0; i < numContPatches; ++i) {
            Long cpatchID = (Long)this.m_contPatches.elementAt(i);
            retIntArr[i] = cpatchID;
        }
        return retIntArr;
    }

    public String toString() {
        return "\n[PSetConts " + this.m_index + " contains the patches : " + this.m_contPatches + "]";
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<PSetCont Index=\"" + this.m_index + "\">");
        long[] cPatchIDs = this.getContPatchIDs();
        int numCPatches = cPatchIDs.length;
        if (numCPatches > 0) {
            pw.println("<CPatches> " + OiigXmlOps.stringWithNumArr(cPatchIDs) + "</" + CPATCHES_TAG + "> ");
        }
        pw.println("</PSetCont>");
    }
}

