/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigDepComp;
import oracle.sysman.oii.oiig.OiigDepReln;
import oracle.sysman.oii.oiig.OiigXmlOps;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigNotifRequest
implements OixwIXmlWriter {
    private Vector m_depComps;
    private Vector m_depRelns;
    private Vector m_checkNowComps;
    private Vector m_notifReqComps;
    private boolean m_bDeleteRest;
    private String m_GUID;
    private String m_emailId;
    private String m_hostName;
    private int m_platform;
    public static final String MAIN_TAG_TYPE = "NotifReq";
    public static final String DEPCOMPS_TAG = "DepComps";
    public static final String DEPRELNS_TAG = "DepRelns";
    public static final String CHECKNOW_COMPS_TAG = "CheckNowComps";
    public static final String NOTIFREQ_COMPS_TAG = "NotifReqComps";
    private static final String GUID_ATTR = "GUID";
    private static final String EMAILID_ATTR = "EmailId";
    private static final String HOSTNAME_ATTR = "HostName";
    private static final String PLATFORM_ATTR = "Platform";
    private static final String DELETEREST_ATTR = "DeleteRest";

    public OiigNotifRequest(String guid, String emailId, String hostName, int platform, boolean bDeleteRest) {
        this.m_GUID = guid;
        this.m_emailId = emailId;
        this.m_hostName = hostName;
        this.m_platform = platform;
        this.m_bDeleteRest = bDeleteRest;
        this.m_depComps = new Vector();
        this.m_depRelns = new Vector();
        this.m_checkNowComps = new Vector();
        this.m_notifReqComps = new Vector();
    }

    public OiigNotifRequest(OixpIElement el) {
        this(el.getAttribValue(GUID_ATTR), el.getAttribValue(EMAILID_ATTR), el.getAttribValue(HOSTNAME_ATTR), Integer.parseInt(el.getAttribValue(PLATFORM_ATTR)), Boolean.valueOf(el.getAttribValue(PLATFORM_ATTR)));
    }

    public void setGUID(String GUID) {
        this.m_GUID = GUID;
    }

    public void setEmailId(String emailId) {
        this.m_emailId = emailId;
    }

    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    public void setPlatform(int platform) {
        this.m_platform = platform;
    }

    public void setDeleteRest(boolean bDeleteRest) {
        this.m_bDeleteRest = bDeleteRest;
    }

    public void setDepComps(Vector depComps) {
        this.m_depComps = depComps;
    }

    public void addDepComp(OiigDepComp depComp) {
        this.m_depComps.addElement(depComp);
    }

    public void setDepRelns(Vector depRelns) {
        this.m_depRelns = depRelns;
    }

    public void addDepReln(OiigDepReln depReln) {
        this.m_depRelns.addElement(depReln);
    }

    public void setCheckNowComps(Vector checkNowComps) {
        this.m_checkNowComps = checkNowComps;
    }

    public void setNotifReqComps(Vector notifReqComps) {
        this.m_notifReqComps = notifReqComps;
    }

    public String getGUID() {
        return this.m_GUID;
    }

    public String getEmailId() {
        return this.m_emailId;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public int getPlatform() {
        return this.m_platform;
    }

    public boolean shouldDeleteRest() {
        return this.m_bDeleteRest;
    }

    public Vector getDepComps() {
        return this.m_depComps;
    }

    public Vector getDepRelns() {
        return this.m_depRelns;
    }

    public Vector getCheckNowComps() {
        return this.m_checkNowComps;
    }

    public Vector getNotifReqComps() {
        return this.m_notifReqComps;
    }

    public int findDepCompIndex(String intName, OiiiVersion version) {
        int retVal = -1;
        int numDepComps = this.m_depComps != null ? this.m_depComps.size() : 0;
        for (int i = 0; i < numDepComps; ++i) {
            OiigDepComp depComp = (OiigDepComp)this.m_depComps.elementAt(i);
            if (!depComp.getInternalName().equals(intName) || !depComp.getVersion().equals(version)) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    public String toString() {
        return "\n[NotifRequest : GUID " + this.m_GUID + ", EmailID " + this.m_emailId + ", HostName " + this.m_hostName + ", Platform " + this.m_platform + ", Delete rest " + this.m_bDeleteRest + "\n DepComps " + this.m_depComps + "\n DepRelns " + this.m_depRelns + "\n CheckNowComps " + this.m_checkNowComps + "\n NotifReqComps " + this.m_notifReqComps + "]";
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<NotifReq " + (this.m_GUID == null ? "" : "GUID=\"" + OixwXmlWriterOps.encodeSplChars(this.m_GUID) + "\" ") + (this.m_emailId == null ? "" : "EmailId=\"" + OixwXmlWriterOps.encodeSplChars(this.m_emailId) + "\" ") + (this.m_hostName == null ? "" : "HostName=\"" + OixwXmlWriterOps.encodeSplChars(this.m_hostName) + "\" ") + PLATFORM_ATTR + "=\"" + this.m_platform + "\" " + DELETEREST_ATTR + "=\"" + this.m_bDeleteRest + "\">");
        pw.println("<DepComps> ");
        OixwXmlWriterOps.writeXmlForm(this.m_depComps, pw);
        pw.println("</DepComps> ");
        pw.println("<DepRelns> ");
        OixwXmlWriterOps.writeXmlForm(this.m_depRelns, pw);
        pw.println("</DepRelns> ");
        pw.println("<CheckNowComps> " + OiigXmlOps.stringWithNumVect(this.m_checkNowComps) + "</" + CHECKNOW_COMPS_TAG + "> ");
        pw.println("<NotifReqComps> " + OiigXmlOps.stringWithNumVect(this.m_notifReqComps) + "</" + NOTIFREQ_COMPS_TAG + "> ");
        pw.println("</NotifReq>");
    }

    public static OiigNotifRequest genNotifRequest(String guid, String emailId, String hostName, Vector checkNowComps, Vector notifReqComps, OiiiInstallInventory instInv, boolean bDeleteRest) {
        long compInd;
        OiiiCompIdOhPair cidOh;
        int i;
        OiigNotifRequest notifReq = new OiigNotifRequest(guid, emailId, hostName, OiixPlatform.getCurrentPlatform(), bDeleteRest);
        Vector<Long> checkCompIds = new Vector<Long>();
        Vector<Long> notifCompIds = new Vector<Long>();
        int numCNComps = checkNowComps != null ? checkNowComps.size() : 0;
        int numNRComps = notifReqComps != null ? notifReqComps.size() : 0;
        for (i = 0; i < numCNComps; ++i) {
            cidOh = (OiiiCompIdOhPair)checkNowComps.elementAt(i);
            compInd = notifReq.addCompAndDeps(cidOh, instInv);
            checkCompIds.addElement(new Long(compInd));
        }
        for (i = 0; i < numNRComps; ++i) {
            cidOh = (OiiiCompIdOhPair)notifReqComps.elementAt(i);
            compInd = notifReq.addCompAndDeps(cidOh, instInv);
            notifCompIds.addElement(new Long(compInd));
        }
        notifReq.setCheckNowComps(checkCompIds);
        notifReq.setNotifReqComps(notifCompIds);
        return notifReq;
    }

    private long addCompAndDeps(OiiiCompIdOhPair cidOh, OiiiInstallInventory instInv) {
        int compInd;
        OiiiCompInstallID cid = cidOh.getCompID();
        int ohIndex = cidOh.getOHIndex();
        String ohome = instInv.getHomeLocation(ohIndex);
        if (ohIndex == 0) {
            ohome = "IndependentProducts";
        }
        if ((compInd = this.findDepCompIndex(cid.getName(), cid.getVersion())) != -1) {
            OiigDepComp depComp = (OiigDepComp)this.m_depComps.elementAt(compInd);
            depComp.addOHomeLoc(ohome);
        } else {
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)instInv.getCompInvEntry(cid, ohIndex);
            if (icie != null) {
                compInd = this.m_depComps.size();
                Vector<String> ohomes = new Vector<String>();
                ohomes.addElement(ohome);
                OiigDepComp depComp = new OiigDepComp(cid.getName(), icie.getName(), icie.getDescription(), cid.getVersion(), icie.getCompInstallID().getCompType(), icie.isTopLevel(), ohomes, compInd);
                this.addDepComp(depComp);
                Vector dependees = icie.getDependees();
                int numDeps = dependees != null ? dependees.size() : 0;
                for (int i = 0; i < numDeps; ++i) {
                    OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)dependees.elementAt(i);
                    long depInd = this.addCompAndDeps(depIdOh, instInv);
                    if (depInd == -1L) continue;
                    OiigDepReln depReln = new OiigDepReln(compInd, depInd, depIdOh.getDepType());
                    this.addDepReln(depReln);
                }
            }
        }
        return compInd;
    }
}

