/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiig;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import oracle.sysman.oii.oiig.OiigCompInfo;
import oracle.sysman.oii.oiig.OiigDepComp;
import oracle.sysman.oii.oiig.OiigPSetContInfo;
import oracle.sysman.oii.oiig.OiigSetContent;
import oracle.sysman.oii.oiig.OiigSetInfo;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixw.OixwIXmlWriter;
import oracle.sysman.oix.oixw.OixwXmlWriterOps;

public class OiigNotifInfo
implements OixwIXmlWriter {
    private Vector m_accSets = new Vector();
    private Vector m_pubComps = new Vector();
    private Vector m_depComps = new Vector();
    private Vector m_pSetConts = new Vector();
    private Date m_filterStartTime;
    private Date m_filterEndTime;
    private String m_notifURL = null;
    public static final String MAIN_TAG_TYPE = "NotifInfo";
    public static final String ACCSETS_TAG = "AccSets";
    public static final String PUBCOMPS_TAG = "PubComps";
    public static final String DEPCOMPS_TAG = "DepComps";
    public static final String PSETCONTS_TAG = "PSetConts";

    public OiigNotifInfo() {
    }

    public OiigNotifInfo(OixpIElement el) {
        this();
    }

    public void addAccSet(OiigSetInfo accSet) {
        this.m_accSets.addElement(accSet);
    }

    public void addPubComp(OiigCompInfo pubComp) {
        this.m_pubComps.addElement(pubComp);
    }

    public void addDepComp(OiigDepComp depComp) {
        this.m_depComps.addElement(depComp);
    }

    public void addPSetCont(OiigPSetContInfo pSetCont) {
        this.m_pSetConts.addElement(pSetCont);
    }

    public void setFilterStartTime(Date filterStartTime) {
        this.m_filterStartTime = filterStartTime;
    }

    public void setFilterEndTime(Date filterEndTime) {
        this.m_filterEndTime = filterEndTime;
    }

    public void setNotifURL(String notifURL) {
        this.m_notifURL = notifURL;
    }

    public Vector getAccSets() {
        return this.m_accSets;
    }

    public void setAccSets(Vector accSets) {
        this.m_accSets = accSets;
    }

    public Vector getPubComps() {
        return this.m_pubComps;
    }

    public Vector getDepComps() {
        return this.m_depComps;
    }

    public Vector getPSetConts() {
        return this.m_pSetConts;
    }

    public Date getFilterStartTime() {
        return this.m_filterStartTime;
    }

    public Date getFilterEndTime() {
        return this.m_filterEndTime;
    }

    public String getNotifURL() {
        return this.m_notifURL;
    }

    public OiigSetInfo getSet(long index) {
        return (OiigSetInfo)this.getItem(this.m_accSets, index);
    }

    public OiigCompInfo getComp(long index) {
        return (OiigCompInfo)this.getItem(this.m_pubComps, index);
    }

    public OiigDepComp getDepComp(long index) {
        return (OiigDepComp)this.getItem(this.m_depComps, index);
    }

    private synchronized OiigSetContent getItem(Vector allItems, long index) {
        OiigSetContent retCont = null;
        int numItems = allItems.size();
        for (int i = 0; i < numItems; ++i) {
            OiigSetContent sc = (OiigSetContent)allItems.elementAt(i);
            if (sc.getIndex() != index) continue;
            retCont = sc;
            break;
        }
        return retCont;
    }

    public String toString() {
        return "Acc Sets \n" + this.m_accSets + "\nPub Comps \n" + this.m_pubComps + "\nDep Comps \n" + this.m_depComps + "\nPSet Conts \n" + this.m_pSetConts;
    }

    @Override
    public void writeXmlForm(PrintWriter pw) throws IOException {
        pw.println("<NotifInfo>");
        pw.println("<AccSets>");
        OixwXmlWriterOps.writeXmlForm(this.m_accSets, pw);
        pw.println("</AccSets>");
        pw.println("<PubComps>");
        OixwXmlWriterOps.writeXmlForm(this.m_pubComps, pw);
        pw.println("</PubComps>");
        pw.println("<DepComps>");
        OixwXmlWriterOps.writeXmlForm(this.m_depComps, pw);
        pw.println("</DepComps>");
        pw.println("<PSetConts>");
        OixwXmlWriterOps.writeXmlForm(this.m_pSetConts, pw);
        pw.println("</PSetConts>");
        pw.println("</NotifInfo>");
    }
}

